/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_1_4;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractMemberExternImplementationCheck;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfConstraintDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.4")
@CheckName(value="SVTB.7.1.4")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.CONSTRAINT, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Define method and constraint implementation external to the class")
@CheckDescription(value="Defining the method and constraint implementation outside the body of the class declaration allows a user of said class to quickly view the class interface (the class API).\nException: methods implemented in a single line can be implemented in the class body.\n\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_7_1_4.class)
public class Check_SVTB_7_1_4
extends AbstractMemberExternImplementationCheck {
    public Check_SVTB_7_1_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected Set<Class<? extends RfNamedElement>> getClassTypes() {
        HashSet<Class<? extends RfNamedElement>> classTypes = new HashSet<Class<? extends RfNamedElement>>();
        classTypes.add(RfConstraint.class);
        classTypes.add(RfFunction.class);
        return classTypes;
    }

    @Override
    protected int getMaxNofLinesFor(RfDefElement rfDefElement) {
        int maxNofLines = Integer.MAX_VALUE;
        if (rfDefElement instanceof RfFunctionDef) {
            maxNofLines = this.pMethodMaxNofLinesValue;
        } else if (rfDefElement instanceof RfConstraintDef) {
            maxNofLines = this.pConstraintMaxNofLinesValue;
        }
        return maxNofLines;
    }
}

