/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfAssociatedTypeWrapper;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.4.1")
@CheckName(value="SVTB.7.1.4.1")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Declared method signatures must exactly match the extern implementation signatures")
@CheckDescription(value="Not Allowed:\n   class foo;\n     ...\n     extern function void moo (input int goo);\n     extern function void doo (int unsigned goo);\n      ...\n   endclass\n   ...\n   function void foo::moo(int goo); // keyword 'input' missing\n   function void foo::doo(int goo); // keyword 'unsigned' missing")
public class Check_SVTB_7_1_4_1
extends OVMComplianceCheck {
    public Check_SVTB_7_1_4_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass tmpClazz = (RfClass)clazz;
            List<RfFunction> allLocalMethods = tmpClazz.getLocalMembers(RfFunction.class);
            if (allLocalMethods == null) continue;
            this.notifyCheckAlive();
            for (RfFunction method : allLocalMethods) {
                ArrayList defs;
                if (method instanceof RfPredefinedFunction || (defs = new ArrayList(method.getDeclarations())).size() < 2) continue;
                List<ArgInfo> decArgs = ((RfFunctionDef)defs.get(0)).getArgumentInfos();
                List<ArgInfo> defArgs = ((RfFunctionDef)defs.get(defs.size() - 1)).getArgumentInfos();
                if (decArgs == null || defArgs == null) {
                    if (decArgs == null && defArgs == null) continue;
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Method declaration and implementation have different number of arguments", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                if (decArgs.size() != defArgs.size()) {
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Method declaration and implementation have different number of arguments", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                boolean isFailure = false;
                DataType decArgType = null;
                DataType defArgType = null;
                String decArgName = null;
                String defArgName = null;
                int i = 0;
                while (i < decArgs.size()) {
                    decArgType = decArgs.get(i).getDataType();
                    defArgType = defArgs.get(i).getDataType();
                    if (decArgType == null || defArgType == null) {
                        if (decArgType != null || defArgType != null) {
                            isFailure = true;
                            break;
                        }
                    } else {
                        DataTypeWrapper decTypeWrap = new DataTypeWrapper(decArgType, clazz);
                        DataTypeWrapper defTypeWrap = new DataTypeWrapper(defArgType, clazz);
                        if (!decTypeWrap.equals(defTypeWrap)) {
                            isFailure = true;
                            break;
                        }
                    }
                    decArgName = decArgs.get(i).getName();
                    defArgName = defArgs.get(i).getName();
                    if (decArgName == null || defArgName == null) {
                        if (decArgName != null || defArgName != null) {
                            isFailure = true;
                            break;
                        }
                    } else if (!decArgName.equals(defArgName)) {
                        isFailure = true;
                        break;
                    }
                    ++i;
                }
                if (!isFailure) continue;
                this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Declared method signature does not match the extern implementation signature", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
            }
        }
    }

    private static class DataTypeWrapper
    extends DataType {
        private static final long serialVersionUID = 1L;

        public DataTypeWrapper(DataType dataType, RfNamedElement enclosingScope) {
            RfAssociatedTypeWrapper wrap;
            IRfNamedElement assocType;
            this.init(dataType);
            if (this.getPackageScope() == null) {
                this.fPackageScope = new DataType(enclosingScope.getName());
            }
            if ((assocType = (wrap = new RfAssociatedTypeWrapper(dataType, enclosingScope)).getAssociatedType()) instanceof RfTypeAlias) {
                this.setParamAssignments(((RfTypeAlias)assocType).getDataType());
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataType other = (DataType)obj;
            if (this.fDirection != other.getRawDirection()) {
                return false;
            }
            if (this.fSign != other.getSign()) {
                return false;
            }
            if (this.fVirtualInterface != other.getVirtualInterface()) {
                return false;
            }
            if (this.fType == null ? other.getType() != null : !this.fType.equals(other.getType())) {
                return false;
            }
            if (this.fNetType == null ? other.getNetType() != null : !this.fNetType.equals(other.getNetType())) {
                return false;
            }
            if (this.fPackageScope == null ? other.getPackageScope() != null : !this.fPackageScope.equals(other.getPackageScope())) {
                return false;
            }
            if (this.fUnpackedDimension == null ? other.getUnpackedDimension() != null && !other.getUnpackedDimension().isEmpty() : !this.fUnpackedDimension.equals(other.getUnpackedDimension())) {
                return false;
            }
            if (this.fEnumRange == null ? other.getEnumRange() != null : !this.fEnumRange.equals(other.getEnumRange())) {
                return false;
            }
            if (this.fPackedDimension == null ? other.getPackedDimension() != null && !other.getPackedDimension().isEmpty() : !this.fPackedDimension.equals(other.getPackedDimension())) {
                return false;
            }
            if (this.fOrderedParamAssignments == null ? other.getOrderedParamAssignments() != null : !this.fOrderedParamAssignments.equals(other.getOrderedParamAssignments())) {
                return false;
            }
            if (this.fNamedParamAssignments == null) {
                return other.getNamedParamAssignments() == null;
            }
            if (!this.fNamedParamAssignments.equals(other.getNamedParamAssignments())) {
                return false;
            }
            ArrayList namedParamAssignmentsList = new ArrayList(this.fNamedParamAssignments.keySet());
            ArrayList<String> otherNamedParamAssignmentsList = new ArrayList<String>(other.getNamedParamAssignments().keySet());
            return namedParamAssignmentsList.equals(otherNamedParamAssignmentsList);
        }

        @Override
        public int hashCode() {
            int result = 1;
            result = 31 * result + Byte.hashCode(this.fDirection);
            result = 31 * result + Byte.hashCode(this.fSign);
            result = 31 * result + Byte.hashCode(this.fVirtualInterface);
            result = 31 * result + (this.fType == null ? 0 : this.fType.hashCode());
            result = 31 * result + (this.fNetType == null ? 0 : this.fNetType.hashCode());
            result = 31 * result + (this.fPackageScope == null ? 0 : this.fPackageScope.hashCode());
            result = 31 * result + (this.fUnpackedDimension == null ? 0 : this.fUnpackedDimension.hashCode());
            result = 31 * result + (this.fEnumRange == null ? 0 : this.fEnumRange.hashCode());
            result = 31 * result + (this.fPackedDimension == null ? 0 : this.fPackedDimension.hashCode());
            result = 31 * result + (this.fOrderedParamAssignments == null ? 0 : this.fOrderedParamAssignments.hashCode());
            result = 31 * result + (this.fNamedParamAssignments == null ? 0 : this.fNamedParamAssignments.hashCode());
            return result;
        }
    }
}

