/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.ArgInfo;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.4.2")
@CheckName(value="SVTB.7.1.4.2")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Declared method arguments default values must exactly match the extern implementation default values")
@CheckDescription(value="This is an LRM requirement.\nNot Allowed:\n   class foo;\n      ...\n      extern function void moo (input int goo = 3);\n      extern function void hoo (int voo = 10);\n      ...\n   endclass\n   ...\n   function void foo::moo(input int goo); // doesn't match! default missing\n   function void foo::hoo(int goo = 4); // doesn't match! default mismatch")
public class Check_SVTB_7_1_4_2
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, ignore missing default arguments but still show errors when the values are different.", name="ignoreDefaultArgumentValues", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pIgnoreDefaultArgumentValuesValue;

    public Check_SVTB_7_1_4_2(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass tmpClazz = (RfClass)clazz;
            List<RfFunction> allLocalMethods = tmpClazz.getLocalMembers(RfFunction.class);
            if (allLocalMethods == null) continue;
            this.notifyCheckAlive();
            for (RfFunction method : allLocalMethods) {
                ArrayList defs;
                if (method instanceof RfPredefinedFunction || (defs = new ArrayList(method.getDeclarations())).size() < 2) continue;
                List<ArgInfo> decArgs = ((RfFunctionDef)defs.get(0)).getArgumentInfos();
                List<ArgInfo> defArgs = ((RfFunctionDef)defs.get(defs.size() - 1)).getArgumentInfos();
                if (decArgs == null || defArgs == null) {
                    if (decArgs == null && defArgs == null) continue;
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Method declaration and implementation have different number of arguments", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                if (decArgs.size() != defArgs.size()) {
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Method declaration and implementation have different number of arguments", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                boolean isFailure = false;
                String decArgDefault = null;
                String defArgDefault = null;
                int i = 0;
                while (i < decArgs.size()) {
                    decArgDefault = decArgs.get(i).getInitialValue();
                    defArgDefault = defArgs.get(i).getInitialValue();
                    if (decArgDefault == null || defArgDefault == null) {
                        if (decArgDefault != null || defArgDefault != null) {
                            if (decArgDefault == null && defArgDefault != null) {
                                isFailure = true;
                                break;
                            }
                            if (!this.pIgnoreDefaultArgumentValuesValue) {
                                isFailure = true;
                                break;
                            }
                        }
                    } else if (!decArgDefault.equals(defArgDefault)) {
                        isFailure = true;
                        break;
                    }
                    ++i;
                }
                if (!isFailure) continue;
                this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Declared method argument default values don't match the extern implementation default values!", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
            }
        }
    }
}

