/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfBitVectorScalarType;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.1.4.3")
@CheckName(value="SVTB.7.1.4.3")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.RETURN, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Declared method return value must exactly match the extern implementation")
@CheckDescription(value="An LRM requirement.\nNot Allowed:\n   class foo;\n      ...\n      extern function void moo (input int goo);\n      ...\n   endclass: foo\n   ...\n   function foo::moo(input int goo); // doesn't match! - return type missing")
public class Check_SVTB_7_1_4_3
extends OVMComplianceCheck {
    public Check_SVTB_7_1_4_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement clazz : this.fOVMProject.getAllNonXVMClasses()) {
            RfClass tmpClazz = (RfClass)clazz;
            List<RfFunction> allLocalMethods = tmpClazz.getLocalMembers(RfFunction.class);
            if (allLocalMethods == null) continue;
            this.notifyCheckAlive();
            for (RfFunction method : allLocalMethods) {
                ArrayList defs;
                if (method instanceof RfPredefinedFunction || (defs = new ArrayList(method.getDeclarations())).size() < 2) continue;
                DataType decType = ((RfFunctionDef)defs.get(0)).getTypeInfoOrImplicit("logic", method);
                DataType defType = ((RfFunctionDef)defs.get(defs.size() - 1)).getTypeInfoOrImplicit("logic", method);
                if (decType == null && defType == null) continue;
                if (decType == null || defType == null) {
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Declared method return type does not match the extern implementation return type!", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                if (decType.getType() == null && defType.getType() == null) continue;
                if (decType.getType() != null && !decType.getType().equals(defType.getType()) || defType.getType() != null && !defType.getType().equals(decType.getType())) {
                    this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Declared method return type does not match the extern implementation return type!", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
                    continue;
                }
                if (decType.getType() == null || defType.getType() == null || Check_SVTB_7_1_4_3.finalSign(defType) == Check_SVTB_7_1_4_3.finalSign(decType)) continue;
                this.addHit(((RfDefElement)defs.get(defs.size() - 1)).getParserPath(), ((RfDefElement)defs.get(defs.size() - 1)).getStartLine(), "Declared method return type does not match the extern implementation return type!", ((RfDefElement)defs.get(defs.size() - 1)).getReparseInfo());
            }
        }
    }

    private static int finalSign(DataType dataType) {
        if (dataType.getSign() != 0) {
            return dataType.getSign();
        }
        return RfBitVectorScalarType.getSign(dataType.getType());
    }
}

