/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_1_4_4;
import ro.amiq.vlogdt.linter.autofixes.utils.ExternFunctionsOrdering;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.9")
@CheckID(value="SVTB.7.1.4.4")
@CheckName(value="SVTB.7.1.4.4")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.EXTERN, RuleLabel.VERIFICATION})
@CheckTitle(value="Implementation method order must match declaration order")
@CheckDescription(value="The extern method implementation order must match the order of the declared methods.\n\nExamples:\n\nclass myclass1;\n  extern function void f1();\n  extern function void f2();\nendclass\n\nfunction void myclass1::f1(); endfunction // allowed\nfunction void myclass1::f2(); endfunction\n\nclass myclass2;\n  extern function void f1();\n  extern function void f2();\nendclass\n\nfunction void myclass2::f2(); endfunction // not allowed\nfunction void myclass2::f1(); endfunction\n\nCheck supports pre-waiving.\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_7_1_4_4.class)
public class Check_SVTB_7_1_4_4
extends OVMComplianceCheck {
    public Check_SVTB_7_1_4_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement element : this.fOVMProject.getAllNonXVMClasses()) {
            List<RfFunction> allMethods;
            RfClass currentClass = (RfClass)element;
            RfFileDef file = element.getFile();
            if (file == null) continue;
            ParserPath fileName = file.getParserPath();
            if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileName, this) || (allMethods = currentClass.getLocalMembers(RfFunction.class)) == null) continue;
            this.notifyCheckAlive();
            List externFunctions = allMethods.stream().filter(function -> !function.isDPI() && function.isExtern()).collect(Collectors.toList());
            if (externFunctions == null || externFunctions.isEmpty()) continue;
            List<ExternFunctionsOrdering.FunctionData> externFunctionsData = externFunctions.stream().map(function -> this.getFunctionData((RfFunction)function)).filter(data -> data != null).collect(Collectors.toList());
            List<ExternFunctionsOrdering.FunctionData> functionDifferentFiles = this.getFunctionsDifferentFileDeclarationAndImplementation(externFunctionsData);
            if (functionDifferentFiles != null) {
                for (ExternFunctionsOrdering.FunctionData function2 : functionDifferentFiles) {
                    if (function2.getDeclarationFile() == null) continue;
                    String linkToDeclaration = this.link("declaration", function2.getDeclarationFile().path, function2.getDeclarationStartLine());
                    this.addHit(function2.getImplementationFile(), function2.getImplementationStartLine(), "The implementation of '" + function2.getFullName() + "' is not in the same file as the " + linkToDeclaration + " at line " + function2.getDeclarationStartLine() + " in file " + this.getFileFromPath(function2.getDeclarationFile().path) + "!", null);
                }
            }
            if (functionDifferentFiles != null) {
                externFunctionsData.removeAll(functionDifferentFiles);
            }
            if (externFunctionsData.isEmpty()) continue;
            externFunctionsData.sort(new Comparator<ExternFunctionsOrdering.FunctionData>(){

                @Override
                public int compare(ExternFunctionsOrdering.FunctionData o1, ExternFunctionsOrdering.FunctionData o2) {
                    if (o1.getDeclarationFile() == null || !o1.getDeclarationFile().equals((Object)o2.getDeclarationFile())) {
                        return -2;
                    }
                    if (o1.getDeclarationStartOffset() < o2.getDeclarationStartOffset()) {
                        return -1;
                    }
                    if (o1.getDeclarationStartOffset() > o2.getDeclarationStartOffset()) {
                        return 1;
                    }
                    return 0;
                }
            });
            ExternFunctionsOrdering.FunctionData prev = null;
            ExternFunctionsOrdering.FunctionData current = externFunctionsData.get(0);
            int i = 1;
            while (i < externFunctionsData.size()) {
                prev = current;
                current = externFunctionsData.get(i);
                if (prev.getImplementationFile() != null && current.getImplementationFile() != null) {
                    String linkToCurrent = this.link(current.getFullName(), current.getImplementationFile().path, current.getImplementationStartLine());
                    String linkToPrev = this.link(prev.getFullName(), prev.getImplementationFile().path, prev.getImplementationStartLine());
                    if (!prev.getImplementationFile().equals((Object)current.getImplementationFile())) {
                        this.addHit(current.getImplementationFile(), current.getImplementationStartLine(), "The implementation of '" + linkToCurrent + "' is not in the same file as the implementation of '" + linkToPrev + "'!", null);
                    } else if (prev.getImplementationStartOffset() > current.getImplementationStartOffset()) {
                        this.addHit(current.getImplementationFile(), current.getImplementationStartLine(), "The implementation of '" + linkToCurrent + "' should be after the implementation of '" + linkToPrev + "'!", null, new VerissimoAutofixAdditionalInfo(externFunctionsData));
                    }
                }
                ++i;
            }
        }
    }

    private String getFileFromPath(String path) {
        int index = path.lastIndexOf(47);
        if (index < 0) {
            return path;
        }
        return path.substring(index + 1);
    }

    private List<ExternFunctionsOrdering.FunctionData> getFunctionsDifferentFileDeclarationAndImplementation(List<ExternFunctionsOrdering.FunctionData> externFunctionsData) {
        ArrayList<ExternFunctionsOrdering.FunctionData> result = new ArrayList<ExternFunctionsOrdering.FunctionData>();
        for (ExternFunctionsOrdering.FunctionData function : externFunctionsData) {
            ParserPath implementationFile;
            ParserPath declarationFile = function.getDeclarationFile();
            if (declarationFile.equals((Object)(implementationFile = function.getImplementationFile()))) continue;
            result.add(function);
        }
        return result;
    }

    private ExternFunctionsOrdering.FunctionData getFunctionData(RfFunction function) {
        ArrayList declarations = new ArrayList(function.getDeclarations());
        if (declarations.size() < 2) {
            return null;
        }
        RfDefElement first = (RfDefElement)declarations.get(0);
        RfDefElement second = (RfDefElement)declarations.get(1);
        if (!(first instanceof RfFunctionDef) || !(second instanceof RfFunctionDef)) {
            return null;
        }
        return new ExternFunctionsOrdering.FunctionData((RfFunctionDef)declarations.get(0), (RfFunctionDef)declarations.get(1), function);
    }
}

