/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="3.5.36")
@CheckID(value="SVTB.7.20")
@CheckName(value="SVTB.7.20")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not write to static class variables from non-static methods")
@CheckDescription(value="This is tricky to get correct if multiple instances are being manipulated, and generally bad practice.\nIf necessary, writing to a static class variable is allowed when the static way of access is being used.\n\nExample:\n   class a;\n      static int x;\n\n      function void foo();\n         x = 1; // not allowed\n         a::x = 1; // allowed when 'allowWriteUsingStaticSyntax' is true\n      endfunction\n\n      function new();\n         x = 1; // allowed when 'allowWriteInConstructor' is true\n      endfunction\n   endclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_20
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, writing to static class variables is allowed in constructors.", name="allowWriteInConstructor", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowWriteInConstructorValue;
    @CheckParameter(defaultValue="true", description="When true, writing to static class variables using the static way of access is allowed.", name="allowWriteUsingStaticAccess", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowWriteUsingStaticAccessValue;
    private final HidOperatorVisitor fAssignmentsVisitor = new HidOperatorVisitor(null){

        public boolean visit(HidOperator hidObject) {
            if (!hidObject.hasOccurrence(HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS)) {
                return true;
            }
            if (Check_SVTB_7_20.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            if (this.scope == null) {
                return true;
            }
            RfFunction functionScope = (RfFunction)this.scope.getEnclosingScope(RfFunction.class);
            if (functionScope == null) {
                return true;
            }
            Check_SVTB_7_20.this.notifyCheckAlive();
            if (functionScope.isObjectStatic()) {
                return true;
            }
            if (Check_SVTB_7_20.this.pAllowWriteInConstructorValue && functionScope.isConstructor()) {
                return true;
            }
            HidOperator hidOperator = hidObject;
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (lhHidObject instanceof RfHidAccess) {
                lhHidObject = ((RfHidAccess)lhHidObject).getParentHid();
            }
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            HidAccess parentAccess = ((RfHid)lhHidObject).getParentAccess();
            if (Check_SVTB_7_20.this.pAllowWriteUsingStaticAccessValue && parentAccess != null && parentAccess.getAccessKind() == 2) {
                return true;
            }
            IRfNamedElement element = ((RfHid)lhHidObject).getElement();
            if (parentAccess != null && parentAccess.getAssociatedType() instanceof RfStruct) {
                return true;
            }
            if (element instanceof RfField && ((RfField)element).isStorageStatic() && element.getEnclosingScope() instanceof RfClass) {
                Check_SVTB_7_20.this.addHit(this.parserPath, hidOperator, HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS, "Static class variable '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' is assigned in non-static method" + " '" + LintUtils.getNamedElementFullName(functionScope) + "()'!");
            }
            return true;
        }
    };

    public Check_SVTB_7_20(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fAssignmentsVisitor);
    }

    private boolean checkPreWaivers(ParserPath parserPath) {
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

