/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.5.36")
@CheckID(value="SVTB.7.21")
@CheckName(value="SVTB.7.21")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Use the explicit static access syntax (::) when using static variables or static functions from non-static functions")
@CheckDescription(value="Makes it clear when using static access.\n\nExample:\n class a;\n   static int x;\n endclass\n\n class b;\n   static int y;\n\n   function void foo(a pa);\n      int v1;\n\n      v1 = pa.x; // static access is not clear\n      v1 = a::x; // OK\n\n      v1 = y; // static access is not clear\n      v1 = b::y; // OK\n   endfunction\n endclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_21
extends OVMComplianceCheck {
    public Check_SVTB_7_21(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor hidVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfClass classElement;
                Check_SVTB_7_21.this.notifyCheckAlive();
                if (namedElement instanceof RfClass && !(classElement = (RfClass)namedElement).isPredefined()) {
                    if (Check_SVTB_7_21.this.checkPreWaivers(classElement.getFile())) {
                        return true;
                    }
                    namedElement.visitHidObject(rfProject, hidVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement hidNamedElement;
            Check_SVTB_7_21.this.notifyCheckAlive();
            if (hid == null || !(this.holder instanceof HidHolder)) {
                return true;
            }
            IRfNamedElement holderScope = ((HidHolder)this.holder).getScope();
            if (!(holderScope instanceof RfFunction)) {
                return true;
            }
            RfFunction holderFunction = (RfFunction)holderScope;
            if (holderFunction.isPredefined() || holderFunction.isObjectStatic()) {
                return true;
            }
            HidAccess parentAccess = hid.getParentAccess();
            String accessString = null;
            if (parentAccess != null) {
                int accessKind = parentAccess.getAccessKind();
                if (accessKind == 2) {
                    return true;
                }
                String string = accessKind == 0 ? "." : (accessString = accessKind == 1 ? ":" : null);
            }
            if (!((hidNamedElement = hid.getElement()) instanceof RfField) && !(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            if (!(hidNamedElement.getEnclosingScope() instanceof RfClass)) {
                return true;
            }
            if (hidNamedElement instanceof RfField) {
                RfField fieldElement = (RfField)hidNamedElement;
                if (fieldElement.isPredefined() || !fieldElement.isField() || !fieldElement.isStorageStatic()) {
                    return true;
                }
                Check_SVTB_7_21.this.addHit(this.parserPath, hid, "Use static syntax (::) to access '" + (accessString != null ? hid.getHierarchicalPath() + accessString : "") + hid.getName() + "'" + "\n in non-static " + (holderFunction.isConstructor() ? "constructor" : (holderFunction.isFunction() ? "function" : "task")) + " '" + holderFunction.getFullName() + "()'!");
            } else if (hidNamedElement instanceof RfFunction) {
                RfFunction functionElement = (RfFunction)hidNamedElement;
                if (functionElement.isPredefined() || !functionElement.isObjectStatic()) {
                    return true;
                }
                Check_SVTB_7_21.this.addHit(this.parserPath, hid, "Use static syntax (::) to call '" + (accessString != null ? hid.getHierarchicalPath() + accessString : "") + hid.getName() + "()'" + "\n in non-static " + (holderFunction.isConstructor() ? "constructor" : (holderFunction.isFunction() ? "function" : "task")) + " '" + holderFunction.getFullName() + "()'!");
            }
            return true;
        }
    }
}

