/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfSpecializedClass;
import ro.amiq.vlogdt.model.reflection.RfTypesResolver;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="3.5.39")
@CheckID(value="SVTB.7.22")
@CheckName(value="SVTB.7.22")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use hierarchical access to class member variables")
@CheckDescription(value="Class member variables are implementation details and should not be visible outside the class.\nUse functions like getter/setter to access class member variables.\n\nExample:\n class a;\n    rand int x;\n    int y;\n\n    function int compare(a other);\n       if(this.x == other.y) // other.y NOT allowed, unless allowAccessToSameClassMembers\n       ...\n    endfunction\n\n endclass\n\n class b;\n    function void foo(a pa);\n       pa.x = 1; // pa.x NOT allowed, unless allowAccessToRandMembers\n       pa.y = 1; // pa.y NOT allowed\n    endfunction\n endclass\n\n\nImplementation Notes:\nThis rule loops over all classes and checks the hierarchical access.")
public class Check_SVTB_7_22
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, hierarchical access to random class variables is allowed.", name="allowAccessToRandMembers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAccessToRandMembersValue;
    @CheckParameter(defaultValue="true", description="When true, hierarchical access to same class (including parent) variables is allowed.", name="allowAccessToSameClassMembers", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pAllowAccessToSameClassMembersValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class variable types to allow hierarchical access to, for example: uvm_pkg::uvm_port_base.", name="allowAccessToClassMembersByType", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowAccessToMembersByTypeValue;
    @CheckParameter(defaultValue="", description="Comma separated list of class variables to allow hierarchical access to, for example: uvm_pkg::uvm_sequence.rsp.", name="allowAccessToClassMembersByFullName", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pAllowAccessToMembersByFullNameValue;

    public Check_SVTB_7_22(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor hidVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfClass classElement;
                Check_SVTB_7_22.this.notifyCheckAlive();
                if (namedElement instanceof RfClass && !(classElement = (RfClass)namedElement).isPredefined()) {
                    namedElement.visitHidObject(rfProject, hidVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        private IRfNamedElement scope;

        LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            RfNamedElement fieldType;
            Check_SVTB_7_22.this.notifyCheckAlive();
            if (hid == null) {
                return true;
            }
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                return true;
            }
            if (parentAccess.getAccessKind() != 0) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfField)) {
                return true;
            }
            RfField hidFieldElement = (RfField)hidNamedElement;
            if (!hidFieldElement.isField() || hidFieldElement.isFromEmbeddedCovergroupDef()) {
                return true;
            }
            if (Check_SVTB_7_22.this.pAllowAccessToMembersByFullNameValue.contains(hidFieldElement.getFullName())) {
                return true;
            }
            if (hidFieldElement.isPredefined()) {
                return true;
            }
            if (Check_SVTB_7_22.this.pAllowAccessToRandMembersValue && (hidFieldElement.isRand() || hidFieldElement.isRandc())) {
                return true;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid != null && "this".equals(parentHid.getName())) {
                return true;
            }
            if (parentHid != null) {
                RfClass enclosingClass;
                if (!(parentAccess.getAssociatedType() instanceof RfNamedElement)) {
                    return true;
                }
                RfNamedElement parentType = (RfNamedElement)parentAccess.getAssociatedType();
                if (parentType instanceof RfField && ((RfField)parentType).isTypeParameter()) {
                    parentType = LintUtils.getAssociatedFinalType((RfField)parentType, RfTypesResolver.create((IRfScopeElement)this.scope, this.scope.getRfProject(), 14));
                }
                if (!(parentType instanceof RfClass) && !(parentType instanceof RfSpecializedClass)) {
                    return true;
                }
                if (Check_SVTB_7_22.this.pAllowAccessToSameClassMembersValue && this.scope != null && (enclosingClass = (RfClass)this.scope.getEnclosingScope(RfClass.class)) != null) {
                    if (parentType.getFullName() != null && parentType.getFullName().equals(enclosingClass.getFullName())) {
                        return true;
                    }
                    if (enclosingClass.isChildOfClass(parentType)) {
                        return true;
                    }
                }
            }
            if (!Check_SVTB_7_22.this.pAllowAccessToMembersByTypeValue.isEmpty() && (fieldType = LintUtils.getAssociatedFinalType(hidFieldElement)) != null) {
                if (Check_SVTB_7_22.this.pAllowAccessToMembersByTypeValue.contains(fieldType.getFullName())) {
                    return true;
                }
                if (fieldType instanceof RfClass) {
                    RfClass fieldTypeClass = (RfClass)fieldType;
                    RfClass parent = fieldTypeClass.getParent();
                    while (parent != null) {
                        if (Check_SVTB_7_22.this.pAllowAccessToMembersByTypeValue.contains(parent.getFullName())) {
                            return true;
                        }
                        parent = parent.getParent();
                    }
                }
            }
            Check_SVTB_7_22.this.addHit(this.parserPath, hid, "Avoid hierarchical access '" + LintUtils.getHierarchicalPath(hid) + "'!");
            return true;
        }

        @Override
        public void setHolder(IHidHolder holder) {
            this.scope = ((RfHidHolder)holder).getScope();
        }
    }
}

