/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="15.1.41")
@CheckID(value="SVTB.7.23")
@CheckName(value="SVTB.7.23")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare classes inside classes")
@CheckDescription(value="It is not recommended to declare inner classes.\n\nExamples:\n\nclass c1;\n\tclass c2; // not allowed\n\tendclass\nendclass\n\nclass c3; // allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_23
extends OVMComplianceCheck {
    public Check_SVTB_7_23(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass classs : this.fOVMProject.getAllClasses()) {
            if (this.checkPreWaivers(classs.getFile())) continue;
            this.checkClass(classs);
        }
    }

    private void checkClass(RfClass classs) {
        this.notifyCheckAlive();
        RfNamedElement enclosingScope = classs.getEnclosingScope();
        if (enclosingScope instanceof RfClass) {
            this.addHit(classs, "Class '" + classs.getFullName() + "' declared inside class '" + enclosingScope.getFullName() + "'!");
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

