/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="15.1.41")
@CheckID(value="SVTB.7.24")
@CheckName(value="SVTB.7.24")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not directly access local members of an object with the exception of 'this'")
@CheckDescription(value="Do not directly access local members of an object, only 'this' object access is allowed.\nDerived classes might not use those local members anymore leading to unexpected results.\n\nExample:\n class a;\n    local int x;\n\n    function foo(a other);\n        $display(\"%d\",other.x); // NOT allowed\n        $display(\"%d\",this.x);  // allowed\n    endfunction\n\n endclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_24
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="field", description="Comma separated list of field, function, task.", name="memberKinds", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pMemberKindsValue = new HashSet<String>();
    @CheckParameter(defaultValue="", description="Comma separated list of method full names in which direct access of local members is allowed, for example: xvm_pkg::xvm_object.do_copy, xvm_pkg::xvm_object.do_compare.", name="allowAccessInMethods", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pAllowAccessInMethods = new HashSet<String>();

    public Check_SVTB_7_24(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (final RfClass clazz : this.fOVMProject.getAllClasses()) {
            if (this.checkPreWaivers(clazz.getFile())) continue;
            RfHidVisitor hidVisitor = new RfHidVisitor(){

                public boolean visit(RfHid hid) {
                    HidAccess parentAccess = hid.getParentAccess();
                    if (parentAccess == null) {
                        return true;
                    }
                    if (parentAccess.getParentHid() != null && "this".equals(parentAccess.getParentHid().getName())) {
                        return true;
                    }
                    Check_SVTB_7_24.this.notifyCheckAlive();
                    IRfNamedElement hidElement = hid.getElement();
                    if (!(hidElement instanceof RfNamedElement)) {
                        return true;
                    }
                    RfNamedElement namedElement = (RfNamedElement)hidElement;
                    if (namedElement.isPrivate() && parentAccess.getAssociatedType() == clazz && Check_SVTB_7_24.this.checkMemberKind(namedElement)) {
                        RfFunction enclosingMethod;
                        IRfNamedElement scope;
                        if (Check_SVTB_7_24.this.pAllowAccessInMethods != null && !Check_SVTB_7_24.this.pAllowAccessInMethods.isEmpty() && this.holder instanceof HidHolder && (scope = ((HidHolder)this.holder).getScope()) != null && (enclosingMethod = (RfFunction)scope.getEnclosingScope(RfFunction.class)) != null) {
                            if (Check_SVTB_7_24.this.pAllowAccessInMethods.contains(enclosingMethod.getFullName())) {
                                return true;
                            }
                            if (enclosingMethod.isVirtual()) {
                                String methodName = enclosingMethod.getName();
                                RfClass enclosingClass = enclosingMethod.getEnclosingScope(RfClass.class);
                                RfClass parent = enclosingClass.getParent();
                                while (parent != null) {
                                    RfFunction member = parent.getLocalMember(RfFunction.class, methodName, true);
                                    if (member != null && Check_SVTB_7_24.this.pAllowAccessInMethods.contains(member.getFullName()) && member.isVirtual()) {
                                        return true;
                                    }
                                    parent = parent.getParent();
                                }
                            }
                        }
                        Check_SVTB_7_24.this.addHit(this.parserPath, hid, "Local " + LintUtils.getElementKind(namedElement) + " '" + hid.getName() + "' is accessed from another object!");
                    }
                    return true;
                }
            };
            clazz.visitHidObject(null, hidVisitor);
        }
    }

    private boolean checkMemberKind(RfNamedElement namedElement) {
        String memberKind = this.getMemberKind(namedElement);
        if (memberKind == null) {
            return false;
        }
        return this.pMemberKindsValue.contains(memberKind);
    }

    private String getMemberKind(RfNamedElement namedElement) {
        if (namedElement instanceof RfField) {
            return "field";
        }
        if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isTask()) {
            return "task";
        }
        if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isFunction()) {
            return "function";
        }
        return null;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

