/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractOverrideMethodFromParentClassCheck;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfFunction;

@CheckVersion(value="16.1.16")
@CheckID(value="SVTB.7.25")
@CheckName(value="SVTB.7.25")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override specified methods from parent class")
@CheckDescription(value="All classes that inherit from <baseClass> must not override <methodName>.\n\nExamples for baseClass='parent' and methodName='foo':\n\nclass parent;\n\tvirtual function void foo(); endfunction\n\tvirtual function void bar(); endfunction\nendclass\n\nclass child extends parent;\n\tvirtual function void foo(); endfunction // not allowed\n\tvirtual function void bar(); endfunction // allowed\nendclass\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="methodName", description="Comma separated list of methods that should be overridden.")
public class Check_SVTB_7_25
extends AbstractOverrideMethodFromParentClassCheck {
    public Check_SVTB_7_25(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void computeHitForMethod(RfClass aClass, String aMethodName, RfFunction implementedMethod) {
        if (implementedMethod != null) {
            this.addHit(implementedMethod, "Class '" + aClass.getName() + "' overrides '" + aMethodName + "()' !");
        }
    }
}

