/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixAdditionalInfo;
import ro.amiq.vlogdt.linter.autofixes.fixes.Autofix_SVTB_7_26;
import ro.amiq.vlogdt.linter.base.annotations.CheckAutofix;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfScope;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccessArgs;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.CodePreprocFileInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;

@CheckVersion(value="16.1.17")
@CheckID(value="SVTB.7.26")
@CheckName(value="SVTB.7.26")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.METHOD, RuleLabel.SUPER, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override method and call only super.method()")
@CheckDescription(value="Do not override a method if the implementation is calling only super.method() with the same arguments.\n\nExamples:\nclass parent;\n  function int f1(); endfunction\n  function int f2(); endfunction\nendclass\n\nclass child extends parent;\n  function int f1(); \n    super.f1(); // not allowed\n  endfunction\n  function int f2(); \n    super.f2(); // allowed\n    $display(`LOG_MESSAGE);\n  endfunction\nendclass\n\nCheck supports auto-correcting.")
@CheckAutofix(value=Autofix_SVTB_7_26.class)
public class Check_SVTB_7_26
extends OVMComplianceCheck {
    public Check_SVTB_7_26(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfClass[] allClasses;
        RfClass[] rfClassArray = allClasses = this.fOVMProject.getRfProject().getAllClasses();
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            RfClass checkedClass = rfClassArray[n2];
            this.performCheckOnMethods(checkedClass);
            ++n2;
        }
    }

    private void performCheckOnMethods(RfClass checkedClass) {
        ArrayList<RfFunction> allMethods = new ArrayList<RfFunction>();
        allMethods.addAll(checkedClass.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        allMethods.addAll(checkedClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        allMethods.addAll(checkedClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        for (RfFunction method : allMethods) {
            List<RfActionBlock> actionBlocks;
            if (method.isPredefined()) continue;
            this.notifyCheckAlive();
            if (method.getStatementNo() != 1 || (actionBlocks = method.getLocalMembers(RfActionBlock.class)) != null && !actionBlocks.isEmpty()) continue;
            CheckSuperVisitor visitor = new CheckSuperVisitor(method);
            method.visitHidObject(null, visitor);
            if (!visitor.hasFoundSuper() || this.methodContainsMacro(method)) continue;
            this.addHitOnFunctionDefinition(method, "Overriding method '" + LintUtils.getNamedElementFullName(method) + "()' is calling only 'super." + method.getName() + "()'!", new VerissimoAutofixAdditionalInfo(method));
        }
    }

    private boolean methodContainsMacro(RfFunction method) {
        Integer firstPreprocAfterMethodStart;
        TreeSet<Integer> lines;
        if (method.getImplementation() == null) {
            return true;
        }
        int methodStartLine = method.getImplementation().getStartLine();
        int methodEndLine = method.getImplementation().getEndLine();
        ParserPath methodParserPath = method.getImplementation().getParserPath();
        List<VlogMacroInfo> macroInfo = this.fOVMProject.getRfProject().getAllMacros(methodParserPath);
        for (VlogMacroInfo macro : macroInfo) {
            List<VlogMacroInfo> layers = macro.getMacroZoneLayers();
            if (layers == null) continue;
            for (VlogMacroInfo layer : layers) {
                if (layer.getLine() < methodStartLine || layer.getLine() > methodEndLine) continue;
                return true;
            }
        }
        CodePreprocFileInfo preprocInfo = this.fOVMProject.getRfProject().getPreprocessingTable().getCodePreprocFileInfos().get(methodParserPath);
        return preprocInfo != null && (lines = preprocInfo.getLines()) != null && (firstPreprocAfterMethodStart = lines.ceiling(methodStartLine)) != null && firstPreprocAfterMethodStart <= methodEndLine;
    }

    private static class CheckSuperVisitor
    implements IHidVisitor<RfHid> {
        private final IRfScope method;
        private boolean foundSuperError = false;
        private boolean first = true;

        public CheckSuperVisitor(IRfScope method) {
            this.method = method;
        }

        public boolean visit(RfHid hidObject) {
            RfHidAccessArgs argAccess;
            List<? extends IHidObject> argumentValues;
            HidAccess argValuesAccess;
            if (!this.first) {
                return false;
            }
            this.first = false;
            if (!"super".equals(hidObject.getName())) {
                return false;
            }
            if (!hidObject.hasAccesses()) {
                return false;
            }
            ListContainer hids = hidObject.getFirstAccess().getHids();
            if (hids == null || hids.size() != 1) {
                return false;
            }
            Hid potentialMethodCall = (Hid)hids.iterator().next();
            if (!HidUtils.isResolved((IHidObject)potentialMethodCall) || !potentialMethodCall.getName().equals(this.method.getName())) {
                return false;
            }
            List<RfField> formalArgs = this.method.getArgumentsWithPrefix("", 2);
            List<Object> mcAccesses = new ArrayList<HidAccess>();
            if (potentialMethodCall.hasAccesses()) {
                ListContainer hidAccesses = potentialMethodCall.getAccesses();
                for (HidAccess hidAccess : hidAccesses) {
                    mcAccesses.add(hidAccess);
                }
            }
            boolean hasMcAccesses = !(mcAccesses = mcAccesses.stream().filter(RfHidAccessArgs.class::isInstance).map(RfHidAccessArgs.class::cast).filter(access -> access.getArgumentValues() != null && !access.getArgumentValues().isEmpty()).collect(Collectors.toList())).isEmpty();
            LocalHidOperatorVisitor localHidOperatorVisitor = new LocalHidOperatorVisitor();
            ((IRfNamedElement)this.method).visitHidObject(null, (IHidVisitor)localHidOperatorVisitor);
            if (formalArgs == null || formalArgs.isEmpty()) {
                this.foundSuperError = !hasMcAccesses && !localHidOperatorVisitor.skipCurrentFunction;
                return false;
            }
            if (hasMcAccesses && (argValuesAccess = (HidAccess)mcAccesses.get(0)) instanceof RfHidAccessArgs && (argumentValues = (argAccess = (RfHidAccessArgs)argValuesAccess).getArgumentValues()) != null && formalArgs.size() == argumentValues.size()) {
                int i = 0;
                while (i < argumentValues.size()) {
                    IHidObject argumentValue = argumentValues.get(i);
                    if (!HidUtils.isOperator((IHidObject)argumentValue)) {
                        return false;
                    }
                    ListContainer rhValues = ((RfHidOperator)argumentValue).getRHValues();
                    if (rhValues == null || rhValues.size() != 1) {
                        return false;
                    }
                    if (!HidUtils.isHid((IHidObject)((IHidObject)rhValues.get(0)))) {
                        return false;
                    }
                    RfHid actualValueHid = (RfHid)((Object)rhValues.get(0));
                    if (formalArgs.get(i) != HidUtils.getResolvedElement((IHidObject)actualValueHid)) {
                        return false;
                    }
                    ++i;
                }
                this.foundSuperError = !localHidOperatorVisitor.skipCurrentFunction;
            }
            return false;
        }

        boolean hasFoundSuper() {
            return this.foundSuperError;
        }

        public Class<RfHid> getType() {
            return RfHid.class;
        }
    }

    private static class LocalHidOperatorVisitor
    implements IHidVisitor<HidOperator> {
        private RfNamedElement scope;
        private boolean skipCurrentFunction = false;

        private LocalHidOperatorVisitor() {
        }

        public boolean visit(HidOperator hidObject) {
            IHidObject lhValue;
            if (!(hidObject instanceof IRfHidOperatorLayer)) {
                return true;
            }
            if (((IRfHidOperatorLayer)hidObject).isReturnStatement()) {
                return true;
            }
            if (hidObject.isAssociation() && (lhValue = hidObject.getLHValue()) instanceof RfHid) {
                IRfNamedElement formalArgument = ((RfHid)lhValue).getElement();
                if (formalArgument == null) {
                    return true;
                }
                RfFunction callingFunction = (RfFunction)formalArgument.getEnclosingScope(RfFunction.class);
                if (callingFunction == null) {
                    return true;
                }
                String callingFunctionName = callingFunction.getName();
                if (callingFunctionName == null) {
                    return true;
                }
                String visitedFunctionName = this.scope.getName();
                if (visitedFunctionName == null) {
                    return true;
                }
                if (!callingFunctionName.equals(visitedFunctionName)) {
                    this.skipCurrentFunction = true;
                } else {
                    RfClass visitedFunctionEnclosingClass = this.scope.getEnclosingScope(RfClass.class);
                    RfClass callingFunctionEnclosingClass = callingFunction.getEnclosingScope(RfClass.class);
                    if (visitedFunctionEnclosingClass == null || callingFunctionEnclosingClass == null) {
                        return true;
                    }
                    if (!LintUtils.isChildOf(visitedFunctionEnclosingClass, callingFunctionEnclosingClass)) {
                        this.skipCurrentFunction = true;
                    }
                    return true;
                }
            }
            this.skipCurrentFunction = true;
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<HidOperator> getType() {
            return HidOperator.class;
        }
    }
}

