/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="16.1.17")
@CheckID(value="SVTB.7.27")
@CheckName(value="SVTB.7.27")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.INITIALIZATION, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not use a class handle without initializing it")
@CheckDescription(value="Do not use a class handle without initializing it.\n\nImplementation Notes:\nOnly method variables are checked.\n\nExamples:\n\nclass parent;\n\tinteger a;\n\tfunction new(); endfunction\nendclass\n\nclass child extends parent\n\tfunction void foo();\n\t\tmy_class obj = new();\n\t\tobj.a = 10; // allowed\n\tendfunction\n\n\tfunction void foo();\n\t\tmy_class obj;\n\t\tobj.a = 5; // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
@CheckReapplyDisable
public class Check_SVTB_7_27
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="true", description="When true, non-initialized handles can be passed as inout arguments.", name="allowNullInoutArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowNullInoutArgumentsValue;
    @CheckParameter(defaultValue="true", description="When true, non-initialized handles can be passed as ref arguments.", name="allowNullRefArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowNullRefArgumentsValue;
    @CheckParameter(defaultValue="true", description="When true, handles passed as inout arguments will be considered initialized after that method call.", name="initializeInoutArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pInitializeInoutArgumentsValue;
    @CheckParameter(defaultValue="true", description="When true, handles passed as ref arguments will be considered initialized after that method call.", name="initializeRefArguments", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pInitializeRefArgumentsValue;

    public Check_SVTB_7_27(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<RfNamedElement, TreeMap<Offsets, VariableState>> objects = new HashMap<RfNamedElement, TreeMap<Offsets, VariableState>>();
        CheckForInitializations initializationVisitator = new CheckForInitializations(objects);
        CheckHandleClass visitor = new CheckHandleClass(objects);
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            if (function.isPredefined() || this.checkPreWaivers(function.getFile())) continue;
            function.visitHidObject(null, initializationVisitator);
            function.visitHidObject(null, visitor);
            objects.clear();
        }
        for (RfNamedElement task : this.fOVMProject.getAllTasks()) {
            if (task.isPredefined() || this.checkPreWaivers(task.getFile())) continue;
            task.visitHidObject(null, initializationVisitator);
            task.visitHidObject(null, visitor);
            objects.clear();
        }
    }

    private void addOffsets(Map<RfNamedElement, TreeMap<Offsets, VariableState>> objects, RfNamedElement namedElement, Offsets offsets, VariableState state) {
        TreeMap<Offsets, VariableState> tree = objects.get(namedElement);
        if (tree == null) {
            tree = new TreeMap();
        }
        tree.put(offsets, state);
        objects.put(namedElement, tree);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class CheckForInitializations
    implements IHidVisitor<IHidObject> {
        private Map<RfNamedElement, TreeMap<Offsets, VariableState>> objects;
        protected IHidHolder holder;
        protected ParserPath parserPath;
        protected Map<IRfScopeElement, DVTLinkedHashMap<String, RfNamedElement>> scopeMembersCache;

        public CheckForInitializations(HashMap<RfNamedElement, TreeMap<Offsets, VariableState>> objects) {
            this.objects = objects;
            this.scopeMembersCache = new HashMap<IRfScopeElement, DVTLinkedHashMap<String, RfNamedElement>>();
        }

        public boolean visit(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    RfHidOperator hidOp = (RfHidOperator)hidObject;
                    if (!hidOp.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) && !hidOp.isAssignment()) {
                        return true;
                    }
                    IHidObject lhValue = hidOp.getLHValue();
                    ListContainer rhValues = hidOp.getRHValues();
                    Check_SVTB_7_27.this.notifyCheckAlive();
                    if (lhValue instanceof RfHidImplicit) {
                        if (!(this.holder instanceof RfHidHolder)) {
                            return true;
                        }
                        IRfNamedElement holderScope = ((RfHidHolder)this.holder).getScope();
                        if (!(holderScope instanceof RfNamedElement)) {
                            return true;
                        }
                        DVTLinkedHashMap<String, RfNamedElement> localMembers = this.getLocalMembers((IRfScopeElement)holderScope);
                        if (localMembers == null || localMembers.isEmpty()) {
                            return true;
                        }
                        RfNamedElement member = (RfNamedElement)localMembers.get((Object)((RfHidImplicit)lhValue).getName());
                        if (rhValues == null) {
                            return true;
                        }
                        HidOperatorOccurrence occurrence = hidOp.getOccurrence();
                        if (rhValues.get(0) instanceof RfHidImplicit && ((RfHidImplicit)rhValues.get(0)).getName().equals("null")) {
                            Check_SVTB_7_27.this.addOffsets(this.objects, member, new Offsets(occurrence.getOffset(), occurrence.getVirtualOffset()), VariableState.NULL);
                            return true;
                        }
                        Check_SVTB_7_27.this.addOffsets(this.objects, member, new Offsets(occurrence.getOffset(), occurrence.getVirtualOffset()), VariableState.INITIALIZED);
                        return true;
                    }
                    if (lhValue instanceof RfHid) {
                        IRfNamedElement hidEl = ((RfHid)lhValue).getElement();
                        if (!(hidEl instanceof RfNamedElement)) {
                            return true;
                        }
                        RfNamedElement namedElement = (RfNamedElement)hidEl;
                        if (!(namedElement instanceof RfField) || !((RfField)namedElement).isVariable()) {
                            return true;
                        }
                        RfField auxField = (RfField)namedElement;
                        RfNamedElement auxType = LintUtils.getAssociatedFinalType(auxField);
                        if (!(auxType instanceof RfClass)) {
                            return true;
                        }
                        if (rhValues == null || rhValues.isEmpty()) {
                            return true;
                        }
                        if (rhValues.get(0) instanceof RfHidImplicit && ((RfHidImplicit)rhValues.get(0)).getName().equals("null") && hidOp.isEqualAssignment()) {
                            Check_SVTB_7_27.this.addOffsets(this.objects, namedElement, new Offsets(hidOp.getOccurrence().getOffset(), hidOp.getOccurrence().getVirtualOffset()), VariableState.NULL);
                            return true;
                        }
                        Check_SVTB_7_27.this.addOffsets(this.objects, namedElement, new Offsets(hidOp.getOccurrence().getOffset(), hidOp.getOccurrence().getVirtualOffset()), VariableState.INITIALIZED);
                    }
                    return true;
                }
                case HID: {
                    RfHid hid = (RfHid)hidObject;
                    IRfNamedElement namedElement = hid.getElement();
                    Check_SVTB_7_27.this.notifyCheckAlive();
                    if (namedElement instanceof RfNamedElement && ((RfNamedElement)namedElement).isImplicit()) {
                        Check_SVTB_7_27.this.addOffsets(this.objects, (RfNamedElement)namedElement, new Offsets(0, 0), VariableState.INITIALIZED);
                        return true;
                    }
                    if (!hid.isMethodCall(false)) {
                        return true;
                    }
                    if (!(namedElement instanceof RfFunction)) {
                        return true;
                    }
                    List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                    if (methodCalls.isEmpty()) {
                        return true;
                    }
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.argumentValuesMap == null) continue;
                        if (((RfFunction)namedElement).isPredefined()) {
                            IHid auxHid;
                            IRfNamedElement element;
                            IRfNamedElement argument = (IRfNamedElement)methodCall.argumentValuesMap.entrySet().iterator().next().getKey();
                            Set values = (Set)methodCall.argumentValuesMap.entrySet().iterator().next().getValue();
                            if (values == null || values.isEmpty() || !(argument instanceof IRfFieldElement) || !((element = (auxHid = (IHid)values.iterator().next()).getElement()) instanceof RfNamedElement)) continue;
                            RfNamedElement namedEl = (RfNamedElement)element;
                            HidOccurrence occurrence = auxHid.getOccurrence();
                            Check_SVTB_7_27.this.addOffsets(this.objects, namedEl, new Offsets(occurrence.getOffset(), occurrence.getVirtualOffset()), VariableState.INITIALIZED);
                            continue;
                        }
                        for (Map.Entry argumentValue : methodCall.argumentValuesMap.entrySet()) {
                            HidOccurrence occ;
                            RfNamedElement type;
                            RfField field;
                            if (!(argumentValue.getKey() instanceof RfField)) continue;
                            RfField argument = (RfField)argumentValue.getKey();
                            Set values = (Set)argumentValue.getValue();
                            if (values == null || values.isEmpty()) continue;
                            IHid auxHid = (IHid)values.iterator().next();
                            IRfNamedElement element = auxHid.getElement();
                            if (argument.isInput() || argument.isConstRef() || argument.isInout() && !Check_SVTB_7_27.this.pInitializeInoutArgumentsValue || argument.isRef() && !Check_SVTB_7_27.this.pInitializeRefArgumentsValue || !(element instanceof RfField) || !(field = (RfField)element).isVariable() || !((type = LintUtils.getAssociatedFinalType(field)) instanceof RfClass) || (occ = auxHid.getOccurrence()) == null) continue;
                            Offsets offsets = null;
                            if (occ.getLine() == methodCall.occurrence.getLine()) {
                                offsets = new Offsets(occ.getOffset(), occ.getVirtualOffset());
                            } else if (occ.getLine() > methodCall.occurrence.getLine()) {
                                offsets = new Offsets(occ.getOffset() - 1, occ.getVirtualOffset() - 1);
                            }
                            if (offsets == null) continue;
                            Check_SVTB_7_27.this.addOffsets(this.objects, field, offsets, VariableState.INITIALIZED);
                        }
                    }
                    return true;
                }
            }
            return true;
        }

        private DVTLinkedHashMap<String, RfNamedElement> getLocalMembers(IRfScopeElement holderScope) {
            if (this.scopeMembersCache.get(holderScope) == null) {
                DVTLinkedHashMap<String, RfNamedElement> localMembers = ((RfNamedElement)holderScope).getLocalMembers(false);
                this.scopeMembersCache.put(holderScope, localMembers);
                return localMembers;
            }
            return this.scopeMembersCache.get(holderScope);
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    class CheckHandleClass
    implements IHidVisitor<IHidObject> {
        private HashMap<RfNamedElement, TreeMap<Offsets, VariableState>> objects;
        protected IHidHolder holder;
        protected ParserPath parserPath;

        public CheckHandleClass(HashMap<RfNamedElement, TreeMap<Offsets, VariableState>> objects) {
            this.objects = objects;
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject.getHidKind() != IHidObject.HidKind.HID) {
                return true;
            }
            RfHid rfHid = (RfHid)hidObject;
            if (rfHid.isMethodCall(false)) {
                IRfNamedElement namedElement = rfHid.getElement();
                if (!(namedElement instanceof RfFunction)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (methodCalls.isEmpty()) {
                    return true;
                }
                block0: for (MethodCall methodCall : methodCalls) {
                    if (methodCall.argumentValuesMap == null) continue;
                    int argumentIndex = -1;
                    for (Map.Entry argumentValue : methodCall.argumentValuesMap.entrySet()) {
                        RfNamedElement type;
                        RfNamedElement namedEl;
                        IHid auxHid;
                        IRfNamedElement element;
                        if (!(argumentValue.getKey() instanceof RfField) || ++argumentIndex == 0 && "$cast".equals(methodCall.getMethodName())) continue;
                        RfField argument = (RfField)argumentValue.getKey();
                        Set values = (Set)argumentValue.getValue();
                        if (values == null || values.isEmpty() || argument.isOutput() || argument.isInout() && Check_SVTB_7_27.this.pAllowNullInoutArgumentsValue || argument.isRef() && !argument.isConstRef() && Check_SVTB_7_27.this.pAllowNullRefArgumentsValue || !((element = (auxHid = (IHid)values.iterator().next()).getElement()) instanceof RfNamedElement) || !((namedEl = (RfNamedElement)element) instanceof RfField) || !((RfField)namedEl).isVariable() || namedEl.getName().equals("this")) continue;
                        RfField field = (RfField)namedEl;
                        IRfNamedElement associatedType = field.getAssociatedType();
                        while (associatedType instanceof RfTypeAlias) {
                            associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
                        }
                        if (associatedType instanceof RfListType || !((type = LintUtils.getAssociatedFinalType(field)) instanceof RfClass)) continue;
                        if (!this.objects.containsKey(namedEl)) {
                            Check_SVTB_7_27.this.addHit(this.parserPath, auxHid.getOccurrence(), "Class handle '" + namedEl.getName() + "' not initialized before use!");
                            return true;
                        }
                        TreeMap<Offsets, VariableState> tree = this.objects.get(namedEl);
                        Map.Entry<Offsets, VariableState> entry = null;
                        entry = tree.floorEntry(new Offsets(methodCall.occurrence.getOffset(), methodCall.occurrence.getVirtualOffset()));
                        if (entry == null) {
                            Check_SVTB_7_27.this.addHit(this.parserPath, methodCall.occurrence, "Class handle '" + namedEl.getName() + "' not initialized before use!");
                            continue;
                        }
                        if (entry.getKey().getOffset() == methodCall.occurrence.getOffset() && entry.getKey().getVirtualOffset() >= methodCall.occurrence.getVirtualOffset()) {
                            Check_SVTB_7_27.this.addHit(this.parserPath, methodCall.occurrence, "Class handle '" + namedEl.getName() + "' not initialized before use!");
                            continue;
                        }
                        if (entry.getValue() == VariableState.INITIALIZED) continue;
                        Check_SVTB_7_27.this.addHit(this.parserPath, methodCall.occurrence, "Class handle '" + auxHid.getName() + "' not initialized before use!");
                        continue block0;
                    }
                }
                return true;
            }
            IRfNamedElement hidElement = rfHid.getElement();
            if (!(hidElement instanceof RfNamedElement) || hidElement.getName().equals("super") || hidElement.getName().equals("this") || hidElement.getName().equals("new")) {
                return true;
            }
            RfNamedElement namedElement = (RfNamedElement)hidElement;
            if (!(namedElement instanceof RfField)) {
                return true;
            }
            RfField field = (RfField)namedElement;
            if (!((RfField)namedElement).isVariable()) {
                return true;
            }
            IRfNamedElement associatedType = field.getAssociatedType();
            while (associatedType instanceof RfTypeAlias) {
                associatedType = ((RfTypeAlias)associatedType).getAssociatedType();
            }
            if (associatedType instanceof RfListType) {
                return true;
            }
            if (!(associatedType instanceof RfClass)) {
                return true;
            }
            if (!rfHid.hasAccesses()) {
                return true;
            }
            ListContainer accesses = rfHid.getAccesses();
            TreeMap<Offsets, VariableState> tree = this.objects.get(namedElement);
            for (HidAccess acc : accesses) {
                ListContainer hids = acc.getHids();
                if (hids == null || hids.isEmpty()) {
                    return true;
                }
                for (Hid hid : hids) {
                    RfNamedElement occurenceScope;
                    IRfScopeElement scope;
                    if ("new".equals(hid.getName())) continue;
                    if (!this.objects.containsKey(namedElement)) {
                        Check_SVTB_7_27.this.addHit(this.parserPath, hid.getOccurrence(), "Class handle '" + namedElement.getName() + "' not initialized before use!");
                        continue;
                    }
                    HidOccurrence occ = hid.getOccurrence();
                    if (occ == null) continue;
                    boolean handleIsInitialized = true;
                    Map.Entry<Offsets, VariableState> entry = tree.floorEntry(new Offsets(occ.getOffset(), occ.getVirtualOffset()));
                    if (entry == null) {
                        handleIsInitialized = false;
                    } else if (entry.getKey().getOffset() == occ.getOffset()) {
                        if (entry.getKey().getVirtualOffset() > occ.getVirtualOffset()) {
                            handleIsInitialized = false;
                        }
                    } else if (entry.getValue() != VariableState.INITIALIZED) {
                        handleIsInitialized = false;
                    }
                    if (handleIsInitialized) continue;
                    RfFileDef defFile = null;
                    RfDefElement declaration = namedElement.getDeclaration();
                    if (declaration != null) {
                        defFile = namedElement.getDeclaration().getDefFile();
                    }
                    if (defFile != null && (scope = defFile.getScope(occ.getLine(), occ.getOffset())) instanceof RfFunctionDef && (occurenceScope = ((RfFunctionDef)scope).getNamedElement()) instanceof RfFunction && ((RfFunction)occurenceScope).isLet()) continue;
                    Check_SVTB_7_27.this.addHit(this.parserPath, occ, "Class handle '" + namedElement.getName() + "' not initialized before use!");
                }
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    static class Offsets
    implements Comparable<Offsets> {
        private int offset;
        private int virtualOffset;

        public Offsets(int offset, int vOffset) {
            this.offset = offset;
            this.virtualOffset = vOffset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getVirtualOffset() {
            return this.virtualOffset;
        }

        @Override
        public int compareTo(Offsets o) {
            if (this.offset < o.offset) {
                return -1;
            }
            if (this.offset > o.offset) {
                return 1;
            }
            if (this.virtualOffset > o.virtualOffset) {
                return 1;
            }
            if (this.virtualOffset < o.virtualOffset) {
                return -1;
            }
            return 0;
        }
    }

    private static enum VariableState {
        INITIALIZED,
        NULL;

    }
}

