/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;

@CheckVersion(value="16.1.22")
@CheckID(value="SVTB.7.28")
@CheckName(value="SVTB.7.28")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.METHOD, RuleLabel.ARGUMENT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not modify method parameters")
@CheckDescription(value="Do not modify method parameters\n\nExamples:\n\nclass c1;\n\tinteger a;\nendclass\n\nclass c2;\n\tfunction void foo(input c1 obj);\n\t\tobj.a = 10; // not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_28
extends OVMComplianceCheck {
    private static final List<String> LIST_MODIFIERS = Arrays.asList("delete", "reverse", "shuffle", "sort", "rsort", "insert", "push_back", "push_front", "pop_back", "pop_front");
    @CheckParameter(defaultValue="false", description="When true, inout parameters will be checked for modification.", name="checkInoutParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pCheckInoutParametersValue;
    @CheckParameter(defaultValue="false", description="When true, ref parameters will be checked for modification.", name="checkRefParameters", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pCheckRefParametersValue;
    @CheckParameter(defaultValue="false", description="When true, parameters passed as inout arguments to other method calls will not be considered modified.", name="allowUsageAsInoutArgument", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowUsageAsInoutArgumentValue;
    @CheckParameter(defaultValue="false", description="When true, parameters passed as ref arguments to other method calls will not be considered modified.", name="allowUsageAsRefArgument", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowUsageAsRefArgumentValue;
    @CheckParameter(defaultValue="false", description="When true, it allows modification of method parameter's fields.", name="allowHierarchicalModification", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowHierarchicalModificationValue;
    @CheckParameter(defaultValue="false", description="When true, it allows modification of list elements.", name="allowListElementsModification", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    boolean pAllowListElementsModificationValue;

    public Check_SVTB_7_28(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement function : this.fOVMProject.getAllFunctions()) {
            this.performCheckOnMethod(function);
        }
        for (RfNamedElement task : this.fOVMProject.getAllTasks()) {
            this.performCheckOnMethod(task);
        }
    }

    private void performCheckOnMethod(RfNamedElement method) {
        if (this.checkPreWaivers(method.getFile())) {
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        if (!method.isPredefined()) {
            this.notifyCheckAlive();
            List<RfField> allArguments = method.getArgumentsWithPrefix("", 2);
            arguments.clear();
            for (RfField arg : allArguments) {
                if (arg.isInput()) {
                    arguments.add(arg.getName());
                    continue;
                }
                if (arg.isRef() && arg.isConstRef()) {
                    arguments.add(arg.getName());
                    continue;
                }
                if (arg.isInout() && this.pCheckInoutParametersValue) {
                    arguments.add(arg.getName());
                    continue;
                }
                if (!arg.isRef() || arg.isConstRef() || !this.pCheckRefParametersValue) continue;
                arguments.add(arg.getName());
            }
            CheckHandleClass visitor = new CheckHandleClass(arguments);
            method.visitHidObject(null, visitor);
        }
    }

    private boolean isOperator(String op) {
        switch (op) {
            case "=": {
                return true;
            }
            case "+=": {
                return true;
            }
            case "-=": {
                return true;
            }
            case "*=": {
                return true;
            }
            case "/=": {
                return true;
            }
            case "++": {
                return true;
            }
            case "--": {
                return true;
            }
        }
        return false;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    class CheckHandleClass
    implements IHidVisitor<IHidObject> {
        protected IHidHolder holder;
        protected ParserPath parserPath;
        protected List<String> arguments;

        public CheckHandleClass(List<String> arguments) {
            this.arguments = arguments;
        }

        public boolean visit(IHidObject hidObject) {
            switch (hidObject.getHidKind()) {
                case OPERATOR: {
                    Hid parentAccess;
                    HidOperator hidOp = (HidOperator)hidObject;
                    if (!Check_SVTB_7_28.this.isOperator(hidOp.getOperatorText())) {
                        return true;
                    }
                    HidOperatorQualifier[] hidOperatorQualifierArray = ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY;
                    int n = ELConstants.DECLARATION_OPERATOR_QUALIFIERS_ARRAY.length;
                    int n2 = 0;
                    while (n2 < n) {
                        HidOperatorQualifier qualifier = hidOperatorQualifierArray[n2];
                        if (hidOp.hasQualifier(qualifier.value())) {
                            return true;
                        }
                        ++n2;
                    }
                    IHidObject lhValue = hidOp.getLHValue();
                    if (lhValue instanceof RfHidAccess && (parentAccess = ((RfHidAccess)lhValue).getParentHid()) != null) {
                        while (parentAccess.getParentHid() != null) {
                            parentAccess = parentAccess.getParentHid();
                        }
                        IRfNamedElement hidEl = parentAccess.getElement();
                        if (!(hidEl instanceof RfNamedElement)) {
                            return true;
                        }
                        RfNamedElement namedEl = (RfNamedElement)hidEl;
                        if (namedEl instanceof RfField && ((RfField)namedEl).getAssociatedType() instanceof RfListType && this.arguments.contains(namedEl.getName()) && !Check_SVTB_7_28.this.pAllowListElementsModificationValue) {
                            Check_SVTB_7_28.this.addHit(this.parserPath, (HidOccurrence)hidOp.getOccurrence(), "Method parameter '" + namedEl.getName() + "' is modified!");
                            return true;
                        }
                    }
                    if (!(lhValue instanceof RfHid)) {
                        return true;
                    }
                    IRfNamedElement hidEl = ((RfHid)lhValue).getElement();
                    if (!(hidEl instanceof RfNamedElement)) {
                        return true;
                    }
                    RfNamedElement namedEl = (RfNamedElement)hidEl;
                    Hid parentAccess2 = ((RfHid)lhValue).getParentHid();
                    if (parentAccess2 != null) {
                        while (parentAccess2.getParentHid() != null) {
                            parentAccess2 = parentAccess2.getParentHid();
                        }
                    }
                    if (parentAccess2 == null && this.arguments.contains(namedEl.getName())) {
                        Check_SVTB_7_28.this.addHit(this.parserPath, (HidOccurrence)hidOp.getOccurrence(), "Method parameter '" + namedEl.getName() + "' is modified!");
                    } else if (parentAccess2 != null && this.arguments.contains(parentAccess2.getName()) && !Check_SVTB_7_28.this.pAllowHierarchicalModificationValue) {
                        Check_SVTB_7_28.this.addHit(this.parserPath, (HidOccurrence)hidOp.getOccurrence(), "Method parameter '" + parentAccess2.getName() + "' is modified!");
                    }
                    return true;
                }
                case HID: {
                    RfHid hid = (RfHid)hidObject;
                    if (hid.isMethodCall(false)) {
                        IRfNamedElement namedElement = hid.getElement();
                        if (namedElement instanceof RfPredefinedFunction) {
                            Hid parentAcc = hid.getParentHid();
                            if (parentAcc != null) {
                                parentAcc = parentAcc.getAncestorHid();
                            }
                            if (parentAcc != null && this.arguments.contains(parentAcc.getName()) && LIST_MODIFIERS.contains(namedElement.getName())) {
                                Check_SVTB_7_28.this.addHit(this.parserPath, hid.getOccurrence(), "Method parameter '" + parentAcc.getName() + "' is modified!");
                            }
                        }
                        if (!(namedElement instanceof RfFunction)) {
                            return true;
                        }
                        List methodCalls = MethodCallUtils.getMethodCalls((IHid)hid);
                        if (methodCalls.isEmpty()) {
                            return true;
                        }
                        for (MethodCall methodCall : methodCalls) {
                            if (methodCall.argumentValuesMapRaw == null) continue;
                            int count = -1;
                            for (Map.Entry argumentValue : methodCall.argumentValuesMapRaw.entrySet()) {
                                RfNamedElement auxEl;
                                IRfNamedElement element;
                                if (++count == 1 && namedElement.getName().equals("$cast") || !(argumentValue.getKey() instanceof RfField)) continue;
                                RfField argument = (RfField)argumentValue.getKey();
                                IHidObject valueRaw = (IHidObject)argumentValue.getValue();
                                Hid elementHid = null;
                                boolean isSelect = false;
                                if (HidUtils.isOperator((IHidObject)valueRaw)) continue;
                                if (HidUtils.isHidAccess((IHidObject)valueRaw) && ((HidAccess)valueRaw).isSelect()) {
                                    elementHid = ((HidAccess)valueRaw).getParentHid();
                                    isSelect = true;
                                } else if (HidUtils.isHid((IHidObject)valueRaw)) {
                                    elementHid = (Hid)valueRaw;
                                }
                                if (elementHid == null || !((element = elementHid.getAncestorHid().getElement()) instanceof RfNamedElement) || !((auxEl = (RfNamedElement)element) instanceof RfField) || ((RfField)auxEl).isVariable() || argument.isConstRef() || argument.isInput() && !namedElement.getName().equals("$cast") || argument.isInout() && Check_SVTB_7_28.this.pAllowUsageAsInoutArgumentValue || argument.isRef() && !argument.isConstRef() && Check_SVTB_7_28.this.pAllowUsageAsRefArgumentValue || ((RfField)auxEl).getAssociatedType() instanceof RfListType && isSelect && this.arguments.contains(auxEl.getName()) && Check_SVTB_7_28.this.pAllowListElementsModificationValue || !this.arguments.contains(auxEl.getName())) continue;
                                Check_SVTB_7_28.this.addHit(this.parserPath, methodCall.occurrence, "Method parameter '" + auxEl.getName() + "' is modified!");
                            }
                        }
                    }
                    return true;
                }
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.holder = holder;
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

