/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="16.1.29")
@CheckID(value="SVTB.7.29")
@CheckName(value="SVTB.7.29")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.RANDOMIZATION, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare non-public members as randomizable")
@CheckDescription(value="Do not declare non-public members as randomizable\nProtected or local class variables should not be randomizable because their values can be changed from outside the class using object.randomize().\nExamples:\n\nclass c1;\n\trand int a; // allowed\n\tprotected rand int b; // not allowed\n\tlocal rand int c; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_29
extends OVMComplianceCheck {
    public Check_SVTB_7_29(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass rfClass : this.fOVMProject.getAllClasses()) {
            List<RfField> allFields;
            if (this.checkPreWaivers(rfClass.getFile()) || (allFields = rfClass.getLocalMembers(RfField.class)) == null) continue;
            for (RfField field : allFields) {
                this.notifyCheckAlive();
                if (field == null || !field.isField() || !field.isRand() && !field.isRandc() || !field.isProtected() && !field.isPrivate()) continue;
                this.addHit(field, "'" + field.getFullName() + "' is randomizable and non-public!");
            }
        }
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }
}

