/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.7.30")
@CheckName(value="SVTB.7.30")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Base classes must be declared virtual")
@CheckDescription(value="Any class that has other classes extending from it and is not extending another class must be a considered a base class and declared virtual\n\nExamples:\n\nclass grand_parent1; endclass // not allowed\nclass parent1 extends grand_parent1; endclass\nclass child1 extends parent1; endclass\n\nvirtual class grand_parent2; endclass // allowed\nclass parent2 extends grand_parent2; endclass\nclass child2 extends parent2; endclass\n")
@CheckReapplyDisable
public class Check_SVTB_7_30
extends OVMComplianceCheck {
    public Check_SVTB_7_30(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass clazz : this.fOVMProject.getAllClasses()) {
            Set<RfClass> children;
            this.notifyCheckAlive();
            RfClass parent = clazz.getParent();
            if (parent != null || (children = clazz.getChildren()) == null || children.isEmpty() || clazz.hasVirtualQualifier() || clazz.isInterfaceClass()) continue;
            this.addHit(clazz, "Base class '" + LintUtils.getNamedElementFullName(clazz) + "' must be declared virtual!");
        }
    }
}

