/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;

@CheckVersion(value="16.1.30")
@CheckID(value="SVTB.7.31")
@CheckName(value="SVTB.7.31")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.RANDOMIZATION, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Only randomizable members should be declared public")
@CheckDescription(value="Do not declare non-randomizable members as public.\n\nExamples:\n\nclass c1;\n\trand int a; // allowed\n\tprotected int b; // allowed\n\tint d; // not allowed\nendclass\n")
public class Check_SVTB_7_31
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of full class names. If a field has a class type that inherints from a class specified in the list, it will be skipped.", name="skipFieldsOfInheritedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipFieldsOfInheritedClasses;

    public Check_SVTB_7_31(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfClass rfClass : this.fOVMProject.getAllClasses()) {
            this.notifyCheckAlive();
            List<RfField> allFields = rfClass.getLocalMembers(RfField.class);
            if (allFields == null) continue;
            block1: for (RfField field : allFields) {
                RfClass associatedType;
                if (field == null || !field.isField() || field.isFromEmbeddedCovergroupDef() || !field.isPublic()) continue;
                if (!this.pSkipFieldsOfInheritedClasses.isEmpty() && (associatedType = LintUtils.getFieldFinalClassTypeOrNull(field)) != null) {
                    RfClass type = associatedType;
                    while (type != null) {
                        String name = type.getFullName();
                        if (this.pSkipFieldsOfInheritedClasses.contains(name)) continue block1;
                        type = type.getParent();
                    }
                }
                if (field.isRand() || field.isRandc()) continue;
                this.addHit(field, "Field '" + LintUtils.getNamedElementFullName(field) + "' is public and not randomizable!");
            }
        }
    }
}

