/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.utils.DVTLinkedHashMap;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="17.1.10")
@CheckID(value="SVTB.7.32")
@CheckName(value="SVTB.7.32")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.NAME, RuleLabel.STYLING, RuleLabel.VERIFICATION})
@CheckTitle(value="Use fully qualified class names")
@CheckDescription(value="Always use fully qualified class names.\n\nExamples:\n\npackage p0;\n\tclass a; endclass\n\tclass b; endclass\nendpackage\n\npackage p1;\n\timport p0::*;\n\ta a_obj; // not allowed\n\tb b_obj; // not allowed\n\tp0::a right_obj; // allowed\nendpackage\n")
public class Check_SVTB_7_32
extends OVMComplianceCheck {
    public Check_SVTB_7_32(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        RfFunction[] allFunctionsAndTasks;
        RfField[] allFields;
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor hidVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfClass classElement;
                Check_SVTB_7_32.this.notifyCheckAlive();
                if (namedElement instanceof RfClass && !(classElement = (RfClass)namedElement).isPredefined()) {
                    namedElement.visitHidObject(rfProject, hidVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
        RfField[] rfFieldArray = allFields = rfProject.getAllFields();
        int n = allFields.length;
        int n2 = 0;
        while (n2 < n) {
            IRfNamedElement assocType;
            RfField field = rfFieldArray[n2];
            if (!this.isValidFieldDeclaration(field) && (assocType = field.getAssociatedType(8)) instanceof RfClass) {
                this.addHit(field, "Class name '" + assocType.getName() + "' is not fully qualified!");
            }
            ++n2;
        }
        RfFunction[] rfFunctionArray = allFunctionsAndTasks = rfProject.getAllFunctionsAndTasks();
        int n3 = allFunctionsAndTasks.length;
        n = 0;
        while (n < n3) {
            DVTLinkedHashMap<String, RfNamedElement> localMembers;
            RfFunction function = rfFunctionArray[n];
            if (!function.isPredefined() && (localMembers = function.getLocalMembers(true)) != null) {
                for (IRfNamedElement namedElement : localMembers) {
                    IRfNamedElement assocType;
                    RfField field;
                    if (!(namedElement instanceof RfField) || this.isValidFieldDeclaration(field = (RfField)namedElement) || !((assocType = field.getAssociatedType(8)) instanceof RfClass)) continue;
                    this.addHit(field, "Class name '" + assocType.getName() + "' is not fully qualified!");
                }
            }
            ++n;
        }
    }

    private boolean isValidFieldDeclaration(RfField field) {
        RfPackage enclosingPackage = field.getEnclosingPackage();
        IRfNamedElement associatedType = field.getAssociatedType();
        if (!(associatedType instanceof RfClass)) {
            return true;
        }
        IRfScopeElement fieldEnclosingScope = associatedType.getEnclosingScope(RfPackage.class);
        if (fieldEnclosingScope == enclosingPackage) {
            return true;
        }
        DataType packageScope = field.getDataType().getPackageScope();
        return packageScope != null && packageScope.getType().equals(fieldEnclosingScope.getName());
    }

    private class LocalHidVisitor
    extends RfHidVisitor {
        private LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement parentElement;
            if (hid == null) {
                return true;
            }
            IRfNamedElement hidNamedElement = hid.getElement();
            if (!(hidNamedElement instanceof RfField) && !(hidNamedElement instanceof RfFunction)) {
                return true;
            }
            HidAccess parentAccess = hid.getParentAccess();
            if (parentAccess == null) {
                return true;
            }
            if (parentAccess.getAccessKind() != 2) {
                return true;
            }
            Hid parentHid = parentAccess.getParentHid();
            if (parentHid == null) {
                return true;
            }
            Hid auxHid = null;
            while ((auxHid = parentHid.getParentHid()) != null) {
                parentHid = auxHid;
            }
            IRfScopeElement localEnclosingScope = ((RfHidHolder)this.holder).getScope().getEnclosingScope();
            IRfScopeElement auxScope = null;
            while ((auxScope = localEnclosingScope.getEnclosingScope()) != null) {
                localEnclosingScope = auxScope;
                if (localEnclosingScope instanceof RfPackage) break;
            }
            if ((parentElement = parentHid.getElement()) == null) {
                return true;
            }
            if (parentElement instanceof RfPackage) {
                return true;
            }
            if (parentElement instanceof RfField && ((RfField)parentElement).isTypeParameter()) {
                return true;
            }
            if (parentElement.getEnclosingScope() != localEnclosingScope) {
                Check_SVTB_7_32.this.addHit(this.parserPath, hid, "Class name '" + parentHid.getName() + "' is not fully qualified!");
            }
            return true;
        }
    }
}

