/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="17.1.24")
@CheckID(value="SVTB.7.33")
@CheckName(value="SVTB.7.33")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.OVERRIDE, RuleLabel.CONSTRAINT, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not override constraints")
@CheckDescription(value="Do not override constraints, use constraint_mode(0) instead.\n\nExamples:\n\nclass parent;\n\tconstraint c_abc {}\nendclass\n\nclass child extends parent\n\tconstraint c_abc {} // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_33
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true, the rule skips the overrides of empty constraints.", name="skipEmptyConstraints", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipEmptyConstraints;

    public Check_SVTB_7_33(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement constraint : this.fOVMProject.getAllConstraints()) {
            RfClass overridedConstraintParent;
            if (!(constraint instanceof RfConstraint)) continue;
            this.notifyCheckAlive();
            if (this.checkPreWaivers(constraint.getFile()) || (overridedConstraintParent = this.findParentWithOverridedConstraint((RfConstraint)constraint)) == null) continue;
            this.addHit(constraint, "Overriding constraint '" + constraint.getName() + "' inherited from class '" + LintUtils.getNamedElementFullName(overridedConstraintParent) + "'!");
        }
    }

    private RfClass findParentWithOverridedConstraint(RfConstraint constraint) {
        RfNamedElement enclosingScope = constraint.getEnclosingScope();
        if (!(enclosingScope instanceof RfClass)) {
            return null;
        }
        RfClass parentClass = (RfClass)enclosingScope;
        while ((parentClass = parentClass.getParent()) != null) {
            RfConstraint parentConstraint = parentClass.getLocalMember(RfConstraint.class, constraint.getName(), false);
            if (parentConstraint == null) continue;
            if (this.pSkipEmptyConstraints) {
                ConstraintVisitor visitor = new ConstraintVisitor();
                parentConstraint.visitHidObject(null, visitor);
                return visitor.foundElement ? parentClass : null;
            }
            return parentClass;
        }
        return null;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class ConstraintVisitor
    implements IHidVisitor<IHidObject> {
        boolean foundElement;

        private ConstraintVisitor() {
        }

        public boolean visit(IHidObject ihidObj) {
            if (!(ihidObj instanceof RfHidOperator) && !(ihidObj instanceof RfHid)) {
                return true;
            }
            this.foundElement = true;
            return false;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

