/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.WordUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.guidelines.AbstractDeclaredClassElementsCheck;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="18.1.32")
@CheckID(value="SVTB.7.34")
@CheckName(value="SVTB.7.34")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not declare element in classes")
@CheckDescription(value="Do not declare <elementKind> in classes extending from <baseClass>.\n\nExamples for baseClass='parent' and elementKind='function':\n\nclass parent;\nendclass\n\nclass child extends parent\n\tfunction void foo();  // not allowed\n\tendfunction\n\n\ttask my_task();  // allowed\n\tendtask\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_34
extends AbstractDeclaredClassElementsCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of base classes, check all classes that inherit from them. When empty, all classes will be checked.", name="baseClass", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pBaseClassValue;
    @CheckParameter(defaultValue="", description="Comma separated list of: function, task, event, field, parameter, constraint, covergroup, class, assert, assume, cover, expect, restrict, typedef, struct, union, enum. typedef enum is enum, similar for struct, union.", name="elementKind", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKind;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the <baseClass> inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pSkipBaseClassesValue;
    @CheckParameter(defaultValue="false", description="When true, covergroup instantiation will also be checked", name="checkCovergroupInstantiation", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckCovergroupInstantiation;

    public Check_SVTB_7_34(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pBaseClassValue == null) {
            return;
        }
        HashSet<RfClass> classes = new HashSet<RfClass>();
        if (this.pBaseClassValue.isEmpty()) {
            classes.addAll(Arrays.asList(this.fOVMProject.getRfProject().getAllClasses()));
        } else {
            for (String baseClass : this.pBaseClassValue) {
                Set<RfClass> childrenClasses;
                RfClass parentClass = this.fOVMProject.getRfProject().getClass(baseClass, true);
                if (parentClass == null || (childrenClasses = parentClass.getChildren()) == null || childrenClasses.isEmpty()) continue;
                classes.addAll(childrenClasses);
            }
        }
        this.performCheck(classes, this.pSkipBaseClassesValue, this.pElementKind);
    }

    @Override
    public String getHitMessage(RfNamedElement namedElement, RfNamedElement enclosingClass) {
        String elementKind = LintUtils.getElementKind(namedElement);
        String name = namedElement.getName();
        if (namedElement instanceof RfStruct && ((RfStruct)namedElement).getAliasName() != null && !((RfStruct)namedElement).getAliasName().isEmpty()) {
            name = ((RfStruct)namedElement).getAliasName();
        }
        String nameAndKind = null;
        nameAndKind = namedElement instanceof RfStruct && (((RfStruct)namedElement).getAliasName() == null || ((RfStruct)namedElement).getAliasName().isEmpty()) ? "Anonymous " + elementKind : (namedElement instanceof RfAssertExpect ? String.valueOf(WordUtils.capitalize((String)elementKind)) + " " : String.valueOf(WordUtils.capitalize((String)elementKind)) + " '" + name + "'");
        return String.valueOf(nameAndKind) + " declared inside class '" + enclosingClass.getName() + "'!";
    }

    @Override
    public void getCoverGroupInstantiation(RfClass clazz) {
        if (!this.pCheckCovergroupInstantiation) {
            return;
        }
        CovergroupInstantiationVisitor covergroupInstantiationVisitor = new CovergroupInstantiationVisitor();
        clazz.visitHidObject(null, (IHidVisitor<?>)covergroupInstantiationVisitor);
        Set<RfHidOperator> covergroupsInstantiations = covergroupInstantiationVisitor.getCovergroupsInstantiations();
        for (RfHidOperator instantiation : covergroupsInstantiations) {
            HidOperatorOccurrence occurrence;
            ParserPath classParserPath;
            RfFileDef classFile = clazz.getFile();
            if (classFile == null || (classParserPath = classFile.getParserPath()) == null || (occurrence = instantiation.getOccurrence()) == null) continue;
            this.addHit(classParserPath, (HidOccurrence)occurrence, "Covergroup instantiated inside class '" + clazz + "'!");
        }
    }

    @Override
    public boolean checkInnerClasses(RfNamedElement clazz, RfNamedElement enclosingScope) {
        return false;
    }

    private static class CovergroupInstantiationVisitor
    extends HidOperatorVisitor {
        private Set<RfHidOperator> covergroupsInstantiations = new HashSet<RfHidOperator>();

        public CovergroupInstantiationVisitor() {
            super(null);
        }

        public boolean visit(HidOperator hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            if (!hidObject.isAssignment()) {
                return true;
            }
            Set rightHids = ((RfHidOperator)hidObject).getRHHids(new HashSet<HidFlatteningOption>(Arrays.asList(HidFlatteningOption.IGNORE_IMPLICITS)));
            for (IHid rightHid : rightHids) {
                HidAccess parentAccess;
                RfHid hid;
                if (!(rightHid instanceof RfHid) || !((hid = (RfHid)rightHid).getElement() instanceof RfPredefinedFunction) || !hid.getName().equals("new") || !((parentAccess = hid.getParentAccess()) instanceof RfHidAccess) || !(parentAccess.getAssociatedType() instanceof RfCovergroup)) continue;
                this.covergroupsInstantiations.add((RfHidOperator)hidObject);
            }
            return true;
        }

        public Set<RfHidOperator> getCovergroupsInstantiations() {
            return this.covergroupsInstantiations;
        }
    }
}

