/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClockingBlock;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.42")
@CheckID(value="SVTB.7.35")
@CheckName(value="SVTB.7.35")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.SIGNAL, RuleLabel.CLOCKING_BLOCK, RuleLabel.VERIFICATION})
@CheckTitle(value="Class access to signals must be done through clocking blocks")
@CheckDescription(value="Class access to signals that are part of clocking blocks must be done through those clocking blocks.\nExample:\nclocking cb @(posedge clk);\n    output outsig;\n    input insig;\nendclocking\n\n@(cb) // ALLOWED\n@(posedge clk) // NOT ALLOWED\ncb.outsig // ALLOWED\noutsig // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_35
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="When true class access to signals is allowed from covergroups.", name="skipCovergroups", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipCovergroups;
    private static final Set<Class<? extends RfNamedElement>> CLOCKING_BLOCK_CONTAINER_CLASSES = new HashSet<Class>(Arrays.asList(RfModule.class, RfInterface.class, RfChecker.class, RfProgram.class));

    public Check_SVTB_7_35(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement cls : this.fOVMProject.getAllNonXVMClasses()) {
            if (!(cls instanceof RfClass) || this.checkPreWaivers(cls.getFile())) continue;
            this.notifyCheckAlive();
            cls.visitHidObject(this.fOVMProject.getRfProject(), new LocalHidVisitor());
            LocalHidOperatorVisitor visitor = new LocalHidOperatorVisitor();
            cls.visitHidObject(this.fOVMProject.getRfProject(), visitor);
            Map<ParserPath, List<RfHidOperator>> operators = visitor.getPossibleInvalidOperators();
            for (Map.Entry<ParserPath, List<RfHidOperator>> entry : operators.entrySet()) {
                ParserPath path = entry.getKey();
                block2: for (RfHidOperator operator : entry.getValue()) {
                    List<RfClockingBlock> clkBlocks;
                    IRfScopeElement scope;
                    Set lhHids = operator.getLHHids(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
                    boolean invalidScope = false;
                    HashSet<IRfScopeElement> scopes = new HashSet<IRfScopeElement>();
                    for (IHid hid : lhHids) {
                        IRfNamedElement element = hid.getElement();
                        if (!(element instanceof RfField)) continue;
                        IRfScopeElement enclosingScope = element.getEnclosingScope(CLOCKING_BLOCK_CONTAINER_CLASSES);
                        if (enclosingScope == null) {
                            invalidScope = true;
                            break;
                        }
                        scopes.add(enclosingScope);
                    }
                    if (invalidScope || scopes.size() != 1 || !((scope = (IRfScopeElement)scopes.iterator().next()) instanceof RfNamedElement) || (clkBlocks = ((RfNamedElement)scope).getClockingBlocksWithPrefix("", 2, 1)) == null || clkBlocks.isEmpty()) continue;
                    for (RfClockingBlock clockingBlock : clkBlocks) {
                        IHidOperator clockingBlockOperator;
                        List<IHidOperator> atOperators = clockingBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_CLOCKING_EVENT}, true);
                        if (atOperators == null || atOperators.size() != 1 || !((clockingBlockOperator = atOperators.get(0)) instanceof RfHidOperator) || !this.equalOperators((RfHidOperator)clockingBlockOperator, operator)) continue;
                        boolean isForce = LintUtils.isInsideXVMReportingMacro(this.fOVMProject.getLibraryKind() == 2, operator.getOccurrence().getReparseInfo());
                        this.addHit(path, (HidOccurrence)operator.getOccurrence(), "Event control '" + HidUtils.toNiceString((IHidObject)operator) + "' is used instead of clocking block '" + LintUtils.getNamedElementFullName(clockingBlock) + "'!", isForce);
                        continue block2;
                    }
                }
            }
        }
    }

    private boolean equalOperators(RfHidOperator clockingBlockOperator, RfHidOperator operator) {
        ListContainer rhValues;
        IHidObject lhValue;
        ListContainer rhValues2;
        IHidObject clockingLHValue = clockingBlockOperator.getLHValue();
        if (clockingLHValue instanceof RfHidOperator && ((RfHidOperator)clockingLHValue).getOperatorText().equals(",") && (rhValues2 = ((RfHidOperator)clockingLHValue).getRHValues()) != null && rhValues2.size() == 1) {
            clockingLHValue = (IHidObject)rhValues2.get(0);
        }
        if ((lhValue = operator.getLHValue()) instanceof RfHidOperator && ((RfHidOperator)lhValue).getOperatorText().equals(",") && (rhValues = ((RfHidOperator)lhValue).getRHValues()) != null && rhValues.size() == 1) {
            lhValue = (IHidObject)rhValues.get(0);
        }
        if (clockingLHValue instanceof RfHidOperator && lhValue instanceof RfHidOperator) {
            return this.recursiveCompareOperators((RfHidOperator)clockingLHValue, (RfHidOperator)lhValue);
        }
        if (clockingLHValue instanceof RfHid && lhValue instanceof RfHid) {
            return this.equalHids((RfHid)clockingLHValue, (RfHid)lhValue);
        }
        return false;
    }

    private boolean equalHids(RfHid clockingOperatorLHValue, RfHid lhValue) {
        IRfScopeElement elementScope;
        String elementName;
        IRfNamedElement clockingElement = clockingOperatorLHValue.getElement();
        IRfNamedElement element = lhValue.getElement();
        if (clockingElement == null) {
            if (element == null) {
                return clockingOperatorLHValue.getName().equals(lhValue.getName());
            }
            return false;
        }
        if (element == null) {
            return false;
        }
        String clockingName = clockingElement.getName();
        if (!clockingName.equals(elementName = element.getName())) {
            return false;
        }
        IRfScopeElement clockingScope = clockingElement.getEnclosingScope(CLOCKING_BLOCK_CONTAINER_CLASSES);
        return clockingScope.equals(elementScope = element.getEnclosingScope(CLOCKING_BLOCK_CONTAINER_CLASSES));
    }

    private boolean recursiveCompareOperators(RfHidOperator clockingOperator, RfHidOperator operator) {
        if (clockingOperator.getOperatorType() != operator.getOperatorType()) {
            return false;
        }
        if (!clockingOperator.getOperatorText().equals(operator.getOperatorText())) {
            return false;
        }
        IHidObject clockingLHValue = clockingOperator.getLHValue();
        IHidObject lhValue = operator.getLHValue();
        if (clockingLHValue != null && lhValue == null) {
            return false;
        }
        if (clockingLHValue == null && lhValue != null) {
            return false;
        }
        if (clockingLHValue instanceof RfHidOperator && lhValue instanceof RfHidOperator) {
            if (!this.recursiveCompareOperators((RfHidOperator)clockingLHValue, (RfHidOperator)lhValue)) {
                return false;
            }
        } else if (clockingLHValue instanceof RfHid && lhValue instanceof RfHid) {
            if (!this.equalHids((RfHid)clockingLHValue, (RfHid)lhValue)) {
                return false;
            }
        } else if (clockingLHValue instanceof RfHidImplicit && lhValue instanceof RfHidImplicit) {
            String clockingName = ((RfHidImplicit)clockingLHValue).getName();
            String name = ((RfHidImplicit)lhValue).getName();
            if (clockingName != null && name != null && !clockingName.equals(name)) {
                return false;
            }
        } else if (clockingLHValue instanceof RfHidAccess && lhValue instanceof RfHidAccess) {
            Hid clockingParent = ((HidAccess)clockingLHValue).getParentHid();
            Hid parent = ((HidAccess)lhValue).getParentHid();
            if (clockingParent != null && parent != null) {
                IRfNamedElement clockingElement = clockingParent.getElement();
                IRfNamedElement element = parent.getElement();
                if (clockingElement != null && element != null && !clockingElement.equals(element)) {
                    return false;
                }
            }
        } else if (clockingLHValue != null && lhValue != null) {
            return false;
        }
        ListContainer clockingRHValues = clockingOperator.getRHValues();
        ListContainer rhValues = operator.getRHValues();
        if (clockingRHValues != null && rhValues == null) {
            return false;
        }
        if (clockingRHValues == null && rhValues != null) {
            return false;
        }
        if (clockingRHValues != null && rhValues != null) {
            if (clockingRHValues.size() != rhValues.size()) {
                return false;
            }
            int i = 0;
            while (i < clockingRHValues.size()) {
                IHidObject clockingRHValue = (IHidObject)clockingRHValues.get(i);
                IHidObject rhValue = (IHidObject)rhValues.get(i);
                if (clockingRHValue instanceof RfHidOperator && rhValue instanceof RfHidOperator) {
                    if (!this.recursiveCompareOperators((RfHidOperator)clockingRHValue, (RfHidOperator)rhValue)) {
                        return false;
                    }
                } else if (clockingRHValue instanceof RfHid && rhValue instanceof RfHid) {
                    if (!this.equalHids((RfHid)clockingRHValue, (RfHid)rhValue)) {
                        return false;
                    }
                } else if (clockingRHValue instanceof RfHidImplicit && rhValue instanceof RfHidImplicit) {
                    String clockingName = ((RfHidImplicit)clockingRHValue).getName();
                    String name = ((RfHidImplicit)rhValue).getName();
                    if (clockingName != null && name != null && !clockingName.equals(name)) {
                        return false;
                    }
                } else if (clockingRHValue instanceof RfHidAccess && rhValue instanceof RfHidAccess) {
                    Hid clockingParent = ((HidAccess)clockingRHValue).getParentHid();
                    Hid parent = ((HidAccess)rhValue).getParentHid();
                    if (clockingParent != null && parent != null) {
                        IRfNamedElement clockingElement = clockingParent.getElement();
                        IRfNamedElement element = parent.getElement();
                        if (clockingElement != null && element != null && !clockingElement.equals(element)) {
                            return false;
                        }
                    }
                } else {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    public class LocalHidOperatorVisitor
    implements IHidVisitor<RfHidOperator> {
        ParserPath parserPath;
        private Map<ParserPath, List<RfHidOperator>> possibleInvalidOperators = new HashMap<ParserPath, List<RfHidOperator>>();
        private IRfNamedElement scope;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(RfHidOperator hidOperator) {
            if (Check_SVTB_7_35.this.pSkipCovergroups && this.scope.getEnclosingScope(RfCovergroup.class) != null) {
                return true;
            }
            if (!hidOperator.hasQualifier(HidQualifierCache.IS_EVENT_CONTROL_QUALIFIER)) {
                return true;
            }
            IHidObject lhValue = hidOperator.getLHValue();
            if (HidUtils.isOperator((IHidObject)lhValue) && ((IHidOperator)lhValue).isRepeat()) {
                lhValue = ((IHidOperator)lhValue).getFirstRHValue();
            }
            if (lhValue == null) {
                return true;
            }
            Set lhHids = hidOperator.getLHHids(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS));
            if (lhHids == null) {
                return true;
            }
            for (IHid hid : lhHids) {
                IHid parentHid;
                IRfNamedElement hidElement;
                if (!(hid instanceof RfHid) || (hidElement = hid.getElement()) == null || hidElement instanceof RfClockingBlock || (parentHid = hid.getParentHid()) != null && parentHid.getElement() instanceof RfClockingBlock) continue;
                List<RfHidOperator> operators = this.possibleInvalidOperators.get(this.parserPath);
                if (operators == null) {
                    operators = new ArrayList<RfHidOperator>();
                }
                operators.add(hidOperator);
                this.possibleInvalidOperators.put(this.parserPath, operators);
                return true;
            }
            return true;
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }

        public Map<ParserPath, List<RfHidOperator>> getPossibleInvalidOperators() {
            return this.possibleInvalidOperators;
        }
    }

    class LocalHidVisitor
    extends RfHidVisitor {
        LocalHidVisitor() {
        }

        public boolean visit(RfHid hid) {
            IRfNamedElement element;
            if (this.holder instanceof HidHolder) {
                IRfNamedElement scope = ((HidHolder)this.holder).getScope();
                if (Check_SVTB_7_35.this.pSkipCovergroups && scope.getEnclosingScope(RfCovergroup.class) != null) {
                    return true;
                }
            }
            if (!((element = hid.getElement()) instanceof RfField)) {
                return true;
            }
            if (hid.getParentHid() == null || hid.getParentHid().getElement() instanceof RfClockingBlock) {
                return true;
            }
            String signalName = element.getName();
            IRfScopeElement enclosingScope = element.getEnclosingScope(CLOCKING_BLOCK_CONTAINER_CLASSES);
            if (enclosingScope == null) {
                return true;
            }
            List<RfClockingBlock> clkBlocks = ((RfNamedElement)enclosingScope).getClockingBlocksWithPrefix("", 2, 1);
            if (clkBlocks == null || clkBlocks.isEmpty()) {
                return true;
            }
            for (RfClockingBlock clockingBlock : clkBlocks) {
                List<IHidOperator> renameOperators = clockingBlock.getHidOperators(new HidOperatorQualifier[]{HidOperatorQualifier.IS_DECLARATION_ASSIGN}, true);
                HashSet<String> signals = new HashSet<String>();
                signals.addAll(clockingBlock.getSignalNames());
                HashMap<String, String> signalMap = new HashMap<String, String>();
                for (IHidOperator operator : renameOperators) {
                    String rhName;
                    IHid rhValue;
                    Set rhValues;
                    String lhName;
                    IHidObject lhValue;
                    if (!(operator instanceof RfHidOperator) || !((lhValue = operator.getLHValue()) instanceof RfHidImplicit) || (lhName = ((RfHidImplicit)lhValue).getName()) == null || lhName.isEmpty() || !signals.contains(lhName) || (rhValues = operator.getRHHids(EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS))).size() != 1 || !((rhValue = (IHid)rhValues.iterator().next()) instanceof RfHid) || (rhName = rhValue.getName()) == null || rhName.isEmpty()) continue;
                    signals.remove(lhName);
                    signals.add(rhName);
                    signalMap.put(rhName, lhName);
                }
                if (!signals.contains(signalName)) continue;
                String clockingBlockSignalName = (String)signalMap.get(signalName);
                if (clockingBlockSignalName == null) {
                    clockingBlockSignalName = signalName;
                }
                boolean isForce = LintUtils.isInsideXVMReportingMacro(Check_SVTB_7_35.this.fOVMProject.getLibraryKind() == 2, hid.getOccurrence().getReparseInfo());
                Check_SVTB_7_35.this.addHit(this.parserPath, hid.getOccurrence(), "Signal '" + signalName + "' is used instead of the clocking block signal '" + LintUtils.getNamedElementFullName(clockingBlock) + "." + clockingBlockSignalName + "'!", isForce);
                return true;
            }
            return true;
        }
    }
}

