/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.4")
@CheckID(value="SVTB.7.36")
@CheckName(value="SVTB.7.36")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Members of classes must be protected or local")
@CheckDescription(value="All classes that extend from <baseClass> must have all fields and methods protected or local.\n\nExamples for baseClass='parent':\n\nclass parent;\n\tlocal int a;\n\tprotected int b;\n\tint c;\nendclass\n\nclass child extends parent\n\tlocal int a; // allowed\n\tprotected int b; // allowed\n\tint c; // not allowed\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_36
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Check only classes that inherit from <baseClass>.", name="baseClass", required=CheckParameterRequired.MANDATORY, type=CheckParameterType.STRING)
    private String pBaseClass;
    @CheckParameter(defaultValue="", description="Comma separated list to filter inheritance subtrees out of the <baseClass> inheritance tree.", name="skipBaseClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipBaseClasses;
    @CheckParameter(defaultValue="", description="Comma separated list of field types that will be skipped.", name="skipFieldsOfTypes", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipFieldsOfTypes;
    @CheckParameter(defaultValue="", description="Comma separated list of full class names. If a field has a class type that inherints from a class specified in the list, it will be skipped.", name="skipFieldsOfInheritedClasses", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pSkipFieldsOfInheritedClasses;

    public Check_SVTB_7_36(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pBaseClass == null || this.pBaseClass.isEmpty()) {
            return;
        }
        RfClass baseClass = this.fOVMProject.getRfProject().getClass(this.pBaseClass, true);
        if (baseClass == null) {
            this.signalParamError("Class '" + this.pBaseClass + "' is not defined in the project!", true);
            return;
        }
        if (baseClass.getChildren() == null) {
            return;
        }
        HashSet<RfClass> visited = new HashSet<RfClass>();
        for (RfClass child : baseClass.getChildren()) {
            if (visited.contains(child)) continue;
            visited.add(child);
            this.analyseClass(child, visited);
        }
    }

    private void analyseClass(RfClass currentClass, Set<RfClass> visited) {
        Set<RfClass> children;
        if (currentClass == null) {
            return;
        }
        if (this.pSkipBaseClasses.contains(currentClass.getFullName())) {
            return;
        }
        this.notifyCheckAlive();
        boolean isPrewaived = false;
        RfFileDef file = currentClass.getFile();
        if (file != null && this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            isPrewaived = true;
        }
        if (!isPrewaived && !this.fOVMProject.isOVMElement(currentClass)) {
            this.checkElements(currentClass.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            this.checkElements(currentClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
            this.checkElements(currentClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if ((children = currentClass.getChildren()) == null || children.isEmpty()) {
            return;
        }
        for (RfClass element : children) {
            if (visited.contains(element)) continue;
            visited.add(element);
            this.analyseClass(element, visited);
        }
    }

    private void checkElements(List<? extends RfNamedElement> elements) {
        for (RfNamedElement rfNamedElement : elements) {
            if (rfNamedElement.isProtected() || rfNamedElement.isPrivate() || rfNamedElement instanceof RfFunction && ((RfFunction)rfNamedElement).isParentVirtual() || rfNamedElement instanceof RfField && this.shouldSkipField((RfField)rfNamedElement)) continue;
            this.addHit(rfNamedElement, this.getHitMessage(rfNamedElement));
        }
    }

    private boolean shouldSkipField(RfField field) {
        if (!this.pSkipFieldsOfTypes.isEmpty()) {
            DataType type = field.getDataType();
            if (type == null) {
                return false;
            }
            String name = type.toString();
            if (this.shouldSkip(this.pSkipFieldsOfTypes, name)) {
                return true;
            }
        }
        if (!this.pSkipFieldsOfInheritedClasses.isEmpty()) {
            RfClass associatedType = LintUtils.getFieldFinalClassTypeOrNull(field);
            if (associatedType == null) {
                return false;
            }
            RfClass type = associatedType;
            while (type != null) {
                String name = type.getFullName();
                if (this.shouldSkip(this.pSkipFieldsOfInheritedClasses, name)) {
                    return true;
                }
                type = type.getParent();
            }
        }
        return false;
    }

    private boolean shouldSkip(Set<String> types, String searched) {
        if (searched == null) {
            return false;
        }
        return types.contains(searched);
    }

    private String getHitMessage(RfNamedElement element) {
        String type = "";
        if (element instanceof RfField) {
            type = "Field";
        } else if (element instanceof RfFunction) {
            type = ((RfFunction)element).isTask() ? "Task" : "Function";
        }
        return String.valueOf(type) + " '" + LintUtils.getNamedElementFullName(element) + "' should be protected or local!";
    }
}

