/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.util.NullProtectedList;

@CheckVersion(value="20.1.25")
@CheckID(value="SVTB.7.37")
@CheckName(value="SVTB.7.37")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.INTERFACE, RuleLabel.MODULE, RuleLabel.PROGRAM, RuleLabel.PARAMETER, RuleLabel.VERIFICATION})
@CheckTitle(value="Class, interface, module or program parameters should all have default values.")
@CheckDescription(value="Every nonlocal <elementKind> parameter declared should have a default value specified.\nExamples:\n - Not Allowed: class a #(int p1);\n - Not Allowed: module b #(type p2);\n - Allowed: class c #(int p3 = 5);\n - Allowed: interface d #(type p4 = bit);")
public class Check_SVTB_7_37
extends OVMComplianceCheck {
    private static final String INTERFACE = "interface";
    private static final String MODULE = "module";
    private static final String CLASS = "class";
    private static final String PROGRAM = "program";
    private static final Set<String> ELEMENT_KIND_SET = new HashSet<String>(Arrays.asList("interface", "module", "class", "program"));
    @CheckParameter(defaultValue="class, module, interface, program", description="Comma separated list of element kinds for which the parameters must have default values. Possible values: class, module, interface, program.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pElementKind;

    public Check_SVTB_7_37(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void configure() {
        super.configure();
        for (String elementKind : this.pElementKind) {
            if (ELEMENT_KIND_SET.contains(elementKind)) continue;
            this.signalParamError("'" + elementKind + "' is not a valid value for parameter!", true);
        }
    }

    @Override
    public void performCheckImpl() {
        NullProtectedList<RfNamedElement> elements = new NullProtectedList<RfNamedElement>();
        if (this.pElementKind.contains(CLASS)) {
            elements.addAll(this.fOVMProject.getAllNonXVMClasses());
        }
        if (this.pElementKind.contains(MODULE)) {
            elements.addAll(this.fOVMProject.getAllInterfaces());
        }
        if (this.pElementKind.contains(INTERFACE)) {
            elements.addAll(this.fOVMProject.getAllModules());
        }
        if (this.pElementKind.contains(PROGRAM)) {
            elements.addAll(this.fOVMProject.getAllPrograms());
        }
        for (RfNamedElement rfNamedElement : elements) {
            this.notifyCheckAlive();
            List<RfField> allParameters = null;
            if (rfNamedElement instanceof RfClass || rfNamedElement instanceof RfInterface || rfNamedElement instanceof RfModule || rfNamedElement instanceof RfProgram) {
                allParameters = rfNamedElement.getLocalParameters(384);
            }
            if (allParameters == null) continue;
            for (RfField rfField : allParameters) {
                String initialValue;
                if (!rfField.isInParameterPortList() || (initialValue = rfField.getInitialValue(false)) != null) continue;
                this.addHit(rfField, "Parameter '" + rfField.getName() + "' of " + LintUtils.getElementKind(rfNamedElement) + " '" + rfNamedElement.getFullName() + "' doesn't have a default value!");
            }
        }
    }
}

