/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfAssociatedType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.parser.ReparseInfo;

@CheckVersion(value="21.1.9")
@CheckID(value="SVTB.7.38")
@CheckName(value="SVTB.7.38")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.MACRO, RuleLabel.FIELD, RuleLabel.VERIFICATION})
@CheckTitle(value="Do not modify class variables in print macros")
@CheckDescription(value="Inside print macros, class fields should not be modified as this is not their purpose.\nThe rule checks all the methods called directly or indirectly from within the macros.\n\nExamples:\n\n`define singleton_macro(obj) \\\n\tobj.get_inst();\n\nclass singleton_class;\n\tstatic singleton_class inst;\n\n\tstatic function singleton_class get_inst();\n\t\tif (inst == null)\n\t\t\tinst = new();\n\t\treturn inst;\n\tendfunction\nendclass\n\nclass test_class;\n\tsingleton_class sg;\n\n\tfunction foo();\n\t\t`singleton_macro(sg); //not allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_7_38
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="", description="Comma separated list of macro names for which the rule is checked.", name="macroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private Set<String> pMacroNames;
    @CheckParameter(defaultValue="true", description="When true the check is applied when at least one of the nested macro call names is listed in macroNames. When false the check is applied only when the topmost macro name is listed in macroNames.", name="checkAllNestedMacroNames", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckAllNestedMacroNames;
    @CheckParameter(defaultValue="false", description="Skip checking calls that generate singleton objects.", name="skipSingletonObjects", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipSingletonObjects;
    private final Set<String> QUEUE_MODIFYING_CALLS = new HashSet<String>(Arrays.asList("push_front", "pop_front", "push_back", "pop_back", "insert", "delete"));
    private Set<RfFunction> visitedFunctions = new HashSet<RfFunction>();
    private Set<RfFunction> failedFunctions = new HashSet<RfFunction>();
    private Map<RfFunction, ArrayList<CallInfo>> callStacks = new HashMap<RfFunction, ArrayList<CallInfo>>();
    private Map<RfFunction, CallInfo> failedFieldForFunction = new HashMap<RfFunction, CallInfo>();

    public Check_SVTB_7_38(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        if (this.pMacroNames.isEmpty()) {
            return;
        }
        MacroVisitor macroVisitor = new MacroVisitor();
        this.fOVMProject.getRfProject().visitHidObject(this.fOVMProject.getRfProject(), macroVisitor);
        FunctionVisitor functionVisitor = new FunctionVisitor();
        this.checkInMacros(functionVisitor, macroVisitor.getCallsInMacro());
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private void checkInMacros(FunctionVisitor functionVisitor, Map<MacroInfo, List<RfHid>> callsInMacro) {
        for (Map.Entry<MacroInfo, List<RfHid>> entry : callsInMacro.entrySet()) {
            MacroInfo macroInfo = entry.getKey();
            List<RfHid> functionCalls = entry.getValue();
            for (RfHid callHid : functionCalls) {
                RfNamedElement callElement;
                CallInfo callInfo;
                RfFunction tempFunction;
                RfFunction function;
                RfNamedElement parentElementType;
                IRfNamedElement assocType;
                RfHid parentHid;
                this.visitedFunctions.clear();
                this.failedFunctions.clear();
                this.callStacks.clear();
                this.failedFieldForFunction.clear();
                if (callHid.getParentAccess() == null || !(callHid.getParentAccess() instanceof RfHidAccess) || !(callHid.getParentAccess().getParentHid() instanceof RfHid) || !((parentHid = (RfHid)callHid.getParentAccess().getParentHid()).getElement() instanceof RfField) || !((assocType = ((RfField)parentHid.getElement()).getAssociatedType()) instanceof RfClass) || !(callHid.getElement() instanceof RfFunction)) continue;
                RfClass methodCallScope = null;
                if (parentHid.getElement() instanceof RfAssociatedType && (parentElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentHid.getElement())) instanceof RfClass) {
                    methodCallScope = (RfClass)parentElementType;
                }
                if (methodCallScope == null) {
                    methodCallScope = (RfClass)assocType;
                }
                if (!this.fOVMProject.isOVMElement(function = (RfFunction)callHid.getElement()) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, callHid, methodCallScope)) != null) {
                    function = tempFunction;
                }
                functionVisitor.setNotFound();
                functionVisitor.setParentFunction(function);
                functionVisitor.setCallingClass(methodCallScope);
                if (!this.visitedFunctions.contains(function)) {
                    this.visitedFunctions.add(function);
                    function.visitHidObject(null, functionVisitor);
                    if (functionVisitor.isFound()) {
                        this.callStacks.putIfAbsent(function, new ArrayList());
                        this.callStacks.get(function).add(new CallInfo(function, macroInfo.getParserPath(), callHid.getOccurrence().getLine()));
                        this.failedFunctions.add(function);
                    }
                } else if (this.failedFunctions.contains(function)) {
                    this.callStacks.get(function).remove(this.callStacks.get(function).size() - 1);
                    this.callStacks.get(function).add(new CallInfo(function, macroInfo.getParserPath(), callHid.getOccurrence().getLine()));
                }
                if (!this.failedFunctions.contains(function)) continue;
                ArrayList<CallInfo> callStack = this.callStacks.get(function);
                StringBuilder stringBuilder = new StringBuilder();
                int lastCallIndex = callStack.size();
                int callIndex = lastCallIndex - 1;
                while (callIndex >= 1) {
                    callInfo = callStack.get(callIndex);
                    callElement = callInfo.getElement();
                    CallInfo nextCallInfo = callStack.get(callIndex - 1);
                    RfNamedElement nextCallElement = nextCallInfo.getElement();
                    stringBuilder.append("\n" + (lastCallIndex - callIndex - 1) + ". " + this.link(callElement) + "() - calls " + nextCallElement.getName() + "() in " + this.link(String.valueOf(LintUtils.getFileShortName(nextCallInfo.getPath().path)) + ":" + nextCallInfo.getLine(), nextCallInfo.getPath().path, nextCallInfo.getLine()));
                    --callIndex;
                }
                callInfo = callStack.get(0);
                callElement = callInfo.getElement();
                stringBuilder.append("\n" + (lastCallIndex - 1) + ". " + this.link(callElement) + "() - modifies class variable");
                String hitMessage = "Macro call '`" + macroInfo.getName() + "' modifies class variable at call " + callHid.getName() + "()!";
                CallInfo modifiedInfo = this.failedFieldForFunction.get(function);
                String variableMessage = String.valueOf(this.link(modifiedInfo.getElement())) + " - " + this.link(String.valueOf(LintUtils.getFileShortName(modifiedInfo.getPath().path)) + ":" + modifiedInfo.getLine(), modifiedInfo.getPath().path, modifiedInfo.getLine());
                this.addHit(macroInfo.getParserPath(), callHid.getOccurrence(), String.valueOf(hitMessage) + "\n" + "Call stack:" + stringBuilder.toString() + "\n" + "Modified class variable: " + variableMessage, true);
            }
        }
    }

    private RfField checkAssignment(RfHidOperator operator, IRfNamedElement scope) {
        RfField field;
        Set rhHids;
        if (!operator.isAssignment()) {
            return null;
        }
        IHidObject lhObject = operator.getLHValue();
        if (operator.getRHValues() == null || operator.getRHValues().size() != 1) {
            return null;
        }
        if (lhObject instanceof RfHidAccess && ((RfHidAccess)lhObject).getParentHid() != null) {
            lhObject = ((RfHidAccess)lhObject).getParentHid();
        }
        if (!(lhObject instanceof RfHid)) {
            return null;
        }
        RfHid lhHid = (RfHid)lhObject;
        while (lhHid.getParentAccess() != null && lhHid.getParentHid() instanceof RfHid && !lhHid.getParentHid().getName().equals("this")) {
            lhHid = (RfHid)lhHid.getParentHid();
        }
        if (!(lhHid.getElement() instanceof RfField)) {
            return null;
        }
        if (this.pSkipSingletonObjects && (rhHids = operator.getRHHids(HidFlatteningOption.NONE_EXCLUDED)) != null && !rhHids.isEmpty()) {
            for (IHid rhHid : rhHids) {
                RfHid callHid;
                boolean isSingleton;
                if (!(rhHid instanceof RfHid) || !(isSingleton = LintUtils.isSingletonCall(lhHid, callHid = (RfHid)rhHid, scope, true, true))) continue;
                return null;
            }
        }
        if (this.fOVMProject.isOVMElement(field = (RfField)lhHid.getElement())) {
            return null;
        }
        if (field.isField() && field.getEnclosingScope(RfClass.class) != null) {
            return field;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private RfField checkQueueModifyingCalls(RfHid hid) {
        if (hid.getParentAccess() == null) {
            return null;
        }
        if (RfListType.isQueue((IRfScopeElement)hid.getParentAccess().getAssociatedType())) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            hid = (RfHid)hid.getParentHid();
lbl6:
            // 2 sources

            ** while (hid.getParentAccess() != null && hid.getParentHid() instanceof RfHid && !hid.getParentHid().getName().equals((Object)"this"))
        }
lbl7:
        // 1 sources

        if (!(hid.getElement() instanceof RfField)) {
            return null;
        }
        field = (RfField)hid.getElement();
        if (this.fOVMProject.isOVMElement(field)) {
            return null;
        }
        if (field.isField() && field.getEnclosingScope(RfClass.class) != null) {
            return field;
        }
        return null;
    }

    private RfClass getMethodCallScope(RfHid hidObject) {
        if (LintUtils.isSuper(hidObject)) {
            return null;
        }
        if (hidObject.getParentAccess() == null) {
            return null;
        }
        HidAccess parentAccess = hidObject.getParentAccess();
        if (parentAccess.getParentHid() == null) {
            return null;
        }
        Hid parentHid = parentAccess.getParentHid();
        if (!(parentHid instanceof RfHid)) {
            return null;
        }
        IRfNamedElement parentElement = parentHid.getElement();
        if (!(parentElement instanceof RfAssociatedType)) {
            return null;
        }
        RfNamedElement parentElementType = LintUtils.getAssociatedFinalType((RfAssociatedType)parentElement);
        if (parentElementType instanceof RfClass) {
            return (RfClass)parentElementType;
        }
        return null;
    }

    private static class CallInfo {
        RfNamedElement element;
        ParserPath path;
        int line;

        public CallInfo(RfNamedElement element, ParserPath path, int line) {
            this.element = element;
            this.path = path;
            this.line = line;
        }

        public RfNamedElement getElement() {
            return this.element;
        }

        public ParserPath getPath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }
    }

    private class FunctionVisitor
    implements IHidVisitor<IHidObject> {
        private Map<RfFunction, RfFunction> parentFunctions = new HashMap<RfFunction, RfFunction>();
        private RfFunction parentFunction;
        private RfClass callingClass;
        private boolean found;
        private ParserPath parserPath;
        private IRfNamedElement scope;

        private FunctionVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public void setNotFound() {
            this.found = false;
        }

        public void setParentFunction(RfFunction parentFunction) {
            this.parentFunction = parentFunction;
        }

        public void setCallingClass(RfClass callingClass) {
            this.callingClass = callingClass;
        }

        public boolean isFound() {
            return this.found;
        }

        public boolean visit(IHidObject hidObject) {
            if (this.found) {
                return false;
            }
            Check_SVTB_7_38.this.notifyCheckAlive();
            if (hidObject instanceof RfHidOperator) {
                RfHidOperator operator = (RfHidOperator)hidObject;
                RfField modifiedField = Check_SVTB_7_38.this.checkAssignment(operator, this.scope);
                if (modifiedField != null) {
                    this.found = true;
                    Check_SVTB_7_38.this.failedFunctions.add(this.parentFunction);
                    Check_SVTB_7_38.this.failedFieldForFunction.putIfAbsent(this.parentFunction, new CallInfo(modifiedField, this.parserPath, operator.getOccurrence().getLine()));
                }
            } else if (hidObject instanceof RfHid) {
                RfHid hid = (RfHid)hidObject;
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                if (LintUtils.checkIsCreateCall(hid) || LintUtils.checkIsNewCall(hid)) {
                    return true;
                }
                if (Check_SVTB_7_38.this.QUEUE_MODIFYING_CALLS.contains(hid.getName())) {
                    RfField modifiedField = Check_SVTB_7_38.this.checkQueueModifyingCalls(hid);
                    if (modifiedField != null) {
                        this.found = true;
                        Check_SVTB_7_38.this.failedFunctions.add(this.parentFunction);
                        Check_SVTB_7_38.this.failedFieldForFunction.putIfAbsent(this.parentFunction, new CallInfo(modifiedField, this.parserPath, hid.getOccurrence().getLine()));
                    }
                } else {
                    RfFunction tempFunction;
                    if (!(hid.getElement() instanceof RfFunction)) {
                        return true;
                    }
                    RfClass methodCallScope = Check_SVTB_7_38.this.getMethodCallScope((RfHid)hidObject);
                    if (methodCallScope == null) {
                        methodCallScope = this.callingClass;
                    }
                    RfFunction function = (RfFunction)hid.getElement();
                    if (!Check_SVTB_7_38.this.fOVMProject.isOVMElement(function) && function.isVirtual() && (tempFunction = LintUtils.getValidVirtualFunction(function, (RfHid)hidObject, methodCallScope)) != null) {
                        function = tempFunction;
                    }
                    ParserPath callPath = this.parserPath;
                    if (!Check_SVTB_7_38.this.visitedFunctions.contains(function)) {
                        Check_SVTB_7_38.this.visitedFunctions.add(function);
                        this.parentFunctions.put(function, this.parentFunction);
                        this.parentFunction = function;
                        function.visitHidObject(null, this);
                        this.parentFunction = this.parentFunctions.get(function);
                        if (Check_SVTB_7_38.this.failedFunctions.contains(function)) {
                            Check_SVTB_7_38.this.callStacks.putIfAbsent(function, new ArrayList());
                            Check_SVTB_7_38.this.callStacks.get(function).add(new CallInfo(function, callPath, hid.getOccurrence().getLine()));
                        }
                    }
                    if (Check_SVTB_7_38.this.failedFunctions.contains(function)) {
                        Check_SVTB_7_38.this.callStacks.get(function).remove(Check_SVTB_7_38.this.callStacks.get(function).size() - 1);
                        Check_SVTB_7_38.this.callStacks.get(function).add(new CallInfo(function, callPath, hid.getOccurrence().getLine()));
                        Check_SVTB_7_38.this.callStacks.putIfAbsent(this.parentFunction, new ArrayList());
                        Check_SVTB_7_38.this.callStacks.get(this.parentFunction).addAll((Collection<CallInfo>)Check_SVTB_7_38.this.callStacks.get(function));
                        if (Check_SVTB_7_38.this.failedFieldForFunction.containsKey(function)) {
                            Check_SVTB_7_38.this.failedFieldForFunction.put(this.parentFunction, Check_SVTB_7_38.this.failedFieldForFunction.get(function));
                        }
                        Check_SVTB_7_38.this.failedFunctions.add(this.parentFunction);
                        this.found = true;
                    }
                }
            }
            return !this.found;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private static class MacroInfo {
        private ParserPath parserPath;
        private String name;

        public MacroInfo(ParserPath parserPath, String name) {
            this.parserPath = parserPath;
            this.name = name;
        }

        public ParserPath getParserPath() {
            return this.parserPath;
        }

        public String getName() {
            return this.name;
        }
    }

    private class MacroVisitor
    implements IHidVisitor<IHidObject> {
        private int crtLine = -1;
        private MacroInfo macroInfo;
        private Map<MacroInfo, List<RfHid>> callsInMacro = new HashMap<MacroInfo, List<RfHid>>();
        private ParserPath parserPath;
        private IRfNamedElement scope;

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            if (holder instanceof HidHolder) {
                this.scope = ((HidHolder)holder).getScope();
            }
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHid) && !(hidObject instanceof RfHidOperator)) {
                return true;
            }
            if (Check_SVTB_7_38.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_7_38.this.notifyCheckAlive();
            if (hidObject instanceof RfHid) {
                RfHid hid = (RfHid)hidObject;
                if (!(hid.getReparseInfo() instanceof ReparseInfo)) {
                    return true;
                }
                if (!hid.isMethodCall(false)) {
                    return true;
                }
                ReparseInfo reparseInfo = (ReparseInfo)hid.getReparseInfo();
                String macroName = "";
                boolean foundOnStack = false;
                if (Check_SVTB_7_38.this.pCheckAllNestedMacroNames) {
                    int i = 0;
                    while (i < reparseInfo.getReparseStack().length && !foundOnStack) {
                        if (Check_SVTB_7_38.this.pMacroNames.contains(reparseInfo.getReparseStack()[i].getReparseMacroName())) {
                            foundOnStack = true;
                        }
                        ++i;
                    }
                } else if (Check_SVTB_7_38.this.pMacroNames.contains(reparseInfo.getReparseStack()[0].getReparseMacroName())) {
                    foundOnStack = true;
                }
                if (!foundOnStack) {
                    return true;
                }
                macroName = reparseInfo.getReparseStack()[0].getReparseMacroName();
                int line = hid.getOccurrence().getLine();
                if (line != this.crtLine) {
                    this.macroInfo = new MacroInfo(this.parserPath, macroName);
                    this.crtLine = line;
                }
                if (Check_SVTB_7_38.this.QUEUE_MODIFYING_CALLS.contains(hid.getName())) {
                    RfField modifiedField = Check_SVTB_7_38.this.checkQueueModifyingCalls(hid);
                    if (modifiedField != null) {
                        Check_SVTB_7_38.this.addHit(this.macroInfo.getParserPath(), hid.getOccurrence(), "Macro call '`" + this.macroInfo.getName() + "' modifies class variable at call " + hid.getName() + "()!" + "\n" + "Modified variable: " + modifiedField.getFullName(), true);
                    }
                } else {
                    this.callsInMacro.putIfAbsent(this.macroInfo, new LinkedList());
                    this.callsInMacro.get(this.macroInfo).add(hid);
                }
            } else {
                RfField modifiedField;
                RfHidOperator operator = (RfHidOperator)hidObject;
                if (!(operator.getReparseInfo() instanceof ReparseInfo)) {
                    return true;
                }
                ReparseInfo reparseInfo = (ReparseInfo)operator.getReparseInfo();
                String macroName = "";
                boolean foundOnStack = false;
                if (Check_SVTB_7_38.this.pCheckAllNestedMacroNames) {
                    int i = 0;
                    while (i < reparseInfo.getReparseStack().length && !foundOnStack) {
                        if (Check_SVTB_7_38.this.pMacroNames.contains(reparseInfo.getReparseStack()[i].getReparseMacroName())) {
                            foundOnStack = true;
                        }
                        ++i;
                    }
                } else if (Check_SVTB_7_38.this.pMacroNames.contains(reparseInfo.getReparseStack()[0].getReparseMacroName())) {
                    foundOnStack = true;
                }
                if (!foundOnStack) {
                    return true;
                }
                macroName = reparseInfo.getReparseStack()[0].getReparseMacroName();
                int line = operator.getOccurrence().getLine();
                if (line != this.crtLine) {
                    this.macroInfo = new MacroInfo(this.parserPath, macroName);
                    this.crtLine = line;
                }
                if ((modifiedField = Check_SVTB_7_38.this.checkAssignment(operator, this.scope)) != null) {
                    Check_SVTB_7_38.this.addHit(this.macroInfo.getParserPath(), (HidOccurrence)operator.getOccurrence(), "Macro call '`" + this.macroInfo.getName() + "' modifies class variable " + modifiedField.getFullName() + "!", true);
                }
            }
            return true;
        }

        public Map<MacroInfo, List<RfHid>> getCallsInMacro() {
            return this.callsInMacro;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

