/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfStruct;

@CheckVersion(value="3.1")
@CheckID(value="SVTB.7.4")
@CheckName(value="SVTB.7.4")
@CheckLabel(labels={RuleLabel.CLASS, RuleLabel.INITIALIZATION, RuleLabel.FIELD, RuleLabel.VERIFICATION, RuleLabel.DECLARATION_ASSIGN})
@CheckTitle(value="Do not initialize class member variables upon declaration")
@CheckDescription(value="Initialize class member variables in the constructor or some subsequent phase method.\nException: static members can be initialized on declaration (in-line).\n\nExamples:\n\nclass myclass1;\n  bit checks_enable = 1; // not allowed\n  bit write_enable;\n\n\tfunction new(string name);\n\t\twrite_enable = 1; // allowed\n\tendfunction\nendclass\n")
public class Check_SVTB_7_4
extends OVMComplianceCheck {
    public Check_SVTB_7_4(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        for (RfNamedElement classs : this.fOVMProject.getAllNonXVMClasses()) {
            this.checkContainer(classs, (RfClass)classs);
        }
    }

    private void checkContainer(RfNamedElement elem, RfClass classs) {
        List<RfField> fields = elem.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE);
        if (fields == null || fields.isEmpty()) {
            return;
        }
        this.notifyCheckAlive();
        for (RfField field : fields) {
            if (field.isObjectStatic()) continue;
            if (field.getInitialValue(false) != null) {
                this.addHit(field, "Member '" + field.getName() + "' of class '" + classs.getFullName() + "' is initialized upon declaration!");
                continue;
            }
            RfNamedElement fieldType = LintUtils.getAssociatedFinalType(field);
            if (fieldType == null || !(fieldType instanceof RfStruct)) continue;
            this.checkContainer(fieldType, classs);
        }
    }
}

