/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.IWhitespaceParserCheck;
import ro.amiq.vlogdt.linter.utils.LiteralToken;
import ro.amiq.vlogdt.linter.utils.SVTBWhitespaceParser;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;

@CheckVersion(value="20.1.39")
@CheckID(value="SVTB.8.2.1")
@CheckName(value="SVTB.8.2.1")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.EVENT_CONTROL, RuleLabel.ALWAYS})
@CheckTitle(value="Always blocks should always have an event control.")
@CheckDescription(value="Because of its looping nature, the always block is only useful when used in conjunction with some form of timing control.\nIn an always block the event control should be right after 'always'.\nAlways block without event controls at the top cannot be synthesized. Such blocks will be executed at time 0 of simulation in random order.\n\nExamples:\nalways  // not allowed\n\tbegin\n\tend\n\ninteger clk;\nalways @(posedge clk) // allowed\n\tbegin\n\tend\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_2_1
extends OVMComplianceCheck
implements IWhitespaceParserCheck {
    private static final int ALWAYS_LENGTH = 6;

    public Check_SVTB_8_2_1(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        List<RfActionBlock> actionBlockList = this.fOVMProject.getRfProject().getAllActionBlocks();
        for (RfActionBlock rfActionBlock : actionBlockList) {
            this.handleActionBlock(rfActionBlock);
        }
    }

    private void handleActionBlock(RfActionBlock actionBlock) {
        if (actionBlock == null) {
            return;
        }
        if (!actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS)) {
            return;
        }
        RfFileDef file = actionBlock.getFile();
        if (file == null) {
            return;
        }
        if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this)) {
            return;
        }
        this.notifyCheckAlive();
        RfDefElement actionBlockDef = actionBlock.getDeclaration();
        if (!(actionBlockDef instanceof RfActionBlockDef)) {
            return;
        }
        LiteralToken token = actionBlock.isAnonymous() ? this.getWSParser().getTokenContainingOffset(actionBlock.getStartOffset() - 6, file.getParserPath()) : this.getAlways(actionBlock);
        if (token == null) {
            return;
        }
        if (token.getStringToken().equals("always")) {
            LiteralToken nextToken = this.getWSParser().getNextToken(token, file.getParserPath());
            while (nextToken != null && nextToken.getZone() != SVTBWhitespaceParser.ZoneType.CODE) {
                nextToken = this.getWSParser().getNextToken(nextToken, file.getParserPath());
            }
            if (nextToken == null || !nextToken.getStringToken().startsWith("@")) {
                this.addHit(actionBlock, "Always block does not have an event control!");
            }
        } else if (!token.getStringToken().startsWith("always@")) {
            this.addHit(actionBlock, "Always block does not have an event control!");
        }
    }

    private LiteralToken getAlways(RfActionBlock actionBlock) {
        RfFileDef file = actionBlock.getFile();
        LiteralToken token = this.getWSParser().getTokenContainingOffset(actionBlock.getStartOffset() - 6, file.getParserPath());
        while (!(token == null || token.getStringToken().startsWith("always") && token.getZone() == SVTBWhitespaceParser.ZoneType.CODE)) {
            token = this.getWSParser().getPrevToken(token, file.getParserPath());
        }
        return token;
    }
}

