/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractProtectiveForkForMethodCallsCheck;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.7")
@CheckID(value="SVTB.8.4.10")
@CheckName(value="SVTB.8.4.10")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use disable fork if it is not enclosed by a protective fork-join block")
@CheckDescription(value="Do not use disable fork if it is not enclosed by a protective fork-join block(fork begin ... end join).\nDisable fork terminates all subprocesses of the calling process even if they are started by multiple fork-join blocks, this can be sometimes unexpected.\n\nExamples:\n\nmodule test;\n\ttask t1();\n\t\tfork\n\t\tjoin_none\n\t\tdisable fork; // not allowed\n\tendtask\n\n\ttask t2();\n\t\tfork\n\t\t\tfork\n\t\t\tjoin_any\n\t\t\tdisable fork; // not allowed\n\t\tjoin_none\n\tendtask\n\n\ttask t3();\n\t\tfork\n\t\t\tbegin\n\t\t\t\tfork\n\t\t\t\tjoin_any\n\t\t\t\tdisable fork; // allowed\n\t\t\tend\n\t\tjoin_none\n\tendtask\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_4_10
extends AbstractProtectiveForkForMethodCallsCheck {
    public Check_SVTB_8_4_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean checkOperatorType(RfHidOperator hidOperator) {
        return hidOperator.isDisableStatement();
    }

    @Override
    protected String generateHitMessage() {
        return "'disable fork' used without enclosing protective fork-join block!";
    }
}

