/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractProtectiveForkForMethodCallsCheck;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.7")
@CheckID(value="SVTB.8.4.11")
@CheckName(value="SVTB.8.4.11")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.WAIT, RuleLabel.FORK, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use wait fork if it is not enclosed by a protective fork-join block")
@CheckDescription(value="Do not use wait fork if it is not enclosed by a protective fork-join block(fork begin ... end join).\nWait fork statement blocks process execution flow until all child subprocesses have completed their execution, this can be sometimes unexpected.\n\nExamples:\n\nmodule test;\n\ttask t1();\n\t\tfork\n\t\tjoin_none\n\t\twait fork; // not allowed\n\tendtask\n\n\ttask t2();\n\t\tfork\n\t\t\tfork\n\t\t\tjoin_any\n\t\t\twait fork; // not allowed\n\t\tjoin_none\n\tendtask\n\n\ttask t3();\n\t\tfork\n\t\t\tbegin\n\t\t\t\tfork\n\t\t\t\tjoin_any\n\t\t\t\twait fork; // allowed\n\t\t\tend\n\t\tjoin_none\n\tendtask\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_4_11
extends AbstractProtectiveForkForMethodCallsCheck {
    public Check_SVTB_8_4_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    protected boolean checkOperatorType(RfHidOperator hidOperator) {
        return hidOperator.isWaitStatement();
    }

    @Override
    protected String generateHitMessage() {
        return "'wait fork' used without enclosing protective fork-join block!";
    }
}

