/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.SearchDependencyContainer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidVisitor;

@CheckVersion(value="18.1.42")
@CheckID(value="SVTB.8.4.3")
@CheckName(value="SVTB.8.4.3")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use disable fork when there are more than one fork-join_any or fork-join_none blocks before it")
@CheckDescription(value="Do not use disable fork when there are more than one fork-join_any or fork-join_none blocks before it.\nDisable fork terminates all subprocesses of the calling process even if they are started by multiple fork-join blocks, this can be sometimes unexpected.\nAlso, disable fork simulators' behavior changed in time and this can lead to a new behaviour when switching the simulator.\n\nTo avoid this, you can wrap the fork-join_any or fork-join_none and the disable fork into a 'protective fork' or you can use the process API to kill the subprocesses.\n\nExample:\n\tinitial begin\n\t\tfork\n\t\t\t...\n\t\tjoin_none\n\t\t...\n\t\tfork\n\t\t\t...\n\t\tjoin_none\n\t\t...\n\t\tdisable fork // not allowed, it kills all active processes, including those started in the first fork\n\tend\n\nUse instead a protective fork:\n\tinitial begin\n\t\tfork\n\t\t\t...\n\t\tjoin_none\n\t\t...\n\t\tfork\n\t\t\tfork\n\t\t\t\t...\n\t\t\tjoin_none\n\t\t\t\t...\n\t\t\tdisable fork // kills only the processes started in the second fork\n\t\tjoin\n\tend\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_4_3
extends OVMComplianceCheck {
    public Check_SVTB_8_4_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HashMap<RfNamedElement, List<Integer>> scopesWithDisable = new HashMap<RfNamedElement, List<Integer>>();
        ArrayList<RfFunction> functionsWithDisable = new ArrayList<RfFunction>();
        this.fOVMProject.getRfProject().visitHidObject(null, new DisableForkVisitor(scopesWithDisable, functionsWithDisable, this));
        HashMap<RfFunction, RfFunction> functionCallingDisableFrom = new HashMap<RfFunction, RfFunction>();
        ArrayList<RfFunction> functionsCallingDisable = new ArrayList<RfFunction>(functionsWithDisable);
        HashMap<RfFunction, List<MethodCall>> allMethodCalls = new HashMap<RfFunction, List<MethodCall>>();
        while (!functionsCallingDisable.isEmpty()) {
            Object members;
            HashSet<RfFunction> functionsCallingDisableToBePropagated = new HashSet<RfFunction>();
            ArrayList dependencyList = new ArrayList();
            for (RfFunction rfFunction : functionsCallingDisable) {
                for (IRfNamedElement dependency : SearchDependencyContainer.getAllDependencies(rfFunction, this.fOVMProject.getRfProject(), false, false, false, true)) {
                    if (!(dependency instanceof RfNamedElement) || (members = ((RfNamedElement)dependency).getMembers()) == null || members.isEmpty()) continue;
                    members.stream().filter(m -> m instanceof RfFunction).map(RfFunction.class::cast).collect(Collectors.toCollection(() -> dependencyList));
                }
            }
            for (RfFunction rfFunction : dependencyList) {
                List<MethodCall> methodCalls = (List<MethodCall>)allMethodCalls.get(rfFunction);
                if (methodCalls == null) {
                    methodCalls = this.getMethodCalls(rfFunction);
                    allMethodCalls.put(rfFunction, methodCalls);
                    methodCalls.sort((f1, f2) -> f1.occurrence.getLine() - f2.occurrence.getLine());
                }
                members = methodCalls.iterator();
                while (members.hasNext()) {
                    MethodCall methodCall = (MethodCall)members.next();
                    if (!functionsCallingDisable.contains(methodCall.method) || methodCall.method.equals(rfFunction)) continue;
                    RfFunction origin = (RfFunction)functionCallingDisableFrom.get(methodCall.method);
                    if (origin != null) {
                        if (origin.equals(rfFunction)) continue;
                        functionCallingDisableFrom.put(rfFunction, origin);
                    } else {
                        functionCallingDisableFrom.put(rfFunction, (RfFunction)methodCall.method);
                    }
                    boolean containsKey = scopesWithDisable.containsKey(rfFunction);
                    if (!containsKey) {
                        scopesWithDisable.put(rfFunction, new ArrayList<Integer>(Arrays.asList(methodCall.occurrence.getLine())));
                    } else {
                        ((List)scopesWithDisable.get(rfFunction)).add(methodCall.occurrence.getLine());
                    }
                    if (functionsCallingDisableToBePropagated.contains(rfFunction) || containsKey) continue;
                    functionsCallingDisableToBePropagated.add(rfFunction);
                }
            }
            functionsCallingDisable.clear();
            functionsCallingDisable.addAll(functionsCallingDisableToBePropagated);
        }
        HashMap<String, Map<RfFunction, List<RfActionBlock>>> forksPerFunction = new HashMap<String, Map<RfFunction, List<RfActionBlock>>>();
        ArrayList<RfFunction> allFunctionsAndTasks = new ArrayList<RfFunction>(Arrays.asList(this.fOVMProject.getRfProject().getAllFunctionsAndTasks()));
        for (RfFunction rfFunction : allFunctionsAndTasks) {
            List<RfActionBlock> actionBlocks;
            String functionName = rfFunction.getFullName();
            HashMap<RfFunction, List<Object>> currentFunctions = (HashMap<RfFunction, List<Object>>)forksPerFunction.get(functionName);
            if (currentFunctions != null && currentFunctions.containsKey(rfFunction)) continue;
            if (currentFunctions == null) {
                currentFunctions = new HashMap<RfFunction, List<Object>>();
            }
            if ((actionBlocks = rfFunction.getLocalMembers(RfActionBlock.class)) == null || actionBlocks.isEmpty()) {
                currentFunctions.put(rfFunction, new ArrayList());
                forksPerFunction.put(functionName, currentFunctions);
                continue;
            }
            List forkActionBlocks = actionBlocks.stream().filter(actionBlock -> actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY) || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE)).collect(Collectors.toList());
            if (forkActionBlocks.isEmpty()) continue;
            if (scopesWithDisable.containsKey(rfFunction)) {
                Integer disableLine = (Integer)((List)scopesWithDisable.get(rfFunction)).iterator().next();
                List forkItemsDisabled = forkActionBlocks.stream().filter(actionBlock -> actionBlock.getLine() < disableLine).collect(Collectors.toList());
                currentFunctions.put(rfFunction, forkItemsDisabled);
            } else {
                currentFunctions.put(rfFunction, forkActionBlocks);
            }
            forksPerFunction.put(functionName, currentFunctions);
        }
        this.fOVMProject.getRfProject().visitHidObject(null, new ActionBlockVisitor(scopesWithDisable, this));
        for (Map.Entry entry : scopesWithDisable.entrySet()) {
            List disableLines = (List)entry.getValue();
            if (disableLines.size() <= 1) continue;
            Collections.sort(disableLines);
        }
        StringBuilder stringBuilder = new StringBuilder();
        HashMap<RfFunction, Integer> visitedFunctions = new HashMap<RfFunction, Integer>();
        HashMap<ParserPath, HashSet<Integer>> oneHitPerDisabledLine = new HashMap<ParserPath, HashSet<Integer>>();
        for (Map.Entry entry : scopesWithDisable.entrySet()) {
            RfNamedElement currentScope = (RfNamedElement)entry.getKey();
            List<RfActionBlock> actionBlocks = currentScope.getLocalMembers(RfActionBlock.class);
            if (actionBlocks == null) {
                actionBlocks = new ArrayList<RfActionBlock>();
            }
            if (currentScope instanceof RfActionBlock && (((RfActionBlock)currentScope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY) || ((RfActionBlock)currentScope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE) || ((RfActionBlock)currentScope).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN))) continue;
            List forkActionBlocks = actionBlocks.stream().filter(actionBlock -> actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_ANY) || actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.FORK_JOIN_NONE)).collect(Collectors.toList());
            int[] previousDisableLine = new int[1];
            for (Integer disableLine : (List)entry.getValue()) {
                HashSet<Integer> lines;
                List<RfActionBlock> forkItemsDisabledCurrentScope = forkActionBlocks.stream().filter(actionBlock -> actionBlock.getLine() < disableLine).collect(Collectors.toList());
                List<MethodCall> methodCalls = this.getMethodCalls(currentScope);
                ArrayList<RfActionBlock> forkItemsInherited = new ArrayList<RfActionBlock>();
                MethodCall disableForkCall = null;
                if (methodCalls != null && !methodCalls.isEmpty()) {
                    for (MethodCall methodCall : methodCalls) {
                        if (methodCall.occurrence.getLine() > disableLine) break;
                        if (methodCall.occurrence.getLine() <= previousDisableLine[0]) continue;
                        if (methodCall.occurrence.getLine() == disableLine.intValue() && scopesWithDisable.containsKey(methodCall.method)) {
                            disableForkCall = methodCall;
                        }
                        visitedFunctions.clear();
                        this.getForksFromFunctionCall(forkItemsInherited, forksPerFunction, currentScope, methodCall, allMethodCalls, visitedFunctions);
                    }
                }
                previousDisableLine[0] = disableLine;
                forkActionBlocks.removeAll(forkItemsDisabledCurrentScope);
                stringBuilder.setLength(0);
                RfFunction originFunction = null;
                List disableLines = null;
                if (forkItemsDisabledCurrentScope.size() + forkItemsInherited.size() > 0) {
                    if (disableForkCall == null) {
                        this.checkForkInLoop(currentScope, currentScope.getFile().getParserPath(), disableLine, forkItemsDisabledCurrentScope, forkItemsInherited);
                    } else {
                        originFunction = this.getOriginFunction(scopesWithDisable, functionsWithDisable, functionCallingDisableFrom, disableForkCall, allMethodCalls);
                        disableLines = (List)scopesWithDisable.get(originFunction);
                        if (disableLines == null || disableLines.isEmpty() || originFunction.getFile() == null) continue;
                        this.checkForkInLoop(currentScope, originFunction.getFile().getParserPath(), (Integer)disableLines.get(0), forkItemsDisabledCurrentScope, forkItemsInherited);
                    }
                }
                if (forkItemsDisabledCurrentScope.size() + forkItemsInherited.size() < 2) continue;
                for (RfActionBlock forkItem : forkItemsDisabledCurrentScope) {
                    stringBuilder.append(this.link(String.valueOf(forkItem.getFile().getName()) + ":" + forkItem.getLine(), forkItem.getFile().getParserPath().path, forkItem.getLine())).append(", ");
                }
                if (forkItemsDisabledCurrentScope.size() < 2) {
                    for (RfActionBlock forkItem : forkItemsInherited) {
                        stringBuilder.append(this.link(String.valueOf(forkItem.getFile().getName()) + ":" + forkItem.getLine(), forkItem.getFile().getParserPath().path, forkItem.getLine())).append(", ");
                    }
                }
                stringBuilder.setLength(stringBuilder.length() - 2);
                stringBuilder.append('!');
                if (disableForkCall == null) {
                    if (currentScope.getFile() == null) continue;
                    lines = (HashSet<Integer>)oneHitPerDisabledLine.get(currentScope.getFile().getParserPath());
                    if (lines == null) {
                        lines = new HashSet<Integer>();
                    }
                    if (lines.isEmpty() || !lines.contains(disableLine)) {
                        this.addHit(currentScope.getFile().getParserPath(), disableLine, "Disable fork might kill subprocesses started by more than one fork block: " + stringBuilder, null);
                    }
                    lines.add(disableLine);
                    oneHitPerDisabledLine.put(currentScope.getFile().getParserPath(), lines);
                    continue;
                }
                if (originFunction == null) {
                    originFunction = this.getOriginFunction(scopesWithDisable, functionsWithDisable, functionCallingDisableFrom, disableForkCall, allMethodCalls);
                }
                if (disableLines == null) {
                    disableLines = (List)scopesWithDisable.get(originFunction);
                }
                if (disableLines == null || disableLines.isEmpty() || originFunction.getFile() == null) continue;
                lines = (HashSet<Integer>)oneHitPerDisabledLine.get(originFunction.getFile().getParserPath());
                if (lines == null) {
                    lines = new HashSet<Integer>();
                }
                if (lines.isEmpty() || !lines.contains(disableLines.get(0))) {
                    this.addHit(originFunction.getFile().getParserPath(), (Integer)disableLines.get(0), "Disable fork might kill subprocesses started by more than one fork block: " + stringBuilder, null);
                }
                lines.add((Integer)disableLines.get(0));
                oneHitPerDisabledLine.put(originFunction.getFile().getParserPath(), lines);
            }
        }
    }

    private void checkForkInLoop(RfNamedElement currentScope, ParserPath parserPath, Integer disableLine, List<RfActionBlock> forkItemsDisabledCurrentScope, List<RfActionBlock> forkItemsInherited) {
        if (currentScope == null || currentScope instanceof RfLibrary) {
            return;
        }
        if (this.isForkBlock(currentScope)) {
            return;
        }
        if (currentScope instanceof RfActionBlock && ((RfActionBlock)currentScope).isLoop()) {
            StringBuilder forkItemsDisabledDescription = new StringBuilder();
            for (RfActionBlock forkItem : forkItemsDisabledCurrentScope) {
                forkItemsDisabledDescription.append(this.link(String.valueOf(forkItem.getFile().getName()) + ":" + forkItem.getLine(), forkItem.getFile().getParserPath().path, forkItem.getLine())).append(", ");
            }
            if (forkItemsDisabledCurrentScope.size() < 2) {
                for (RfActionBlock forkItem : forkItemsInherited) {
                    forkItemsDisabledDescription.append(this.link(String.valueOf(forkItem.getFile().getName()) + ":" + forkItem.getLine(), forkItem.getFile().getParserPath().path, forkItem.getLine())).append(", ");
                }
            }
            forkItemsDisabledDescription.setLength(forkItemsDisabledDescription.length() - 2);
            forkItemsDisabledDescription.append('!');
            this.addHit(parserPath, disableLine, "Disable fork might kill subprocesses started by more than one fork block: " + forkItemsDisabledDescription, null);
            return;
        }
        this.checkForkInLoop(currentScope.getEnclosingScope(), parserPath, disableLine, forkItemsDisabledCurrentScope, forkItemsInherited);
    }

    private boolean isForkBlock(RfNamedElement currentScope) {
        if (!(currentScope instanceof RfActionBlock)) {
            return false;
        }
        return ((RfActionBlock)currentScope).isForkJoin();
    }

    private List<MethodCall> getMethodCalls(RfNamedElement function) {
        RfHidHolder holder;
        RfHidHolder rfHidHolder = holder = function != null ? function.getHidHolder() : null;
        if (holder == null) {
            return Collections.emptyList();
        }
        final ArrayList<MethodCall> localMethodCalls = new ArrayList<MethodCall>();
        holder.visitHidObject(null, new RfHidVisitor(){

            public boolean visit(RfHid hidObject) {
                if (!(hidObject.getElement() instanceof RfFunction)) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)hidObject);
                if (methodCalls != null && !methodCalls.isEmpty()) {
                    localMethodCalls.addAll(methodCalls);
                }
                return true;
            }
        });
        return localMethodCalls;
    }

    private RfFunction getOriginFunction(Map<RfNamedElement, List<Integer>> scopesWithDisable, List<RfFunction> functionsWithDisable, HashMap<RfFunction, RfFunction> functionCallingDisableFrom, MethodCall methodCall, Map<RfFunction, List<MethodCall>> allMethodCalls) {
        if (functionsWithDisable.contains(methodCall.method)) {
            List<MethodCall> methodCalls = allMethodCalls.get(methodCall.method);
            if (methodCalls == null) {
                return (RfFunction)methodCall.method;
            }
            int firstDisableLine = scopesWithDisable.get(methodCall.method).get(0);
            for (MethodCall call : methodCalls) {
                if (call.occurrence.getLine() > firstDisableLine) break;
                if (call.occurrence.getLine() != firstDisableLine || call.equals(methodCall)) continue;
                return this.getOriginFunction(scopesWithDisable, functionsWithDisable, functionCallingDisableFrom, call, allMethodCalls);
            }
            return (RfFunction)methodCall.method;
        }
        RfFunction originFunction = functionCallingDisableFrom.get(methodCall.method);
        return originFunction == null ? (RfFunction)methodCall.method : originFunction;
    }

    private void getForksFromFunctionCall(List<RfActionBlock> forkItemsInherited, Map<String, Map<RfFunction, List<RfActionBlock>>> forksPerFunction, RfNamedElement parent, MethodCall methodCall, Map<RfFunction, List<MethodCall>> allMethodCalls, HashMap<RfFunction, Integer> visited) {
        List<MethodCall> methodCalls;
        if (methodCall.method == null) {
            return;
        }
        if (forkItemsInherited.size() > 2) {
            return;
        }
        Integer entry = visited.get(methodCall.method);
        if (entry == null) {
            visited.put((RfFunction)methodCall.method, 1);
        }
        if (entry != null && entry > 2) {
            return;
        }
        RfFunction function = (RfFunction)methodCall.method;
        Map<RfFunction, List<RfActionBlock>> functions = forksPerFunction.get(function.getFullName());
        if (functions == null) {
            return;
        }
        List<RfActionBlock> forkList = functions.get(function);
        if (forkList == null) {
            return;
        }
        forkItemsInherited.addAll(forkList);
        if (entry != null) {
            visited.put((RfFunction)methodCall.method, entry + 1);
        }
        if ((methodCalls = allMethodCalls.get(methodCall.method)) == null) {
            return;
        }
        for (MethodCall call : methodCalls) {
            this.getForksFromFunctionCall(forkItemsInherited, forksPerFunction, parent, call, allMethodCalls, visited);
        }
    }

    private final class ActionBlockVisitor
    implements IHidVisitor<IHidObject> {
        private final Map<RfNamedElement, List<Integer>> scopesWithDisable;
        RfNamedElement scope;
        private OVMComplianceCheck check;

        private ActionBlockVisitor(Map<RfNamedElement, List<Integer>> scopesWithDisable, OVMComplianceCheck check) {
            this.scopesWithDisable = scopesWithDisable;
            this.check = check;
        }

        public boolean visit(IHidObject hidObject) {
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (Check_SVTB_8_4_3.this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this.check)) {
                return true;
            }
            if (this.scope instanceof RfFunction) {
                return true;
            }
            if (!(hidObject instanceof RfHid)) {
                return true;
            }
            Check_SVTB_8_4_3.this.notifyCheckAlive();
            IRfNamedElement element = ((RfHid)hidObject).getElement();
            if (!(element instanceof RfFunction)) {
                return true;
            }
            if (!this.scopesWithDisable.containsKey(element)) {
                return true;
            }
            List methodCalls = MethodCallUtils.getMethodCalls((IHid)((RfHid)hidObject));
            if (methodCalls == null || methodCalls.isEmpty()) {
                return true;
            }
            List occurencesList = methodCalls.stream().map(m -> m.occurrence.getLine()).collect(Collectors.toList());
            boolean containsKey = this.scopesWithDisable.containsKey(this.scope);
            if (!containsKey) {
                this.scopesWithDisable.put(this.scope, new ArrayList(occurencesList));
            } else {
                this.scopesWithDisable.get(this.scope).addAll(occurencesList);
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }

    private final class DisableForkVisitor
    implements IHidVisitor<RfHidOperator> {
        private final Map<RfNamedElement, List<Integer>> scopesWithDisable;
        private final List<RfFunction> functionsWithDisable;
        RfNamedElement scope;
        private OVMComplianceCheck check;

        private DisableForkVisitor(Map<RfNamedElement, List<Integer>> scopesWithDisable, List<RfFunction> functionsWithDisable, OVMComplianceCheck check) {
            this.scopesWithDisable = scopesWithDisable;
            this.functionsWithDisable = functionsWithDisable;
            this.check = check;
        }

        public boolean visit(RfHidOperator hidOperator) {
            boolean containsKey;
            RfFileDef file = this.scope.getFile();
            if (file == null) {
                return true;
            }
            if (Check_SVTB_8_4_3.this.fOVMProject.getProjectWaivers().pathIsPrewaived(file.getParserPath(), this.check)) {
                return true;
            }
            if (!hidOperator.isDisableStatement()) {
                return true;
            }
            if (!(hidOperator.getLHValue() instanceof RfHidImplicit)) {
                return true;
            }
            if (!((RfHidImplicit)hidOperator.getLHValue()).getName().equals("fork")) {
                return true;
            }
            if (this.scope instanceof RfFunction) {
                this.functionsWithDisable.add((RfFunction)this.scope);
            }
            if (!(containsKey = this.scopesWithDisable.containsKey(this.scope))) {
                this.scopesWithDisable.put(this.scope, new ArrayList<Integer>(Arrays.asList(hidOperator.getOccurrence().getLine())));
            } else {
                this.scopesWithDisable.get(this.scope).add(hidOperator.getOccurrence().getLine());
            }
            return true;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public Class<RfHidOperator> getType() {
            return RfHidOperator.class;
        }
    }
}

