/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="17.1.31")
@CheckID(value="SVTB.8.4.6")
@CheckName(value="SVTB.8.4.6")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not access variables that might change inside forks")
@CheckDescription(value="Using <elementKind> in a fork is not allowed. Accessing variables inside forks without proper synchronization can lead to race conditions.\nThe variables declared inside the fork's variable declaration block or automatic variables declared in the same scope as the fork block can be used.\n\nImplementation Notes:\nIt is allowed to access constants and const ref arguments.\nBy default the rule flags ref arguments which are not allowed by LRM specification.\n\nExamples:\n\nfor (int i = 0; i < 10; i++) begin\n\tfork\n\t\tbegin\n\t\t\tmy_task(i);\t\t\t// not allowed\n\t\tend\n\tjoin_none\nend\n\nfor (int i = 0; i < 10; i++) begin\n\tfork\n\t\tautomatic int j = i;\n\t\tbegin\n\t\t\tmy_task(j);\t\t\t// allowed, variable declared inside the fork's variable declaration block\n\t\tend\n\tjoin_none\nend\n\nfor (int i = 0; i < 10; i++) begin\n\tautomatic int j = i;\n\tfork\n\t\tbegin\n\t\t\tmy_task(j);\t\t\t// allowed, automatic variable declared in the same scope as the fork block\n\t\tend\n\tjoin_none\nend\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_4_6
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="ref_argument", description="Comma separated list of: variable, input_argument, output_argument, inout_argument, ref_argument.", name="elementKind", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.CSL_STRING)
    private HashSet<String> pElementKindValue = new HashSet();

    public Check_SVTB_8_4_6(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        final LocalHidOperatorVisitor operatorVisitor = new LocalHidOperatorVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                RfActionBlock actionBlock;
                Check_SVTB_8_4_6.this.notifyCheckAlive();
                if (Check_SVTB_8_4_6.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (namedElement instanceof RfActionBlock && (actionBlock = (RfActionBlock)namedElement).hasForkJoin()) {
                    operatorVisitor.setEnclosingFork(actionBlock);
                    actionBlock.visitHidObject(rfProject, operatorVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    public boolean isValidElement(RfNamedElement element) {
        if (!(element instanceof RfField)) {
            return false;
        }
        if (element.isConst()) {
            return false;
        }
        RfField field = (RfField)element;
        if (this.pElementKindValue.contains("variable") && field.isVariable() && (field.getEnclosingScope() instanceof RfFunction || field.getEnclosingScope() instanceof RfActionBlock)) {
            return true;
        }
        if (this.pElementKindValue.contains("input_argument") && field.isArgument() && field.isInput()) {
            return true;
        }
        if (this.pElementKindValue.contains("output_argument") && field.isArgument() && field.isOutput()) {
            return true;
        }
        if (this.pElementKindValue.contains("inout_argument") && field.isArgument() && field.isInout()) {
            return true;
        }
        return this.pElementKindValue.contains("ref_argument") && field.isArgument() && field.isRef();
    }

    public boolean foundForkJoin(IRfScopeElement elementScope, RfActionBlock enclosingFork, boolean isAutomatic) {
        RfNamedElement enclosingForkScope;
        boolean isEnclosingScopeAutomatic = false;
        if (isAutomatic && (enclosingForkScope = enclosingFork.getEnclosingScope()) != null) {
            isEnclosingScopeAutomatic = enclosingForkScope.equals(elementScope);
        }
        return isEnclosingScopeAutomatic || enclosingFork.equals(elementScope);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    static /* synthetic */ OVMComplianceHit access$0(Check_SVTB_8_4_6 check_SVTB_8_4_6, ParserPath parserPath, HidOccurrence hidOccurrence, String string) {
        return check_SVTB_8_4_6.addHit(parserPath, hidOccurrence, string);
    }

    static /* synthetic */ List access$1(Check_SVTB_8_4_6 check_SVTB_8_4_6, ParserPath parserPath, RfHid rfHid, String string) {
        return check_SVTB_8_4_6.addHit(parserPath, rfHid, string);
    }

    private final class LocalHidOperatorVisitor
    implements IHidVisitor<IHidObject> {
        private RfActionBlock enclosingFork;
        private ParserPath parserPath;
        private RfNamedElement scope;
        private final EnumSet<HidFlatteningOption> HID_FLATTENING = EnumSet.of(HidFlatteningOption.IGNORE_IMPLICITS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS);

        private LocalHidOperatorVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        /*
         * Unable to fully structure code
         */
        public boolean visit(IHidObject hidObject) {
            block12: {
                block11: {
                    if (!(hidObject instanceof HidOperator)) break block11;
                    hidOperator = (HidOperator)hidObject;
                    if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN) && this.scope.equals(this.enclosingFork)) {
                        return true;
                    }
                    hids = new HashSet<E>();
                    hids.addAll(hidOperator.getRHHids(this.HID_FLATTENING));
                    if (hidOperator.getLHValue() != null && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_ARGUMENT_VALUE) && !hidOperator.hasOccurrence(HidOperatorQualifier.IS_DECLARATION_ASSIGN)) {
                        hids.addAll(hidOperator.getLHHids(this.HID_FLATTENING));
                    }
                    for (IHid hid : hids) {
                        if (hid instanceof RfHid) ** GOTO lbl15
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            hid = ((RfHid)hid).getParentHid();
lbl15:
                            // 2 sources

                            ** while (((RfHid)hid).getParentHid() != null)
                        }
lbl16:
                        // 1 sources

                        if (((RfHid)hid).getElement() == null || !Check_SVTB_8_4_6.this.isValidElement((RfNamedElement)(element = ((RfHid)hid).getElement()))) continue;
                        isAutomatic = ((RfNamedElement)element).hasStorageAutomaticQualifier();
                        found = false;
                        elementScope = element.getEnclosingScope();
                        do {
                            if (!Check_SVTB_8_4_6.this.foundForkJoin(elementScope, this.enclosingFork, isAutomatic)) continue;
                            found = true;
                            break;
                        } while ((elementScope = elementScope.getEnclosingScope()) != null);
                        if (found) continue;
                        elementKind = LintUtils.getElementKind((RfNamedElement)element);
                        elementKind = String.valueOf(Character.toUpperCase(elementKind.charAt(0))) + elementKind.substring(1);
                        Check_SVTB_8_4_6.access$0(Check_SVTB_8_4_6.this, this.parserPath, (HidOccurrence)hidOperator.getOccurrence(), String.valueOf(elementKind) + " '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' is accessed inside fork!");
                    }
                    break block12;
                }
                if (hidObject instanceof RfHidAccess) {
                    hidAccess = (RfHidAccess)hidObject;
                    parentHid = hidAccess.getParentHid();
                    if (parentHid == null || !(parentHid instanceof RfHid)) {
                        return true;
                    }
                    rfHid = (RfHid)parentHid;
                    element = rfHid.getElement();
                    if (element == null || !(element instanceof RfNamedElement)) {
                        return true;
                    }
                    if (!Check_SVTB_8_4_6.this.isValidElement((RfNamedElement)element)) {
                        return true;
                    }
                    isAutomatic = ((RfNamedElement)element).hasStorageAutomaticQualifier();
                    found = false;
                    elementScope = element.getEnclosingScope();
                    do {
                        if (!Check_SVTB_8_4_6.this.foundForkJoin(elementScope, this.enclosingFork, isAutomatic)) continue;
                        found = true;
                        break;
                    } while ((elementScope = elementScope.getEnclosingScope()) != null);
                    if (!found) {
                        elementKind = LintUtils.getElementKind((RfNamedElement)element);
                        elementKind = String.valueOf(Character.toUpperCase(elementKind.charAt(0))) + elementKind.substring(1);
                        Check_SVTB_8_4_6.access$1(Check_SVTB_8_4_6.this, this.parserPath, rfHid, String.valueOf(elementKind) + " '" + LintUtils.getNamedElementFullName((RfNamedElement)element) + "' is accessed inside fork!");
                    }
                }
            }
            return true;
        }

        public void setEnclosingFork(RfActionBlock enclosingFork) {
            this.enclosingFork = enclosingFork;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

