/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidHolder;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.util.MethodCall;
import ro.amiq.dvt.model.reflection.util.MethodCallUtils;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidHolder;

@CheckVersion(value="17.1.37")
@CheckID(value="SVTB.8.4.7")
@CheckName(value="SVTB.8.4.7")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK, RuleLabel.METHOD})
@CheckTitle(value="Do not use fork/join_none to call tasks inside functions")
@CheckDescription(value="Calling a task inside a function can cause unwanted behaviour such as reseting while a main process is running without any obvious reason.\n\nExamples:\n\nclass parent;\n\ttask t1;\n\tendtask;\n\n\tfunction void foo();\n\t\tfork\n\t\t\tt1(); // not allowed\n\t\tjoin_none\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_8_4_7
extends OVMComplianceCheck {
    public Check_SVTB_8_4_7(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        final LocalHidVisitor hidVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                Check_SVTB_8_4_7.this.notifyCheckAlive();
                if (Check_SVTB_8_4_7.this.checkPreWaivers(namedElement.getFile())) {
                    return true;
                }
                if (namedElement instanceof RfFunction && ((RfFunction)namedElement).isFunction()) {
                    namedElement.visitHidObject(rfProject, hidVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    private boolean checkPreWaivers(RfFileDef fileDef) {
        if (fileDef == null) {
            return false;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(fileDef.getParserPath(), this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private static final String ERROR_MESSAGE_FORMAT = "Task {0} called inside function using fork/join_none!";
        private ParserPath parserPath;
        private RfNamedElement scope;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public void setHolder(IHidHolder holder) {
            this.scope = (RfNamedElement)((RfHidHolder)holder).getScope();
        }

        public boolean visit(IHidObject hidObject) {
            if (hidObject instanceof RfHid) {
                RfHid rfHid = (RfHid)hidObject;
                if (!rfHid.isMethodCall(false)) {
                    return true;
                }
                IRfNamedElement element = rfHid.getElement();
                if (element == null || !(element instanceof RfFunction) || !((RfFunction)element).isTask()) {
                    return true;
                }
                List methodCalls = MethodCallUtils.getMethodCalls((IHid)rfHid);
                if (this.scope instanceof RfActionBlock && ((RfActionBlock)this.scope).isForkJoinNone()) {
                    for (MethodCall methodCall : methodCalls) {
                        Check_SVTB_8_4_7.this.addHit(this.parserPath, methodCall.occurrence, MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName((RfNamedElement)element)));
                    }
                    return true;
                }
                RfNamedElement parentScope = this.scope.getEnclosingScope();
                while (parentScope != null && !(parentScope instanceof RfFunction)) {
                    if (parentScope instanceof RfActionBlock && ((RfActionBlock)parentScope).isForkJoinNone()) {
                        for (MethodCall methodCall : methodCalls) {
                            Check_SVTB_8_4_7.this.addHit(this.parserPath, methodCall.occurrence, MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName((RfNamedElement)element)));
                        }
                        return true;
                    }
                    parentScope = parentScope.getEnclosingScope();
                }
            }
            return true;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

