/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterOverride;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.svtb.AbstractSVTBSimpleIssues;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.SVTBIssues;

@CheckVersion(value="18.1.27")
@CheckID(value="SVTB.8.4.8")
@CheckName(value="SVTB.8.4.8")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK})
@CheckTitle(value="Do not use disable statement with fork block name")
@CheckDescription(value="Do not use disable statement with fork block name because the result is inconsistent across simulators\n\nExample:\nfork: my_fork\n   ...\njoin_any\ndisable my_fork; // not allowed\n\nImplementation notes:\nThis rule is applied only on disable statements with fork block names. It flags only the statements called in the enclosing scope of the fork block definition.\n\nCheck supports pre-waiving.")
@CheckParameterOverride(name="maxHitsPerFile", isVisible=false)
public class Check_SVTB_8_4_8
extends AbstractSVTBSimpleIssues {
    public Check_SVTB_8_4_8(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void preBuildNotification(RfProject aRfProject) {
        aRfProject.lintTrackP2LInfo(135);
    }

    @Override
    protected String getFailMessage(SVTBIssues issue) {
        return "Fork '" + issue.getInfo() + "' is disabled!";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Map<ParserPath, List<SVTBIssues>> getSVTBIssues() {
        block4: {
            allForkBlocks = new HashMap<K, V>();
            this.fOVMProject.getRfProject().accept(this.fOVMProject.getRfProject(), new IRfNamedElementVisitor(){

                @Override
                public boolean visit(RfNamedElement namedElement) {
                    RfActionBlock actionBlock;
                    if (namedElement instanceof RfActionBlock && (actionBlock = (RfActionBlock)namedElement).hasForkJoin()) {
                        allForkBlocks.put(actionBlock.getName(), actionBlock);
                    }
                    return true;
                }
            });
            allIssues = this.fOVMProject.getSVTBIssuesWithKind(135);
            filteredIssues = new HashMap<ParserPath, List<SVTBIssues>>();
            if (allIssues == null) break block4;
            for (Map.Entry<ParserPath, List<SVTBIssues>> entry : allIssues.entrySet()) {
                parserPath = entry.getKey();
                issuesInParserPath = entry.getValue();
                if (this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this) || issuesInParserPath == null || issuesInParserPath.isEmpty()) continue;
                this.notifyCheckAlive();
                fileDef = this.fOVMProject.getRfProject().getFileDefUsingParserPath(parserPath);
                for (SVTBIssues currentIssue : issuesInParserPath) {
                    offset = currentIssue.getOffset();
                    scope = fileDef.getScope(offset);
                    if (!(scope instanceof RfDefElement) || (associatedForkBlock = (RfActionBlock)allForkBlocks.get(currentIssue.getInfo())) == null) continue;
                    disableEnclosingScope = ((RfDefElement)scope).getNamedElement();
                    forkEnclosingScope = associatedForkBlock.getEnclosingScope();
                    if (disableEnclosingScope != null && forkEnclosingScope != null) ** GOTO lbl21
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        disableEnclosingScope = disableEnclosingScope.getEnclosingScope();
lbl21:
                        // 2 sources

                        ** while (disableEnclosingScope != null && !disableEnclosingScope.equals((Object)forkEnclosingScope))
                    }
lbl22:
                    // 1 sources

                    if (disableEnclosingScope == null) continue;
                    if (!filteredIssues.containsKey(parserPath)) {
                        filteredIssues.put(parserPath, new ArrayList<E>());
                    }
                    ((List)filteredIssues.get(parserPath)).add(currentIssue);
                }
            }
        }
        return filteredIssues;
    }
}

