/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.1")
@CheckID(value="SVTB.8.4.9")
@CheckName(value="SVTB.8.4.9")
@CheckLabel(labels={RuleLabel.PROCESS, RuleLabel.FORK})
@CheckTitle(value="Do not use 'disable fork'")
@CheckDescription(value="Do not use 'disable fork'.\n\nExamples:\n\nmodule test;\n\tfunction void foo();\n\t\tfork\n\t\tjoin_none\n\t\tdisable fork; // not allowed\n\tendfunction\nendmodule\n")
public class Check_SVTB_8_4_9
extends OVMComplianceCheck {
    public Check_SVTB_8_4_9(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, new IHidVisitor<RfHidOperator>(){
            ParserPath parserPath;

            public boolean visit(RfHidOperator hidOperator) {
                if (!hidOperator.isDisableStatement()) {
                    return true;
                }
                Check_SVTB_8_4_9.this.notifyCheckAlive();
                IHidObject lhValue = hidOperator.getLHValue();
                if (!(lhValue instanceof RfHidImplicit)) {
                    return true;
                }
                if (!((RfHidImplicit)lhValue).getName().equals("fork")) {
                    return true;
                }
                HidOperatorOccurrence occurence = hidOperator.getOccurrence();
                if (occurence == null) {
                    return true;
                }
                Check_SVTB_8_4_9.this.addHit(this.parserPath, (HidOccurrence)occurence, "'disable fork' used!");
                return true;
            }

            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            public Class<RfHidOperator> getType() {
                return RfHidOperator.class;
            }
        });
    }
}

