/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameter;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterRequired;
import ro.amiq.vlogdt.linter.base.annotations.CheckParameterType;
import ro.amiq.vlogdt.linter.base.annotations.CheckReapplyDisable;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.IRfHidOperatorLayer;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;

@CheckVersion(value="16.1.37")
@CheckID(value="SVTB.9.10")
@CheckName(value="SVTB.9.10")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.FIELD, RuleLabel.FUNCTIONAL})
@CheckTitle(value="Do not use blocking and non-blocking assignments on the same variable")
@CheckDescription(value="Using blocking and non-blocking assignments on the same variable can cause inconsistencies between simulations.\n\nExamples:\n\nclass my_class;\n\tinteger a; // not allowed\n\tinteger b; // allowed\n\n\tfunction void foo()\n\t\ta = a + 1;\n\t\ta <= a - 1;\n\t\tb = b + a;\n\tendfunction\nendclass\n")
@CheckReapplyDisable
public class Check_SVTB_9_10
extends OVMComplianceCheck {
    @CheckParameter(defaultValue="false", description="If true, this check allows different assignment types for the same variables if they're not in the same block type, initial or non-initial.", name="checkInitialBlock", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pCheckInitialBlock;
    @CheckParameter(defaultValue="false", description="If true, blocking and non-blocking assignments placed in mutual exclusive generate blocks will be ignored.", name="skipExclusiveGenerateBlocks", required=CheckParameterRequired.OPTIONAL, type=CheckParameterType.BOOLEAN)
    private boolean pSkipExclusiveGenerateBlocks;
    private static final String ERROR_MESSAGE_FORMAT = "Variable ''{0}'' is used in both blocking and non-blocking operations.\n\nBlocking:\n{1}\nNon-blocking:\n{2}";
    private Map<CustomHid, List<Object[]>> fBlockingAssignments = new HashMap<CustomHid, List<Object[]>>();
    private Map<CustomHid, List<Object[]>> fNonBlockingAssignments = new HashMap<CustomHid, List<Object[]>>();
    private int fNoOfBlockingAssignments;
    private int fNoOfNonBlockingAssignments;
    private boolean fVisitBlockingFirst;
    private final HidOperatorVisitor fCounterVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_BLOCKING_ASSIGN, HidOperatorQualifier.IS_NONBLOCKING_ASSIGN}){

        public boolean visit(HidOperator hidObject) {
            boolean isBlockingOrNonBlocking = hidObject.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN.value() | HidOperatorQualifier.IS_NONBLOCKING_ASSIGN.value());
            boolean isIncrementOrDecrement = ((IRfHidOperatorLayer)hidObject).isIncrementOrDecrement();
            if (!isBlockingOrNonBlocking && !isIncrementOrDecrement) {
                return true;
            }
            Check_SVTB_9_10.this.notifyCheckAlive();
            HidOperator hidOperator = hidObject;
            if (isIncrementOrDecrement) {
                IHidObject lhHidObject = hidOperator.getLHValue();
                if (!(lhHidObject instanceof RfHid)) {
                    return true;
                }
                ++Check_SVTB_9_10.this.fNoOfBlockingAssignments;
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN)) {
                ++Check_SVTB_9_10.this.fNoOfBlockingAssignments;
            } else if (hidOperator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN)) {
                ++Check_SVTB_9_10.this.fNoOfNonBlockingAssignments;
            }
            return true;
        }
    };
    private final HidOperatorVisitor fBlockingAssignmentsVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_BLOCKING_ASSIGN}){

        public boolean visit(HidOperator hidObject) {
            boolean isBlocking = hidObject.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN.value());
            boolean isIncrementOrDecrement = ((IRfHidOperatorLayer)hidObject).isIncrementOrDecrement();
            if (!isBlocking && !isIncrementOrDecrement) {
                return true;
            }
            Check_SVTB_9_10.this.notifyCheckAlive();
            HidOperator hidOperator = hidObject;
            if (isIncrementOrDecrement) {
                IHidObject lhHidObject = hidOperator.getLHValue();
                if (!(lhHidObject instanceof RfHid)) {
                    return true;
                }
                RfHid lhHid = (RfHid)lhHidObject;
                CustomHid customHid = new CustomHid(lhHid);
                if (!Check_SVTB_9_10.this.fVisitBlockingFirst && !Check_SVTB_9_10.this.fNonBlockingAssignments.containsKey(customHid)) {
                    return true;
                }
                List<Object[]> operatorList = Check_SVTB_9_10.this.fBlockingAssignments.get(customHid);
                if (operatorList == null) {
                    operatorList = new ArrayList<Object[]>();
                }
                boolean isInitialBlock = Check_SVTB_9_10.this.isInInitialBlock((IRfScopeElement)this.scope);
                RfGenerateBlock enclosingGenerateBlock = Check_SVTB_9_10.this.isInGenerateBlock((IRfScopeElement)this.scope);
                operatorList.add(new Object[]{hidOperator, this.parserPath, isInitialBlock, enclosingGenerateBlock});
                Check_SVTB_9_10.this.fBlockingAssignments.put(customHid, operatorList);
                return true;
            }
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhHidObject;
            CustomHid customHid = new CustomHid(lhHid);
            if (!Check_SVTB_9_10.this.fVisitBlockingFirst && !Check_SVTB_9_10.this.fNonBlockingAssignments.containsKey(customHid)) {
                return true;
            }
            List<Object[]> operatorList = Check_SVTB_9_10.this.fBlockingAssignments.get(customHid);
            if (operatorList == null) {
                operatorList = new ArrayList<Object[]>();
            }
            boolean isInitialBlock = Check_SVTB_9_10.this.isInInitialBlock((IRfScopeElement)this.scope);
            RfGenerateBlock enclosingGenerateBlock = Check_SVTB_9_10.this.isInGenerateBlock((IRfScopeElement)this.scope);
            operatorList.add(new Object[]{hidOperator, this.parserPath, isInitialBlock, enclosingGenerateBlock});
            Check_SVTB_9_10.this.fBlockingAssignments.put(customHid, operatorList);
            return true;
        }
    };
    private final HidOperatorVisitor fNonBlockingAssignmentsVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_NONBLOCKING_ASSIGN}){

        public boolean visit(HidOperator hidObject) {
            boolean isNonBlocking = hidObject.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN.value());
            if (!isNonBlocking) {
                return true;
            }
            Check_SVTB_9_10.this.notifyCheckAlive();
            HidOperator hidOperator = hidObject;
            IHidObject lhHidObject = hidOperator.getLHValue();
            if (!(lhHidObject instanceof RfHid)) {
                return true;
            }
            RfHid lhHid = (RfHid)lhHidObject;
            CustomHid customHid = new CustomHid(lhHid);
            if (Check_SVTB_9_10.this.fVisitBlockingFirst && !Check_SVTB_9_10.this.fBlockingAssignments.containsKey(customHid)) {
                return true;
            }
            List<Object[]> operatorList = Check_SVTB_9_10.this.fNonBlockingAssignments.get(customHid);
            if (operatorList == null) {
                operatorList = new ArrayList<Object[]>();
            }
            boolean isInitialBlock = Check_SVTB_9_10.this.isInInitialBlock((IRfScopeElement)this.scope);
            RfGenerateBlock enclosingGenerateBlock = Check_SVTB_9_10.this.isInGenerateBlock((IRfScopeElement)this.scope);
            operatorList.add(new Object[]{hidOperator, this.parserPath, isInitialBlock, enclosingGenerateBlock});
            Check_SVTB_9_10.this.fNonBlockingAssignments.put(customHid, operatorList);
            return true;
        }
    };

    public Check_SVTB_9_10(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fBlockingAssignments.clear();
        this.fNonBlockingAssignments.clear();
        this.fNoOfBlockingAssignments = 0;
        this.fNoOfNonBlockingAssignments = 0;
        this.fVisitBlockingFirst = false;
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fCounterVisitor);
        if (this.fNoOfBlockingAssignments == 0 || this.fNoOfNonBlockingAssignments == 0) {
            return;
        }
        if (this.fNoOfBlockingAssignments < this.fNoOfNonBlockingAssignments) {
            this.fVisitBlockingFirst = true;
        }
        if (this.fVisitBlockingFirst) {
            this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fBlockingAssignmentsVisitor);
            this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fNonBlockingAssignmentsVisitor);
        } else {
            this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fNonBlockingAssignmentsVisitor);
            this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fBlockingAssignmentsVisitor);
        }
        for (Map.Entry<CustomHid, List<Object[]>> entry : this.fBlockingAssignments.entrySet()) {
            CustomHid customHid = entry.getKey();
            List<Object[]> blockingAssignments = entry.getValue();
            List<Object[]> nonBlockingAssignments = this.fNonBlockingAssignments.get(customHid);
            if (this.pSkipExclusiveGenerateBlocks && this.checkMutualExclusiveGenerateBlocks(blockingAssignments, nonBlockingAssignments) || nonBlockingAssignments == null || !(customHid.fElement instanceof RfNamedElement)) continue;
            String message = this.getErrorMessage(customHid, nonBlockingAssignments, blockingAssignments);
            if (this.pCheckInitialBlock) {
                if (!this.checkInitial(blockingAssignments, nonBlockingAssignments)) continue;
                this.addHit((RfNamedElement)customHid.fElement, message);
                continue;
            }
            this.addHit((RfNamedElement)customHid.fElement, message);
        }
    }

    private boolean checkInitial(List<Object[]> blockingAssignments, List<Object[]> nonBlockingAssignments) {
        boolean isInInitial;
        boolean blockingHasAssignmentInInitial = false;
        boolean blockingHasAssignmentInNonInitial = false;
        boolean nonBlockingHasAssignmentInInitial = false;
        boolean nonBlockingHasAssignmentInNonInitial = false;
        for (Object[] blocking : blockingAssignments) {
            if (blocking.length != 4) continue;
            isInInitial = (Boolean)blocking[2];
            if (isInInitial) {
                blockingHasAssignmentInInitial = true;
                continue;
            }
            blockingHasAssignmentInNonInitial = true;
        }
        for (Object[] nonBlocking : nonBlockingAssignments) {
            if (nonBlocking.length != 4) continue;
            isInInitial = (Boolean)nonBlocking[2];
            if (isInInitial) {
                nonBlockingHasAssignmentInInitial = true;
                continue;
            }
            nonBlockingHasAssignmentInNonInitial = true;
        }
        if (blockingHasAssignmentInInitial && nonBlockingHasAssignmentInInitial) {
            return true;
        }
        return blockingHasAssignmentInNonInitial && nonBlockingHasAssignmentInNonInitial;
    }

    private boolean checkMutualExclusiveGenerateBlocks(List<Object[]> blockingAssignments, List<Object[]> nonBlockingAssignments) {
        RfGenerateBlock enclosingGenerate;
        RfGenerateBlock enclosingGenerateBlockForBlockingAssignments = null;
        RfGenerateBlock enclosingGenerateBlockForNonBlockingAssignments = null;
        for (Object[] blocking : blockingAssignments) {
            if (blocking.length != 4) continue;
            enclosingGenerate = (RfGenerateBlock)blocking[3];
            if (enclosingGenerate == null) {
                return false;
            }
            if (enclosingGenerateBlockForBlockingAssignments == null) {
                enclosingGenerateBlockForBlockingAssignments = enclosingGenerate;
                continue;
            }
            if (enclosingGenerateBlockForBlockingAssignments.equals(enclosingGenerate)) continue;
            return false;
        }
        for (Object[] nonBlocking : nonBlockingAssignments) {
            if (nonBlocking.length != 4) continue;
            enclosingGenerate = (RfGenerateBlock)nonBlocking[3];
            if (enclosingGenerate == null) {
                return false;
            }
            if (enclosingGenerateBlockForNonBlockingAssignments == null) {
                enclosingGenerateBlockForNonBlockingAssignments = enclosingGenerate;
                continue;
            }
            if (enclosingGenerateBlockForNonBlockingAssignments.equals(enclosingGenerate)) continue;
            return false;
        }
        if (enclosingGenerateBlockForBlockingAssignments == null || enclosingGenerateBlockForNonBlockingAssignments == null) {
            return false;
        }
        return this.areGenerateBlocksFromSameConditional(enclosingGenerateBlockForBlockingAssignments, enclosingGenerateBlockForNonBlockingAssignments);
    }

    private boolean areGenerateBlocksFromSameConditional(RfGenerateBlock genblk1, RfGenerateBlock genblk2) {
        return genblk1.getName().equals(genblk2.getName()) && genblk1.getEnclosingScope().equals(genblk2.getEnclosingScope());
    }

    private String getErrorMessage(CustomHid customHid, List<Object[]> nonBlockingAssignments, List<Object[]> blockingAssignments) {
        StringBuilder blockingMessage = new StringBuilder();
        for (Object[] entry : blockingAssignments) {
            HidOperator blockingOperator = (HidOperator)entry[0];
            ParserPath parserPath = (ParserPath)entry[1];
            boolean isInitialBlock = (Boolean)entry[2];
            String initialBlockMessage = "";
            if (this.pCheckInitialBlock) {
                initialBlockMessage = isInitialBlock ? " in initial block" : " in non-initial block";
            }
            if (parserPath == null) continue;
            String path = parserPath.path;
            int line = blockingOperator.getOccurrence().getLine();
            blockingMessage.append("'").append(blockingOperator.toString()).append("'").append(initialBlockMessage).append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
        }
        StringBuilder nonBlockingMessage = new StringBuilder();
        for (Object[] entry : nonBlockingAssignments) {
            HidOperator nonBlockingOperator = (HidOperator)entry[0];
            ParserPath parserPath = (ParserPath)entry[1];
            boolean isInitialBlock = (Boolean)entry[2];
            String initialBlockMessage = "";
            if (this.pCheckInitialBlock) {
                initialBlockMessage = isInitialBlock ? " in initial block" : " in non-initial block";
            }
            if (parserPath == null) continue;
            String path = parserPath.path;
            int line = nonBlockingOperator.getOccurrence().getLine();
            nonBlockingMessage.append("'").append(nonBlockingOperator.toString()).append("'").append(initialBlockMessage).append(this.link(" at line " + line + " of " + LintUtils.getFileShortName(path), path, line)).append("\n");
        }
        String message = MessageFormat.format(ERROR_MESSAGE_FORMAT, LintUtils.getNamedElementFullName((RfNamedElement)customHid.fElement), blockingMessage.toString(), nonBlockingMessage.toString());
        if (message.endsWith("\n")) {
            message = message.substring(0, message.length() - 1);
        }
        return message;
    }

    boolean isInInitialBlock(IRfScopeElement enclosingScope) {
        while (enclosingScope != null) {
            if (enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isInitial()) {
                return true;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return false;
    }

    RfGenerateBlock isInGenerateBlock(IRfScopeElement enclosingScope) {
        while (enclosingScope != null) {
            if (enclosingScope instanceof RfGenerateBlock && (((RfGenerateBlock)enclosingScope).getExpression().contains("if") || ((RfGenerateBlock)enclosingScope).getExpression().contains("case"))) {
                return (RfGenerateBlock)enclosingScope;
            }
            enclosingScope = enclosingScope.getEnclosingScope();
        }
        return null;
    }

    private static class CustomHid {
        public IRfNamedElement fElement;
        public RfHid fHid;

        public CustomHid(RfHid hid) {
            this.fElement = hid.getElement();
            this.fHid = hid;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fElement == null ? 0 : this.fElement.hashCode());
            result = 31 * result + (this.fHid == null ? 0 : this.fHid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CustomHid other = (CustomHid)obj;
            if (this.fElement == null ? other.fElement != null : !this.fElement.equals(other.fElement)) {
                return false;
            }
            return !(this.fHid == null ? other.fHid != null : !this.fHid.equals((Object)other.fHid));
        }
    }
}

