/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.9.11")
@CheckName(value="SVTB.9.11")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.METHOD})
@CheckTitle(value="Non-blocking assignments are not allowed in functions")
@CheckDescription(value="Using non-blocking assignments inside functions may lead to unexpected behavior.\n\nExamples:\n\nclass my_class;\n\tinteger a;\n\tinteger b;\n\n\tfunction void foo()\n\t\ta = a + 1; // allowed\n\t\ta <= a - 1; // not allowed\n\t\tb = b + a; // allowed\n\tendfunction\nendclass\n\nCheck supports pre-waiving.")
public class Check_SVTB_9_11
extends OVMComplianceCheck {
    private final HidOperatorVisitor fAssignmentsVisitor = new HidOperatorVisitor(new HidOperatorQualifier[]{HidOperatorQualifier.IS_NONBLOCKING_ASSIGN}){

        public boolean visit(HidOperator hidObject) {
            if (Check_SVTB_9_11.this.checkPreWaivers(this.parserPath)) {
                return true;
            }
            Check_SVTB_9_11.this.notifyCheckAlive();
            boolean isNonBlocking = hidObject.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN.value());
            if (isNonBlocking) {
                IRfNamedElement currentScope = this.scope;
                while (currentScope != null) {
                    if (currentScope instanceof RfFunction && ((RfFunction)currentScope).isFunction()) {
                        Check_SVTB_9_11.this.addHit(this.parserPath, hidObject.getOccurrence().getLine(), "Non-blocking assignment used inside function '" + LintUtils.getNamedElementFullName((RfNamedElement)currentScope) + "'!", null);
                    }
                    currentScope = currentScope.getEnclosingScope();
                }
            }
            return true;
        }
    };

    public Check_SVTB_9_11(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)this.fAssignmentsVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

