/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidExpressionBuilder;

@CheckVersion(value="20.1.40")
@CheckID(value="SVTB.9.12")
@CheckName(value="SVTB.9.12")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.ALWAYS})
@CheckTitle(value="All assignments in always_ff blocks are non-blocking and all assignments in always_comb blocks are blocking")
@CheckDescription(value="This rule checks that all assignments in always_ff blocks are \"<=\" and all assignments in always_comb blocks are \"=\".\n\nExamples:\n\nmodule example;\n\tinteger a;\n\n\talways_ff begin\n\t\ta = a + 1; // not allowed\n\t\ta <= a - 1; // allowed\n\tend\n\n\talways_comb begin\n\t\ta = a + 2; // allowed\n\t\ta <= a - 2; // not allowed\n\tend\nendmodule\n\nCheck supports pre-waiving.")
public class Check_SVTB_9_12
extends OVMComplianceCheck {
    public Check_SVTB_9_12(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        HidOperatorVisitor hidOperatorVisitor = new HidOperatorVisitor(null){

            public boolean visit(HidOperator operator) {
                if (Check_SVTB_9_12.this.checkPreWaivers(this.parserPath)) {
                    return true;
                }
                boolean isNonBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_NONBLOCKING_ASSIGN);
                boolean isBlocking = operator.hasOccurrence(HidOperatorQualifier.IS_BLOCKING_ASSIGN);
                if (!isBlocking && !isNonBlocking) {
                    return true;
                }
                Check_SVTB_9_12.this.notifyCheckAlive();
                RfNamedElement actionBlock = (RfNamedElement)this.scope.getEnclosingScope(RfActionBlock.class);
                boolean isInFor = false;
                if (actionBlock instanceof RfActionBlock && ((RfActionBlock)actionBlock).isFor()) {
                    isInFor = true;
                }
                while (actionBlock != null) {
                    if (actionBlock instanceof RfActionBlock && (((RfActionBlock)actionBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF) || ((RfActionBlock)actionBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB))) break;
                    actionBlock = actionBlock.getEnclosingScope();
                }
                if (!(actionBlock instanceof RfActionBlock)) {
                    return true;
                }
                IHidObject lhValue = operator.getLHValue();
                if (lhValue instanceof RfHidAccess) {
                    lhValue = ((RfHidAccess)lhValue).getParentHid();
                }
                if (!(lhValue instanceof RfHid)) {
                    return true;
                }
                if (isInFor && ((RfHid)lhValue).hasQualifier(RfHidExpressionBuilder.IF_CASE_LOOP_EXPR_QUALIFIER)) {
                    return true;
                }
                if (((RfActionBlock)actionBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_FF)) {
                    if (isBlocking) {
                        Check_SVTB_9_12.this.addHit(this.parserPath, operator.getOccurrence().getLine(), "Blocking assignment of '" + ((RfHid)lhValue).getName() + "' in always_ff block!", null);
                    }
                } else if (((RfActionBlock)actionBlock).hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB) && isNonBlocking) {
                    Check_SVTB_9_12.this.addHit(this.parserPath, operator.getOccurrence().getLine(), "Non-blocking assignment of '" + ((RfHid)lhValue).getName() + "' in always_comb block!", null);
                }
                return true;
            }
        };
        this.fOVMProject.getRfProject().visitHidObject(null, (IHidVisitor<?>)hidOperatorVisitor);
    }

    public boolean checkPreWaivers(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }
}

