/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.HashSet;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyDataType;
import ro.amiq.dvt.model.reflection.semantic.extension2.ISDataAbstract;
import ro.amiq.dvt.model.reflection.semantic.extension2.SDataUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.base.annotations.CheckDescription;
import ro.amiq.vlogdt.linter.base.annotations.CheckID;
import ro.amiq.vlogdt.linter.base.annotations.CheckLabel;
import ro.amiq.vlogdt.linter.base.annotations.CheckName;
import ro.amiq.vlogdt.linter.base.annotations.CheckTitle;
import ro.amiq.vlogdt.linter.base.annotations.CheckVersion;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.model.reflection.IRfNamedElementVisitor;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidAccess;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidImplicit;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;

@CheckVersion(value="20.1.36")
@CheckID(value="SVTB.9.3")
@CheckName(value="SVTB.9.3")
@CheckLabel(labels={RuleLabel.ASSIGNMENT, RuleLabel.STRUCT, RuleLabel.ARRAY})
@CheckTitle(value="Do not use the same structure/array pattern key in assignment patterns")
@CheckDescription(value="This check flags duplicate structure/array pattern key in the same assignment pattern.\nExample: \nstruct { int x, y; } s = '{x: 0, y: 0, x: 0}; // NOT ALLOWED\nint array[10] = '{3: 1, 3: 2, default: 0}; // NOT ALLOWED\n\nCheck supports pre-waiving.")
public class Check_SVTB_9_3
extends OVMComplianceCheck {
    public Check_SVTB_9_3(OVMProject oVMProject, OVMComplianceCategory category) {
        super(oVMProject, category);
    }

    @Override
    public void performCheckImpl() {
        final RfProject rfProject = this.fOVMProject.getRfProject();
        if (rfProject == null) {
            return;
        }
        final LocalHidVisitor localVisitor = new LocalHidVisitor();
        IRfNamedElementVisitor neVisitor = new IRfNamedElementVisitor(){

            @Override
            public boolean visit(RfNamedElement namedElement) {
                if (!namedElement.isPredefined()) {
                    RfFileDef file = namedElement.getFile();
                    if (file == null) {
                        return true;
                    }
                    if (Check_SVTB_9_3.this.isPreWaived(file.getParserPath())) {
                        return true;
                    }
                    namedElement.visitHidObject(rfProject, localVisitor);
                }
                return true;
            }
        };
        rfProject.accept(neVisitor);
    }

    public boolean isPreWaived(ParserPath parserPath) {
        if (parserPath == null) {
            return true;
        }
        return this.fOVMProject.getProjectWaivers().pathIsPrewaived(parserPath, this);
    }

    private final class LocalHidVisitor
    implements IHidVisitor<IHidObject> {
        private static final String ERROR_MESSAGE = "Assignment pattern contains duplicate member/index key: ";
        private ParserPath parserPath;

        private LocalHidVisitor() {
        }

        public void setParserPath(ParserPath parserPath) {
            this.parserPath = parserPath;
        }

        public boolean visit(IHidObject hidObject) {
            if (!(hidObject instanceof RfHidOperator)) {
                return true;
            }
            RfHidOperator operator = (RfHidOperator)hidObject;
            if (!operator.isEqualAssignment()) {
                return true;
            }
            Check_SVTB_9_3.this.notifyCheckAlive();
            IRfNamedElement leftHandType = this.getLeftHandType(operator);
            if (!(leftHandType instanceof RfStruct) && !(leftHandType instanceof RfListType)) {
                return true;
            }
            ListContainer rhValues = operator.getRHValues();
            if (rhValues == null || rhValues.isEmpty()) {
                return true;
            }
            for (IHidObject rhValue : rhValues) {
                ListContainer rhLocalValues;
                if (!(rhValue instanceof RfHidOperator)) {
                    return true;
                }
                RfHidOperator localOperator = (RfHidOperator)rhValue;
                if (!localOperator.isAssignmentPattern() || (rhLocalValues = localOperator.getRHValues()) == null || rhLocalValues.isEmpty()) continue;
                HashSet<String> items = new HashSet<String>();
                for (IHidObject value : rhLocalValues) {
                    IHidObject lhValue;
                    if (!(value instanceof RfHidOperator) || !(localOperator = (RfHidOperator)value).hasOccurrence(HidQualifierCache.IS_PATTERN_VALUE_QUALIFIER) || (lhValue = localOperator.getLHValue()) == null) continue;
                    String item = null;
                    if (lhValue instanceof RfHidImplicit) {
                        item = ((RfHidImplicit)lhValue).getName();
                    }
                    if (lhValue instanceof RfHid) {
                        item = ((RfHid)lhValue).getName();
                    }
                    if (item == null) continue;
                    if (items.contains(item)) {
                        Check_SVTB_9_3.this.addHit(this.parserPath, (HidOccurrence)operator.getOccurrence(), ERROR_MESSAGE + item);
                    }
                    items.add(item);
                }
            }
            return true;
        }

        private IRfNamedElement getLeftHandType(RfHidOperator operator) {
            IHidObject lhValue = operator.getLHValue();
            if (lhValue == null || !(lhValue instanceof RfHid) && !(lhValue instanceof RfHidAccess) && !(lhValue instanceof RfHidImplicit)) {
                return null;
            }
            if (lhValue instanceof RfHidImplicit) {
                ISDataAbstract resolvedType = operator.getOperatorResolvedType();
                if (resolvedType == null || resolvedType instanceof DummyDataType) {
                    return null;
                }
                IRfNamedElement dataType = SDataUtils.getDataType((ISDataAbstract)resolvedType).getType();
                return dataType;
            }
            if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).isSelect()) {
                return ((RfHidAccess)lhValue).getAssociatedType();
            }
            if (lhValue instanceof RfHidAccess && ((RfHidAccess)lhValue).getParentHid() instanceof RfHid) {
                lhValue = ((RfHidAccess)lhValue).getParentHid();
            }
            if (!(lhValue instanceof RfHid)) {
                return null;
            }
            IRfNamedElement leftElement = ((RfHid)lhValue).getElement();
            if (leftElement == null || !(leftElement instanceof RfField)) {
                return null;
            }
            IRfNamedElement leftType = ((RfField)leftElement).getAssociatedType();
            if (leftType instanceof RfTypeAlias) {
                RfTypeAlias alias = (RfTypeAlias)leftType;
                return alias.getResolvedType(true);
            }
            return leftType;
        }

        public Class<IHidObject> getType() {
            return IHidObject.class;
        }
    }
}

