/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

public class ClassMembersIterator
implements Iterator<RfNamedElement> {
    HashSet<String> memberKinds;
    boolean skipPredefined;
    HashSet<String> skipMembersDeclaredInsideMacrosWithPrefixes;
    HashSet<String> skipMembersDeclaredInsideClassesWithPrefixes;
    List<RfNamedElement> classMembers;
    int currentIndex;
    public static final String KEY_field = "field";
    public static final String KEY_constructor = "constructor";
    public static final String KEY_function = "function";
    public static final String KEY_task = "task";
    public static final String KEY_constraint = "constraint";
    public static final String KEY_function_implementation = "function_extern_implementation";
    public static final String KEY_task_implementation = "task_extern_implementation";
    public static final String KEY_constraint_implementation = "constraint_extern_implementation";
    public static final String KEY_constructor_implementation = "constructor_extern_implementation";
    public static final String KEY_event = "event";
    public static final String KEY_covergroup = "covergroup";
    public static final String KEY_type_parameter = "type_parameter";

    public ClassMembersIterator(RfClass aClass, HashSet<String> aMemberKinds, boolean aSkipPredefined) {
        this.memberKinds = aMemberKinds;
        if (this.memberKinds == null) {
            this.memberKinds = new HashSet();
        }
        this.skipPredefined = aSkipPredefined;
        this.classMembers = new ArrayList<RfNamedElement>();
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_field)) {
            this.classMembers.addAll(aClass.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (this.memberKinds.contains(KEY_constructor) || this.memberKinds.contains(KEY_constructor_implementation)) {
            this.classMembers.addAll(aClass.getConstructorsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_function) || this.memberKinds.contains(KEY_function_implementation)) {
            this.classMembers.addAll(aClass.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_task) || this.memberKinds.contains(KEY_task_implementation)) {
            this.classMembers.addAll(aClass.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_constraint) || this.memberKinds.contains(KEY_constraint_implementation)) {
            this.classMembers.addAll(aClass.getConstraintsWithPrefix("", 2, 1));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_event)) {
            this.classMembers.addAll(aClass.getEventsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_covergroup)) {
            this.classMembers.addAll(aClass.getCovergroupsWithPrefix("", 2, 1));
        }
        if (this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_type_parameter)) {
            this.classMembers.addAll(aClass.getParametersWithPrefix("", 384, 2, 1));
        }
        this.currentIndex = 0;
    }

    public ClassMembersIterator(RfClass aClass, HashSet<String> aMemberKinds, boolean aSkipPredefined, HashSet<String> aSkipMembersDeclaredInsideMacrosWithPrefixes, HashSet<String> aSkipMembersDeclaredInsideClassesWithPrefixes) {
        this(aClass, aMemberKinds, aSkipPredefined);
        this.skipMembersDeclaredInsideMacrosWithPrefixes = aSkipMembersDeclaredInsideMacrosWithPrefixes;
        this.skipMembersDeclaredInsideClassesWithPrefixes = aSkipMembersDeclaredInsideClassesWithPrefixes;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.classMembers.size();
    }

    @Override
    public RfNamedElement next() {
        while (this.currentIndex >= 0 && this.currentIndex < this.classMembers.size()) {
            RfNamedElement result = this.classMembers.get(this.currentIndex);
            ++this.currentIndex;
            if (result == null || this.skipPredefined && (result instanceof RfPredefinedFunction || result instanceof RfPredefinedField) || LintUtils.isInsideMacroWithPrefix(result, this.skipMembersDeclaredInsideMacrosWithPrefixes) || LintUtils.isDeclaredInAParentClassWithPrefixes(result, this.skipMembersDeclaredInsideClassesWithPrefixes)) continue;
            if (result instanceof RfField) {
                RfField eachField = (RfField)result;
                if ((this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_field)) && eachField.isField()) {
                    return result;
                }
                if ((this.memberKinds.isEmpty() || this.memberKinds.contains(KEY_event)) && eachField.isEvent()) {
                    return result;
                }
                if (!this.memberKinds.isEmpty() && !this.memberKinds.contains(KEY_type_parameter) || !eachField.isTypeParameter()) continue;
                return result;
            }
            return result;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

