/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.List;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.svtb.IDataDeclarationCheck;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;

public class DataDeclarationChecker {
    OVMProject fOVMProject;
    IDataDeclarationCheck fIdDeclarationChecker;

    DataDeclarationChecker(OVMProject aOVMProject, IDataDeclarationCheck aIdDeclarationChecker) {
        this.fOVMProject = aOVMProject;
        this.fIdDeclarationChecker = aIdDeclarationChecker;
    }

    public void visit() {
        for (RfNamedElement scope : this.fOVMProject.getAllNonXVMFunctionCallContainers()) {
            this.fIdDeclarationChecker.notifyCheckIsAlive();
            this.visitScope(scope);
        }
    }

    private void visitScope(RfNamedElement aScope) {
        if (aScope.isPredefined()) {
            return;
        }
        List<RfField> candidates = aScope.getLocalMembers(RfField.class);
        this.visitCandidates(candidates);
        List<RfActionBlock> allBlocks = aScope.getLocalMembers(RfActionBlock.class);
        if (allBlocks == null || allBlocks.isEmpty()) {
            return;
        }
        for (RfActionBlock innerBlock : allBlocks) {
            this.visitScope(innerBlock);
        }
    }

    private void visitCandidates(List<RfField> aCandidates) {
        if (aCandidates == null || aCandidates.isEmpty()) {
            return;
        }
        for (RfField candidate : aCandidates) {
            this.fIdDeclarationChecker.notifyPerformCheck(candidate);
        }
    }
}

