/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.svtb;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedField;
import ro.amiq.vlogdt.model.reflection.predefined.RfPredefinedFunction;

public class ModuleMembersIterator
implements Iterator<RfNamedElement> {
    List<RfNamedElement> classMembers;
    int currentIndex;
    boolean skipPredefined;
    HashSet<String> skipMembersDeclaredInsideMacrosWithPrefixes;
    HashSet<String> skipMembersDeclaredInsideClassesWithPrefixes;
    public static final String KEY_field = "field";
    public static final String KEY_instance = "instance";
    public static final String KEY_function = "function";
    public static final String KEY_task = "task";
    public static final String KEY_event = "event";
    public static final String KEY_covergroup = "covergroup";

    public ModuleMembersIterator(RfModule aModule, HashSet<String> aMemberKinds, boolean aSkipPredefined) {
        this.skipPredefined = aSkipPredefined;
        this.classMembers = new ArrayList<RfNamedElement>();
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_field)) {
            this.classMembers.addAll(aModule.getFieldsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_instance)) {
            this.classMembers.addAll(aModule.getInstancesWithPrefix("", 2, 1));
        }
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_function)) {
            this.classMembers.addAll(aModule.getFunctionsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_task)) {
            this.classMembers.addAll(aModule.getTasksWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_event)) {
            this.classMembers.addAll(aModule.getEventsWithPrefix("", 2, 1, IRfNamedElement.AccessModifier.SHOW_PRIVATE));
        }
        if (aMemberKinds.isEmpty() || aMemberKinds.contains(KEY_covergroup)) {
            this.classMembers.addAll(aModule.getCovergroupsWithPrefix("", 2, 1));
        }
        this.currentIndex = 0;
    }

    public ModuleMembersIterator(RfModule aModule, HashSet<String> aMemberKinds, boolean aSkipPredefined, HashSet<String> aSkipMembersDeclaredInsideMacrosWithPrefixes, HashSet<String> aSkipMembersDeclaredInsideClassesWithPrefixes) {
        this(aModule, aMemberKinds, aSkipPredefined);
        this.skipMembersDeclaredInsideMacrosWithPrefixes = aSkipMembersDeclaredInsideMacrosWithPrefixes;
        this.skipMembersDeclaredInsideClassesWithPrefixes = aSkipMembersDeclaredInsideClassesWithPrefixes;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.classMembers.size();
    }

    @Override
    public RfNamedElement next() {
        while (this.currentIndex >= 0 && this.currentIndex < this.classMembers.size()) {
            RfField eachField;
            RfNamedElement result = this.classMembers.get(this.currentIndex);
            ++this.currentIndex;
            if (result == null || this.skipPredefined && (result instanceof RfPredefinedFunction || result instanceof RfPredefinedField) || LintUtils.isInsideMacroWithPrefix(result, this.skipMembersDeclaredInsideMacrosWithPrefixes) || LintUtils.isDeclaredInAParentClassWithPrefixes(result, this.skipMembersDeclaredInsideClassesWithPrefixes)) continue;
            if (result instanceof RfInstance) {
                return result;
            }
            if (result instanceof RfField && (eachField = (RfField)result).isField()) {
                return result;
            }
            return result;
        }
        return null;
    }

    @Override
    public void remove() {
    }
}

