/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMProject;

public abstract class AbstractLintingHandler
extends AbstractHandler {
    protected Set<IProject> getSingleFileProjects() {
        HashSet<IProject> singleFileProjectsMap = new HashSet<IProject>();
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                try {
                    OVMProject ovmProject;
                    if (proj.isAccessible() && proj.isNatureEnabled("ro.amiq.vlogdt.VlogNature") && (ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(proj)) != null && !ovmProject.lintProject()) {
                        singleFileProjectsMap.add(proj);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
                ++n2;
            }
        });
        return singleFileProjectsMap;
    }
}

