/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.linter.ui.ArchitectureDoublePanelElement;
import ro.amiq.vlogdt.linter.ui.ArchitectureModel;
import ro.amiq.vlogdt.linter.ui.FontFactory;
import ro.amiq.vlogdt.linter.ui.IArchitectureChangedListener;
import ro.amiq.vlogdt.linter.ui.Messages;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class ArchitectureDoublePanel
extends Composite {
    private static final Object FAMILY_FILTER = new Object();
    private RightPanelFilterTriggerJob fRightPanelFilterTriggerJob = new RightPanelFilterTriggerJob();
    private StringMatcher fRightPanelFilterStringMatcher;
    private LeftPanelFilterTriggerJob fLeftPanelFilterTriggerJob = new LeftPanelFilterTriggerJob();
    private StringMatcher fLeftPanelFilterStringMatcher;
    private TreeViewer fLeftPanel;
    private TableViewer fRightPanel;
    private Text fRightPanelFilterTextBox;
    private Text fLeftPanelFilterTextBox;
    private Text fStatusBar;
    private FontFactory fFontFactory;
    private ArrayList<ArchitectureDoublePanelElement> fLeftPanelData;
    private ArrayList<ArchitectureDoublePanelElement> fRightPanelData;
    private ArrayList<IArchitectureChangedListener> fArchitectureChangedListeners;
    private Color fBackgroundColor;
    private Color fInfoBackgroundColor;

    public ArchitectureDoublePanel(Composite parent, int style) {
        super(parent, style);
        this.fFontFactory = new FontFactory(parent.getDisplay());
        this.fArchitectureChangedListeners = new ArrayList();
        this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor());
        this.fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        this.setLayout((Layout)gl);
        Composite titleComposite = new Composite((Composite)this, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        titleComposite.setLayout((Layout)new GridLayout(1, true));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor, true);
        Composite subTitleComposite = new Composite(titleComposite, 0);
        subTitleComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        subTitleComposite.setLayout((Layout)new GridLayout(2, true));
        DVTColorUtil.INSTANCE.setBackground((Control)subTitleComposite, this.fBackgroundColor, true);
        Label titleLabel = new Label(subTitleComposite, 64);
        titleLabel.setLayoutData((Object)new GridData(0, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText(Messages.ArchitectureDoublePanel_Page_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        Label descriptionLabel = new Label(titleComposite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        descriptionLabel.setFont(this.fFontFactory.createFont("description", 0));
        descriptionLabel.setText(Messages.ArchitectureDoublePanel_Page_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)descriptionLabel, this.fBackgroundColor, true);
        Composite panelContainer = new Composite((Composite)this, 0);
        panelContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        panelContainer.setLayout((Layout)new GridLayout(3, false));
        DVTColorUtil.INSTANCE.setBackground((Control)panelContainer, this.fBackgroundColor, true);
        Composite leftContainer = new Composite(panelContainer, 0);
        leftContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        leftContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)leftContainer, this.fBackgroundColor, true);
        this.fLeftPanelFilterTextBox = new Text(leftContainer, 2048);
        this.fLeftPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fLeftPanelFilterTextBox.setText("");
        this.fLeftPanelFilterStringMatcher = new StringMatcher("**", false, false);
        this.fLeftPanelFilterTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                ArchitectureDoublePanel.this.fLeftPanelFilterStringMatcher = new StringMatcher(String.valueOf('*') + text + '*', false, false);
                ArchitectureDoublePanel.this.fLeftPanelFilterTriggerJob.cancel();
                ArchitectureDoublePanel.this.fLeftPanelFilterTriggerJob.schedule(250L);
                ArchitectureDoublePanel.this.setFilterTextColor(ArchitectureDoublePanel.this.fLeftPanelFilterTextBox);
            }
        });
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLeftPanelFilterTextBox, this.fBackgroundColor, true);
        this.fLeftPanel = new TreeViewer(leftContainer);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.fLeftPanel.getControl().setLayoutData((Object)gridData);
        LeftPanelProvider leftPanelProvider = new LeftPanelProvider();
        this.fLeftPanel.setContentProvider((IContentProvider)leftPanelProvider);
        this.fLeftPanel.setLabelProvider((IBaseLabelProvider)leftPanelProvider);
        DVTColorUtil.INSTANCE.setBackground(this.fLeftPanel.getControl(), this.fBackgroundColor, true);
        Tree leftTree = this.fLeftPanel.getTree();
        leftTree.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)leftTree, this.fBackgroundColor, true);
        TreeColumn leftColumn = new TreeColumn(leftTree, 16384);
        leftColumn.setText("Mapped Classes");
        leftColumn.setWidth(200);
        this.fLeftPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ArchitectureDoublePanel.this.openSelected(true);
            }
        });
        this.fLeftPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfClass) {
                    ArchitectureDoublePanel.this.fStatusBar.setText(((RfClass)((ArchitectureDoublePanelElement)element).getElement()).getFullName());
                }
            }
        });
        this.fLeftPanel.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfClass) {
                    return 1;
                }
                return 0;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                String name1 = cat1 != 0 ? ((ArchitectureDoublePanelElement)e1).getText() : "";
                String name2 = cat2 != 0 ? ((ArchitectureDoublePanelElement)e2).getText() : "";
                return this.getComparator().compare(name1, name2);
            }
        });
        this.fLeftPanel.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (viewer instanceof TreeViewer && element instanceof ArchitectureDoublePanelElement) {
                    if (((ArchitectureDoublePanelElement)element).getElement() instanceof RfClass) {
                        return ArchitectureDoublePanel.this.fLeftPanelFilterStringMatcher.match(((ArchitectureDoublePanelElement)element).getText());
                    }
                    return true;
                }
                return false;
            }
        });
        Composite rightContainer = new Composite(panelContainer, 0);
        rightContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        rightContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)rightContainer, this.fBackgroundColor, true);
        this.fRightPanelFilterTextBox = new Text(rightContainer, 2048);
        this.fRightPanelFilterTextBox.setLayoutData((Object)new GridData(4, 128, true, false));
        this.fRightPanelFilterTextBox.setText("");
        this.fRightPanelFilterStringMatcher = new StringMatcher("**", false, false);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRightPanelFilterTextBox, this.fBackgroundColor, true);
        this.fRightPanelFilterTextBox.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = ((Text)e.widget).getText();
                ArchitectureDoublePanel.this.fRightPanelFilterStringMatcher = new StringMatcher(String.valueOf('*') + text + '*', false, false);
                ArchitectureDoublePanel.this.fRightPanelFilterTriggerJob.cancel();
                ArchitectureDoublePanel.this.fRightPanelFilterTriggerJob.schedule(250L);
                ArchitectureDoublePanel.this.setFilterTextColor(ArchitectureDoublePanel.this.fRightPanelFilterTextBox);
            }
        });
        this.fRightPanel = new TableViewer(rightContainer);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = 300;
        this.fRightPanel.getControl().setLayoutData((Object)gridData);
        RightPanelProvider rightPanelProvider = new RightPanelProvider();
        this.fRightPanel.setContentProvider((IContentProvider)rightPanelProvider);
        this.fRightPanel.setLabelProvider((IBaseLabelProvider)rightPanelProvider);
        DVTColorUtil.INSTANCE.setBackground(this.fRightPanel.getControl(), this.fBackgroundColor, true);
        Table rightTable = this.fRightPanel.getTable();
        rightTable.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)rightTable, this.fBackgroundColor, true);
        TableColumn rightColumn = new TableColumn(rightTable, 16384);
        rightColumn.setText("Unmapped Classes");
        rightColumn.setWidth(200);
        this.fRightPanel.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ArchitectureDoublePanel.this.openSelected(false);
            }
        });
        this.fRightPanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).getElement() instanceof RfClass) {
                    ArchitectureDoublePanel.this.fStatusBar.setText(((RfClass)((ArchitectureDoublePanelElement)element).getElement()).getFullName());
                }
            }
        });
        this.fRightPanel.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof ArchitectureDoublePanelElement) {
                    return 1;
                }
                return 0;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                int cat2;
                int cat1 = this.category(e1);
                if (cat1 != (cat2 = this.category(e2))) {
                    return cat1 - cat2;
                }
                String name1 = cat1 != 0 ? ((ArchitectureDoublePanelElement)e1).getText() : "";
                String name2 = cat2 != 0 ? ((ArchitectureDoublePanelElement)e2).getText() : "";
                return this.getComparator().compare(name1, name2);
            }
        });
        this.fRightPanel.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return viewer instanceof TableViewer && ArchitectureDoublePanel.this.fRightPanelFilterStringMatcher.match(((ArchitectureDoublePanelElement)element).getText());
            }
        });
        this.fStatusBar = new Text(panelContainer, 2056);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fBackgroundColor, true);
        this.fStatusBar.setLayoutData((Object)new GridData(4, 1024, true, false, 3, 0));
    }

    public void setInput(ArchitectureModel architectureModel) {
        Assert.isNotNull((Object)architectureModel);
        this.fRightPanelData = architectureModel.getRightPanelData();
        this.fLeftPanelData = architectureModel.getLeftPanelData();
        this.fLeftPanel.setInput(this.fLeftPanelData);
        if (this.fLeftPanel.getTree().getItemCount() > 0) {
            this.fLeftPanel.getTree().setSelection(this.fLeftPanel.getTree().getItem(0));
        }
        this.fLeftPanel.expandAll();
        this.fRightPanel.setInput(this.fRightPanelData);
        if (this.fRightPanel.getTable().getItemCount() > 0) {
            this.fRightPanel.getTable().setSelection(0);
        }
        this.architectureChanged();
        architectureModel.setUpdateListener(this);
    }

    private void setFilterTextColor(Text textBox) {
        DVTColorUtil.INSTANCE.setBackground((Control)textBox, this.fInfoBackgroundColor);
    }

    private void openSelected(boolean leftNotRight) {
        if (leftNotRight) {
            Object selection = ((IStructuredSelection)this.fLeftPanel.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            TreeItem[] selectionTreeItems = this.fLeftPanel.getTree().getSelection();
            if (selectionTreeItems == null || selectionTreeItems.length == 0) {
                return;
            }
            Object element = ((ArchitectureDoublePanelElement)selectionTreeItems[0].getData()).getElement();
            if (element instanceof RfNamedElement) {
                int line = ((RfNamedElement)element).getLine();
                RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
                if (declaration == null) {
                    return;
                }
                IFile file = (IFile)declaration.getFileAdapter();
                if (file != null) {
                    VlogFileUtils.getInstance().openEditor(file, line, ((RfNamedElement)element).getName());
                }
            }
        } else {
            Object selection = ((IStructuredSelection)this.fRightPanel.getSelection()).getFirstElement();
            if (selection == null) {
                return;
            }
            Object element = ((ArchitectureDoublePanelElement)selection).getElement();
            if (element instanceof RfNamedElement) {
                int line = ((RfNamedElement)element).getLine();
                RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
                if (declaration == null) {
                    return;
                }
                IFile file = (IFile)declaration.getFileAdapter();
                if (file != null) {
                    VlogFileUtils.getInstance().openEditor(file, line, null);
                }
            }
        }
    }

    public void addArchitectureChangedListener(IArchitectureChangedListener listener) {
        Assert.isNotNull((Object)listener);
        this.fArchitectureChangedListeners.add(listener);
    }

    private void architectureChanged() {
        for (IArchitectureChangedListener listener : this.fArchitectureChangedListeners) {
            listener.architectureChanged();
        }
    }

    public void dispose() {
        if (this.fArchitectureChangedListeners != null) {
            this.fArchitectureChangedListeners.clear();
        }
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
        super.dispose();
    }

    public void refresh() {
        this.fLeftPanel.refresh();
        this.fLeftPanel.expandAll();
        this.fRightPanel.refresh();
    }

    private final class LeftPanelFilterTriggerJob
    extends UIJob {
        public LeftPanelFilterTriggerJob() {
            super("Filter Left Panel");
            this.setPriority(50);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_FILTER;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                ArchitectureDoublePanel.this.fLeftPanel.refresh();
                ArchitectureDoublePanel.this.fLeftPanel.expandAll();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class LeftPanelProvider
    implements ITreeContentProvider,
    ILabelProvider {
        private LeftPanelProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement != null && parentElement instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)parentElement).childrenCount() > 0) {
                return ((ArchitectureDoublePanelElement)parentElement).getChildren();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element != null && element instanceof ArchitectureDoublePanelElement && ((ArchitectureDoublePanelElement)element).childrenCount() > 0;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                if (((ArchitectureDoublePanelElement)element).getElement() instanceof String) {
                    result = DVTImages.imageCache.getImage(DVTImages.TYPES);
                } else if (((ArchitectureDoublePanelElement)element).getElement() instanceof RfClass) {
                    result = ((RfClass)((ArchitectureDoublePanelElement)element).getElement()).isInterfaceClass() ? DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS) : DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
                }
            }
            return result;
        }

        public String getText(Object element) {
            if (element != null && element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getText();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class RightPanelFilterTriggerJob
    extends UIJob {
        public RightPanelFilterTriggerJob() {
            super("Filter Right Panel");
            this.setPriority(50);
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_FILTER;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                ArchitectureDoublePanel.this.fRightPanel.refresh();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            return Status.OK_STATUS;
        }
    }

    private static final class RightPanelProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private RightPanelProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (element instanceof ArchitectureDoublePanelElement) {
                element = ((ArchitectureDoublePanelElement)element).getElement();
            }
            if (element instanceof RfClass && ((RfClass)element).isInterfaceClass()) {
                return DVTImages.imageCache.getImage(DVTImages.OUTLINE_INTERFACE_CLASS);
            }
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_CLASS);
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ArchitectureDoublePanelElement) {
                return ((ArchitectureDoublePanelElement)element).getText();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

