/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ui.ArchitectureDoublePanel;
import ro.amiq.vlogdt.linter.ui.ArchitectureDoublePanelElement;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;

public class ArchitectureModel {
    private final IProject fProject;
    private final OVMProject fOVMProject;
    private final ArrayList<ArchitectureDoublePanelElement> fArchitectureLeftPanelData;
    private final ArrayList<ArchitectureDoublePanelElement> fArchitectureRightPanelData;
    private LinkedHashMap<String, Map<String, RfClass>> fOVMArchitectureCategories;
    private ArchitectureDoublePanel fArchitectureDoublePanel;

    public ArchitectureModel(OVMProject ovmProject, IProject project) {
        this.fOVMProject = ovmProject;
        this.fProject = project;
        this.fArchitectureLeftPanelData = new ArrayList();
        this.fArchitectureRightPanelData = new ArrayList();
        this.wrapArchitectureElements();
    }

    private void wrapArchitectureElements() {
        ArchitectureDoublePanelElement classWrapper;
        Map inheritedClasses;
        ArchitectureDoublePanelElement categoryWraper;
        String categoryName;
        LinkedHashMap<String, ArchitectureDoublePanelElement> categoryWrappers = new LinkedHashMap<String, ArchitectureDoublePanelElement>();
        LinkedHashMap<RfClass, ArchitectureDoublePanelElement> classWrappers = new LinkedHashMap<RfClass, ArchitectureDoublePanelElement>();
        LinkedHashMap<RfClass, ArchitectureDoublePanelElement> remainingClassWrappers = new LinkedHashMap<RfClass, ArchitectureDoublePanelElement>();
        for (RfNamedElement rfNamedElement : this.fOVMProject.getAllNonXVMClasses()) {
            classWrappers.put((RfClass)rfNamedElement, new ArchitectureDoublePanelElement(rfNamedElement));
            remainingClassWrappers.put((RfClass)rfNamedElement, new ArchitectureDoublePanelElement(rfNamedElement));
        }
        this.fOVMArchitectureCategories = this.fOVMProject.getCategories();
        for (String string : this.fOVMArchitectureCategories.keySet()) {
            categoryWrappers.put(string, new ArchitectureDoublePanelElement(string));
        }
        for (Map.Entry entry : this.fOVMArchitectureCategories.entrySet()) {
            categoryName = (String)entry.getKey();
            categoryWraper = (ArchitectureDoublePanelElement)categoryWrappers.get(categoryName);
            inheritedClasses = (Map)entry.getValue();
            for (RfClass clazz : inheritedClasses.values()) {
                classWrapper = (ArchitectureDoublePanelElement)classWrappers.get(clazz);
                if (classWrapper == null) continue;
                classWrapper.setAutoParent(categoryWraper);
            }
        }
        for (Map.Entry entry : this.fOVMArchitectureCategories.entrySet()) {
            categoryName = (String)entry.getKey();
            categoryWraper = (ArchitectureDoublePanelElement)categoryWrappers.get(categoryName);
            inheritedClasses = (Map)entry.getValue();
            for (RfClass clazz : inheritedClasses.values()) {
                classWrapper = (ArchitectureDoublePanelElement)classWrappers.get(clazz);
                if (classWrapper == null) continue;
                classWrapper.setParent(categoryWraper);
                categoryWraper.addChild(classWrapper);
                remainingClassWrappers.remove(clazz);
            }
        }
        this.fArchitectureLeftPanelData.addAll(categoryWrappers.values());
        this.fArchitectureRightPanelData.addAll(remainingClassWrappers.values());
    }

    private void unwrapArchitectureElements() {
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        if (rfProject == null) {
            return;
        }
        for (ArchitectureDoublePanelElement category : this.fArchitectureLeftPanelData) {
            Map<String, RfClass> OVMCategory = this.fOVMArchitectureCategories.get(category.getText());
            if (OVMCategory == null) continue;
            OVMCategory.clear();
            ArchitectureDoublePanelElement[] architectureDoublePanelElementArray = category.getChildren();
            int n = architectureDoublePanelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                ArchitectureDoublePanelElement element = architectureDoublePanelElementArray[n2];
                if (element != null && element.getElement() != null) {
                    RfClass target = (RfClass)element.getElement();
                    OVMCategory.put(target.getFullName(), target);
                }
                ++n2;
            }
        }
    }

    public ArrayList<ArchitectureDoublePanelElement> getRightPanelData() {
        return this.fArchitectureRightPanelData;
    }

    public ArrayList<ArchitectureDoublePanelElement> getLeftPanelData() {
        return this.fArchitectureLeftPanelData;
    }

    public void updateOVMProject(boolean updateContent, boolean architectureChanged) {
        if (architectureChanged) {
            LinkedHashMap<String, String[]> architecture = new LinkedHashMap<String, String[]>();
            for (ArchitectureDoublePanelElement category : this.fArchitectureLeftPanelData) {
                ArchitectureDoublePanelElement[] categoryChildren = category.getChildren();
                String[] childrenFullNames = new String[category.childrenCount()];
                int i = 0;
                while (i < categoryChildren.length) {
                    childrenFullNames[i] = ((RfClass)categoryChildren[i].getElement()).getFullName();
                    ++i;
                }
                architecture.put(category.getText(), childrenFullNames);
            }
        }
        if (updateContent) {
            this.fArchitectureLeftPanelData.clear();
            this.fArchitectureRightPanelData.clear();
            this.wrapArchitectureElements();
            this.fArchitectureDoublePanel.refresh();
        }
        this.unwrapArchitectureElements();
    }

    public void setUpdateListener(ArchitectureDoublePanel architectureDoublePanel) {
        this.fArchitectureDoublePanel = architectureDoublePanel;
    }
}

