/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.OVMReportInfoProvider;
import ro.amiq.vlogdt.linter.annotations.Annotation;
import ro.amiq.vlogdt.linter.annotations.AnnotationLocation;
import ro.amiq.vlogdt.linter.annotations.AnnotationType;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAIAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.generate.AbstractGenerateHandler;
import ro.amiq.vlogdt.linter.generate.AbstractGenerateRulePoolDocHandler;
import ro.amiq.vlogdt.linter.generate.doc.LinterDocGenerator;
import ro.amiq.vlogdt.linter.ruleset.ErrorCheck;
import ro.amiq.vlogdt.linter.ruleset.RulesetConfiguration;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;
import ro.amiq.vlogdt.linter.ui.FontFactory;
import ro.amiq.vlogdt.linter.ui.IReportUpdateListener;
import ro.amiq.vlogdt.linter.ui.IWaiversChangeListener;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.ui.Messages;
import ro.amiq.vlogdt.linter.ui.OVMComplianceChecksUtilUI;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReport;
import ro.amiq.vlogdt.linter.ui.TagWidget;
import ro.amiq.vlogdt.linter.ui.WaiverDialog;
import ro.amiq.vlogdt.linter.ui.WaiverFileValidator;
import ro.amiq.vlogdt.linter.ui.WaiversManager;
import ro.amiq.vlogdt.linter.ui.WaiversUtils;
import ro.amiq.vlogdt.linter.utils.HTMLUtils;
import ro.amiq.vlogdt.linter.waivers.IWaiver;
import ro.amiq.vlogdt.linter.waivers.PostWaiver;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class ChecksTreeBrowser
implements IReportUpdateListener {
    private static final String FAILURE_FORMAT = "LINT {0} {1} at line {2} in file {3}: {4}";
    private static final int TAG_LABEL_FONT_SIZE = 10;
    private FontFactory fFontFactory;
    private Composite fRightPartComposite;
    private Composite fLeftPartComposite;
    private TreeViewer fTree;
    private Button fMarkAsPassedButton;
    private Button fMarkAsFailedButton;
    private Combo fFiltersList;
    private Button fHidePassedButton;
    private Button fHideErrorButton;
    private Button fHideWarningButton;
    private Button fHideInfoButton;
    private Button fHideDisabledButton;
    private Button fHideAutomaticButton;
    private Button fHideManualButton;
    private Button fHideNonAutofixableButton;
    private Text fDetailsTitle;
    private Text fDetailsDescription;
    private Link fLinkDescription;
    private Composite fTagComposite;
    private Composite fTagAndLabelComposite;
    private Composite fLabelComposite;
    Composite fTitleAndDescription;
    private int fMaxTagCompositeWitdh;
    private int fMaxLabelCompositeWitdh;
    private List<ResizeListener> fTagResizeListenerList = new ArrayList<ResizeListener>();
    private List<ResizeListener> fLabelResizeListenerList = new ArrayList<ResizeListener>();
    private Composite fCheckStatusDetailsContainer;
    private Label fCheckStatusIcon;
    private Label fCheckStatusText;
    private StackLayout fContentsStack;
    private Composite fSummaryComposite;
    private TableViewer fSummaryTable;
    private Text fSummaryTableDetails;
    private Composite fStatusComposite;
    private Label fChecksScoreValueLabel;
    private Label fPassedScoreValueLabel;
    private Label fFailuresScoreValueLabel;
    private Label fWarningsScoreValueLabel;
    private Label fInfosScoreValueLabel;
    private Label fDisabledScoreValueLabel;
    private Label fChecksHitsValueLabel;
    private Composite fCategoriesComposite;
    private TableViewer fCategoriesTable;
    private Text fCategoriesTableDetails;
    private Combo fLabelFiltersList;
    private Composite fChecksComposite;
    private TableViewer fChecksTable;
    private Composite fManualChecksComposite;
    private Composite fNonExistentRuleComposite;
    private Object fSelectedItem;
    private final IProject fProject;
    private OVMComplianceReport fComplianceReport;
    private Color fBackgroundColor;
    private Color fInfoBackgroundColor;
    private Color fButtonBackgroundColor;
    private FiltersListSelectionListener fFiltersListSelectionListener;
    private FilterButtonSelectionListener fFilterButtonSelectionListener;
    public RuleLabel labelFilter;
    private SelectionListener fLabelFiltersListSelectionListener;
    private LinkedList<IWaiversChangeListener> fWaiversChangeListeners;
    private List<MenuItem> fAutocorrectCheckMenuItems;
    private MenuItem fTreeWaiveCheckMenuItem;
    private MenuItem fTreeReapplyCheckMenuItem;
    private MenuItem fTreeAutofixHitsCheckMenuItem;
    public EnumMap<CheckStatus, Boolean> filters = new EnumMap(CheckStatus.class);

    private void loadFilterPreferences() {
        this.filters.put(CheckStatus.DISABLED, this.fHideDisabledButton.getSelection());
        this.filters.put(CheckStatus.PASSED, this.fHidePassedButton.getSelection());
        this.filters.put(CheckStatus.ERROR, this.fHideErrorButton.getSelection());
        this.filters.put(CheckStatus.WARNING, this.fHideWarningButton.getSelection());
        this.filters.put(CheckStatus.INFO, this.fHideInfoButton.getSelection());
    }

    private void loadLabelsFilters() {
        int index = this.fLabelFiltersList.getSelectionIndex();
        String selection = this.fLabelFiltersList.getItem(index);
        this.labelFilter = RuleLabel.valueOfString(selection);
    }

    public ChecksTreeBrowser(Composite parent, Object layoutData, IProject project, OVMComplianceReport complianceReport) {
        this.fWaiversChangeListeners = new LinkedList();
        this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor());
        this.fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
        this.fButtonBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoButtonBackgroundColor());
        this.fProject = project;
        this.fComplianceReport = complianceReport;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        if (layoutData != null) {
            composite.setLayoutData(layoutData);
        }
        DVTColorUtil.INSTANCE.setBackground((Control)composite, this.fBackgroundColor, true);
        this.fFontFactory = new FontFactory(parent.getDisplay());
        SashForm sashForm = new SashForm(composite, 256);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.createLeftPart((Composite)sashForm);
        this.createRightPart((Composite)sashForm);
        int[] componentWeight = new int[]{3, 7};
        sashForm.setWeights(componentWeight);
    }

    private void createLeftPart(Composite parent) {
        this.fLeftPartComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        this.fLeftPartComposite.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLeftPartComposite, this.fBackgroundColor, true);
        Composite titleComposite = new Composite(this.fLeftPartComposite, 0);
        titleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        titleComposite.setLayout((Layout)new GridLayout(2, false));
        DVTColorUtil.INSTANCE.setBackground((Control)titleComposite, this.fBackgroundColor, true);
        this.createTitle(titleComposite);
        Composite filterBarComposite = new Composite(this.fLeftPartComposite, 0);
        filterBarComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)filterBarComposite, this.fBackgroundColor, true);
        this.createFilterBar(filterBarComposite);
        this.fTree = new TreeViewer(this.fLeftPartComposite, 2820);
        this.fTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTree.setContentProvider((IContentProvider)new ChecksTreeContentProvider());
        this.fTree.setLabelProvider((IBaseLabelProvider)new ChecksTreeLabelProvider());
        this.fTree.addSelectionChangedListener((ISelectionChangedListener)new ChecksTreeSelectionChangedListener());
        this.fTree.addFilter((ViewerFilter)new ComplianceCheckFilter());
        DVTColorUtil.INSTANCE.setBackground(this.fTree.getControl(), this.fBackgroundColor, true);
        Menu treeMenu = new Menu((Control)this.fTree.getTree());
        this.fTreeAutofixHitsCheckMenuItem = new MenuItem(treeMenu, 0);
        this.fTreeAutofixHitsCheckMenuItem.setText("Fix Failures for Check");
        this.fTreeAutofixHitsCheckMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck) {
                    VerissimoAutofixManager.getInstance().fixCheckFailures((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem, false, ChecksTreeBrowser.this.getCurrentOVMProject());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fAutocorrectCheckMenuItems = this.getAndAddAIAutofixForCheckMenuItems(treeMenu);
        this.fTreeWaiveCheckMenuItem = new MenuItem(treeMenu, 0);
        this.fTreeWaiveCheckMenuItem.setText("Add Waiver for Check");
        this.fTreeWaiveCheckMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck) {
                    IWaiver waiverResult;
                    OVMProject ovmProject = ChecksTreeBrowser.this.fComplianceReport.getOVMInfoProvider().getOVMProject();
                    if (!WaiversManager.getInstance().checkReadOnlyWaiverFiles(ovmProject)) {
                        return;
                    }
                    String checkName = ((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).getName();
                    PostWaiver waiver = WaiversUtils.INSTANCE.createCheckPostWaiver(checkName);
                    WaiverDialog dialog = new WaiverDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ovmProject);
                    dialog.setInput(waiver);
                    if (dialog.open() == 0 && WaiverFileValidator.INSTANCE.validate(ChecksTreeBrowser.this.fProject, (waiverResult = dialog.getWaiver()).getFilePath())) {
                        ovmProject.getProjectWaivers().addWaiver(waiverResult);
                        ovmProject.getProjectWaivers().save();
                        ovmProject.getProjectWaivers().load();
                        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                            return;
                        }
                        try {
                            if (waiverResult instanceof PostWaiver) {
                                WaiversManager.getInstance().reapplyWaivers((PostWaiver)waiverResult, ovmProject);
                                ChecksTreeBrowser.this.notifyChangeListeners(true);
                            } else if (waiverResult instanceof PreWaiver) {
                                ((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).reapplyWaivers();
                                ChecksTreeBrowser.this.notifyChangeListeners(false);
                            }
                            ChecksTreeBrowser.this.updateLeftPart();
                            ChecksTreeBrowser.this.fComplianceReport.updateListeners();
                            LintingProblemsManager.getInstance().updateMarkersAfterWaivers(ChecksTreeBrowser.this.fProject);
                        }
                        finally {
                            DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fTreeReapplyCheckMenuItem = new MenuItem(treeMenu, 0);
        this.fTreeReapplyCheckMenuItem.setText("Reapply Check");
        this.fTreeReapplyCheckMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck || ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCategory) {
                    ChecksTreeBrowser.this.fComplianceReport.doReapply(false, ChecksTreeBrowser.this.fSelectedItem);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fTree.getTree().setMenu(treeMenu);
    }

    private void createTitle(Composite parent) {
        Label titleLabel = new Label(parent, 64);
        titleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        titleLabel.setFont(this.fFontFactory.createFont("title", 18, 1));
        titleLabel.setText(Messages.ChecksTreeBrowser_Page_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)titleLabel, this.fBackgroundColor, true);
        this.createGenerateRulesDocButton(parent);
        Label descriptionLabel = new Label(parent, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        descriptionLabel.setFont(this.fFontFactory.createFont("description", 0));
        descriptionLabel.setText(Messages.ChecksTreeBrowser_Page_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)descriptionLabel, this.fBackgroundColor, true);
    }

    private void createGenerateRulesDocButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText(Messages.ChecksTreeBrowser_Page_Generate_Rules_Doc_Button);
        button.setLayoutData((Object)new GridData(131072, 0x1000000, true, true, 1, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)button, this.fBackgroundColor, true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMProject ovmProject = new OVMReportInfoProvider(ChecksTreeBrowser.this.fProject).getOVMProject();
                String htmlReportLocation = ovmProject.getConfiguration().getHTMLReportLocation();
                if (htmlReportLocation == null || htmlReportLocation.equals("")) {
                    htmlReportLocation = new OVMReportInfoProvider(ChecksTreeBrowser.this.fProject).getOutputPath();
                }
                Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                final AbstractGenerateHandler.SavingDialog dialog = new AbstractGenerateHandler.SavingDialog(currentShell, "Generate Rules Doc", "Rules Doc Location:", "Choose generating location", "Generate", false, false);
                dialog.setLocation(htmlReportLocation);
                if (dialog.open() == 1) {
                    return;
                }
                Job job = new Job("Generating Rules Doc"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            String location;
                            block9: {
                                location = dialog.getLocation();
                                monitor.beginTask("Generating Rules Doc", 100);
                                if (DVTSplashMLT.INSTANCE.cc(false, new String[]{"F73765F6C696E74"})) break block9;
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                LinterDocGenerator.dumpRuleset(ChecksTreeBrowser.this.getCurrentOVMProject(), String.valueOf(location) + "/", null);
                                AbstractGenerateRulePoolDocHandler.openDoc(String.valueOf(location) + "/" + "Verissimo_Linter_Ruleset_Doc.html");
                            }
                            catch (TemplateException | IOException e) {
                                DVTLogger.INSTANCE.logError(e);
                            }
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                        finally {
                            monitor.done();
                            DVTSplashMLT.INSTANCE.i(false, "F73765F6C696E74");
                        }
                    }
                };
                job.setUser(true);
                job.setPriority(30);
                job.schedule();
            }
        });
    }

    private void createFilterBar(final Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        this.fLabelFiltersList = new Combo(parent, 12);
        this.fLabelFiltersList.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fLabelFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Label_Show_All);
        this.fLabelFiltersListSelectionListener = new LabelFiltersListSelectionListener();
        this.fLabelFiltersList.addSelectionListener(this.fLabelFiltersListSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLabelFiltersList, this.fBackgroundColor, true);
        this.fLabelFiltersList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ChecksTreeBrowser.this.loadLabelsFilters();
                ChecksTreeBrowser.this.updateTree(true);
                if (ChecksTreeBrowser.this.fLabelFiltersList.getSelectionIndex() == 0) {
                    ChecksTreeBrowser.this.fLabelFiltersList.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
                    DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fLabelFiltersList, DVTColorUtil.INSTANCE.getColor(130, 130, 130));
                } else {
                    ChecksTreeBrowser.this.fLabelFiltersList.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
                    DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fLabelFiltersList, DVTColorUtil.INSTANCE.getForeground((Control)parent));
                }
            }
        });
        this.updateLabelFiltersList(this.fComplianceReport.getOVMInfoProvider().getCategories());
        this.fFiltersList = new Combo(parent, 12);
        this.fFiltersList.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Label);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All_And_Disabled);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Disabled);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Automatic);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Manual);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_NonAutofixable);
        this.fFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Passed);
        this.fFiltersListSelectionListener = new FiltersListSelectionListener();
        this.fFiltersList.addSelectionListener((SelectionListener)this.fFiltersListSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fFiltersList, this.fBackgroundColor, true);
        this.fFiltersList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ChecksTreeBrowser.this.fFiltersList.getSelectionIndex() == 0) {
                    ChecksTreeBrowser.this.fFiltersList.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
                    DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fFiltersList, DVTColorUtil.INSTANCE.getColor(130, 130, 130));
                } else {
                    ChecksTreeBrowser.this.fFiltersList.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
                    DVTColorUtil.INSTANCE.setForeground((Control)ChecksTreeBrowser.this.fFiltersList, DVTColorUtil.INSTANCE.getForeground((Control)parent));
                }
            }
        });
        this.resetFiltersList();
        Label buttonsText = new Label(parent, 0x1000040);
        buttonsText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        buttonsText.setText(Messages.ChecksTreeBrowser_Filter_Hide_Label);
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsText, this.fBackgroundColor, true);
        RowLayout rl = new RowLayout();
        rl.fill = true;
        rl.type = 256;
        rl.marginBottom = 0;
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        Composite buttonsComposite = new Composite(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        buttonsComposite.setLayout((Layout)rl);
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsComposite, this.fBackgroundColor, true);
        this.fFilterButtonSelectionListener = new FilterButtonSelectionListener();
        this.fHidePassedButton = new Button(buttonsComposite, 2);
        this.fHidePassedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_PASSED));
        this.fHidePassedButton.setData((Object)"Passed");
        this.fHidePassedButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHidePassedButton, this.fButtonBackgroundColor, true);
        this.fHidePassedButton.setSelection(true);
        this.fHideErrorButton = new Button(buttonsComposite, 2);
        this.fHideErrorButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_ERROR));
        this.fHideErrorButton.setData((Object)"Errors");
        this.fHideErrorButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideErrorButton, this.fBackgroundColor, true);
        this.fHideWarningButton = new Button(buttonsComposite, 2);
        this.fHideWarningButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_WARNING));
        this.fHideWarningButton.setData((Object)"Warnings");
        this.fHideWarningButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideWarningButton, this.fBackgroundColor, true);
        this.fHideInfoButton = new Button(buttonsComposite, 2);
        this.fHideInfoButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_INFO));
        this.fHideInfoButton.setData((Object)"Info");
        this.fHideInfoButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideInfoButton, this.fBackgroundColor, true);
        this.fHideDisabledButton = new Button(buttonsComposite, 2);
        this.fHideDisabledButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_DISABLED));
        this.fHideDisabledButton.setData((Object)"Disabled");
        this.fHideDisabledButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideDisabledButton, this.fButtonBackgroundColor, true);
        this.fHideDisabledButton.setSelection(true);
        this.fHideAutomaticButton = new Button(buttonsComposite, 2);
        this.fHideAutomaticButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_AUTOMATIC));
        this.fHideAutomaticButton.setData((Object)"Automatic");
        this.fHideAutomaticButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideAutomaticButton, this.fBackgroundColor, true);
        this.fHideManualButton = new Button(buttonsComposite, 2);
        this.fHideManualButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MANUAL));
        this.fHideManualButton.setData((Object)"Manual");
        this.fHideManualButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideManualButton, this.fBackgroundColor, true);
        this.fHideNonAutofixableButton = new Button(buttonsComposite, 2);
        this.fHideNonAutofixableButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_AUTOFIX));
        this.fHideNonAutofixableButton.setData((Object)"Non-Autofixable");
        this.fHideNonAutofixableButton.addSelectionListener((SelectionListener)this.fFilterButtonSelectionListener);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fHideNonAutofixableButton, this.fBackgroundColor, true);
        this.updateAllFilterButtonsTooltTips();
        this.loadFilterPreferences();
    }

    private void updateLabelFiltersList(ArrayList<OVMComplianceCategory> input) {
        Set<RuleLabel> labels = RuleLabel.getLabelsFromCategories(input);
        List<String> values = RuleLabel.getValues(labels);
        this.labelFilter = null;
        this.fLabelFiltersList.removeAll();
        this.fLabelFiltersList.add(Messages.ChecksTreeBrowser_Predefined_Filter_Label_Show_All);
        for (String value : values) {
            this.fLabelFiltersList.add(value);
        }
        this.resetLabelFiltersList();
    }

    private void resetLabelFiltersList() {
        this.fLabelFiltersList.removeSelectionListener(this.fLabelFiltersListSelectionListener);
        this.fLabelFiltersList.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fLabelFiltersList, DVTColorUtil.INSTANCE.getColor(130, 130, 130));
        this.fLabelFiltersList.select(0);
        this.fLabelFiltersList.addSelectionListener(this.fLabelFiltersListSelectionListener);
    }

    private void resetFiltersList() {
        this.fFiltersList.removeSelectionListener((SelectionListener)this.fFiltersListSelectionListener);
        this.fFiltersList.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFiltersList, DVTColorUtil.INSTANCE.getColor(130, 130, 130));
        this.fFiltersList.select(0);
        this.fFiltersList.addSelectionListener((SelectionListener)this.fFiltersListSelectionListener);
    }

    private void createRightPart(Composite parent) {
        this.fRightPartComposite = new Composite(parent, 0);
        this.fRightPartComposite.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fRightPartComposite, this.fBackgroundColor, true);
        Group detailsComposite = new Group(this.fRightPartComposite, 0);
        detailsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)detailsComposite, this.fBackgroundColor, true);
        this.createDetails(detailsComposite);
        Composite contentsComposite = new Composite(this.fRightPartComposite, 0);
        contentsComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)contentsComposite, this.fBackgroundColor, true);
        this.createContents(contentsComposite);
    }

    private void createDetails(Group parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.fTitleAndDescription = new Composite((Composite)parent, 0);
        GridData layoutData = new GridData(4, 4, true, false);
        this.fTitleAndDescription.setLayoutData((Object)layoutData);
        this.fTitleAndDescription.setLayout((Layout)new GridLayout(1, false));
        this.fDetailsTitle = new Text(this.fTitleAndDescription, 72);
        this.fDetailsTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fDetailsTitle.setFont(this.fFontFactory.createFont("title", 14, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsTitle, this.fBackgroundColor, true);
        parent.addListener(11, x -> {
            int n = ((GridData)this.fTitleAndDescription.getLayoutData()).minimumWidth = (this.fMaxTagCompositeWitdh + this.fMaxLabelCompositeWitdh) * 2;
        });
        this.fTagAndLabelComposite = new Composite((Composite)parent, 0);
        this.fTagAndLabelComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fTagAndLabelComposite.setLayout((Layout)new GridLayout(2, false));
        this.fTagComposite = new Composite(this.fTagAndLabelComposite, 0);
        this.fTagComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fTagComposite.setLayout((Layout)new GridLayout(1, false));
        this.fLabelComposite = new Composite(this.fTagAndLabelComposite, 0);
        this.fLabelComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.fLabelComposite.setLayout((Layout)new GridLayout(1, false));
        this.fCheckStatusDetailsContainer = new Composite(this.fTitleAndDescription, 0);
        GridData gd = new GridData(4, 1, true, false, 2, 1);
        gd.exclude = true;
        this.fCheckStatusDetailsContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.fCheckStatusDetailsContainer.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusDetailsContainer, this.fBackgroundColor, true);
        this.fCheckStatusIcon = new Label(this.fCheckStatusDetailsContainer, 0);
        this.fCheckStatusIcon.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusIcon, this.fBackgroundColor, true);
        this.fCheckStatusText = new Label(this.fCheckStatusDetailsContainer, 16448);
        this.fCheckStatusText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCheckStatusText, this.fBackgroundColor, true);
        this.fDetailsDescription = new Text(this.fTitleAndDescription, 72);
        this.fDetailsDescription.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fDetailsDescription.setFont(JFaceResources.getTextFont());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDetailsDescription, this.fBackgroundColor, true);
        this.fLinkDescription = new Link(this.fTitleAndDescription, 64);
        this.fLinkDescription.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fLinkDescription.setFont(JFaceResources.getTextFont());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fLinkDescription, this.fBackgroundColor, true);
        DVTUiUtils.setPlatformLinkColor((Link)this.fLinkDescription);
    }

    private void createTag(String tag) {
        TagWidget label = new TagWidget(this.fTagComposite, 4);
        label.setFont(this.fFontFactory.createFont("label", 10, 1));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setToolTipText(tag);
        label.setText(tag);
        this.truncateTagText(label, tag, false);
        ResizeListener resizeListener = new ResizeListener(label, tag, false);
        this.fTagAndLabelComposite.getParent().addListener(11, (Listener)resizeListener);
        this.fTagResizeListenerList.add(resizeListener);
    }

    private void createLabel(String labelText) {
        TagWidget label = new TagWidget(this.fLabelComposite, 4);
        label.setFont(this.fFontFactory.createFont("label", 10, 1));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        gridData.verticalAlignment = 1;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setToolTipText(labelText);
        label.setText(labelText);
        this.truncateTagText(label, labelText, true);
        ResizeListener resizeListener = new ResizeListener(label, labelText, true);
        this.fTagAndLabelComposite.getParent().addListener(11, (Listener)resizeListener);
        this.fLabelResizeListenerList.add(resizeListener);
    }

    private void truncateTagText(TagWidget label, String tagText, boolean isLabel) {
        if (label.isDisposed()) {
            return;
        }
        GC gc = new GC((Drawable)label);
        try {
            gc.setFont(label.getFont());
            int paddingOffset = 45;
            if (this.fMaxLabelCompositeWitdh != 0 && this.fMaxTagCompositeWitdh != 0) {
                paddingOffset = 85;
            }
            int parentWidth = this.fTagAndLabelComposite.getParent().getSize().x - ((GridData)this.fTitleAndDescription.getLayoutData()).minimumWidth - paddingOffset;
            parentWidth = isLabel ? (int)((float)parentWidth * ((float)this.fMaxLabelCompositeWitdh / (float)(this.fMaxLabelCompositeWitdh + this.fMaxTagCompositeWitdh))) : (int)((float)parentWidth * ((float)this.fMaxTagCompositeWitdh / (float)(this.fMaxLabelCompositeWitdh + this.fMaxTagCompositeWitdh)));
            int labelTextWidth = gc.stringExtent((String)tagText).x;
            String finalString = tagText;
            if (labelTextWidth > parentWidth) {
                String tempText = tagText.substring(0, tagText.length() - 1);
                while (gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)tempText)).append((String)"...").toString()).x > parentWidth && tempText.length() > 0) {
                    tempText = tempText.substring(0, tempText.length() - 1);
                }
                finalString = String.valueOf(tempText) + "...";
            }
            label.setText(finalString);
            this.fTitleAndDescription.getParent().layout();
        }
        finally {
            gc.dispose();
        }
    }

    private void createContents(Composite parent) {
        this.fContentsStack = new StackLayout();
        parent.setLayout((Layout)this.fContentsStack);
        this.fSummaryComposite = new Composite(parent, 0);
        this.createSummaryTable(this.fSummaryComposite);
        this.fCategoriesComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesComposite, this.fBackgroundColor, true);
        this.createCategoriesTable(this.fCategoriesComposite);
        this.fChecksComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fChecksComposite, this.fBackgroundColor, true);
        this.createChecksTable(this.fChecksComposite);
        this.fManualChecksComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fManualChecksComposite, this.fBackgroundColor, true);
        this.createManualChecksPage(this.fManualChecksComposite);
        this.fNonExistentRuleComposite = new Composite(parent, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fNonExistentRuleComposite, this.fBackgroundColor, true);
    }

    private void createSummaryTable(Composite parent) {
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)parent, this.fBackgroundColor, true);
        Group scoreGroup = new Group(parent, 0);
        scoreGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)scoreGroup, this.fBackgroundColor, true);
        scoreGroup.setLayout((Layout)new GridLayout(2, false));
        Label scoreLabel = new Label((Composite)scoreGroup, 0);
        scoreLabel.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        scoreLabel.setFont(this.fFontFactory.createFont("score", 12, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)scoreLabel, this.fBackgroundColor, true);
        scoreLabel.setText(Messages.ChecksTreeBrowser_Summary_Score);
        this.fStatusComposite = new Composite((Composite)scoreGroup, 0);
        this.fStatusComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusComposite, this.fBackgroundColor, true);
        GridLayout layout = new GridLayout(12, false);
        layout.marginWidth = 0;
        this.fStatusComposite.setLayout((Layout)layout);
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Checks_Score_Label, "checks");
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Passed_Score_Label, "passed");
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Failures_Score_Label, "failures");
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Warnings_Score_Label, "warnings");
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Infos_Score_Label, "infos");
        this.createScoreValuePair(Messages.ChecksTreeBrowser_Summary_Disabled_Score_Label, "disabled");
        Label checksHitsLabel = new Label((Composite)scoreGroup, 0);
        checksHitsLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)checksHitsLabel, this.fBackgroundColor, true);
        checksHitsLabel.setText(Messages.ChecksTreeBrowser_Summary_Hits);
        this.fChecksHitsValueLabel = new Label((Composite)scoreGroup, 0);
        this.fChecksHitsValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fChecksHitsValueLabel, this.fBackgroundColor, true);
        this.fChecksHitsValueLabel.setText("2");
        SashForm sashForm = new SashForm(parent, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fSummaryTable = new TableViewer((Composite)sashForm, 68356);
        this.fSummaryTable.setContentProvider((IContentProvider)new SummaryTableContentProvider());
        this.fSummaryTable.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        this.fSummaryTable.addSelectionChangedListener((ISelectionChangedListener)new SummaryTableSelectionChangedListener());
        this.fSummaryTable.addDoubleClickListener((IDoubleClickListener)new SummaryTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fSummaryTable.getControl(), this.fBackgroundColor, true);
        Table table = this.fSummaryTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        DVTColorUtil.INSTANCE.setBackground((Control)table, this.fBackgroundColor, true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_2);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_3);
        column.setAlignment(0x1000000);
        column.setWidth(90);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Summary_Table_Column_4);
        column.setWidth(85);
        this.fSummaryTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fSummaryTableDetails, this.fBackgroundColor, true);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createScoreValuePair(String message, String value) {
        Label label = new Label(this.fStatusComposite, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)label, this.fBackgroundColor, true);
        label.setText(message);
        switch (value) {
            case "checks": {
                this.fChecksScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fChecksScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fChecksScoreValueLabel, this.fBackgroundColor, true);
                this.fChecksScoreValueLabel.setText("2");
                break;
            }
            case "passed": {
                this.fPassedScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fPassedScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fPassedScoreValueLabel, this.fBackgroundColor, true);
                this.fPassedScoreValueLabel.setText("2");
                break;
            }
            case "failures": {
                this.fFailuresScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fFailuresScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fFailuresScoreValueLabel, this.fBackgroundColor, true);
                this.fFailuresScoreValueLabel.setText("2");
                break;
            }
            case "warnings": {
                this.fWarningsScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fWarningsScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fWarningsScoreValueLabel, this.fBackgroundColor, true);
                this.fWarningsScoreValueLabel.setText("2");
                break;
            }
            case "infos": {
                this.fInfosScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fInfosScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fInfosScoreValueLabel, this.fBackgroundColor, true);
                this.fInfosScoreValueLabel.setText("2");
                break;
            }
            case "disabled": {
                this.fDisabledScoreValueLabel = new Label(this.fStatusComposite, 0);
                this.fDisabledScoreValueLabel.setLayoutData((Object)new GridData(4, 4, false, false));
                DVTColorUtil.INSTANCE.setBackground((Control)this.fDisabledScoreValueLabel, this.fBackgroundColor, true);
                this.fDisabledScoreValueLabel.setText("2");
                break;
            }
        }
    }

    private void createCategoriesTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        SashForm sashForm = new SashForm(parent, 512);
        DVTColorUtil.INSTANCE.setBackground((Control)sashForm, this.fBackgroundColor, true);
        this.fCategoriesTable = new TableViewer((Composite)sashForm, 68356);
        this.fCategoriesTable.setContentProvider((IContentProvider)new CategoriesTableContentProvider());
        this.fCategoriesTable.setLabelProvider((IBaseLabelProvider)new CategoriesTableLabelProvider());
        this.fCategoriesTable.addSelectionChangedListener((ISelectionChangedListener)new CategoriesTableSelectionChangedListener());
        this.fCategoriesTable.addDoubleClickListener((IDoubleClickListener)new CategoriesTableDubleClickListener());
        this.fCategoriesTable.addFilter((ViewerFilter)new ComplianceCheckFilter());
        DVTColorUtil.INSTANCE.setBackground(this.fCategoriesTable.getControl(), this.fBackgroundColor, true);
        Menu tableMenu = new Menu((Control)this.fCategoriesTable.getTable());
        MenuItem fTreeAutofixHitsCheckMenuItem = new MenuItem(tableMenu, 0);
        fTreeAutofixHitsCheckMenuItem.setText("Fix Failures for Check");
        fTreeAutofixHitsCheckMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fCategoriesTable.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof OVMComplianceCheck) {
                    VerissimoAutofixManager.getInstance().fixCheckFailures((OVMComplianceCheck)element, false, ChecksTreeBrowser.this.getCurrentOVMProject());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fCategoriesTable.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.getFirstElement() instanceof OVMComplianceCheck) {
                OVMComplianceCheck check = (OVMComplianceCheck)selection.getFirstElement();
                fTreeAutofixHitsCheckMenuItem.setEnabled(!check.hasConfigurationErrors() && VerissimoAutofixUtils.getInstance().hasAutofixImplemented(check) && check.getNofVisibleHits() != 0);
            } else {
                fTreeAutofixHitsCheckMenuItem.setEnabled(false);
            }
        });
        this.fCategoriesTable.getTable().setMenu(tableMenu);
        Table table = this.fCategoriesTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_1);
        column.setWidth(200);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_2);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_3);
        column.setAlignment(0x1000000);
        column.setWidth(75);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Categories_Table_Column_4);
        column.setWidth(100);
        this.fCategoriesTableDetails = new Text((Composite)sashForm, 2634);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fCategoriesTableDetails, this.fInfoBackgroundColor, true);
        int[] componentWeight = new int[]{4, 1};
        sashForm.setWeights(componentWeight);
    }

    private void createChecksTable(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fChecksTable = new TableViewer(parent, 68354);
        this.fChecksTable.setContentProvider((IContentProvider)new ChecksTableContentProvider());
        this.fChecksTable.setLabelProvider((IBaseLabelProvider)new ChecksTableLabelProvider());
        this.fChecksTable.addDoubleClickListener((IDoubleClickListener)new ChecksTableDubleClickListener());
        DVTColorUtil.INSTANCE.setBackground(this.fChecksTable.getControl(), this.fBackgroundColor, true);
        Menu tableMenu = new Menu((Control)this.fChecksTable.getTable());
        MenuItem tableExplainSelectedHitsMenuItem = new MenuItem(tableMenu, 0);
        tableExplainSelectedHitsMenuItem.setText("Explain Failure using AI Assistant");
        tableExplainSelectedHitsMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCheckHit) {
                    VerissimoAIAutofixManager.getInstance().explainHitsUsingAIAssistant(element, ((OVMComplianceCheckHit)element).getParserPath().getCanonicalPath());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem tableAutoFixSelectedHitsMenuItem = new MenuItem(tableMenu, 0);
        tableAutoFixSelectedHitsMenuItem.setText("Fix Failures");
        tableAutoFixSelectedHitsMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null) {
                    List hits = selection.toList();
                    VerissimoAutofixManager.getInstance().fixFailures(((OVMComplianceCheckHit)hits.get(0)).getCheck(), hits, false, ChecksTreeBrowser.this.getCurrentOVMProject(), false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        List<MenuItem> autocorrectHitMenuItems = this.getAndAddAIAutofixForHitMenuItems(tableMenu);
        MenuItem tableWaiveHitMenuItem = new MenuItem(tableMenu, 0);
        tableWaiveHitMenuItem.setText("Add Waiver for Failure");
        tableWaiveHitMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCheckHit) {
                    IWaiver waiverResult;
                    OVMProject ovmProject = ChecksTreeBrowser.this.fComplianceReport.getOVMInfoProvider().getOVMProject();
                    if (!WaiversManager.getInstance().checkReadOnlyWaiverFiles(ovmProject)) {
                        return;
                    }
                    OVMComplianceCheckHit hit = (OVMComplianceCheckHit)element;
                    WaiverDialog dialog = WaiversManager.getInstance().createWaiverDialog(hit, ovmProject);
                    if (dialog.open() == 0 && WaiverFileValidator.INSTANCE.validate(ChecksTreeBrowser.this.fProject, (waiverResult = dialog.getWaiver()).getFilePath())) {
                        ovmProject.getProjectWaivers().addWaiver(waiverResult);
                        ovmProject.getProjectWaivers().save();
                        ovmProject.getProjectWaivers().load();
                        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                            return;
                        }
                        try {
                            if (waiverResult instanceof PostWaiver) {
                                WaiversManager.getInstance().reapplyWaivers((PostWaiver)waiverResult, ovmProject);
                                ChecksTreeBrowser.this.notifyChangeListeners(true);
                            } else if (waiverResult instanceof PreWaiver) {
                                ((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).reapplyWaivers();
                                ChecksTreeBrowser.this.notifyChangeListeners(false);
                            }
                            ChecksTreeBrowser.this.updateLeftPart();
                            ChecksTreeBrowser.this.fComplianceReport.updateListeners();
                            LintingProblemsManager.getInstance().updateMarkersAfterWaivers(ChecksTreeBrowser.this.fProject);
                        }
                        finally {
                            DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                        }
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem tableAddInlineWaiverMenuItem = new MenuItem(tableMenu, 0);
        tableAddInlineWaiverMenuItem.setText("Add Code Waiver for Failure");
        tableAddInlineWaiverMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object element;
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCheckHit) {
                    OVMComplianceCheckHit hit = (OVMComplianceCheckHit)element;
                    String path = DVTStringUtil.intern((String)hit.getParserPath().path);
                    PostWaiver waiver = WaiversUtils.INSTANCE.createPragmaPostWaiver(hit.getCheck().getName(), path, hit.getLine());
                    OVMProject ovmProject = ChecksTreeBrowser.this.fComplianceReport.getOVMInfoProvider().getOVMProject();
                    DocumentManager documentManager = ChecksTreeBrowser.this.fComplianceReport.getDocumentManager();
                    boolean uselessWaiverWarning = WaiversUtils.INSTANCE.isUselessInlineWaiver(hit, ovmProject);
                    WaiverDialog dialog = new WaiverDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ovmProject, true, uselessWaiverWarning, null, documentManager);
                    dialog.setInput(waiver);
                    if (dialog.open() == 0) {
                        String waiverComment = WaiversUtils.INSTANCE.computeWaiverComment(waiver);
                        boolean isMultiLineComment = waiver.getCommentType().equalsIgnoreCase("MULTI LINE");
                        boolean isEndOfLine = !dialog.isDefineOnLine();
                        DVTFileUtils.getInstance().addComment(ChecksTreeBrowser.this.fProject, hit.getParserPath().path, hit.getLine(), waiverComment, isMultiLineComment, isEndOfLine, true, "Add Code Waiver");
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem tableCopy = new MenuItem(tableMenu, 0);
        tableCopy.setText("Copy Failure");
        tableCopy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null) {
                    Object[] elements = selection.toArray();
                    StringBuilder sb = new StringBuilder();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof OVMComplianceCheckHit) {
                            OVMComplianceCheckHit hit = (OVMComplianceCheckHit)element;
                            if (!element.equals(selection.getFirstElement())) {
                                sb.append("\n");
                            }
                            sb.append(MessageFormat.format(ChecksTreeBrowser.FAILURE_FORMAT, new Object[]{hit.getSeverity(), hit.getCheck().getName(), hit.getLine(), hit.getParserPath(), hit.getDetails()}));
                        }
                        ++n2;
                    }
                    ro.amiq.dvt.utils.Utils.copyToClipboard((String)sb.toString(), (int)3);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        MenuItem tableCopyDetails = new MenuItem(tableMenu, 0);
        tableCopyDetails.setText("Copy Details");
        tableCopyDetails.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                if (selection != null) {
                    Object[] elements = selection.toArray();
                    StringBuilder sb = new StringBuilder();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof OVMComplianceCheckHit) {
                            OVMComplianceCheckHit hit = (OVMComplianceCheckHit)element;
                            if (!element.equals(selection.getFirstElement())) {
                                sb.append("\n");
                            }
                            sb.append(hit.getDetails());
                        }
                        ++n2;
                    }
                    ro.amiq.dvt.utils.Utils.copyToClipboard((String)sb.toString(), (int)3);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fChecksTable.getTable().setMenu(tableMenu);
        this.fChecksTable.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            Object element = selection.getFirstElement();
            if (selection.size() == 1 && element instanceof OVMComplianceCheckHit && ((OVMComplianceCheckHit)element).getSeverity() != CheckStatus.DISABLED) {
                tableWaiveHitMenuItem.setEnabled(!((OVMComplianceCheckHit)element).getParserPath().path.equals("none"));
                tableAddInlineWaiverMenuItem.setEnabled(!((OVMComplianceCheckHit)element).getParserPath().path.equals("none") && ((OVMComplianceCheckHit)element).getLine() != 0);
            } else {
                tableWaiveHitMenuItem.setEnabled(false);
                tableAddInlineWaiverMenuItem.setEnabled(false);
            }
            if (selection.getFirstElement() instanceof OVMComplianceCheckHit) {
                OVMComplianceCheckHit selectedHit = (OVMComplianceCheckHit)selection.getFirstElement();
                OVMComplianceCheck check = selectedHit.getCheck();
                tableAutoFixSelectedHitsMenuItem.setEnabled(!check.hasConfigurationErrors() && VerissimoAutofixUtils.getInstance().hasAutofixImplemented(check));
                autocorrectHitMenuItems.forEach(menuItem -> menuItem.setEnabled(true));
                HashSet<String> blueprintNamesForCheck = new HashSet<String>(VerissimoAIAutofixManager.getInstance().getAIAutofixBlueprintNames(check.getName()));
                autocorrectHitMenuItems.forEach(menuItem -> {
                    String associatedBlueprint;
                    if (!VerissimoAIAutofixManager.getInstance().isFileAIAvailable(selectedHit.getParserPath().getCanonicalPath())) {
                        menuItem.setEnabled(false);
                    }
                    if (!blueprintNamesForCheck.contains(associatedBlueprint = (String)menuItem.getData())) {
                        menuItem.setEnabled(false);
                    }
                });
            } else {
                tableAutoFixSelectedHitsMenuItem.setEnabled(false);
                autocorrectHitMenuItems.forEach(menuItem -> menuItem.setEnabled(false));
            }
            if (selection.size() == 1 && element instanceof OVMComplianceCheckHit) {
                if (VerissimoAIAutofixManager.getInstance().isFileAIAvailable(((OVMComplianceCheckHit)element).getParserPath().getCanonicalPath())) {
                    tableExplainSelectedHitsMenuItem.setEnabled(true);
                } else {
                    tableExplainSelectedHitsMenuItem.setEnabled(false);
                }
            } else {
                tableExplainSelectedHitsMenuItem.setEnabled(false);
            }
        });
        Table table = this.fChecksTable.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(JFaceResources.getTextFont());
        TableColumn column = new TableColumn(table, 0);
        column.setResizable(false);
        column.setWidth(25);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_2);
        column.setWidth(50);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_3);
        column.setWidth(280);
        column = new TableColumn(table, 0);
        column.setText(Messages.ChecksTreeBrowser_Checks_Table_Column_4);
        column.setWidth(2000);
    }

    private List<MenuItem> getAndAddAIAutofixForCheckMenuItems(Menu treeMenu) {
        ArrayList<MenuItem> treeItems = new ArrayList<MenuItem>();
        List<String> blueprintNames = VerissimoAIAutofixManager.getInstance().getAIAutofixBlueprintNames("ALL");
        if (blueprintNames == null || blueprintNames.isEmpty()) {
            return treeItems;
        }
        for (final String blueprintName : blueprintNames) {
            MenuItem fTreeAIAutofixHitsCheckMenuItem = new MenuItem(treeMenu, 0);
            fTreeAIAutofixHitsCheckMenuItem.setText("Fix Failures for Check using AI Assistant" + VerissimoAutofixUtils.getInstance().getAIAutofixButtonSuffixIfNecessary(blueprintName, blueprintNames.size() == 1));
            fTreeAIAutofixHitsCheckMenuItem.setData((Object)blueprintName);
            fTreeAIAutofixHitsCheckMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck) {
                        OVMComplianceCheck check = (OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem;
                        if (check == null || check.hasConfigurationErrors()) {
                            return;
                        }
                        ArrayList<OVMComplianceCheckHit> hits = check.getAllAutoCorrectabledHits();
                        VerissimoAIAutofixManager.getInstance().fixFailuresUsingAI(hits, blueprintName, true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            treeItems.add(fTreeAIAutofixHitsCheckMenuItem);
        }
        return treeItems;
    }

    private List<MenuItem> getAndAddAIAutofixForHitMenuItems(Menu tableMenu) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        List<String> allBlueprintNames = VerissimoAIAutofixManager.getInstance().getAIAutofixBlueprintNames("ALL");
        if (allBlueprintNames == null || allBlueprintNames.isEmpty()) {
            return menuItems;
        }
        for (final String blueprintName : allBlueprintNames) {
            MenuItem tableAutoFixSelectedHitsMenuItem = new MenuItem(tableMenu, 0);
            tableAutoFixSelectedHitsMenuItem.setText("Fix Failures using AI Assistant" + VerissimoAutofixUtils.getInstance().getAIAutofixButtonSuffixIfNecessary(blueprintName, allBlueprintNames.size() == 1));
            tableAutoFixSelectedHitsMenuItem.setData((Object)blueprintName);
            tableAutoFixSelectedHitsMenuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)ChecksTreeBrowser.this.fChecksTable.getSelection();
                    if (selection != null) {
                        List hits = selection.toList();
                        VerissimoAIAutofixManager.getInstance().fixFailuresUsingAI(hits, blueprintName, true);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            menuItems.add(tableAutoFixSelectedHitsMenuItem);
        }
        return menuItems;
    }

    private void createManualChecksPage(Composite parent) {
        GridLayout gl = new GridLayout(1, true);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        parent.setLayout((Layout)gl);
        Group buttonsComposite = new Group(parent, 0);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        buttonsComposite.setLayout((Layout)new GridLayout(2, false));
        DVTColorUtil.INSTANCE.setBackground((Control)buttonsComposite, this.fBackgroundColor, true);
        Label description = new Label((Composite)buttonsComposite, 16448);
        description.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
        description.setText(Messages.ChecksTreeBrowser_Manual_Checks_Description_Label);
        DVTColorUtil.INSTANCE.setBackground((Control)description, this.fBackgroundColor, true);
        this.fMarkAsPassedButton = new Button((Composite)buttonsComposite, 16);
        this.fMarkAsPassedButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fMarkAsPassedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MARK_AS_PASSED));
        this.fMarkAsPassedButton.setData((Object)CheckStatus.PASSED);
        this.fMarkAsPassedButton.addSelectionListener((SelectionListener)new MarkAsButtonSelectionListener());
        Label markAsPassedDescription = new Label((Composite)buttonsComposite, 16448);
        markAsPassedDescription.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        markAsPassedDescription.setText(Messages.ChecksTreeBrowser_Manual_Checks_Radio_Passed);
        DVTColorUtil.INSTANCE.setBackground((Control)markAsPassedDescription, this.fBackgroundColor, true);
        this.fMarkAsFailedButton = new Button((Composite)buttonsComposite, 16);
        this.fMarkAsFailedButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.fMarkAsFailedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_MARK_AS_FAILED));
        this.fMarkAsFailedButton.setData((Object)CheckStatus.ERROR);
        this.fMarkAsFailedButton.addSelectionListener((SelectionListener)new MarkAsButtonSelectionListener());
        Label markAsFailedDescription = new Label((Composite)buttonsComposite, 16448);
        markAsFailedDescription.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        markAsFailedDescription.setText(Messages.ChecksTreeBrowser_Manual_Checks_Radio_Failed);
        DVTColorUtil.INSTANCE.setBackground((Control)markAsFailedDescription, this.fBackgroundColor, true);
    }

    private void updateTree(boolean clearHits) {
        if (this.fSelectedItem == null || ((IStructuredSelection)this.fTree.getSelection()).getFirstElement() == null) {
            StructuredSelection selection = new StructuredSelection((Object)Messages.ChecksTreeBrowser_Summary_Item);
            this.fTree.setSelection((ISelection)selection, true);
        }
        if (clearHits) {
            this.updateVisibleHits();
        }
        this.fTree.expandAll();
        this.fTree.refresh();
        this.fCategoriesTable.refresh();
        this.fChecksTable.refresh();
        this.fSummaryTable.refresh();
        this.updateLeftPart();
        this.updateScore();
        this.fStatusComposite.layout();
    }

    private void updateLeftPart() {
        if (this.fSelectedItem != null) {
            if (this.fSelectedItem instanceof String && ((String)this.fSelectedItem).equals(Messages.ChecksTreeBrowser_Summary_Item)) {
                this.updateSummaryComposite();
            } else if (this.fSelectedItem instanceof OVMComplianceCategory) {
                this.updateCategoriesComposite((OVMComplianceCategory)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof OVMComplianceManualCheck) {
                this.updateManualChecksComposite((OVMComplianceManualCheck)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof ErrorCheck) {
                this.updateErrorCheckComposite((ErrorCheck)this.fSelectedItem);
            } else if (this.fSelectedItem instanceof OVMComplianceCheck) {
                this.updateChecksComposite((OVMComplianceCheck)this.fSelectedItem);
            }
            Object element = ((IStructuredSelection)this.fCategoriesTable.getSelection()).getFirstElement();
            if (element == null) {
                this.fCategoriesTableDetails.setText("");
            } else if (element instanceof OVMComplianceCheck) {
                this.fCategoriesTableDetails.setText(HTMLUtils.stripTags(((OVMComplianceCheck)element).getFullDescription()));
            }
            this.fRightPartComposite.layout(true, true);
        }
    }

    private void updateSummaryComposite() {
        this.fSummaryTable.setInput(this.fTree.getInput());
        this.updateCheckStatusAndPropertiesControls(null);
        this.updateTitleAndDescriptionAndTagsAndLabels(Messages.ChecksTreeBrowser_Summary_Table_Title, Messages.ChecksTreeBrowser_Summary_Table_Description, null, null);
        this.updateScore();
        this.fContentsStack.topControl = this.fSummaryComposite;
    }

    private void updateCategoriesComposite(OVMComplianceCategory category) {
        ArrayList<OVMComplianceCheck> checks = new ArrayList<OVMComplianceCheck>();
        checks.addAll(category.getChecks());
        this.fCategoriesTable.setInput(checks);
        this.updateCheckStatusAndPropertiesControls(null);
        this.updateTitleAndDescriptionAndTagsAndLabels(category.getName(), HTMLUtils.stripTags(category.getDescription()), null, null);
        this.fContentsStack.topControl = this.fCategoriesComposite;
    }

    private void updateChecksComposite(OVMComplianceCheck check) {
        ArrayList<OVMComplianceCheckHit> visibleHits = check.getVisibleHits();
        this.fChecksTable.setInput(visibleHits);
        this.updateCheckStatusAndPropertiesControls(check);
        String fix = VerissimoAutofixUtils.getInstance().hasAutofixImplemented(check) ? " [Fix]" : "";
        Set<RuleLabel> labels = null;
        LinkedHashMap<String, List<String>> annotationTagsMap = new LinkedHashMap<String, List<String>>();
        RulesetConfiguration rulesetConfiguration = check.getOVMProject().getRulesetConfiguration();
        if (rulesetConfiguration != null && rulesetConfiguration.getAnnotationManager() != null) {
            Set<Annotation> annotationTags;
            Set<Annotation> annotationLabels = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.LABEL);
            if (annotationLabels != null && !annotationLabels.isEmpty() && annotationLabels.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT))) {
                labels = check.getLabels();
            }
            if ((annotationTags = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.TAG)) != null && !annotationTags.isEmpty() && annotationTags.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT)) && check.getAnnotationsByTagIdMap() != null) {
                for (Map.Entry<String, List<String>> annotation : check.getAnnotationsByTagIdMap().entrySet()) {
                    if (!annotationTags.stream().anyMatch(x -> x.getName().equals(annotation.getKey()) || x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey()))) continue;
                    Optional<Annotation> key = annotationTags.stream().filter(x -> x.getLocations().contains((Object)AnnotationLocation.DVT) && x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey())).findFirst();
                    if (key.isPresent()) {
                        annotationTagsMap.put(key.get().getName(), annotation.getValue());
                        continue;
                    }
                    annotationTagsMap.put(annotation.getKey(), annotation.getValue());
                }
            }
        }
        this.updateTitleAndDescriptionAndTagsAndLabels(String.valueOf(check.getName()) + ": " + check.getTitle() + fix, check.getCheckDescriptionToPrint(), annotationTagsMap, labels);
        this.fContentsStack.topControl = this.fChecksComposite;
    }

    private void updateErrorCheckComposite(OVMComplianceCheck check) {
        this.updateCheckStatusAndPropertiesControls(check);
        Set<RuleLabel> labels = null;
        LinkedHashMap<String, List<String>> annotationTagsMap = new LinkedHashMap<String, List<String>>();
        RulesetConfiguration rulesetConfiguration = check.getOVMProject().getRulesetConfiguration();
        if (rulesetConfiguration != null && rulesetConfiguration.getAnnotationManager() != null) {
            Set<Annotation> annotationTags;
            Set<Annotation> annotationLabels = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.LABEL);
            if (annotationLabels != null && !annotationLabels.isEmpty() && annotationLabels.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT))) {
                labels = check.getLabels();
            }
            if ((annotationTags = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.TAG)) != null && !annotationTags.isEmpty() && annotationTags.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT)) && check.getAnnotationsByTagIdMap() != null) {
                for (Map.Entry<String, List<String>> annotation : check.getAnnotationsByTagIdMap().entrySet()) {
                    if (!annotationTags.stream().anyMatch(x -> x.getName().equals(annotation.getKey()) || x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey()))) continue;
                    Optional<Annotation> key = annotationTags.stream().filter(x -> x.getLocations().contains((Object)AnnotationLocation.DVT) && x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey())).findFirst();
                    if (key.isPresent()) {
                        annotationTagsMap.put(key.get().getName(), annotation.getValue());
                        continue;
                    }
                    annotationTagsMap.put(annotation.getKey(), annotation.getValue());
                }
            }
        }
        this.updateTitleAndDescriptionAndTagsAndLabels(String.valueOf(check.getName()) + ": " + check.getTitle(), HTMLUtils.stripTags(check.getFullDescription()), annotationTagsMap, labels);
        this.fContentsStack.topControl = this.fNonExistentRuleComposite;
    }

    private void updateManualChecksComposite(OVMComplianceManualCheck check) {
        if (check.isEnabled()) {
            this.updateManualChecksButtons(true);
            CheckStatus status = ((OVMComplianceManualCheck)this.fSelectedItem).getStatus();
            this.fMarkAsPassedButton.setSelection(status == CheckStatus.PASSED);
            this.fMarkAsFailedButton.setSelection(status == CheckStatus.ERROR);
        } else {
            this.updateManualChecksButtons(false);
        }
        this.updateCheckStatusAndPropertiesControls(check);
        Set<RuleLabel> labels = null;
        LinkedHashMap<String, List<String>> annotationTagsMap = new LinkedHashMap<String, List<String>>();
        RulesetConfiguration rulesetConfiguration = check.getOVMProject().getRulesetConfiguration();
        if (rulesetConfiguration != null && rulesetConfiguration.getAnnotationManager() != null) {
            Set<Annotation> annotationTags;
            Set<Annotation> annotationLabels = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.LABEL);
            if (annotationLabels != null && !annotationLabels.isEmpty() && annotationLabels.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT))) {
                labels = check.getLabels();
            }
            if ((annotationTags = rulesetConfiguration.getAnnotationManager().getAnnotationOfType(AnnotationType.TAG)) != null && !annotationTags.isEmpty() && annotationTags.stream().anyMatch(x -> x.getLocations().contains((Object)AnnotationLocation.DVT)) && check.getAnnotationsByTagIdMap() != null) {
                for (Map.Entry<String, List<String>> annotation : check.getAnnotationsByTagIdMap().entrySet()) {
                    if (!annotationTags.stream().anyMatch(x -> x.getName().equals(annotation.getKey()) || x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey()))) continue;
                    Optional<Annotation> key = annotationTags.stream().filter(x -> x.getLocations().contains((Object)AnnotationLocation.DVT) && x.getArgs().length != 0 && x.getArgs()[0].equals(annotation.getKey())).findFirst();
                    if (key.isPresent()) {
                        annotationTagsMap.put(key.get().getName(), annotation.getValue());
                        continue;
                    }
                    annotationTagsMap.put(annotation.getKey(), annotation.getValue());
                }
            }
        }
        this.updateTitleAndDescriptionAndTagsAndLabels(String.valueOf(check.getName()) + ": " + check.getTitle(), HTMLUtils.stripTags(check.getFullDescription()), annotationTagsMap, labels);
        this.fContentsStack.topControl = this.fManualChecksComposite;
    }

    private void updateManualChecksButtons(boolean enabled) {
        this.fMarkAsPassedButton.setEnabled(enabled);
        this.fMarkAsFailedButton.setEnabled(enabled);
    }

    private void updateTitleAndDescriptionAndTagsAndLabels(String title, String description, Map<String, List<String>> annotationsByTagIdMap, Set<RuleLabel> labels) {
        this.fDetailsTitle.setText(title == null ? "" : title);
        Utils.setTextWithMore((Text)this.fDetailsDescription, (Link)this.fLinkDescription, (String)title, (String)(description == null ? "" : description), (int)100, (int)800, (int)500);
        this.clearTagsAndLabels();
        List<String> processedLabels = null;
        List<String> processTags = null;
        if (annotationsByTagIdMap != null && !annotationsByTagIdMap.isEmpty()) {
            processTags = this.processTags(annotationsByTagIdMap);
            this.setCompositeVisibility(this.fTagComposite, true);
        } else {
            this.setCompositeVisibility(this.fTagComposite, false);
        }
        if (labels != null && !labels.isEmpty()) {
            processedLabels = this.processLabels(labels);
            this.setCompositeVisibility(this.fLabelComposite, true);
        } else {
            this.setCompositeVisibility(this.fLabelComposite, false);
        }
        this.updateTags(processTags);
        this.updateLabels(processedLabels);
    }

    private void setCompositeVisibility(Composite composite, boolean visibility) {
        GridData data = (GridData)composite.getLayoutData();
        data.exclude = !visibility;
        composite.setVisible(visibility);
        composite.getParent().layout(true, true);
    }

    private void clearTagsAndLabels() {
        Control control;
        Control[] controlArray = this.fTagComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        controlArray = this.fLabelComposite.getChildren();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        for (ResizeListener listener : this.fTagResizeListenerList) {
            this.fTagAndLabelComposite.getParent().removeListener(11, (Listener)listener);
        }
        this.fTagResizeListenerList.clear();
        for (ResizeListener listener : this.fLabelResizeListenerList) {
            this.fTagAndLabelComposite.getParent().removeListener(11, (Listener)listener);
        }
        this.fLabelResizeListenerList.clear();
    }

    private void updateLabels(List<String> processedLabels) {
        if (processedLabels == null || processedLabels.isEmpty()) {
            return;
        }
        for (String label : processedLabels) {
            this.createLabel(label);
        }
    }

    private List<String> processLabels(Set<RuleLabel> labels) {
        ArrayList<String> processedLabels = new ArrayList<String>();
        String maxLabelLengthString = "";
        for (RuleLabel label : labels) {
            processedLabels.add(label.getValue());
            if (label.getValue().length() <= maxLabelLengthString.length()) continue;
            maxLabelLengthString = label.getValue();
        }
        GC gc = new GC((Drawable)this.fCheckStatusText);
        try {
            gc.setFont(this.fFontFactory.createFont("label", 10, 1));
            this.fMaxLabelCompositeWitdh = gc.stringExtent((String)maxLabelLengthString).x;
        }
        finally {
            gc.dispose();
        }
        return processedLabels;
    }

    private void updateTags(List<String> processTags) {
        if (processTags == null || processTags.isEmpty()) {
            return;
        }
        for (String tag : processTags) {
            this.createTag(tag);
        }
    }

    private List<String> processTags(Map<String, List<String>> tags) {
        ArrayList<String> processedTags = new ArrayList<String>();
        String maxTagLengthString = "";
        for (Map.Entry<String, List<String>> tag : tags.entrySet()) {
            StringBuilder textValueSB = new StringBuilder();
            textValueSB.append(String.valueOf(tag.getKey()) + " : ");
            textValueSB.append(DVTStringUtil.join((Iterable)tag.getValue(), (String)", "));
            String tagString = textValueSB.toString();
            processedTags.add(tagString);
            if (tagString.length() <= maxTagLengthString.length()) continue;
            maxTagLengthString = tagString;
        }
        GC gc = new GC((Drawable)this.fCheckStatusText);
        try {
            gc.setFont(this.fFontFactory.createFont("label", 10, 1));
            this.fMaxTagCompositeWitdh = gc.stringExtent((String)maxTagLengthString).x;
        }
        finally {
            gc.dispose();
        }
        return processedTags;
    }

    private void updateCheckStatusAndPropertiesControls(OVMComplianceCheck check) {
        boolean visible = false;
        if (check != null) {
            this.fCheckStatusIcon.setImage(OVMComplianceChecksUtilUI.getImage(check, OVMComplianceChecksUtil.getStatus(check)));
            this.fCheckStatusText.setText(String.valueOf(Messages.ChecksTreeBrowser_Checks_Status) + " " + OVMComplianceChecksUtilUI.getDetailsText(check));
            visible = true;
        }
        this.fCheckStatusDetailsContainer.setVisible(visible);
        ((GridData)this.fCheckStatusDetailsContainer.getLayoutData()).exclude = !visible;
    }

    private void updateScore() {
        Object input = this.fTree.getInput();
        if (input instanceof List) {
            ComplianceCheckFilter filter = new ComplianceCheckFilter();
            Map<String, String> results = ChecksTreeBrowser.getScoreStats((List)input, filter);
            this.fChecksScoreValueLabel.setText(results.get("CHECKS"));
            this.fPassedScoreValueLabel.setText(results.get(CheckStatus.PASSED.toString()));
            this.fFailuresScoreValueLabel.setText(results.get(CheckStatus.ERROR.toString()));
            this.fWarningsScoreValueLabel.setText(results.get(CheckStatus.WARNING.toString()));
            this.fInfosScoreValueLabel.setText(results.get(CheckStatus.INFO.toString()));
            this.fDisabledScoreValueLabel.setText(results.get(CheckStatus.DISABLED.toString()));
            String result = ChecksTreeBrowser.getHits((List)input, filter);
            this.fChecksHitsValueLabel.setText(result);
        }
    }

    private void updateVisibleHits() {
        this.loadFilterPreferences();
        for (OVMComplianceCheck check : this.getCurrentOVMProject().getChecks()) {
            check.applyFilters(this.filters, this.labelFilter);
        }
    }

    public static Map<String, String> getScoreStats(List<OVMComplianceCategory> categories, ComplianceCheckFilter filter) {
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        for (OVMComplianceCategory category : categories) {
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            for (OVMComplianceCheck check : checks) {
                if (!filter.select(null, category, check)) continue;
                scores.put("CHECKS", scores.getOrDefault("CHECKS", 0) + 1);
                if (OVMComplianceChecksUtil.getStatus(check) == CheckStatus.PASSED) {
                    scores.put(CheckStatus.PASSED.toString(), scores.getOrDefault(CheckStatus.PASSED.toString(), 0) + 1);
                    continue;
                }
                if (OVMComplianceChecksUtil.getStatus(check) == CheckStatus.ERROR) {
                    scores.put(CheckStatus.ERROR.toString(), scores.getOrDefault(CheckStatus.ERROR.toString(), 0) + 1);
                    continue;
                }
                if (OVMComplianceChecksUtil.getStatus(check) == CheckStatus.WARNING) {
                    scores.put(CheckStatus.WARNING.toString(), scores.getOrDefault(CheckStatus.WARNING.toString(), 0) + 1);
                    continue;
                }
                if (OVMComplianceChecksUtil.getStatus(check) == CheckStatus.INFO) {
                    scores.put(CheckStatus.INFO.toString(), scores.getOrDefault(CheckStatus.INFO.toString(), 0) + 1);
                    continue;
                }
                if (OVMComplianceChecksUtil.getStatus(check) != CheckStatus.DISABLED) continue;
                scores.put(CheckStatus.DISABLED.toString(), scores.getOrDefault(CheckStatus.DISABLED.toString(), 0) + 1);
            }
        }
        int nofChecks = scores.getOrDefault("CHECKS", 0);
        int nofPassedChecks = scores.getOrDefault(CheckStatus.PASSED.toString(), 0);
        int nofFailures = scores.getOrDefault(CheckStatus.ERROR.toString(), 0);
        int nofWarnings = scores.getOrDefault(CheckStatus.WARNING.toString(), 0);
        int nofInfos = scores.getOrDefault(CheckStatus.INFO.toString(), 0);
        int nofDisabledChecks = scores.getOrDefault(CheckStatus.DISABLED.toString(), 0);
        HashMap<String, String> scoreStats = new HashMap<String, String>();
        scoreStats.put("CHECKS", "(" + nofChecks + "),");
        ChecksTreeBrowser.computeScore(nofChecks, CheckStatus.PASSED.toString(), nofPassedChecks, scoreStats);
        ChecksTreeBrowser.computeScore(nofChecks, CheckStatus.ERROR.toString(), nofFailures, scoreStats);
        ChecksTreeBrowser.computeScore(nofChecks, CheckStatus.WARNING.toString(), nofWarnings, scoreStats);
        ChecksTreeBrowser.computeScore(nofChecks, CheckStatus.INFO.toString(), nofInfos, scoreStats);
        ChecksTreeBrowser.computeScore(nofChecks, CheckStatus.DISABLED.toString(), nofDisabledChecks, scoreStats);
        return scoreStats;
    }

    private static void computeScore(int nofChecks, String status, int nofChecksForStatus, Map<String, String> scoreStats) {
        StringBuilder score = new StringBuilder();
        if (nofChecks != 0) {
            score.append(String.valueOf((int)((float)nofChecksForStatus * 100.0f / (float)nofChecks)) + "% (" + nofChecksForStatus + ")");
        } else {
            score.append("0% (0)");
        }
        if (!status.equals(CheckStatus.DISABLED.toString())) {
            score.append(",");
        }
        scoreStats.put(status, score.toString());
    }

    public static String getHits(List<OVMComplianceCategory> categories, ComplianceCheckFilter filter) {
        int nofErrors = 0;
        int nofWarnings = 0;
        int nofInfos = 0;
        int nofDisabled = 0;
        for (OVMComplianceCategory category : categories) {
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            for (OVMComplianceCheck check : checks) {
                if (!check.isEnabled() || !filter.select(null, category, check)) continue;
                ArrayList<OVMComplianceCheckHit> hits = check.getVisibleHits();
                for (OVMComplianceCheckHit hit : hits) {
                    switch (hit.getSeverity()) {
                        case ERROR: {
                            ++nofErrors;
                            break;
                        }
                        case WARNING: {
                            ++nofWarnings;
                            break;
                        }
                        case INFO: {
                            ++nofInfos;
                            break;
                        }
                        case DISABLED: {
                            ++nofDisabled;
                            break;
                        }
                    }
                }
            }
        }
        String hitMessage = String.valueOf(nofErrors) + " errors, " + nofWarnings + " warnings, " + nofInfos + " infos, " + nofDisabled + " disabled";
        return hitMessage;
    }

    private void updateFilterButtonsTooltTips(Button button) {
        String buttonToolTip = (String)button.getData();
        button.setToolTipText(String.valueOf(button.getSelection() ? "Show " : "Hide ") + (buttonToolTip == null ? "" : buttonToolTip) + " Checks");
    }

    private void updateAllFilterButtonsTooltTips() {
        this.updateFilterButtonsTooltTips(this.fHidePassedButton);
        this.updateFilterButtonsTooltTips(this.fHideErrorButton);
        this.updateFilterButtonsTooltTips(this.fHideWarningButton);
        this.updateFilterButtonsTooltTips(this.fHideInfoButton);
        this.updateFilterButtonsTooltTips(this.fHideDisabledButton);
        this.updateFilterButtonsTooltTips(this.fHideAutomaticButton);
        this.updateFilterButtonsTooltTips(this.fHideManualButton);
        this.updateFilterButtonsTooltTips(this.fHideNonAutofixableButton);
    }

    public void setInput(ArrayList<OVMComplianceCategory> input, boolean clearHits) {
        this.updateLabelFiltersList(input);
        this.fTree.setInput(input);
        this.updateTree(clearHits);
    }

    @Override
    public void reportUpdate() {
        this.updateTree(true);
        this.updateLeftPart();
    }

    public void showCheck(String checkName) {
        ArrayList input = (ArrayList)this.fTree.getInput();
        OVMComplianceCheck check = null;
        for (OVMComplianceCategory cat : input) {
            for (OVMComplianceCheck candidate : cat.getChecks()) {
                if (!candidate.getName().equals(checkName)) continue;
                check = candidate;
            }
        }
        if (check == null) {
            return;
        }
        this.fTree.setSelection((ISelection)new StructuredSelection(check));
    }

    public void showHit(OVMComplianceCheckHit checkHit) {
        if (checkHit == null) {
            return;
        }
        this.fChecksTable.setSelection((ISelection)new StructuredSelection((Object)checkHit), true);
        this.fChecksTable.getTable().setFocus();
    }

    private OVMProject getCurrentOVMProject() {
        return this.fComplianceReport.getOVMInfoProvider().getOVMProject();
    }

    public void notifyChangeListeners(boolean isPostWaiver) {
        for (IWaiversChangeListener listener : this.fWaiversChangeListeners) {
            listener.waiversChanged(isPostWaiver);
        }
    }

    public void addWaiversChangeListener(IWaiversChangeListener listener) {
        if (listener != null) {
            this.fWaiversChangeListeners.add(listener);
        }
    }

    public void dispose() {
        this.fComplianceReport.getDocumentManager().deactivate();
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
    }

    private static final class CategoriesTableContentProvider
    implements IStructuredContentProvider {
        private CategoriesTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputList = (ArrayList)inputElement;
                return inputList.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class CategoriesTableDubleClickListener
    implements IDoubleClickListener {
        private CategoriesTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCheck) {
                ChecksTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class CategoriesTableLabelProvider
    implements ITableLabelProvider {
        private CategoriesTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1 && element != null && element instanceof OVMComplianceCheck) {
                return OVMComplianceChecksUtilUI.getImage(element, OVMComplianceChecksUtil.getStatus(element));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof OVMComplianceCheck) {
                OVMComplianceCheck check = (OVMComplianceCheck)element;
                if (columnIndex == 0) {
                    return check.getName();
                }
                if (columnIndex == 2) {
                    if (check instanceof OVMComplianceManualCheck) {
                        return "Manual";
                    }
                    return Integer.toString(check.getNofVisibleHits());
                }
                if (columnIndex == 3) {
                    return String.valueOf(check.getTitle()) + ": " + HTMLUtils.stripTags(check.getFullDescription());
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class CategoriesTableSelectionChangedListener
    implements ISelectionChangedListener {
        private CategoriesTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof OVMComplianceCheck) {
                ChecksTreeBrowser.this.fCategoriesTableDetails.setText(HTMLUtils.stripTags(((OVMComplianceCheck)element).getFullDescription()));
            }
        }
    }

    private static final class ChecksTableContentProvider
    implements IStructuredContentProvider {
        private ChecksTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                return ((ArrayList)inputElement).toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ChecksTableDubleClickListener
    implements IDoubleClickListener {
        private ChecksTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            File file;
            ParserPath fileName;
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCheckHit && (fileName = ((OVMComplianceCheckHit)element).getParserPath()) != null && (file = new File(fileName.path)).isFile() && file.canRead()) {
                VlogFileUtils.getInstance().openFile(ChecksTreeBrowser.this.fProject, fileName.path, ((OVMComplianceCheckHit)element).getLine());
            }
        }
    }

    private static final class ChecksTableLabelProvider
    implements ITableLabelProvider {
        private ChecksTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element != null && element instanceof OVMComplianceCheckHit) {
                return OVMComplianceChecksUtilUI.getImage(element, OVMComplianceChecksUtil.getStatus(element));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof OVMComplianceCheckHit) {
                OVMComplianceCheckHit hit = (OVMComplianceCheckHit)element;
                if (columnIndex == 1) {
                    return Integer.toString(hit.getLine());
                }
                if (columnIndex == 2) {
                    return hit.getShortFileNameAndMacroPath();
                }
                if (columnIndex == 3) {
                    return hit.getDetails();
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class ChecksTreeContentProvider
    implements ITreeContentProvider {
        private ChecksTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof OVMComplianceCategory) {
                ArrayList<OVMComplianceCheck> children = new ArrayList<OVMComplianceCheck>();
                children.addAll(((OVMComplianceCategory)parentElement).getChecks());
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof OVMComplianceCheck) {
                return ((OVMComplianceCheck)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ArrayList || element instanceof OVMComplianceCategory;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<Object> children = new ArrayList<Object>();
                children.add(Messages.ChecksTreeBrowser_Summary_Item);
                for (OVMComplianceCategory category : inputElementTmp) {
                    if (this.getNoOfFilteredChecks(category) <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        private int getNoOfFilteredChecks(OVMComplianceCategory category) {
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            if (checks == null || checks.isEmpty()) {
                return 0;
            }
            int filteredCheckNo = 0;
            ComplianceCheckFilter filter = new ComplianceCheckFilter();
            for (OVMComplianceCheck check : checks) {
                if (!filter.select(null, category, check)) continue;
                ++filteredCheckNo;
            }
            return filteredCheckNo;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static final class ChecksTreeLabelProvider
    implements ILabelProvider {
        private ChecksTreeLabelProvider() {
        }

        public Image getImage(Object element) {
            return OVMComplianceChecksUtilUI.getImage(element, OVMComplianceChecksUtil.getStatus(element));
        }

        public String getText(Object element) {
            return OVMComplianceChecksUtilUI.getTreeText(element);
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private final class ChecksTreeSelectionChangedListener
    implements ISelectionChangedListener {
        private ChecksTreeSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            ChecksTreeBrowser.this.fSelectedItem = element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck) {
                if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceManualCheck) {
                    ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(true);
                    ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(false);
                } else if (ChecksTreeBrowser.this.fSelectedItem instanceof ErrorCheck) {
                    ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(false);
                    ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(false);
                } else {
                    ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(true);
                    ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(true);
                }
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setText("Reapply Check");
                ChecksTreeBrowser.this.fTreeAutofixHitsCheckMenuItem.setEnabled(!((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).hasConfigurationErrors() && VerissimoAutofixUtils.getInstance().hasAutofixImplemented((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem) && ((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).getNofVisibleHits() != 0);
                ChecksTreeBrowser.this.fAutocorrectCheckMenuItems.forEach(menuItem -> menuItem.setEnabled(true));
                HashSet<String> blueprintNamesForCheck = new HashSet<String>(VerissimoAIAutofixManager.getInstance().getAIAutofixBlueprintNames(((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).getName()));
                ChecksTreeBrowser.this.fAutocorrectCheckMenuItems.forEach(menuItem -> {
                    String associatedBlueprint = (String)menuItem.getData();
                    if (!blueprintNamesForCheck.contains(associatedBlueprint)) {
                        menuItem.setEnabled(false);
                    }
                });
            } else if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCategory) {
                ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(true);
                ChecksTreeBrowser.this.fTreeAutofixHitsCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fAutocorrectCheckMenuItems.forEach(menuItem -> menuItem.setEnabled(false));
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setText("Reapply Category");
            } else {
                ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setText("Reapply Check");
                ChecksTreeBrowser.this.fTreeAutofixHitsCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fAutocorrectCheckMenuItems.forEach(menuItem -> menuItem.setEnabled(false));
            }
            ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck && !(ChecksTreeBrowser.this.fSelectedItem instanceof ErrorCheck));
            if (ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceCheck && !((OVMComplianceCheck)ChecksTreeBrowser.this.fSelectedItem).isEnabled()) {
                ChecksTreeBrowser.this.fTreeWaiveCheckMenuItem.setEnabled(false);
                ChecksTreeBrowser.this.fTreeReapplyCheckMenuItem.setEnabled(false);
            }
            ChecksTreeBrowser.this.updateLeftPart();
        }
    }

    public final class ComplianceCheckFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ChecksTreeBrowser.this.fSelectedItem == null || ((IStructuredSelection)ChecksTreeBrowser.this.fTree.getSelection()).getFirstElement() == null) {
                StructuredSelection selection = new StructuredSelection((Object)Messages.ChecksTreeBrowser_Summary_Item);
                ChecksTreeBrowser.this.fTree.setSelection((ISelection)selection, true);
            }
            if (element instanceof OVMComplianceCheck) {
                if (element instanceof OVMComplianceCheck && !(element instanceof OVMComplianceManualCheck) && ChecksTreeBrowser.this.fHideAutomaticButton.getSelection()) {
                    return false;
                }
                if (element instanceof OVMComplianceManualCheck && ChecksTreeBrowser.this.fHideManualButton.getSelection()) {
                    return false;
                }
                if (!VerissimoAutofixUtils.getInstance().hasAutofixImplemented((OVMComplianceCheck)element) && ChecksTreeBrowser.this.fHideNonAutofixableButton.getSelection()) {
                    return false;
                }
                OVMComplianceCheck check = (OVMComplianceCheck)element;
                if (!OVMComplianceChecksUtil.applyLabelFiltersOnCheck(ChecksTreeBrowser.this.labelFilter, check)) {
                    return false;
                }
                CheckStatus checkStatus = check.getStatus();
                if (!OVMComplianceChecksUtil.applyFiltersOnCheck(ChecksTreeBrowser.this.filters, checkStatus)) {
                    return !check.getVisibleHits().isEmpty();
                }
                return true;
            }
            return element instanceof String || element instanceof OVMComplianceCategory;
        }
    }

    private final class FilterButtonSelectionListener
    implements SelectionListener {
        private FilterButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.widget != null && e.widget instanceof Button) {
                Button button = (Button)e.widget;
                Color color = button.getSelection() ? ChecksTreeBrowser.this.fButtonBackgroundColor : ChecksTreeBrowser.this.fBackgroundColor;
                DVTColorUtil.INSTANCE.setBackground((Control)button, color, true);
                ChecksTreeBrowser.this.updateFilterButtonsTooltTips(button);
                ChecksTreeBrowser.this.resetFiltersList();
                ChecksTreeBrowser.this.updateTree(true);
            }
        }
    }

    private final class FiltersListSelectionListener
    implements SelectionListener {
        private FiltersListSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            int index = ChecksTreeBrowser.this.fFiltersList.getSelectionIndex();
            String selection = ChecksTreeBrowser.this.fFiltersList.getItem(index);
            ChecksTreeBrowser.this.fHidePassedButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideErrorButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideWarningButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideInfoButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideDisabledButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideAutomaticButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideManualButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideNonAutofixableButton.removeSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHidePassedButton.setSelection(false);
            ChecksTreeBrowser.this.fHideErrorButton.setSelection(false);
            ChecksTreeBrowser.this.fHideWarningButton.setSelection(false);
            ChecksTreeBrowser.this.fHideInfoButton.setSelection(false);
            ChecksTreeBrowser.this.fHideDisabledButton.setSelection(false);
            ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(false);
            ChecksTreeBrowser.this.fHideManualButton.setSelection(false);
            ChecksTreeBrowser.this.fHideNonAutofixableButton.setSelection(false);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHidePassedButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideErrorButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideWarningButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideInfoButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideDisabledButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideAutomaticButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideManualButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideNonAutofixableButton, ChecksTreeBrowser.this.fBackgroundColor, true);
            if (!selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All_And_Disabled)) {
                if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_All)) {
                    ChecksTreeBrowser.this.fHideDisabledButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideDisabledButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Errors)) {
                    ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideDisabledButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHidePassedButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideWarningButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideInfoButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideDisabledButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Show_Only_Disabled)) {
                    ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideErrorButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideWarningButton.setSelection(true);
                    ChecksTreeBrowser.this.fHideInfoButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHidePassedButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideErrorButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideWarningButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideInfoButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Manual)) {
                    ChecksTreeBrowser.this.fHideManualButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideManualButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Automatic)) {
                    ChecksTreeBrowser.this.fHideAutomaticButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideAutomaticButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_Passed)) {
                    ChecksTreeBrowser.this.fHidePassedButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHidePassedButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                } else if (selection.equals(Messages.ChecksTreeBrowser_Predefined_Filter_Hide_NonAutofixable)) {
                    ChecksTreeBrowser.this.fHideNonAutofixableButton.setSelection(true);
                    DVTColorUtil.INSTANCE.setBackground((Control)ChecksTreeBrowser.this.fHideNonAutofixableButton, ChecksTreeBrowser.this.fButtonBackgroundColor, true);
                }
            }
            ChecksTreeBrowser.this.fHidePassedButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideErrorButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideWarningButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideInfoButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideDisabledButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideAutomaticButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideManualButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.fHideNonAutofixableButton.addSelectionListener((SelectionListener)ChecksTreeBrowser.this.fFilterButtonSelectionListener);
            ChecksTreeBrowser.this.updateAllFilterButtonsTooltTips();
            ChecksTreeBrowser.this.updateTree(true);
        }
    }

    private final class LabelFiltersListSelectionListener
    implements SelectionListener {
        private LabelFiltersListSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ChecksTreeBrowser.this.loadLabelsFilters();
            ChecksTreeBrowser.this.updateTree(true);
        }
    }

    private final class MarkAsButtonSelectionListener
    implements SelectionListener {
        private MarkAsButtonSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            CheckStatus status;
            if (!(e.widget instanceof Button) || !((Button)e.widget).getSelection()) {
                return;
            }
            if (ChecksTreeBrowser.this.fSelectedItem != null && ChecksTreeBrowser.this.fSelectedItem instanceof OVMComplianceManualCheck && (status = (CheckStatus)((Object)e.widget.getData())) != null) {
                ((OVMComplianceManualCheck)ChecksTreeBrowser.this.fSelectedItem).setStatus(status);
                ChecksTreeBrowser.this.fComplianceReport.getOVMInfoProvider().getOVMProject().saveManualChecksStatus();
                ChecksTreeBrowser.this.updateManualChecksComposite((OVMComplianceManualCheck)ChecksTreeBrowser.this.fSelectedItem);
                ChecksTreeBrowser.this.fRightPartComposite.layout(true, true);
                ChecksTreeBrowser.this.updateTree(true);
            }
        }
    }

    private class ResizeListener
    implements Listener {
        TagWidget label;
        String text;
        boolean isLabel;

        public ResizeListener(TagWidget label, String text, boolean isLabel) {
            this.label = label;
            this.text = text;
            this.isLabel = isLabel;
        }

        public void handleEvent(Event event) {
            ChecksTreeBrowser.this.truncateTagText(this.label, this.text, this.isLabel);
        }
    }

    private final class SummaryTableContentProvider
    implements IStructuredContentProvider {
        private SummaryTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof ArrayList) {
                ArrayList inputElementTmp = (ArrayList)inputElement;
                ArrayList<OVMComplianceCategory> children = new ArrayList<OVMComplianceCategory>();
                for (OVMComplianceCategory category : inputElementTmp) {
                    if (!this.hasEnabledChecks(category) || category.getNofChecks() <= 0) continue;
                    children.add(category);
                }
                return children.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean hasEnabledChecks(OVMComplianceCategory category) {
            ArrayList<OVMComplianceCheck> checks = category.getChecks();
            if (checks == null) {
                return false;
            }
            ComplianceCheckFilter filter = new ComplianceCheckFilter();
            for (OVMComplianceCheck check : checks) {
                if (!filter.select(null, category, check)) continue;
                return true;
            }
            return false;
        }
    }

    private final class SummaryTableDubleClickListener
    implements IDoubleClickListener {
        private SummaryTableDubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object element;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null && (element = selection.getFirstElement()) instanceof OVMComplianceCategory) {
                ChecksTreeBrowser.this.fTree.setSelection((ISelection)selection);
            }
        }
    }

    private static final class SummaryTableLabelProvider
    implements ITableLabelProvider {
        private SummaryTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 1 && element != null && element instanceof OVMComplianceCategory) {
                return OVMComplianceChecksUtilUI.getImage(element, OVMComplianceChecksUtil.getStatus(element));
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element != null && element instanceof OVMComplianceCategory) {
                OVMComplianceCategory category = (OVMComplianceCategory)element;
                if (columnIndex == 0) {
                    return category.getName();
                }
                if (columnIndex == 2) {
                    return String.valueOf(Integer.toString(category.getNofEnabledChecks())) + " / " + Integer.toString(category.getNofChecks());
                }
                if (columnIndex == 3) {
                    return HTMLUtils.stripTags(category.getDescription());
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class SummaryTableSelectionChangedListener
    implements ISelectionChangedListener {
        private SummaryTableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (element instanceof OVMComplianceCategory) {
                ChecksTreeBrowser.this.fSummaryTableDetails.setText(HTMLUtils.stripTags(((OVMComplianceCategory)element).getDescription()));
            }
        }
    }
}

