/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilder;
import ro.amiq.vlogdt.linter.launch.VerissimoAfterCompilationLauncher;
import ro.amiq.vlogdt.linter.ui.AbstractLintingHandler;
import ro.amiq.vlogdt.model.reflection.RfManager;

public class ClearLintingResultsHandler
extends AbstractLintingHandler {
    public boolean isEnabled() {
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject == null) {
            return false;
        }
        return SingleFileLintingBuilder.getInstance().isEnabled(selectedProject) || VerissimoAfterCompilationLauncher.getInstance().isEnabled(selectedProject);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject selectedProject = this.getSelectedProject();
        if (selectedProject != null) {
            if (SingleFileLintingBuilder.getInstance().isEnabled(selectedProject)) {
                SingleFileLintingBuilder.getInstance().clearResults(selectedProject);
            }
            if (VerissimoAfterCompilationLauncher.getInstance().isEnabled(selectedProject)) {
                VerissimoAfterCompilationLauncher.getInstance().clearResults(RfManager.getInstance().getRfProject(selectedProject));
            }
        }
        return null;
    }

    private IProject getSelectedProject() {
        IResource resource = DVTPlugin.getSelectionManager().getLastSelectedResource();
        if (resource == null) {
            return null;
        }
        IProject selectedProject = resource.getProject();
        return selectedProject;
    }
}

