/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.linter.ui.LinterHTMLReportHandler;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.report.VerissimoReportConverter;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.RReport;

public interface HTML5ReportGenerator {
    public static void generate(RReport report, String location, OVMProject ovmProject, IProgressMonitor monitor) {
        HTML5ReportGenerator.generate(report, location, ovmProject, monitor, null);
    }

    public static void generate(RReport report, String location, OVMProject ovmProject, IProgressMonitor monitor, ReportManager.ReportType reportType) {
        File[] files = VerissimoReportWriter.writeReportFilesStructure(location, ovmProject, null, true, HTML5ReportGenerator::errorHandler, monitor, reportType);
        VerissimoReportWriter.writeReport(VerissimoReportWriter::writeHtmlCodeFiles, report, files, ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode(), monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        if (files == null) {
            return;
        }
        HTML5ReportGenerator.refresh(files[1], monitor);
        LinterHTMLReportHandler.openHTMLReport((String)files[1].getParent(), (int)report.getHits().size());
    }

    public static File[] generateWithoutOpen(RReport report, String location, OVMProject ovmProject, IProgressMonitor monitor, ReportManager.ReportType reportType) {
        File[] files = VerissimoReportWriter.writeReportFilesStructure(location, ovmProject, null, true, HTML5ReportGenerator::errorHandler, monitor, reportType);
        VerissimoReportWriter.writeReport(VerissimoReportWriter::writeHtmlCodeFiles, report, files, ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode(), monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        if (files == null) {
            return null;
        }
        return files;
    }

    public static void generate(String location, OVMProject ovmProject, IProgressMonitor monitor) {
        File[] files = VerissimoReportWriter.writeReportFilesStructure(location, ovmProject, null, true, HTML5ReportGenerator::errorHandler, monitor);
        RReport report = VerissimoReportConverter.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        VerissimoReportWriter.writeReport(VerissimoReportWriter::writeHtmlCodeFiles, report, files, ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode(), monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        if (files == null) {
            return;
        }
        HTML5ReportGenerator.refresh(files[1], monitor);
        LinterHTMLReportHandler.openHTMLReport((String)files[1].getParent(), (int)report.getHits().size());
    }

    public static File[] generateWithoutOpen(String location, OVMProject ovmProject, IProgressMonitor monitor) {
        File[] files = VerissimoReportWriter.writeReportFilesStructure(location, ovmProject, null, true, HTML5ReportGenerator::errorHandler, monitor);
        RReport report = VerissimoReportConverter.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        VerissimoReportWriter.writeReport(VerissimoReportWriter::writeHtmlCodeFiles, report, files, ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode(), monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
        return files;
    }

    public static void refreshAndOpenReport(File indexFile, int hits, IProgressMonitor monitor) {
        if (indexFile == null) {
            return;
        }
        HTML5ReportGenerator.refresh(indexFile, monitor);
        LinterHTMLReportHandler.openHTMLReport((String)indexFile.getParent(), (int)hits);
    }

    public static String[] collectInfo(OVMProject ovmProject) {
        return new String[]{(String)DVTPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version"), ovmProject.getProject().getName()};
    }

    public static void refresh(File indexFile, IProgressMonitor monitor) {
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(indexFile.toURI());
        if (containers != null) {
            try {
                IContainer[] iContainerArray = containers;
                int n = containers.length;
                int n2 = 0;
                while (n2 < n) {
                    IContainer container = iContainerArray[n2];
                    container.refreshLocal(2, monitor);
                    ++n2;
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public static IProgressMonitor subprogressMonitorSuplier(IProgressMonitor monitor, int ticks) {
        return new SubProgressMonitor(monitor, ticks);
    }

    public static void errorHandler(String message) {
        if (message.startsWith("WARNING:")) {
            return;
        }
        if (message.startsWith("ERROR:")) {
            message = message.substring("ERROR:".length()).trim();
        }
        final String errorMessage = message;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, (String)"Can't generate linter report!", (IStatus)new Status(4, "ro.amiq.dvt", errorMessage));
            }
        });
    }
}

