/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import com.github.difflib.DiffUtils;
import com.github.difflib.patch.Patch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.json.JSONException;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.PathMapper;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.LicenseUnavailableException;
import ro.amiq.vlogdt.linter.annotations.AnnotationResults;
import ro.amiq.vlogdt.linter.base.annotations.RuleLabel;
import ro.amiq.vlogdt.linter.report.VerissimoReportReader;
import ro.amiq.vlogdt.linter.report.VerissimoReportWriter;
import ro.amiq.vlogdt.linter.report.model.RCategory;
import ro.amiq.vlogdt.linter.report.model.RCheck;
import ro.amiq.vlogdt.linter.report.model.RHit;
import ro.amiq.vlogdt.linter.report.model.RInfo;
import ro.amiq.vlogdt.linter.report.model.RPreWaiver;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.report.model.RWaiver;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ui.HTML5ReportGenerator;
import ro.amiq.vlogdt.linter.ui.VerissimoDiffer;

public abstract class HTML5ReportMergerCommon {
    public static int newMax = 0;

    public static RReport merge(List<String> mergeReportsPaths, String htmlReportLocation, List<String> infoKeyValues) {
        File[] reportFiles = VerissimoReportWriter.computeReportFiles(htmlReportLocation, null, infoKeyValues);
        File outputReportLocation = reportFiles[0];
        String absoluteHtmlReportLocation = HTML5ReportMergerCommon.getCannonicalPath(outputReportLocation.getAbsolutePath());
        LinkedHashSet<String> cannonicalMergeReportPaths = new LinkedHashSet<String>();
        for (String mergeReportPath : mergeReportsPaths) {
            String cannonicalMergePath = HTML5ReportMergerCommon.getCannonicalPath(mergeReportPath);
            if (cannonicalMergePath == null) {
                return null;
            }
            cannonicalMergeReportPaths.add(cannonicalMergePath);
        }
        File infoKeysValuesFile = reportFiles[3];
        if (infoKeysValuesFile != null) {
            StringBuilder mappingsSB = new StringBuilder();
            for (String pair : infoKeyValues) {
                mappingsSB.append(pair).append("\n");
            }
            VerissimoReportWriter.writeStringToFile(infoKeysValuesFile, mappingsSB.toString(), HTML5ReportGenerator::errorHandler);
        }
        if (cannonicalMergeReportPaths.contains(absoluteHtmlReportLocation)) {
            DVTLogger.INSTANCE.logError("ERROR: Output report location '" + htmlReportLocation + "' overlaps with the location of merged reports.");
            return null;
        }
        if (cannonicalMergeReportPaths.size() < 2) {
            DVTLogger.INSTANCE.logError("ERROR: At least two valid report locations must be used with -merge argument.");
            return null;
        }
        ArrayList<RReport> reports = new ArrayList<RReport>();
        for (String path : cannonicalMergeReportPaths) {
            try {
                RReport report = VerissimoReportReader.readReportFiles(path);
                reports.add(report);
                if (!report.getInfoWrapper().isCompareReport()) continue;
                DVTLogger.INSTANCE.logError("ERROR: Report '" + path + "' is the result of a compare operation and cannot be merged with another report.");
                return null;
            }
            catch (IOException | JSONException e) {
                DVTLogger.INSTANCE.logError("ERROR: No valid report found in location '" + path + "'." + e.getMessage());
                return null;
            }
        }
        if (reports.size() < 2) {
            DVTLogger.INSTANCE.logError("ERROR: At least two valid report locations must be used with -merge argument.");
            return null;
        }
        RReport report = (RReport)reports.get(0);
        int i = 1;
        while (i < reports.size()) {
            try {
                report = HTML5ReportMergerCommon.merge(report, (RReport)reports.get(i), false);
            }
            catch (LicenseUnavailableException licenseUnavailableException) {
                DVTLogger.INSTANCE.logError("ERROR: No available license.");
                return null;
            }
            ++i;
        }
        return report;
    }

    public static RReport diff(List<String> diffReportsPaths, String htmlReportLocation, List<String> infoKeyValues, List<String> mappings, PathMapper.Result mappingResult, boolean isReverseOrder) {
        File[] reportFiles = VerissimoReportWriter.computeReportFiles(htmlReportLocation, null, infoKeyValues);
        File outputReportLocation = reportFiles[0];
        String absoluteHtmlReportLocation = HTML5ReportMergerCommon.getCannonicalPath(outputReportLocation.getAbsolutePath());
        LinkedHashSet<String> cannonicalDiffReportPaths = new LinkedHashSet<String>();
        for (String diffReportPath : diffReportsPaths) {
            String cannonicalDiffPath = HTML5ReportMergerCommon.getCannonicalPath(diffReportPath);
            if (cannonicalDiffPath == null) {
                return null;
            }
            cannonicalDiffReportPaths.add(cannonicalDiffPath);
        }
        File infoKeysValuesFile = reportFiles[3];
        if (infoKeysValuesFile != null) {
            StringBuilder mappingsSB = new StringBuilder();
            for (String pair : infoKeyValues) {
                mappingsSB.append(pair).append("\n");
            }
            VerissimoReportWriter.writeStringToFile(infoKeysValuesFile, mappingsSB.toString(), HTML5ReportGenerator::errorHandler);
        }
        if (cannonicalDiffReportPaths.contains(absoluteHtmlReportLocation)) {
            DVTLogger.INSTANCE.logError("ERROR: Output report location '" + htmlReportLocation + "' overlaps with the location of diff reports.");
            return null;
        }
        ArrayList<RReport> reports = new ArrayList<RReport>();
        for (String path : cannonicalDiffReportPaths) {
            RReport report;
            block15: {
                block14: {
                    File codeFolder = new File(path, "code");
                    if (codeFolder.exists() && codeFolder.isDirectory()) break block14;
                    DVTLogger.INSTANCE.logError("ERROR: No valid code folder found in location '" + path + "'. Use -include_html_code when generating the reports that you want to diff.");
                    return null;
                }
                report = VerissimoReportReader.readReportFiles(path);
                if (!report.getInfoWrapper().isCompareReport()) break block15;
                DVTLogger.INSTANCE.logError("ERROR: Report '" + path + "' is the result of a compare operation and cannot be diffed with another report.");
                return null;
            }
            try {
                reports.add(report);
            }
            catch (IOException | JSONException e) {
                DVTLogger.INSTANCE.logError("ERROR: No valid report found in location '" + path + "'." + e.getMessage());
                return null;
            }
        }
        RReport report = (RReport)reports.get(0);
        int i = 1;
        while (i < reports.size()) {
            RReport nextReport = (RReport)reports.get(i);
            if (mappingResult == null) {
                mappingResult = PathMapper.map(report.getFiles(), nextReport.getFiles(), mappings);
            }
            try {
                report = HTML5ReportMergerCommon.diff(report, nextReport, mappingResult, isReverseOrder);
            }
            catch (LicenseUnavailableException licenseUnavailableException) {
                DVTLogger.INSTANCE.logError("ERROR: No available license.");
                return null;
            }
            ++i;
        }
        return report;
    }

    public static RReport getRReport(String reportPath) {
        RReport report;
        String cannonicalPath = HTML5ReportMergerCommon.getCannonicalPath(reportPath);
        if (cannonicalPath == null) {
            return null;
        }
        try {
            report = VerissimoReportReader.readReportFiles(cannonicalPath);
        }
        catch (IOException | JSONException e) {
            DVTLogger.INSTANCE.logError("ERROR: No valid report found in location '" + cannonicalPath + "'." + e.getMessage());
            return null;
        }
        return report;
    }

    public static String getCannonicalPath(String path) {
        File file;
        String cannonicalPath;
        block3: {
            cannonicalPath = null;
            file = new File(path);
            if (file.canRead()) break block3;
            DVTLogger.INSTANCE.logError("ERROR: '" + path + "' is not readable.");
            return null;
        }
        try {
            cannonicalPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            DVTLogger.INSTANCE.logError("ERROR: '" + path + "' is not readable.");
        }
        return cannonicalPath;
    }

    public static RReport merge(RReport currentReport, RReport baselineReport, boolean isCompare) throws LicenseUnavailableException {
        return HTML5ReportMergerCommon.merge(currentReport, baselineReport, isCompare, PathMapper.map(currentReport.getAllImportedFiles(), baselineReport.getAllImportedFiles(), null));
    }

    public static RReport merge(RReport currentReport, RReport baselineReport, boolean isCompare, PathMapper.Result mappingResult) throws LicenseUnavailableException {
        newMax = currentReport.getMaxSourceCode();
        RReport result = new RReport();
        List<AnnotationResults.AnnotationInfo> haInfos_1 = currentReport.getAnnotationInfos();
        List<AnnotationResults.AnnotationInfo> haInfos_2 = baselineReport.getAnnotationInfos();
        List<Set<String>> haStrings_1 = currentReport.getAnnotationStrings();
        List<Set<String>> haStrings_2 = baselineReport.getAnnotationStrings();
        LinkedList<AnnotationResults.AnnotationInfo> resultInfos = new LinkedList<AnnotationResults.AnnotationInfo>(haInfos_1);
        for (AnnotationResults.AnnotationInfo entry : haInfos_2) {
            Set<Integer> locations = entry.getLocations();
            int indexOf = resultInfos.indexOf(entry);
            if (indexOf != -1) {
                ((AnnotationResults.AnnotationInfo)resultInfos.get(indexOf)).getLocations().addAll(locations);
                continue;
            }
            resultInfos.add(entry);
        }
        result.setAnnotationInfos(resultInfos);
        Map<String, Set<String>> infoToValuesMap_1 = HTML5ReportMergerCommon.getInfoToValuesMap(haInfos_1, haStrings_1);
        Map<String, Set<String>> infoToValuesMap_2 = HTML5ReportMergerCommon.getInfoToValuesMap(haInfos_2, haStrings_2);
        LinkedHashMap<String, Set<String>> resultInfoToValuesMap = new LinkedHashMap<String, Set<String>>(infoToValuesMap_1);
        for (Map.Entry<String, Set<String>> entry : infoToValuesMap_2.entrySet()) {
            String title = entry.getKey();
            Set<String> locations = entry.getValue();
            if (resultInfoToValuesMap.containsKey(title)) {
                ((Set)resultInfoToValuesMap.get(title)).addAll(locations);
                continue;
            }
            resultInfoToValuesMap.put(title, locations);
        }
        LinkedHashMap<String, Set<String>> hitAnnotationsNewModel = new LinkedHashMap<String, Set<String>>(resultInfoToValuesMap);
        hitAnnotationsNewModel.replaceAll((k, v) -> new LinkedHashSet());
        ArrayList<Set<String>> haStrings = new ArrayList<Set<String>>();
        Set entrySet2 = resultInfoToValuesMap.entrySet();
        for (Map.Entry entry : entrySet2) {
            haStrings.add((Set)entry.getValue());
        }
        result.setAnnotationStrings(haStrings);
        RInfo infoWrapper = currentReport.getInfoWrapper();
        RInfo infoWrapperBaseline = baselineReport.getInfoWrapper();
        infoWrapper.setHasEffortEstimation(infoWrapper.hasEffortEstimation() || infoWrapperBaseline.hasEffortEstimation());
        infoWrapper.getCommonSegmentsInfo().addAll(infoWrapperBaseline.getCommonSegmentsInfo());
        infoWrapper.setNofCompiledLines(infoWrapper.getNofCompiledLines() + infoWrapperBaseline.getNofCompiledLines());
        infoWrapper.setLintRunTime(infoWrapper.getLintRunTime() + infoWrapperBaseline.getLintRunTime());
        infoWrapper.setBuildRunTime(infoWrapper.getBuildRunTime() + infoWrapperBaseline.getBuildRunTime());
        infoWrapper.setLicenseWaitTime(infoWrapper.getLicenseWaitTime() + infoWrapperBaseline.getLicenseWaitTime());
        infoWrapper.setBaselineReportUUID(infoWrapperBaseline.getUUID());
        infoWrapper.setCurrentReportUUID(infoWrapper.getUUID());
        infoWrapper.setUUID(UUID.randomUUID().toString());
        infoWrapper.setCommiterDate("");
        result.setInfoWrapper(infoWrapper);
        Set<String> files1 = currentReport.getFiles();
        Set<String> files2 = baselineReport.getFiles();
        LinkedHashSet<String> allFiles = new LinkedHashSet<String>();
        allFiles.addAll(files1);
        for (String file : files2) {
            if (mappingResult.isUnmappedB(file)) {
                allFiles.add(file);
                continue;
            }
            if (mappingResult.getA(file) != null) {
                allFiles.add(mappingResult.getA(file));
                continue;
            }
            if (file == null) continue;
            allFiles.add(file);
        }
        ArrayList allFilesList = new ArrayList(allFiles);
        ArrayList<String> fileList2 = new ArrayList<String>(files2);
        result.setFiles(allFiles);
        List<RuleLabel> labels1 = currentReport.getLabels();
        List<RuleLabel> labels2 = baselineReport.getLabels();
        LinkedHashSet<RuleLabel> allLabels = new LinkedHashSet<RuleLabel>();
        allLabels.addAll(labels1);
        allLabels.addAll(labels2);
        result.setLabels(new ArrayList<RuleLabel>(allLabels));
        String buildFile = currentReport.getBuildFile();
        result.setBuildFile(buildFile);
        String waiversFile = currentReport.getWaiversFile();
        result.setWaiversFile(waiversFile);
        RulesetKind rulesetKind = currentReport.getRulesetKind();
        result.setRulesetKind(rulesetKind);
        String rulesetFile = currentReport.getRulesetFile();
        result.setRulesetFile(rulesetFile);
        List<RCategory> categories1 = currentReport.getCategories();
        List<RCategory> categories2 = baselineReport.getCategories();
        for (RCategory rCategory : categories1) {
            HTML5ReportMergerCommon.updateCategoryHitsToGlobalModel(rCategory, hitAnnotationsNewModel, currentReport, currentReport);
        }
        LinkedHashMap categoriesOfResultReport = categories1.stream().collect(Collectors.toMap(RCategory::getSelf, RCategory::getChecks, (e1, e2) -> e1, LinkedHashMap::new));
        for (RCategory categoryOfSecondReport : categories2) {
            if (categoriesOfResultReport.containsKey(categoryOfSecondReport)) {
                Object check122;
                Set checksOfFirstReport = (Set)categoriesOfResultReport.get(categoryOfSecondReport);
                Set<RCheck> checksOfSecondReport = categoryOfSecondReport.getChecks();
                Iterator iterator = checksOfSecondReport.iterator();
                block6: while (iterator.hasNext()) {
                    RCheck check2 = (RCheck)iterator.next();
                    if (!checksOfFirstReport.contains(check2)) continue;
                    for (Object check122 : checksOfFirstReport) {
                        if (!((RCheck)check122).equals(check2)) continue;
                        ((RCheck)check122).setRunTime(((RCheck)check122).getRunTime() + check2.getRunTime());
                        continue block6;
                    }
                }
                LinkedHashMap checksOfFirstReportMap = checksOfFirstReport.stream().collect(Collectors.toMap(RCheck::getSelf, RCheck::getHits, (e1, e2) -> e1, LinkedHashMap::new));
                check122 = checksOfSecondReport.iterator();
                while (check122.hasNext()) {
                    RCheck checkOfSecondReport = (RCheck)check122.next();
                    if (!DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74"})) {
                        throw new LicenseUnavailableException();
                    }
                    if (checksOfFirstReportMap.containsKey(checkOfSecondReport)) {
                        Set hitsOfFirstReport = (Set)checksOfFirstReportMap.get(checkOfSecondReport);
                        Set<RHit> hitsOfSecondReport = checkOfSecondReport.getHits();
                        Map hitsOfSecondReportMap = hitsOfSecondReport.stream().collect(Collectors.groupingBy(RHit::getHitLine, Collectors.mapping(RHit::getSelf, Collectors.toList())));
                        LinkedHashSet<RHit> hitsOfMergedReport = new LinkedHashSet<RHit>();
                        LinkedHashSet<RHit> hitsToBeRemoved = new LinkedHashSet<RHit>();
                        boolean isMerged = false;
                        for (RHit hitOfFirstReport : hitsOfFirstReport) {
                            List hitsOnLine = hitsOfSecondReportMap.get(hitOfFirstReport.getHitLine());
                            if (!isCompare && hitsOnLine != null) {
                                for (RHit hitOfSecondReport : hitsOnLine) {
                                    if (!hitOfFirstReport.equals(hitOfSecondReport)) continue;
                                    Map<Integer, String> sourcesLocations = currentReport.getSourcesLocations();
                                    for (Integer hitResource : hitOfFirstReport.getHitSources()) {
                                        if (sourcesLocations.containsKey(hitResource)) continue;
                                        sourcesLocations.put(hitResource, String.valueOf(currentReport.getLocation()) + "/code/" + hitResource);
                                    }
                                    int it = 1;
                                    for (Integer n : hitOfSecondReport.getHitSources()) {
                                        sourcesLocations.put(currentReport.getMaxSourceCode() + it, String.valueOf(baselineReport.getLocation()) + "/code/" + n);
                                        newMax = currentReport.getMaxSourceCode() + it;
                                        ++it;
                                    }
                                    HTML5ReportMergerCommon.mergeHits(hitAnnotationsNewModel, currentReport, baselineReport, hitOfFirstReport, hitOfSecondReport);
                                    hitsToBeRemoved.add(hitOfSecondReport);
                                    isMerged = true;
                                    break;
                                }
                            }
                            if (!isMerged) {
                                Map<String, Set<String>> adnotationsToList = HTML5ReportMergerCommon.convertAdnotationsToList(hitOfFirstReport, currentReport);
                                HTML5ReportMergerCommon.updateAdnotationsToGlobalModel(hitAnnotationsNewModel, currentReport, hitOfFirstReport, adnotationsToList);
                                Map<Integer, String> sourcesLocations = currentReport.getSourcesLocations();
                                for (Integer hitResource : hitOfFirstReport.getHitSources()) {
                                    if (sourcesLocations.containsKey(hitResource)) continue;
                                    sourcesLocations.put(hitResource, currentReport.getLocation() == null ? "" : String.valueOf(currentReport.getLocation()) + "/code/" + hitResource);
                                }
                            }
                            isMerged = false;
                            hitsOfMergedReport.add(hitOfFirstReport);
                            hitsOfSecondReport.removeAll(hitsToBeRemoved);
                        }
                        Iterator iterator2 = hitsOfSecondReport.iterator();
                        while (iterator2.hasNext()) {
                            RHit hit = (RHit)iterator2.next();
                            Map<String, Set<String>> adnotationsToList = HTML5ReportMergerCommon.convertAdnotationsToList(hit, baselineReport);
                            HTML5ReportMergerCommon.updateAdnotationsToGlobalModel(hitAnnotationsNewModel, baselineReport, hit, adnotationsToList);
                            Map<Integer, String> sourcesLocations = currentReport.getSourcesLocations();
                            int it = 1;
                            for (Integer hitResource2 : hit.getHitSources()) {
                                sourcesLocations.put(currentReport.getMaxSourceCode() + it, String.valueOf(baselineReport.getLocation()) + "/code/" + hitResource2);
                                newMax = currentReport.getMaxSourceCode() + it;
                                ++it;
                            }
                            HTML5ReportMergerCommon.updateHits(hit, currentReport.getMaxSourceCode());
                            List<RHit.MacroPathWrapper> macroParts = hit.getMacroParts();
                            for (RHit.MacroPathWrapper macroPathWrapper : macroParts) {
                                String file = (String)fileList2.get(macroPathWrapper.getIndex());
                                int index = allFilesList.indexOf(file);
                                if (index == -1 && !mappingResult.isUnmappedB(file)) {
                                    index = allFilesList.indexOf(mappingResult.getA(file));
                                }
                                macroPathWrapper.setIndex(index == -1 ? 0 : index);
                            }
                            List<RHit.DetailsLinkWrapper> detailsLinks = hit.getDetailsLinks();
                            for (RHit.DetailsLinkWrapper detailsLinkWrapper : detailsLinks) {
                                String file = (String)fileList2.get(detailsLinkWrapper.getIndex());
                                int index = allFilesList.indexOf(file);
                                if (index == -1 && !mappingResult.isUnmappedB(file)) {
                                    index = allFilesList.indexOf(mappingResult.getA(file));
                                }
                                detailsLinkWrapper.setIndex(index == -1 ? 0 : index);
                            }
                        }
                        hitsOfMergedReport.addAll(hitsOfSecondReport);
                        if (isCompare) {
                            ((Set)checksOfFirstReportMap.get(checkOfSecondReport)).clear();
                        }
                        ((Set)checksOfFirstReportMap.get(checkOfSecondReport)).addAll(hitsOfMergedReport);
                        for (RHit hit : hitsOfMergedReport) {
                            int size = hit.getAnnotationStringsValues().size();
                            hit.initAnnotationStringIndex(size);
                        }
                        continue;
                    }
                    HTML5ReportMergerCommon.updateCheckHitsToGlobalModel(checkOfSecondReport, hitAnnotationsNewModel, currentReport, baselineReport);
                    checksOfFirstReportMap.put(checkOfSecondReport, checkOfSecondReport.getHits());
                }
                LinkedHashSet<RCheck> resultSet = new LinkedHashSet<RCheck>();
                Set entrySet = checksOfFirstReportMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    RCheck key2 = (RCheck)entry.getKey();
                    Set value2 = (Set)entry.getValue();
                    key2.setHits(value2);
                    resultSet.add(key2);
                }
                categoriesOfResultReport.put(categoryOfSecondReport, resultSet);
                continue;
            }
            HTML5ReportMergerCommon.updateCategoryHitsToGlobalModel(categoryOfSecondReport, hitAnnotationsNewModel, currentReport, baselineReport);
            categoriesOfResultReport.put(categoryOfSecondReport, categoryOfSecondReport.getChecks());
        }
        Set<String> allFiles1 = currentReport.getAllImportedFiles();
        Set<String> allFiles2 = baselineReport.getAllImportedFiles();
        for (String file : allFiles2) {
            if (mappingResult.isUnmappedB(file)) {
                allFiles1.add(file);
                continue;
            }
            allFiles1.add(mappingResult.getA(file));
        }
        for (String file : allFiles1) {
            String hash = null;
            if (isCompare) {
                hash = currentReport.getAllFilesHashesMap().get(file);
            }
            if (hash == null) {
                hash = "";
            }
            result.putFileHash(file, hash);
        }
        LinkedHashMap<String, Set<RCheck>> preWaivedFilesForChecksMap1 = currentReport.getPrewaivedFilesForChecks();
        LinkedHashMap<String, Set<RCheck>> preWaivedFilesForChecksMap2 = baselineReport.getPrewaivedFilesForChecks();
        preWaivedFilesForChecksMap2.forEach((key, value) -> {
            LinkedHashSet checksInFirstReport = (LinkedHashSet)preWaivedFilesForChecksMap1.get(key);
            if (checksInFirstReport == null) {
                checksInFirstReport = new LinkedHashSet(value);
            } else {
                checksInFirstReport.addAll(value);
            }
            preWaivedFilesForChecksMap1.put((String)key, checksInFirstReport);
        });
        result.setPrewaivedFilesForChecks(preWaivedFilesForChecksMap1);
        List<RPreWaiver> preWaivers = currentReport.getPreWaivers();
        result.setPreWaivers(preWaivers);
        List<RWaiver> postWaivers = currentReport.getPostWaivers();
        result.setPostWaivers(postWaivers);
        int categoryIndex = 0;
        int checkIndex = 0;
        int hitIndex = 0;
        Set<String> files = result.getFiles();
        ArrayList<String> filesList = new ArrayList<String>(files);
        Set entrySet = categoriesOfResultReport.entrySet();
        for (Map.Entry entry : entrySet) {
            RCategory category = (RCategory)entry.getKey();
            Set checksSet = (Set)entry.getValue();
            RCategory catWrapper = new RCategory(category.getName(), category.getDescription(), categoryIndex);
            for (RCheck checkWrapper : checksSet) {
                checkWrapper.setCheckIndex(checkIndex);
                catWrapper.addCheck(checkWrapper);
                Set<RHit> hits = checkWrapper.getHits();
                for (RHit rHit : hits) {
                    rHit.setCheckIndex(checkIndex);
                    rHit.setHitIndex(hitIndex);
                    List<List<String>> haStringsValues = rHit.getAnnotationStringsValues();
                    int annotationIndex = -1;
                    int listIndex = -1;
                    for (List<String> listOfValues : haStringsValues) {
                        ++listIndex;
                        annotationIndex = -1;
                        for (String value3 : listOfValues) {
                            ArrayList list = new ArrayList((Collection)haStrings.get(listIndex));
                            rHit.setAnnotationStringIndex(listIndex, ++annotationIndex, list.indexOf(value3));
                        }
                    }
                    if (mappingResult.isUnmappedB(rHit.getFile()) || filesList.indexOf(rHit.getFile()) != -1) {
                        rHit.setIndexPath(filesList.indexOf(rHit.getFile()));
                    } else {
                        rHit.setIndexPath(filesList.indexOf(mappingResult.getA(rHit.getFile())));
                    }
                    result.addHit(rHit);
                    ++hitIndex;
                }
                checkWrapper.setCategoryIndex(categoryIndex);
                result.addCheck(checkWrapper);
                ++checkIndex;
            }
            result.addCategory(catWrapper);
            ++categoryIndex;
        }
        result.setSourcesLocations(currentReport.getSourcesLocations());
        result.setMaxSourceCode(newMax);
        newMax = 0;
        return result;
    }

    public static void updateHitsLocationsFirstReport(RHit hit, RReport report) {
        Map<Integer, String> sourcesLocations = report.getSourcesLocations();
        for (Integer hitResource : hit.getHitSources()) {
            if (sourcesLocations.containsKey(0)) continue;
            int location = hitResource;
            sourcesLocations.put(0, report.getLocation() == null ? "" : String.valueOf(report.getLocation()) + "/code/" + location);
        }
    }

    public static void updateHitsLocationsSecondReport(RHit hit, RReport refReport, RReport report) {
        Map<Integer, String> sourcesLocations = refReport.getSourcesLocations();
        int it = 1;
        for (Integer hitResource : hit.getHitSources()) {
            sourcesLocations.put(refReport.getMaxSourceCode() + it, String.valueOf(report.getLocation()) + "/code/" + hitResource);
            newMax = refReport.getMaxSourceCode() + it;
            ++it;
        }
    }

    public static void updateCategoryHitsToGlobalModel(RCategory category, Map<String, Set<String>> hitAdnotationsNewModel, RReport refReport, RReport report) {
        Set<RCheck> checks = category.getChecks();
        for (RCheck rCheck : checks) {
            HTML5ReportMergerCommon.updateCheckHitsToGlobalModel(rCheck, hitAdnotationsNewModel, refReport, report);
        }
    }

    public static void updateCheckHitsToGlobalModel(RCheck check, Map<String, Set<String>> hitAdnotationsNewModel, RReport refReport, RReport report) {
        Set<RHit> hits = check.getHits();
        for (RHit hit : hits) {
            Map<String, Set<String>> adnotationsToList = HTML5ReportMergerCommon.convertAdnotationsToList(hit, report);
            HTML5ReportMergerCommon.updateAdnotationsToGlobalModel(hitAdnotationsNewModel, report, hit, adnotationsToList);
            int size = hit.getAnnotationStringsValues().size();
            hit.initAnnotationStringIndex(size);
            if (refReport.equals(report)) {
                HTML5ReportMergerCommon.updateHitsLocationsFirstReport(hit, report);
                continue;
            }
            HTML5ReportMergerCommon.updateHitsLocationsSecondReport(hit, refReport, report);
            HTML5ReportMergerCommon.updateHits(hit, refReport.getMaxSourceCode());
        }
    }

    public static Map<String, Set<String>> convertAdnotationsToList(RHit hit, RReport report) {
        ArrayList<Set<String>> hitAdnotations = new ArrayList<Set<String>>();
        for (List<String> adnotationValue : hit.getAnnotationStringsValues()) {
            hitAdnotations.add(new LinkedHashSet<String>(adnotationValue));
        }
        return HTML5ReportMergerCommon.getInfoToValuesMap(report.getAnnotationInfos(), hitAdnotations);
    }

    public static void mergeHits(Map<String, Set<String>> model, RReport r1, RReport r2, RHit h1, RHit h2) {
        if (h1 == null || h2 == null) {
            return;
        }
        Map<String, Set<String>> adnotationsToList = HTML5ReportMergerCommon.convertAdnotationsToList(h1, r1);
        for (Map.Entry<String, Set<String>> entry : HTML5ReportMergerCommon.convertAdnotationsToList(h2, r2).entrySet()) {
            String title = entry.getKey();
            Set<String> locations = entry.getValue();
            if (adnotationsToList.containsKey(title)) {
                adnotationsToList.get(title).addAll(locations);
                continue;
            }
            adnotationsToList.put(title, locations);
        }
        HTML5ReportMergerCommon.updateAdnotationsToGlobalModel(model, r1, h1, adnotationsToList);
        HTML5ReportMergerCommon.updateHits(h1, h2, r1.getMaxSourceCode());
    }

    private static void updateHits(RHit h1, RHit h2, int maxSourceCode) {
        List<Integer> hitSources = h2.getHitSources();
        int i = 1;
        for (Integer hitSource : hitSources) {
            h1.addHitSources(hitSource + maxSourceCode + i);
            ++i;
        }
    }

    private static void updateHits(RHit h2, int maxSourceCode) {
        int i = 1;
        List<Integer> hitSources = h2.getHitSources();
        ListIterator<Integer> iterator = hitSources.listIterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.set(maxSourceCode + i);
            ++i;
        }
    }

    public static void updateAdnotationsToGlobalModel(Map<String, Set<String>> model, RReport report, RHit hit, Map<String, Set<String>> adnotationsMap) {
        for (Map.Entry<String, Set<String>> entrySet : model.entrySet()) {
            entrySet.getValue().clear();
        }
        for (Map.Entry<String, Set<String>> entry : adnotationsMap.entrySet()) {
            String title = entry.getKey();
            Set<String> locations = entry.getValue();
            if (model.containsKey(title)) {
                model.get(title).addAll(locations);
                continue;
            }
            model.put(title, locations);
        }
        hit.clearAnnotationValues();
        for (Map.Entry<String, Set<String>> entrySet : model.entrySet()) {
            hit.addAnnotationStringsValues(new ArrayList<String>((Collection)entrySet.getValue()));
        }
    }

    public static Map<String, Set<String>> getInfoToValuesMap(List<AnnotationResults.AnnotationInfo> haInfos_1, List<Set<String>> haStrings_1) {
        int counter = 0;
        LinkedHashMap<String, Set<String>> infoToValuesMap = new LinkedHashMap<String, Set<String>>();
        if (haInfos_1 == null) {
            return infoToValuesMap;
        }
        for (AnnotationResults.AnnotationInfo entry : haInfos_1) {
            String title = entry.getTitle();
            if (!haStrings_1.isEmpty()) {
                infoToValuesMap.put(title, haStrings_1.get(counter));
            }
            ++counter;
        }
        return infoToValuesMap;
    }

    public static IProgressMonitor subprogressMonitorSuplier(IProgressMonitor monitor, int work) {
        return monitor;
    }

    private static RReport diff(RReport report1, RReport report2, PathMapper.Result mappingResult, boolean isReverseDiff) throws LicenseUnavailableException {
        newMax = report1.getMaxSourceCode();
        RReport result = new RReport();
        List<AnnotationResults.AnnotationInfo> haInfos_1 = report1.getAnnotationInfos();
        result.setAnnotationInfos(haInfos_1);
        List<Set<String>> haStrings_1 = report1.getAnnotationStrings();
        Map<String, Set<String>> infoToValuesMap_1 = HTML5ReportMergerCommon.getInfoToValuesMap(haInfos_1, haStrings_1);
        LinkedHashMap<String, Set<String>> resultInfoToValuesMap = new LinkedHashMap<String, Set<String>>(infoToValuesMap_1);
        LinkedHashMap<String, Set<String>> hitAdnotationsNewModel = new LinkedHashMap<String, Set<String>>(resultInfoToValuesMap);
        hitAdnotationsNewModel.replaceAll((k, v) -> new LinkedHashSet());
        ArrayList<Set<String>> haStrings = new ArrayList<Set<String>>();
        Set entrySet2 = resultInfoToValuesMap.entrySet();
        for (Map.Entry entry : entrySet2) {
            haStrings.add((Set)entry.getValue());
        }
        result.setAnnotationStrings(haStrings);
        RInfo infoWrapper1 = report1.getInfoWrapper();
        RInfo infoWrapper2 = report2.getInfoWrapper();
        infoWrapper1.setNofCompiledLines(infoWrapper1.getNofCompiledLines() - infoWrapper2.getNofCompiledLines());
        infoWrapper1.setLintRunTime(infoWrapper1.getLintRunTime() - infoWrapper2.getLintRunTime());
        infoWrapper1.setBuildRunTime(infoWrapper1.getBuildRunTime() - infoWrapper2.getBuildRunTime());
        infoWrapper1.setLicenseWaitTime(infoWrapper1.getLicenseWaitTime() - infoWrapper2.getLicenseWaitTime());
        result.setInfoWrapper(infoWrapper1);
        List<RCategory> categories1 = report1.getCategories();
        List<RCategory> categories2 = report2.getCategories();
        for (RCategory rCategory : categories1) {
            HTML5ReportMergerCommon.updateCategoryHitsToGlobalModel(rCategory, hitAdnotationsNewModel, report1, report1);
        }
        for (RCategory rCategory : categories2) {
            for (RCheck check : rCategory.getChecks()) {
                for (RHit hit : check.getHits()) {
                    HTML5ReportMergerCommon.updateHitsLocationsFirstReport(hit, report2);
                }
            }
        }
        LinkedHashMap categoriesOfResultReport = categories1.stream().collect(Collectors.toMap(RCategory::getSelf, RCategory::getChecks, (e1, e2) -> e1, LinkedHashMap::new));
        ReportDiffer differ = new ReportDiffer(report1, report2, mappingResult, isReverseDiff);
        for (RCategory categoryOfSecondReport : categories2) {
            Object check12;
            if (!categoriesOfResultReport.containsKey(categoryOfSecondReport)) continue;
            Set checksOfFirstReport = (Set)categoriesOfResultReport.get(categoryOfSecondReport);
            Set<RCheck> checksOfSecondReport = categoryOfSecondReport.getChecks();
            Iterator iterator = checksOfSecondReport.iterator();
            block6: while (iterator.hasNext()) {
                RCheck check2 = (RCheck)iterator.next();
                if (!checksOfFirstReport.contains(check2)) continue;
                for (Object check12 : checksOfFirstReport) {
                    if (!((RCheck)check12).equals(check2)) continue;
                    ((RCheck)check12).setRunTime(((RCheck)check12).getRunTime() - check2.getRunTime());
                    continue block6;
                }
            }
            LinkedHashMap checksOfFirstReportMap = checksOfFirstReport.stream().collect(Collectors.toMap(RCheck::getSelf, RCheck::getHits, (e1, e2) -> e1, LinkedHashMap::new));
            check12 = checksOfSecondReport.iterator();
            while (check12.hasNext()) {
                RCheck checkOfSecondReport = (RCheck)check12.next();
                if (!DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74"})) {
                    throw new LicenseUnavailableException();
                }
                if (!checksOfFirstReportMap.containsKey(checkOfSecondReport)) continue;
                Set hitsOfFirstReport = (Set)checksOfFirstReportMap.get(checkOfSecondReport);
                Set<RHit> hitsOfSecondReport = checkOfSecondReport.getHits();
                LinkedHashSet hitsOfMergedReport = new LinkedHashSet(hitsOfFirstReport);
                HashSet<RHit> commonHits = new HashSet<RHit>();
                for (RHit hitOfMergedReport : hitsOfMergedReport) {
                    String file = hitOfMergedReport.getFile();
                    Patch<String> filePatch = differ.computeFilePatch(file);
                    if (filePatch != null) {
                        int line = hitOfMergedReport.getHitLine();
                        VerissimoDiffer.Range offsetRange = differ.computeLineMapping(file, line);
                        Iterator<RHit> iterator2 = hitsOfSecondReport.iterator();
                        while (iterator2.hasNext()) {
                            RHit hitOfSecondReport = iterator2.next();
                            if (!differ.areFilesEqual(file, hitOfSecondReport.getFile()) || !offsetRange.contains(hitOfSecondReport.getHitLine()) || !HTML5ReportMergerCommon.compareHits(hitOfMergedReport, hitOfSecondReport, -1, report1.getAllImportedFiles(), report1.getFiles(), differ)) continue;
                            commonHits.add(hitOfMergedReport);
                        }
                        continue;
                    }
                    commonHits.add(hitOfMergedReport);
                }
                hitsOfMergedReport.removeAll(commonHits);
                checksOfFirstReportMap.put(checkOfSecondReport, hitsOfMergedReport);
            }
            LinkedHashSet<RCheck> resultSet = new LinkedHashSet<RCheck>();
            Set entrySet = checksOfFirstReportMap.entrySet();
            for (Map.Entry entry : entrySet) {
                RCheck key = (RCheck)entry.getKey();
                Set value = (Set)entry.getValue();
                key.setHits(value);
                resultSet.add(key);
            }
            categoriesOfResultReport.put(categoryOfSecondReport, resultSet);
        }
        Set<String> files1 = report1.getFiles();
        result.setFiles(files1);
        Set<String> allFiles1 = report1.getAllImportedFiles();
        for (String file : allFiles1) {
            result.putFileHash(file, "");
        }
        LinkedHashMap<String, Set<RCheck>> preWaivedFilesForChecksMapInFirstReport = report1.getPrewaivedFilesForChecks();
        result.setPrewaivedFilesForChecks(preWaivedFilesForChecksMapInFirstReport);
        int categoryIndex = 0;
        int checkIndex = 0;
        int hitIndex = 0;
        Set<String> files = result.getFiles();
        ArrayList<String> filesList = new ArrayList<String>(files);
        Set entrySet = categoriesOfResultReport.entrySet();
        for (Map.Entry entry : entrySet) {
            RCategory category = (RCategory)entry.getKey();
            Set checksSet = (Set)entry.getValue();
            RCategory catWrapper = new RCategory(category.getName(), category.getDescription(), categoryIndex);
            for (RCheck checkWrapper : checksSet) {
                checkWrapper.setCheckIndex(checkIndex);
                catWrapper.addCheck(checkWrapper);
                Set<RHit> hits = checkWrapper.getHits();
                for (RHit hitWrapper : hits) {
                    hitWrapper.setCheckIndex(checkIndex);
                    hitWrapper.setHitIndex(hitIndex);
                    List<List<String>> haStringsValues = hitWrapper.getAnnotationStringsValues();
                    int annotationIndex = -1;
                    int listIndex = -1;
                    for (List<String> listOfValues : haStringsValues) {
                        ++listIndex;
                        annotationIndex = -1;
                        for (String value : listOfValues) {
                            ArrayList list = new ArrayList((Collection)haStrings.get(listIndex));
                            hitWrapper.setAnnotationStringIndex(listIndex, ++annotationIndex, list.indexOf(value));
                        }
                    }
                    List<RHit.MacroPathWrapper> macroParts = hitWrapper.getMacroParts();
                    for (RHit.MacroPathWrapper macroPathWrapper : macroParts) {
                        int index = filesList.indexOf(hitWrapper.getFile()) == -1 ? 0 : filesList.indexOf(hitWrapper.getFile());
                        macroPathWrapper.setIndex(index);
                    }
                    hitWrapper.setIndexPath(filesList.indexOf(hitWrapper.getFile()));
                    result.addHit(hitWrapper);
                    ++hitIndex;
                }
                checkWrapper.setCategoryIndex(categoryIndex);
                result.addCheck(checkWrapper);
                ++checkIndex;
            }
            result.addCategory(catWrapper);
            ++categoryIndex;
        }
        result.setSourcesLocations(report1.getSourcesLocations());
        result.setMaxSourceCode(newMax);
        newMax = 0;
        return result;
    }

    private static boolean compareHits(RHit h1, RHit h2, int hitLine, Set<String> filesInOrder, Set<String> files, ReportDiffer differ) {
        if (h1.getClass() != h2.getClass()) {
            return false;
        }
        if (h1.getFile() == null ? h2.getFile() != null : !differ.areFilesEqual(h1.getFile(), h2.getFile())) {
            return false;
        }
        if (h1.getHitDetails() == null ? h2.getHitDetails() != null : !HTML5ReportMergerCommon.compareDetailsLinkWrapper(h1, h2, filesInOrder, files, differ)) {
            return false;
        }
        if (hitLine != -1 && hitLine != h2.getHitLine()) {
            return false;
        }
        return !(h1.getMacroParts() == null ? h2.getMacroParts() != null : !HTML5ReportMergerCommon.compareMacroParts(h1, h2, differ));
    }

    private static boolean compareDetailsLinkWrapper(RHit h1, RHit h2, Set<String> filesInOrder, Set<String> files, ReportDiffer differ) {
        RHit.DetailsLinkWrapper link2;
        RHit.DetailsLinkWrapper link1;
        List<RHit.DetailsLinkWrapper> detailsLinkWrappers1 = h1.getDetailsLinks();
        List<RHit.DetailsLinkWrapper> detailsLinkWrappers2 = h2.getDetailsLinks();
        if (detailsLinkWrappers1.size() != detailsLinkWrappers2.size()) {
            return false;
        }
        StringBuilder sb1 = new StringBuilder(h1.getHitDetails());
        StringBuilder sb2 = new StringBuilder(h2.getHitDetails());
        int i = detailsLinkWrappers1.size() - 1;
        while (i >= 0) {
            link1 = detailsLinkWrappers1.get(i);
            link2 = detailsLinkWrappers2.get(i);
            sb1.replace(link1.getOffset(), link1.getOffset() + link1.getLength(), "");
            sb2.replace(link2.getOffset(), link2.getOffset() + link2.getLength(), "");
            --i;
        }
        if (!sb1.toString().equals(sb2.toString())) {
            return false;
        }
        i = 0;
        while (i < detailsLinkWrappers1.size()) {
            int line;
            VerissimoDiffer.Range offsetRange;
            link1 = detailsLinkWrappers1.get(i);
            link2 = detailsLinkWrappers2.get(i);
            ArrayList<String> stringsList = new ArrayList<String>(files);
            String file = (String)stringsList.get(link1.getIndex());
            String filePath = null;
            for (String fullPath : filesInOrder) {
                if (!fullPath.contains(file)) continue;
                filePath = fullPath;
                break;
            }
            Patch<String> filePatch = differ.computeFilePatch(filePath);
            if (filePath != null && filePatch != null && !(offsetRange = differ.computeLineMapping(filePath, line = Integer.parseInt(link1.getLine()))).contains(Integer.valueOf(link2.getLine()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean compareMacroParts(RHit h1, RHit h2, ReportDiffer differ) {
        List<RHit.MacroPathWrapper> macroParts1 = h1.getMacroParts();
        List<RHit.MacroPathWrapper> macroParts2 = h2.getMacroParts();
        if (macroParts1.size() != macroParts2.size()) {
            return false;
        }
        int i = 0;
        while (i < macroParts1.size()) {
            RHit.MacroPathWrapper macroPart1 = macroParts1.get(i);
            RHit.MacroPathWrapper macroPart2 = macroParts2.get(i);
            if (!macroPart1.getMacroName().equals(macroPart2.getMacroName())) {
                return false;
            }
            if (!differ.areFilesEqual(macroPart1.getFile(), macroPart2.getFile())) {
                return false;
            }
            Patch<String> filePatch = differ.computeFilePatch(macroPart1.getFile());
            if (filePatch != null) {
                int line = Integer.parseInt(macroPart1.getLine());
                VerissimoDiffer.Range offsetRange = differ.computeLineMapping(macroPart1.getFile(), line);
                if (!offsetRange.contains(Integer.parseInt(macroPart2.getLine()))) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public static void markCompareFailures(RReport currentReport, RReport baselineReport, PathMapper.Result mappingResult) throws LicenseUnavailableException {
        ReportDiffer differ = new ReportDiffer(currentReport, baselineReport, mappingResult, false);
        List<RCategory> currentCategories = currentReport.getCategories();
        List<RCategory> baselineCategories = baselineReport.getCategories();
        for (RCategory rCategory : currentCategories) {
            for (RCheck check : rCategory.getChecks()) {
                for (RHit rHit : check.getHits()) {
                    HTML5ReportMergerCommon.updateHitsLocationsFirstReport(rHit, currentReport);
                }
            }
        }
        for (RCategory rCategory : baselineCategories) {
            for (RCheck check : rCategory.getChecks()) {
                for (RHit rHit : check.getHits()) {
                    HTML5ReportMergerCommon.updateHitsLocationsFirstReport(rHit, baselineReport);
                }
            }
        }
        List<RCheck> currentChecks = currentReport.getChecks();
        List<RCheck> baselineChecks = baselineReport.getChecks();
        ArrayList<RCheck> addedChecks = new ArrayList<RCheck>();
        addedChecks.addAll(currentChecks);
        addedChecks.removeAll(baselineChecks);
        for (RCheck check : addedChecks) {
            check.addCompareAnnotation("Added Checks");
        }
        ArrayList<RCheck> removedChecks = new ArrayList<RCheck>();
        removedChecks.addAll(baselineChecks);
        removedChecks.removeAll(currentChecks);
        for (RCheck rCheck : removedChecks) {
            rCheck.addCompareAnnotation("Removed Checks");
        }
        HashSet<RHit> hashSet = new HashSet<RHit>();
        HashSet<RHit> baselineReportMappedHits = new HashSet<RHit>();
        LinkedHashMap baselineChecksMap = baselineChecks.stream().collect(Collectors.toMap(RCheck::getSelf, RCheck::getHits, (e1, e2) -> e1, LinkedHashMap::new));
        for (RCheck check : currentChecks) {
            Set<RHit> currentHits;
            baselineReportMappedHits.clear();
            if (!DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74"})) {
                throw new LicenseUnavailableException();
            }
            if (baselineChecksMap.containsKey(check)) {
                check.addCompareAnnotation("Common");
                currentHits = check.getHits();
                Set baselineHits = (Set)baselineChecksMap.get(check);
                Map mapFileToBaselineHits = baselineHits.stream().collect(Collectors.groupingBy(RHit::getFile, Collectors.groupingBy(RHit::getHitLine, Collectors.mapping(RHit::getSelf, Collectors.toList()))));
                for (RHit currentHit : currentHits) {
                    String currentFile = currentHit.getFile();
                    String baselineFile = differ.getMappedFile(currentFile);
                    Patch<String> filePatch = differ.computeFilePatch(currentFile);
                    boolean foundCommon = false;
                    if (baselineFile != null && filePatch != null && mapFileToBaselineHits.containsKey(baselineFile)) {
                        int line = currentHit.getHitLine();
                        Map fileBaselineHits = (Map)mapFileToBaselineHits.get(baselineFile);
                        VerissimoDiffer.Range linesDifferenceRange = differ.computeLineMapping(currentFile, line);
                        int baselineLine = linesDifferenceRange.min;
                        while (baselineLine <= linesDifferenceRange.max) {
                            if (fileBaselineHits.containsKey(baselineLine)) {
                                for (RHit baselineHit : (List)fileBaselineHits.get(baselineLine)) {
                                    if (!HTML5ReportMergerCommon.compareHits(currentHit, baselineHit, -1, currentReport.getAllImportedFiles(), currentReport.getFiles(), differ) || baselineReportMappedHits.contains(baselineHit)) continue;
                                    foundCommon = true;
                                    if (currentHit.getSeverity() != CheckStatus.DISABLED && baselineHit.getSeverity() == CheckStatus.DISABLED) {
                                        currentHit.addCompareAnnotation("New Failures");
                                    } else if (currentHit.getSeverity() == CheckStatus.DISABLED && baselineHit.getSeverity() != CheckStatus.DISABLED) {
                                        if (baselineHit.isHiddenCompare()) {
                                            currentHit.addCompareAnnotation("Hidden");
                                        } else {
                                            currentHit.addCompareAnnotation("New Fixes");
                                        }
                                    } else {
                                        currentHit.addCompareAnnotation("Common");
                                    }
                                    currentHit.setCompareModifiedStatus(baselineHit.getHitSeverity());
                                    baselineReportMappedHits.add(baselineHit);
                                    break;
                                }
                            }
                            ++baselineLine;
                        }
                    }
                    if (!foundCommon && currentHit.getSeverity() != CheckStatus.DISABLED) {
                        currentHit.addCompareAnnotation("New Failures");
                    }
                    if (foundCommon || currentHit.getSeverity() != CheckStatus.DISABLED) continue;
                    currentHit.addCompareAnnotation("Common");
                }
                continue;
            }
            currentHits = check.getHits();
            for (RHit currentHit : currentHits) {
                if (currentHit.getSeverity() != CheckStatus.DISABLED) {
                    currentHit.addCompareAnnotation("Added Rules");
                    continue;
                }
                currentHit.addCompareAnnotation("Common");
            }
        }
        ReportDiffer reverseDiffer = new ReportDiffer(baselineReport, currentReport, mappingResult, true);
        LinkedHashMap currentChecksMap = currentChecks.stream().collect(Collectors.toMap(RCheck::getSelf, RCheck::getHits, (e1, e2) -> e1, LinkedHashMap::new));
        for (RCheck check : baselineChecks) {
            Set<RHit> baselineHits;
            hashSet.clear();
            if (!DVTSplashMLT.INSTANCE.cc(new String[]{"F73765F6C696E74"})) {
                throw new LicenseUnavailableException();
            }
            if (currentChecksMap.containsKey(check)) {
                check.addCompareAnnotation("Common");
                baselineHits = check.getHits();
                Set currentHits = (Set)currentChecksMap.get(check);
                Map mapFileToCurrentHits = currentHits.stream().collect(Collectors.groupingBy(RHit::getFile, Collectors.groupingBy(RHit::getHitLine, Collectors.mapping(RHit::getSelf, Collectors.toList()))));
                for (RHit baselineHit : baselineHits) {
                    String baselineFile = baselineHit.getFile();
                    String currentFile = reverseDiffer.getMappedFile(baselineFile);
                    Patch<String> filePatch = reverseDiffer.computeFilePatch(baselineFile);
                    boolean foundCommon = false;
                    if (currentFile != null && filePatch != null && mapFileToCurrentHits.containsKey(currentFile)) {
                        int line = baselineHit.getHitLine();
                        Map fileCurrentHits = mapFileToCurrentHits.get(currentFile);
                        VerissimoDiffer.Range offsetRange = reverseDiffer.computeLineMapping(baselineFile, line);
                        int currentLine = offsetRange.min;
                        while (currentLine <= offsetRange.max) {
                            if (fileCurrentHits.containsKey(currentLine)) {
                                for (RHit currentHit : fileCurrentHits.get(currentLine)) {
                                    if (!HTML5ReportMergerCommon.compareHits(baselineHit, currentHit, -1, baselineReport.getAllImportedFiles(), baselineReport.getFiles(), reverseDiffer) || hashSet.contains(currentHit)) continue;
                                    foundCommon = true;
                                    if (currentHit.getSeverity() != CheckStatus.DISABLED && baselineHit.getSeverity() == CheckStatus.DISABLED) {
                                        baselineHit.addCompareAnnotation("New Failures");
                                    } else if (currentHit.getSeverity() == CheckStatus.DISABLED && baselineHit.getSeverity() != CheckStatus.DISABLED) {
                                        if (baselineHit.isHiddenCompare()) {
                                            baselineHit.addCompareAnnotation("Hidden");
                                        } else {
                                            baselineHit.addCompareAnnotation("New Fixes");
                                        }
                                    } else {
                                        baselineHit.addCompareAnnotation("Common");
                                    }
                                    baselineHit.setCompareModifiedStatus(currentHit.getHitSeverity());
                                    hashSet.add(currentHit);
                                    break;
                                }
                            }
                            ++currentLine;
                        }
                    }
                    if (!foundCommon && baselineHit.getSeverity() != CheckStatus.DISABLED) {
                        if (baselineHit.isHiddenCompare()) {
                            baselineHit.addCompareAnnotation("Hidden");
                        } else {
                            baselineHit.addCompareAnnotation("New Fixes");
                        }
                    }
                    if (foundCommon || baselineHit.getSeverity() != CheckStatus.DISABLED) continue;
                    baselineHit.addCompareAnnotation("Common");
                }
                continue;
            }
            baselineHits = check.getHits();
            for (RHit baselineHit : baselineHits) {
                if (baselineHit.getSeverity() != CheckStatus.DISABLED) {
                    baselineHit.addCompareAnnotation("Removed Rules");
                    continue;
                }
                baselineHit.addCompareAnnotation("Common");
            }
        }
    }

    public static RReport compareReportsWithMapping(RReport currentReport, RReport baselineReport, List<String> mappings) {
        try {
            List<String> noneFile = Arrays.asList("none");
            PathMapper.Result mappingResult = PathMapper.map(currentReport.getFiles().contains("none") ? (Collection)Stream.concat(currentReport.getAllImportedFiles().stream(), noneFile.stream()).collect(Collectors.toList()) : currentReport.getAllImportedFiles(), baselineReport.getFiles().contains("none") ? (Collection)Stream.concat(baselineReport.getAllImportedFiles().stream(), noneFile.stream()).collect(Collectors.toList()) : baselineReport.getAllImportedFiles(), mappings);
            for (RCategory category : currentReport.getCategories()) {
                for (RCheck check : category.getChecks()) {
                    for (RHit hit : check.getHits()) {
                        hit.setCompareHitOrigin("Current");
                    }
                }
            }
            for (RCategory category : baselineReport.getCategories()) {
                for (RCheck check : category.getChecks()) {
                    for (RHit hit : check.getHits()) {
                        hit.setCompareHitOrigin("Baseline");
                    }
                }
            }
            HTML5ReportMergerCommon.markCompareFailures(currentReport, baselineReport, mappingResult);
            RReport compareReport = HTML5ReportMergerCommon.merge(currentReport, baselineReport, true, mappingResult);
            compareReport.setBaselineReportLocation(baselineReport.getBaselineReportLocation() == null || baselineReport.getBaselineReportLocation().isEmpty() ? baselineReport.getLocation() : baselineReport.getBaselineReportLocation());
            compareReport.getInfoWrapper().setCompareReport(true);
            LinkedHashMap<String, String> allBaselineHashMap = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> allFilesWithBaselineFilesMap = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> allFilesHashMap : baselineReport.getAllFilesHashesMap().entrySet()) {
                if (mappingResult.isUnmappedB(allFilesHashMap.getKey()) || mappingResult.getA(allFilesHashMap.getKey()) == null) continue;
                allBaselineHashMap.put(allFilesHashMap.getKey(), allFilesHashMap.getValue());
                allFilesWithBaselineFilesMap.put(mappingResult.getA(allFilesHashMap.getKey()), allFilesHashMap.getKey());
            }
            compareReport.setAllBaselineFilesHashesMap(allBaselineHashMap);
            compareReport.setAllFilesWithBaselineFilesMap(allFilesWithBaselineFilesMap);
            compareReport.setPaths(currentReport.getPaths());
            return compareReport;
        }
        catch (LicenseUnavailableException licenseUnavailableException) {
            DVTLogger.INSTANCE.logError("ERROR: No available license.");
            return null;
        }
    }

    public static class ReportDiffer
    extends VerissimoDiffer {
        private RReport report1;
        private RReport report2;

        public ReportDiffer(RReport report1, RReport report2, PathMapper.Result mappingResult, boolean isReverseDiffer) {
            super(mappingResult, isReverseDiffer);
            this.report1 = report1;
            this.report2 = report2;
        }

        private Patch<String> computeFilePatch(String file) {
            Patch patch = (Patch)this.patchesByFile.get(file);
            if (patch != null) {
                return patch;
            }
            try {
                String sourceLocations1 = this.report1.getSourcesLocations().get(0).isEmpty() ? file : String.valueOf(this.report1.getSourcesLocations().get(0)) + File.separator + file + ".html";
                File file1 = new File(sourceLocations1);
                File file2 = null;
                String sourceLocations2 = this.report2.getSourcesLocations().get(0);
                file2 = this.isReverseDiffer ? (this.mappingResult.isUnmappedB(file) ? new File(sourceLocations2 == null || sourceLocations2.isEmpty() ? file : String.valueOf(sourceLocations2) + File.separator + file + ".html") : new File(sourceLocations2 == null || sourceLocations2.isEmpty() ? this.mappingResult.getA(file) : String.valueOf(sourceLocations2) + File.separator + this.mappingResult.getA(file) + ".html")) : (this.mappingResult.isUnmappedA(file) ? new File(sourceLocations2 == null || sourceLocations2.isEmpty() ? file : String.valueOf(sourceLocations2) + File.separator + file + ".html") : new File(sourceLocations2 == null || sourceLocations2.isEmpty() ? this.mappingResult.getB(file) : String.valueOf(sourceLocations2) + File.separator + this.mappingResult.getB(file) + ".html"));
                patch = DiffUtils.diff(this.collectFileLines(file1), this.collectFileLines(file2));
                this.patchesByFile.put(file, patch);
            }
            catch (Exception exception) {}
            return patch;
        }

        private List<String> collectFileLines(File file) {
            List<String> fileLines = Collections.emptyList();
            boolean isHTML = "html".equals(FilenameUtils.getExtension((String)file.getName()));
            if (file.canRead()) {
                try {
                    String fileContent = FileUtils.readFileToString((File)file);
                    if (isHTML) {
                        String firstAnchor = "<code class=\"source verilog\">";
                        String lastAnchor = "</code>";
                        int start = fileContent.indexOf(firstAnchor);
                        int end = fileContent.lastIndexOf(lastAnchor);
                        if (start != -1 && end != -1) {
                            fileContent = VerissimoReportReader.unescapeHTML(fileContent.substring(start + firstAnchor.length(), end));
                        }
                    }
                    fileLines = Arrays.asList(fileContent.split(System.lineSeparator(), -1)).stream().map(String::trim).collect(Collectors.toList());
                }
                catch (IOException iOException) {}
            }
            return fileLines;
        }

        @Override
        public boolean areFilesEqual(String file1, String file2) {
            if (file1 == null || file2 == null) {
                return false;
            }
            if (!this.isReverseDiffer) {
                return file1.equals(this.mappingResult.getA(file2));
            }
            return file1.equals(this.mappingResult.getB(file2));
        }

        @Override
        public String getMappedFile(String file) {
            return !this.isReverseDiffer ? this.mappingResult.getB(file) : this.mappingResult.getA(file);
        }
    }
}

