/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTUpdatePersistentJob;
import ro.amiq.dvt.linter.ILintingListener;
import ro.amiq.dvt.model.floatingwidgets.FLintingManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.ILintingBuildListener;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.SingleFileLintingBuilder;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;

public class LintingProblemsManager
implements ILintingBuildListener {
    private static final String MESSAGE_FORMAT = "[{0}] {1}";
    private static final String SHORTCUT_FOR_MESSAGE = " [Right click to show check]";
    public static final String ERROR_MARKER_ID = "ro.amiq.vlogdt.LintingErrorMarker";
    public static final String WARNING_MARKER_ID = "ro.amiq.vlogdt.LintingWarningMarker";
    public static final String INFO_MARKER_ID = "ro.amiq.vlogdt.LintingInfoMarker";
    public static final String CHECK_NAME_ATTRIBUTE = "ro.amiq.vlogdt.linter.ui.LintingProblemsManager.CheckNameAttribute";
    public static final String HIT_ATTRIBUTE = "ro.amiq.vlogdt.linter.ui.LintingProblemsManager.HitAttribute";
    public static final String PROJECT_NAME_ATTRIBUTE = "ro.amiq.vlogdt.linter.ui.LintingProblemsManager.ProjectNameAttribute";
    public static final String IMPLEMENTED_AUTOFIX_ATTRIBUTE = "ro.amiq.vlogdt.linter.ui.LintingProblemsManager.ImplementedAutofixAttribute";
    public static final Set<String> LINTING_MARKERS = new HashSet<String>(Arrays.asList("ro.amiq.vlogdt.LintingErrorMarker", "ro.amiq.vlogdt.LintingWarningMarker", "ro.amiq.vlogdt.LintingInfoMarker"));
    public static final int MAX_MARKERS_PER_LINT_REPORT = new Boolean(System.getenv("VERISSIMO_DISABLE_MAX_LINTING_MARKERS")) != false ? Integer.MAX_VALUE : 4999;
    public static final int MAX_MARKERS_PER_FILE = new Boolean(System.getenv("VERISSIMO_DISABLE_MAX_LINTING_MARKERS")) != false ? Integer.MAX_VALUE : 499;
    private Map<String, Integer> nofLintMarkers = new HashMap<String, Integer>();
    private Map<String, Map<String, Integer>> nofLintMarkersPerFile = new HashMap<String, Map<String, Integer>>();
    private Map<ParserPath, Set<OVMComplianceCheckHit>> parserPathToHitsMap = new HashMap<ParserPath, Set<OVMComplianceCheckHit>>();
    private final ConcurrentLinkedQueue<Runnable> fUpdateQueue = new ConcurrentLinkedQueue();
    private final Job fUpdateJob = new DVTUpdatePersistentJob("Update linting markers", this.fUpdateQueue);
    private static volatile LintingProblemsManager fInstance;
    private static final Object fSyncInstance;
    private final String GLUE = "__#__";

    static {
        fSyncInstance = new Object();
    }

    private LintingProblemsManager() {
        this.fUpdateJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LintingProblemsManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new LintingProblemsManager();
            }
        }
        return fInstance;
    }

    public void startup() {
        OVMComplianceBuilder.getInstance().addListener(this);
        FLintingManager.setInstance((ILintingListener)LintingProblemsManager.getInstance());
    }

    public void shutdown() {
        OVMComplianceBuilder.getInstance().removeListener(this);
    }

    private void addHit(OVMComplianceCheckHit hit, IProject project) {
        if (hit.getSeverity() == CheckStatus.DISABLED || !hit.getCheck().isEnabled() || hit.isHidden() || hit.getCheck().getOVMProject().isChangesHidden(hit)) {
            return;
        }
        if (this.getNofLintMarkers(project) > MAX_MARKERS_PER_LINT_REPORT) {
            return;
        }
        ParserPath fileName = hit.getParserPath();
        IFile file = DVTFileUtils.getInstance().findProjectFile(project.getProject(), fileName.path);
        Object targetResource = file == null ? project : file;
        hit.getCheck().getOVMProject();
        try {
            Integer nofErrors = this.getNofLintMarkersPerFile(project, fileName);
            if (nofErrors > MAX_MARKERS_PER_FILE) {
                return;
            }
            int severity = this.translateSeverity(hit.getSeverity());
            IMarker marker = targetResource.createMarker(this.getMarkerId(severity));
            marker.setAttribute("lineNumber", hit.getLine());
            String markerMessage = MessageFormat.format(MESSAGE_FORMAT, hit.getCheck().getName(), hit.getDetails());
            markerMessage = String.valueOf(markerMessage) + SHORTCUT_FOR_MESSAGE;
            marker.setAttribute("message", (Object)markerMessage);
            marker.setAttribute("priority", 2);
            marker.setAttribute("severity", severity);
            marker.setAttribute("location", (Object)fileName);
            marker.setAttribute(CHECK_NAME_ATTRIBUTE, (Object)hit.getCheck().getName());
            marker.setAttribute(HIT_ATTRIBUTE, (Object)hit);
            marker.setAttribute(PROJECT_NAME_ATTRIBUTE, (Object)project.getName());
            boolean hasAutofix = VerissimoAutofixUtils.getInstance().hasAutofixImplemented(hit.getCheck());
            marker.setAttribute(IMPLEMENTED_AUTOFIX_ATTRIBUTE, hasAutofix);
            this.setNofLintMarkersPerFile(project, fileName.path, this.getNofLintMarkersPerFile(project, fileName) + 1);
            this.setNofLintMarkers(project, this.getNofLintMarkers(project) + 1);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String getMarkerId(int severity) {
        switch (severity) {
            case 2: {
                return ERROR_MARKER_ID;
            }
            case 1: {
                return WARNING_MARKER_ID;
            }
            case 0: {
                return INFO_MARKER_ID;
            }
        }
        return ERROR_MARKER_ID;
    }

    private int translateSeverity(CheckStatus severity) {
        if (severity == CheckStatus.ERROR) {
            return 2;
        }
        if (severity == CheckStatus.WARNING) {
            return 1;
        }
        if (severity == CheckStatus.INFO) {
            return 0;
        }
        return 2;
    }

    @Override
    public void preBuild(OVMProject ovmProject) {
    }

    @Override
    public void postBuild(OVMProject ovmProject) {
        this.clearMarkers(ovmProject.getProject());
        Runnable r = () -> {
            ArrayList<OVMComplianceCheck> allChecks = ovmProject.getChecks();
            for (OVMComplianceCheck check : allChecks) {
                ArrayList<OVMComplianceCheckHit> hits = check.getVisibleHits();
                for (OVMComplianceCheckHit hit : hits) {
                    this.addHitToParserPathMap(hit.getParserPath(), hit);
                    this.addHit(hit, ovmProject.getProject());
                }
            }
            this.updateOpenedFiles();
            ObjectionManager.getInstance().clear(Objection.LINT_DONE);
        };
        this.fUpdateQueue.offer(r);
    }

    public void clearMarkers(IProject project) {
        Runnable r = () -> {
            try {
                if (!project.isAccessible()) {
                    return;
                }
                this.deleteAttributesAndMarkers(project, ERROR_MARKER_ID);
                this.deleteAttributesAndMarkers(project, WARNING_MARKER_ID);
                this.deleteAttributesAndMarkers(project, INFO_MARKER_ID);
                this.nofLintMarkers.remove(project.getName());
                this.parserPathToHitsMap.clear();
                Map<String, Integer> markersPerFile = this.nofLintMarkersPerFile.get(project.getName());
                if (markersPerFile != null) {
                    markersPerFile.clear();
                }
                this.nofLintMarkersPerFile.remove(project.getName());
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        this.fUpdateQueue.offer(r);
    }

    private void deleteAttributesAndMarkers(IProject project, String markerId) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(markerId, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.setAttributes(null);
            marker.delete();
            ++n2;
        }
    }

    public void updateMarkersAfterWaivers(IProject project) {
        Runnable r = () -> {
            try {
                if (!project.isAccessible()) {
                    return;
                }
                this.updateExistingMarkers(project, ERROR_MARKER_ID);
                this.updateExistingMarkers(project, WARNING_MARKER_ID);
                this.updateExistingMarkers(project, INFO_MARKER_ID);
                OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(project);
                if (ovmProject.lintProject()) {
                    this.updateOpenedFiles();
                } else {
                    this.updateFile(SingleFileLintingBuilder.getInstance().getSelectedFile());
                }
                ObjectionManager.getInstance().clear(Objection.LINT_WAIVERS_APPLIED);
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        };
        this.fUpdateQueue.offer(r);
    }

    private void updateExistingMarkers(IProject project, String markerId) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(markerId, true, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            Object hitAttribute = marker.getAttribute(HIT_ATTRIBUTE);
            if (hitAttribute instanceof OVMComplianceCheckHit) {
                OVMComplianceCheckHit hit = (OVMComplianceCheckHit)hitAttribute;
                CheckStatus severity = hit.getSeverity();
                ParserPath path = hit.getParserPath();
                if (marker.getAttribute("severity", 0) != this.translateSeverity(severity) || !hit.getCheck().isEnabled()) {
                    marker.delete();
                    if (severity != CheckStatus.DISABLED && hit.getCheck().isEnabled() && !hit.isHidden()) {
                        this.addHit(hit, project);
                    } else {
                        this.setNofLintMarkersPerFile(project, path.path, this.getNofLintMarkersPerFile(project, path) - 1);
                        this.setNofLintMarkers(project, this.getNofLintMarkers(project) - 1);
                    }
                }
            }
            ++n2;
        }
    }

    public int getNofLintMarkers(IProject project) {
        Integer nofMarkers = this.nofLintMarkers.get(project.getName());
        if (nofMarkers == null) {
            return 0;
        }
        return nofMarkers;
    }

    public void setNofLintMarkers(IProject project, int nofMarkers) {
        this.nofLintMarkers.put(project.getName(), nofMarkers);
    }

    private Integer getNofLintMarkersPerFile(IProject project, ParserPath fileName) {
        Map<String, Integer> lintMarkersPerFile = this.nofLintMarkersPerFile.get(project.getName());
        if (lintMarkersPerFile == null) {
            return 0;
        }
        return lintMarkersPerFile.get(fileName.path) == null ? 0 : lintMarkersPerFile.get(fileName.path);
    }

    private void setNofLintMarkersPerFile(IProject project, String file, int nofMarkers) {
        Map<String, Integer> lintMarkersPerFile = this.nofLintMarkersPerFile.get(project.getName());
        if (lintMarkersPerFile == null) {
            lintMarkersPerFile = new HashMap<String, Integer>();
        }
        lintMarkersPerFile.put(file, nofMarkers);
        this.nofLintMarkersPerFile.put(project.getName(), lintMarkersPerFile);
    }

    protected void addHitToParserPathMap(ParserPath parserPath, OVMComplianceCheckHit hit) {
        Set<OVMComplianceCheckHit> hitsByParserPath = this.parserPathToHitsMap.get(parserPath);
        if (hitsByParserPath == null) {
            hitsByParserPath = new HashSet<OVMComplianceCheckHit>();
        }
        hitsByParserPath.add(hit);
        this.parserPathToHitsMap.put(parserPath, hitsByParserPath);
    }

    public void updateFile(IFile currentFile) {
        try {
            if (currentFile == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)currentFile);
            Set<OVMComplianceCheckHit> hitsInFile = this.parserPathToHitsMap.get(parserPath);
            if (hitsInFile == null) {
                return;
            }
            HashMap<String, IMarker> existing = new HashMap<String, IMarker>();
            this.addMarkersToExistingMap(existing, currentFile.findMarkers(ERROR_MARKER_ID, true, 2));
            this.addMarkersToExistingMap(existing, currentFile.findMarkers(WARNING_MARKER_ID, true, 2));
            this.addMarkersToExistingMap(existing, currentFile.findMarkers(INFO_MARKER_ID, true, 2));
            for (OVMComplianceCheckHit hit : hitsInFile) {
                OVMProject ovmProject = hit.getCheck().getOVMProject();
                if (hit.getSeverity() == CheckStatus.DISABLED || !hit.getCheck().isEnabled() || hit.isHidden() || ovmProject.isChangesHidden(hit)) continue;
                int severity = this.translateSeverity(hit.getSeverity());
                String myHash = this.myHash(hit);
                if (existing.containsKey(myHash)) {
                    existing.remove(this.myHash(hit));
                    continue;
                }
                IMarker marker = currentFile.createMarker(this.getMarkerId(severity));
                marker.setAttribute("lineNumber", hit.getLine());
                String markerMessage = MessageFormat.format(MESSAGE_FORMAT, hit.getCheck().getName(), hit.getDetails());
                markerMessage = String.valueOf(markerMessage) + SHORTCUT_FOR_MESSAGE;
                marker.setAttribute("message", (Object)markerMessage);
                marker.setAttribute("priority", 2);
                marker.setAttribute("severity", severity);
                marker.setAttribute("location", (Object)parserPath);
                marker.setAttribute(CHECK_NAME_ATTRIBUTE, (Object)hit.getCheck().getName());
                marker.setAttribute(HIT_ATTRIBUTE, (Object)hit);
                marker.setAttribute(PROJECT_NAME_ATTRIBUTE, (Object)currentFile.getProject().getName());
                boolean hasAutofix = VerissimoAutofixUtils.getInstance().hasAutofixImplemented(hit.getCheck());
                marker.setAttribute(IMPLEMENTED_AUTOFIX_ATTRIBUTE, hasAutofix);
            }
            for (IMarker marker : existing.values()) {
                marker.delete();
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void addMarkersToExistingMap(Map<String, IMarker> existing, IMarker[] findErrorMarkers) {
        if (findErrorMarkers == null) {
            return;
        }
        IMarker[] iMarkerArray = findErrorMarkers;
        int n = findErrorMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            existing.put(this.myHash(marker), marker);
            ++n2;
        }
    }

    private String myHash(IMarker marker) {
        return marker == null ? "" : String.valueOf(marker.getAttribute("lineNumber", -1)) + "__#__" + marker.getAttribute("severity", 0) + "__#__" + marker.getAttribute("message", "");
    }

    private String myHash(OVMComplianceCheckHit hit) {
        if (hit == null) {
            return "";
        }
        String message = MessageFormat.format(MESSAGE_FORMAT, hit.getCheck().getName(), hit.getDetails());
        message = String.valueOf(message) + SHORTCUT_FOR_MESSAGE;
        return String.valueOf(hit.getLine()) + "__#__" + this.translateSeverity(hit.getSeverity()) + "__#__" + message;
    }

    private void updateOpenedFiles() {
        List currentlyEditedFiles = Utils.getCurrentlyEditedFiles();
        if (currentlyEditedFiles == null) {
            return;
        }
        for (IFile file : currentlyEditedFiles) {
            this.updateFile(file);
        }
    }

    public boolean isLintingMarker(IMarker marker) {
        try {
            String markerType = marker.getType();
            return LINTING_MARKERS.contains(markerType);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }
}

