/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.linter.CheckStatus;
import ro.amiq.vlogdt.linter.OVMComplianceCategory;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceChecksUtil;
import ro.amiq.vlogdt.linter.autofixes.utils.VerissimoAutofixUtils;
import ro.amiq.vlogdt.linter.standard.checks.OVMComplianceManualCheck;
import ro.amiq.vlogdt.linter.waivers.WaiverStatus;

public class OVMComplianceChecksUtilUI {
    public static Image getImage(Object element, CheckStatus status) {
        if (element instanceof String && ((String)element).equals("Summary")) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_SUMMARY);
        }
        if (status == CheckStatus.PASSED) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_PASSED);
        }
        if (status == CheckStatus.ERROR) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_ERROR);
        }
        if (status == CheckStatus.WARNING) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_WARNING);
        }
        if (status == CheckStatus.INFO) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_INFO);
        }
        if (status == CheckStatus.DISABLED) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_DISABLED);
        }
        return null;
    }

    public static String getTreeText(Object element) {
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof OVMComplianceCategory) {
            return ((OVMComplianceCategory)element).getName();
        }
        if (element instanceof OVMComplianceManualCheck) {
            return String.valueOf(((OVMComplianceManualCheck)element).getName()) + " [Manual]";
        }
        if (element instanceof OVMComplianceCheck) {
            OVMComplianceCheck tmpElement = (OVMComplianceCheck)element;
            String fix = VerissimoAutofixUtils.getInstance().hasAutofixImplemented(tmpElement) ? " [Fix]" : "";
            return String.valueOf(tmpElement.getName()) + " [" + Integer.toString(tmpElement.getNofVisibleHits()) + "]" + fix;
        }
        return "???";
    }

    public static String getDetailsText(Object element) {
        CheckStatus status = OVMComplianceChecksUtil.getStatus(element);
        if (status == CheckStatus.PASSED) {
            return "PASSED";
        }
        if (status == CheckStatus.ERROR) {
            return "ERROR";
        }
        if (status == CheckStatus.WARNING) {
            return "WARNING";
        }
        if (status == CheckStatus.INFO) {
            return "INFO";
        }
        if (status == CheckStatus.DISABLED) {
            return "DISABLED";
        }
        return "???";
    }

    public static Image getImage(WaiverStatus status) {
        if (status == WaiverStatus.DISABLE) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_DISABLED);
        }
        if (status == WaiverStatus.ERROR) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_ERROR);
        }
        if (status == WaiverStatus.WARNING) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_WARNING);
        }
        if (status == WaiverStatus.INFO) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_INFO);
        }
        if (status == WaiverStatus.NONE) {
            return DVTImages.imageCache.getImage(DVTImages.OVM_STATUS_NOT_APPLIED);
        }
        return null;
    }
}

