/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.linter.ui;

import java.io.File;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveableFilter;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.DVTSplashMLT;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.linter.ui.LinterHTMLReportHandler;
import ro.amiq.dvt.memorymonitor.MemoryMonitor;
import ro.amiq.dvt.memorymonitor.MemoryMonitorState;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.IDVTReparseListener;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.DVTProblemMatcher;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.DocumentManager;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.XMLException;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.OVMProject;
import ro.amiq.vlogdt.linter.OVMReportInfoProvider;
import ro.amiq.vlogdt.linter.ReportManager;
import ro.amiq.vlogdt.linter.autofixes.VerissimoAutofixManager;
import ro.amiq.vlogdt.linter.generate.AbstractGenerateHandler;
import ro.amiq.vlogdt.linter.launch.LintConfigurationContainer;
import ro.amiq.vlogdt.linter.report.VerissimoReportConverterCommon;
import ro.amiq.vlogdt.linter.report.VerissimoReportReader;
import ro.amiq.vlogdt.linter.report.model.RReport;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.linter.ui.ArchitectureDoublePanel;
import ro.amiq.vlogdt.linter.ui.ArchitectureModel;
import ro.amiq.vlogdt.linter.ui.ChecksTreeBrowser;
import ro.amiq.vlogdt.linter.ui.FontFactory;
import ro.amiq.vlogdt.linter.ui.HTML5ReportGenerator;
import ro.amiq.vlogdt.linter.ui.HTML5ReportMerger;
import ro.amiq.vlogdt.linter.ui.IArchitectureChangedListener;
import ro.amiq.vlogdt.linter.ui.IBeforeReportUpdateListener;
import ro.amiq.vlogdt.linter.ui.IPreferencesChangedListener;
import ro.amiq.vlogdt.linter.ui.IReportUpdateListener;
import ro.amiq.vlogdt.linter.ui.IWaiversChangeListener;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.linter.ui.Messages;
import ro.amiq.vlogdt.linter.ui.OVMComplianceReportInput;
import ro.amiq.vlogdt.linter.ui.WaiversEditor;
import ro.amiq.vlogdt.linter.utils.LintUtils;
import ro.amiq.vlogdt.linter.utils.OVMUtils;
import ro.amiq.vlogdt.linter.waivers.PreWaiver;
import ro.amiq.vlogdt.linter.waivers.WaiverType;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class OVMComplianceReport
extends EditorPart
implements IArchitectureChangedListener,
IDVTReparseListener,
IPreferencesChangedListener,
IWaiversChangeListener,
IResourceChangeListener,
ISelectionProvider {
    public static final String ID = "ro.amiq.vlogdt.linter.ui.OVMComplianceReport";
    private IProject fProject;
    private OVMReportInfoProvider fOVMInfoProvider;
    private ArchitectureModel fArchitectureModel;
    private ArrayList<IReportUpdateListener> fReportUpdateListeners;
    private ArrayList<IBeforeReportUpdateListener> fBeforeReportUpdateListeners;
    private FontFactory fFontFactory;
    private Label fDate;
    private StyledText fStatusBar;
    private Group fTopBar;
    private TabFolder fTabFolder;
    private Color fBackgroundColor;
    private Color fInfoBackgroundColor;
    private boolean fArchitectureChanged;
    private WaiversEditor fWaiversEditor;
    private ChecksTreeBrowser fChecksTreeBrowser;
    private ArchitectureDoublePanel fArchitecturePanel;
    private DocumentManager fDocumentManager;
    private boolean fRequiresFullBuild;
    List<ISelectionChangedListener> fSelectionListeners = new ArrayList<ISelectionChangedListener>();

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fDocumentManager = new DocumentManager(true);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.addResourceChangeListener((IResourceChangeListener)this);
        }
        if (input instanceof OVMComplianceReportInput) {
            this.setTitleImage(DVTImages.imageCache.getImage(((OVMComplianceReportInput)input).getImageDescriptor()));
            this.fBackgroundColor = DVTColorUtil.INSTANCE.getColor(PrefConst.getVerissimoBackgroundColor());
            this.fInfoBackgroundColor = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
            this.fReportUpdateListeners = new ArrayList();
            this.fBeforeReportUpdateListeners = new ArrayList();
            this.fProject = ((OVMComplianceReportInput)input).getProject();
            VlogModelManager.getInstance().addReparseListener(this);
            final OVMProject ovmProject = OVMComplianceBuilder.getInstance().initializeOVMProject(this.fProject);
            this.fArchitectureModel = new ArchitectureModel(ovmProject, this.fProject);
            this.fOVMInfoProvider = new OVMReportInfoProvider(this.fProject);
            this.fArchitectureModel.updateOVMProject(false, this.fArchitectureChanged);
            String title = ovmProject.getRulesetName();
            if (title == null) {
                title = ((OVMComplianceReportInput)input).getName();
            }
            title = String.valueOf(title) + " on " + this.fProject.getName();
            this.setPartName(title);
            if (!ovmProject.isImportHTML()) {
                try {
                    this.createBaselineReportPreWaivers(ovmProject);
                }
                catch (Exception e) {
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            }
            if (PrecompiledDBUtils.containsPrecompiledInvocation((IProject)this.fProject)) {
                LintUtils.createPrewaiverForPrecompiledCode(ovmProject);
            }
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                    protected void execute(IProgressMonitor monitor) {
                        try {
                            if (!ovmProject.isImportHTML()) {
                                ArrayList<OVMComplianceCheck> checks = OVMComplianceBuilder.getInstance().getChecks(OVMComplianceReport.this.fProject);
                                if (checks != null) {
                                    monitor.beginTask("Running: ", checks.size());
                                    OVMComplianceBuilder.getInstance().build(OVMComplianceReport.this.fProject, monitor, false, null);
                                }
                            } else {
                                OVMComplianceReport.this.fRequiresFullBuild = !ovmProject.getConfiguration().isLaunchedFromCLI();
                                monitor.setTaskName("Importing failures");
                                ovmProject.updateHitFilesAfterImport();
                                OVMComplianceBuilder.getInstance().notifyPostBuild(ovmProject);
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
                ((OVMComplianceReportInput)input).setLintingCanceled(progressDialog.getProgressMonitor().isCanceled());
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        site.setSelectionProvider((ISelectionProvider)this);
    }

    private void createBaselineReportPreWaivers(OVMProject ovmProject) throws Exception {
        LintConfigurationContainer config = ovmProject.getConfiguration();
        for (PreWaiver preWaiver : ovmProject.getProjectWaivers().getPreWaivers()) {
            if (preWaiver.getType() != WaiverType.READ_ONLY || !preWaiver.getName().equals("Prewaiver generated by prewaive_unchanged_files")) continue;
            ovmProject.getProjectWaivers().getPreWaivers().remove(preWaiver);
            break;
        }
        if (config.isPrewaivedUnchanged() && config.getBaselineReportLocation() != null && !config.getBaselineReportLocation().isEmpty()) {
            File data0File = new File(config.getBaselineReportLocation(), "js/data0.js");
            RReport baseLineReportInfo = ovmProject.getReportManager().getBaselineReport();
            if (data0File.exists() && data0File.canRead()) {
                baseLineReportInfo = VerissimoReportReader.readReportInfo(data0File);
            }
            ReportManager.createPreWaiversWithBaselineReport(baseLineReportInfo, ovmProject);
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        DVTColorUtil.INSTANCE.setBackground((Control)parent, this.fBackgroundColor, true);
        if (this.fArchitectureModel == null) {
            Label label = new Label(parent, 0);
            DVTColorUtil.INSTANCE.setForeground((Control)label, PlatformUI.getWorkbench().getDisplay().getSystemColor(3), true);
            label.setText("OVM Compliance Review editor view can only be invoked by the OVM Compliance Review process!");
            return;
        }
        this.fFontFactory = new FontFactory(parent.getDisplay());
        this.fTopBar = new Group(parent, 0);
        this.fTopBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fTopBar, this.fBackgroundColor, true);
        this.createTopBar((Composite)this.fTopBar);
        this.fTabFolder = new TabFolder(parent, 1024);
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fTabFolder, this.fBackgroundColor, true);
        this.createTabs();
        OVMProject ovmProject = this.fOVMInfoProvider.getOVMProject();
        if (ovmProject.compiledFilesChangedOnImport(ovmProject.getImportedReport())) {
            this.setStatusBarDirty();
        }
    }

    void createTopBar(Composite parent) {
        parent.setLayout((Layout)new GridLayout(7, false));
        if (this.isCompareReport()) {
            final OVMProject ovmProject = this.fOVMInfoProvider.getOVMProject();
            if (!ovmProject.isInChangesMode()) {
                ovmProject.switchModes();
            }
            Group reportModeGroup = new Group(parent, 0);
            RowLayout rowLayout = new RowLayout(256);
            reportModeGroup.setLayout((Layout)rowLayout);
            DVTColorUtil.INSTANCE.setBackground((Control)reportModeGroup, this.fBackgroundColor, true);
            Button changesModeButton = new Button((Composite)reportModeGroup, 16);
            changesModeButton.setSelection(true);
            Button currentModeButton = new Button((Composite)reportModeGroup, 16);
            changesModeButton.setText(String.valueOf(Messages.OVMComplianceReport_Top_Bar_Changes_Mode_Button) + " ");
            currentModeButton.setText(String.valueOf(Messages.OVMComplianceReport_Top_Bar_Current_Mode_Button) + "   ");
            changesModeButton.setToolTipText(Messages.OVMComplianceReport_Top_Bar_Show_Changes_Button_TT);
            currentModeButton.setToolTipText(Messages.OVMComplianceReport_Top_Bar_Show_Current_Button_TT);
            changesModeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (!ovmProject.isInChangesMode()) {
                        ovmProject.switchModes();
                    }
                    OVMComplianceReport.this.fChecksTreeBrowser.reportUpdate();
                    LintingProblemsManager.getInstance().updateMarkersAfterWaivers(OVMComplianceReport.this.fProject);
                }
            });
            currentModeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (ovmProject.isInChangesMode()) {
                        ovmProject.switchModes();
                    }
                    OVMComplianceReport.this.fChecksTreeBrowser.reportUpdate();
                    LintingProblemsManager.getInstance().updateMarkersAfterWaivers(OVMComplianceReport.this.fProject);
                }
            });
        }
        this.fStatusBar = new StyledText(parent, 2056);
        this.fStatusBar.setLayoutData((Object)new GridData(4, 4, true, true));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fBackgroundColor, true);
        this.fStatusBar.setMargins(7, 7, 0, 0);
        this.fStatusBar.setEnabled(false);
        this.fDate = new Label(parent, 0x1000040);
        this.fDate.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, true));
        SimpleDateFormat dateFormat = new SimpleDateFormat(Messages.OVMComplianceReport_Top_Bar_Date_Format);
        this.fDate.setText(dateFormat.format(new Date()));
        DVTColorUtil.INSTANCE.setBackground((Control)this.fDate, this.fBackgroundColor, true);
        if (((OVMComplianceReportInput)this.getEditorInput()).isLintingCanceled()) {
            this.lintingCanceled();
        } else if (OVMComplianceBuilder.getInstance().checkErrors(this.fProject)) {
            this.lintingErrors();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutProcess(this.fProject)) {
            this.timedOutProcess();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutSession(this.fProject)) {
            this.timedOutSession();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutChecks(this.fProject)) {
            this.timedOutChecks();
        } else if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Error);
        } else if (MemoryMonitorState.WARNING.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Warning);
        }
        Button applyFailedButton = new Button(parent, 8);
        applyFailedButton.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        applyFailedButton.setText(Messages.OVMComplianceReport_Top_Bar_Refresh_Failed_Button);
        applyFailedButton.setToolTipText(Messages.OVMComplianceReport_Top_Bar_Refresh_Failed_Button_TT);
        applyFailedButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_REPORT_REFRESH_FAILED));
        DVTColorUtil.INSTANCE.setBackground((Control)applyFailedButton, this.fBackgroundColor, true);
        applyFailedButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OVMComplianceReport.this.doReapply(true, null);
                    }
                });
            }
        });
        Button applyButton = new Button(parent, 8);
        applyButton.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        applyButton.setText(Messages.OVMComplianceReport_Top_Bar_Refresh_Button);
        applyButton.setToolTipText(Messages.OVMComplianceReport_Top_Bar_Refresh_Button_TT);
        applyButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_REPORT_REFRESH));
        DVTColorUtil.INSTANCE.setBackground((Control)applyButton, this.fBackgroundColor, true);
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OVMComplianceReport.this.doReapply(false, null);
                    }
                });
            }
        });
        Button reRunButton = new Button(parent, 8);
        reRunButton.setLayoutData((Object)new GridData(0x1000000, 4, false, true));
        reRunButton.setText("Rerun All");
        reRunButton.setToolTipText("Reload the ruleset and rerun the rules");
        reRunButton.setImage(DVTImages.imageCache.getImage(DVTImages.OVM_REPORT_RERUN));
        DVTColorUtil.INSTANCE.setBackground((Control)reRunButton, this.fBackgroundColor, true);
        reRunButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OVMComplianceReport.this.doReRun();
                    }
                });
            }
        });
    }

    private boolean saveDirtyResources() {
        IWorkbenchWindow w = Utils.getActiveWorkbenchWindow();
        if (w == null) {
            return false;
        }
        ISaveableFilter filter = (saveable, containingParts) -> {
            IWorkbenchPart[] iWorkbenchPartArray = containingParts;
            int n = containingParts.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IEditorInput editorInput;
                IWorkbenchPart containingPart = iWorkbenchPartArray[n2];
                if (containingPart instanceof IEditorPart && ((editorInput = ((IEditorPart)containingPart).getEditorInput()) instanceof FileEditorInput ? (file = ((FileEditorInput)editorInput).getFile()) != null && file.getProject() == this.fProject : editorInput instanceof FileStoreEditorInput && containingPart instanceof DVTEditor)) {
                    return true;
                }
                ++n2;
            }
            return false;
        };
        boolean saveAll = PlatformUI.getWorkbench().saveAll((IShellProvider)w, (IRunnableContext)w, filter, true);
        return saveAll;
    }

    public void doReRun() {
        if (this.fRequiresFullBuild && !this.triggerFullBuildAfterImport(this.fProject, false)) {
            return;
        }
        boolean saved = this.saveDirtyResources();
        if (!saved) {
            return;
        }
        this.fOVMInfoProvider.getOVMProject().setReapplyOrRerun(true);
        DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printStartSection("Starting rerun all linting checks");
        this.updateBeforeReportListeners();
        final OVMProject ovmProject = OVMComplianceBuilder.getInstance().getOVMProject(this.fProject);
        if (ovmProject.getConfiguration().getRulesetKind() == RulesetKind.IMPORT_FROM_HTML && ovmProject.getTempRulesetkind() != null) {
            ovmProject.getConfiguration().setRulesetKind(ovmProject.getTempRulesetkind());
        }
        try {
            ovmProject.loadRuleset();
        }
        catch (XMLException e) {
            OVMUtils.configError(e);
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(this.fProject);
        ovmProject.initialize(rfProject, true, true);
        rfProject.setOvmProject(ovmProject);
        try {
            this.createBaselineReportPreWaivers(this.fOVMInfoProvider.getOVMProject());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (PrecompiledDBUtils.containsPrecompiledInvocation((IProject)this.fProject)) {
            LintUtils.createPrewaiverForPrecompiledCode(ovmProject);
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                            return;
                        }
                        ovmProject.initializeProcessEndTime();
                        ArrayList<OVMComplianceCheck> checks = OVMComplianceBuilder.getInstance().getChecks(OVMComplianceReport.this.fProject);
                        if (checks != null) {
                            monitor.beginTask("Running: ", checks.size());
                            OVMComplianceBuilder.getInstance().build(OVMComplianceReport.this.fProject, monitor, false, null);
                        }
                    }
                    finally {
                        monitor.done();
                        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        catch (InterruptedException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        this.fArchitectureModel.updateOVMProject(true, this.fArchitectureChanged);
        this.fChecksTreeBrowser.setInput(ovmProject.getComplianceCategories(), false);
        this.updateTopBar(true);
        this.fWaiversEditor.setWaivedFailuresOutOfSync(false);
        this.updateListeners();
        if (progressDialog.getProgressMonitor().isCanceled()) {
            this.lintingCanceled();
        } else if (OVMComplianceBuilder.getInstance().checkErrors(this.fProject)) {
            this.lintingErrors();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutSession(this.fProject)) {
            this.timedOutSession();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutChecks(this.fProject)) {
            this.timedOutChecks();
        } else if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Error);
        } else if (MemoryMonitorState.WARNING.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Warning);
        }
    }

    public void doReapply(boolean onlyFailed, Object target) {
        this.doReapply(onlyFailed, target, false, false);
    }

    public void doReapply(boolean onlyFailed, Object target, boolean ignoreImportDialog) {
        this.doReapply(onlyFailed, target, ignoreImportDialog, false);
    }

    public void doReapply(final boolean onlyFailed, final Object target, boolean ignoreImportDialog, final boolean printAutofixSummary) {
        if (this.fRequiresFullBuild && !this.triggerFullBuildAfterImport(this.fProject, ignoreImportDialog)) {
            return;
        }
        boolean saved = this.saveDirtyResources();
        if (!saved) {
            return;
        }
        this.fOVMInfoProvider.getOVMProject().setReapplyOrRerun(true);
        if (onlyFailed) {
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printStartSection("Starting reapply failed linting checks");
        } else {
            DVTBuildConsoleRegistry.getConsole((IProject)this.getProject()).printStartSection("Starting reapply all linting checks");
        }
        this.updateBeforeReportListeners();
        OVMComplianceBuilder.getInstance().initializeOVMProject(this.fProject);
        try {
            this.createBaselineReportPreWaivers(this.fOVMInfoProvider.getOVMProject());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (PrecompiledDBUtils.containsPrecompiledInvocation((IProject)this.fProject)) {
            LintUtils.createPrewaiverForPrecompiledCode(this.fOVMInfoProvider.getOVMProject());
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            progressDialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) {
                    try {
                        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                            return;
                        }
                        OVMComplianceReport.this.fOVMInfoProvider.getOVMProject().initializeProcessEndTime();
                        ArrayList<OVMComplianceCheck> checks = OVMComplianceBuilder.getInstance().getChecks(OVMComplianceReport.this.fProject);
                        if (checks != null) {
                            monitor.beginTask("Running: ", checks.size());
                            OVMComplianceBuilder.getInstance().build(OVMComplianceReport.this.fProject, monitor, onlyFailed, target, printAutofixSummary);
                        }
                    }
                    finally {
                        monitor.done();
                        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        catch (InterruptedException ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        this.fArchitectureModel.updateOVMProject(true, this.fArchitectureChanged);
        this.updateTopBar(true);
        this.fWaiversEditor.setWaivedFailuresOutOfSync(false);
        this.updateListeners();
        if (progressDialog.getProgressMonitor().isCanceled()) {
            this.lintingCanceled();
        } else if (OVMComplianceBuilder.getInstance().checkErrors(this.fProject)) {
            this.lintingErrors();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutSession(this.fProject)) {
            this.timedOutSession();
        } else if (OVMComplianceBuilder.getInstance().checkTimedoutChecks(this.fProject)) {
            this.timedOutChecks();
        } else if (MemoryMonitorState.ERROR.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Error);
        } else if (MemoryMonitorState.WARNING.equals((Object)MemoryMonitor.getInstance().getMonitorState())) {
            this.memoryChecks(Messages.OVMComplianceReport_Top_Bar_Memory_Warning);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean triggerFullBuildAfterImport(IProject project, boolean ignoreImportDialog) {
        if (!ignoreImportDialog) {
            messageDialogExitCode = new int[]{0};
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$1(int[] ), ()V)((OVMComplianceReport)this, (int[])messageDialogExitCode));
            if (messageDialogExitCode[0] != 0) {
                return false;
            }
        }
        waitForBuildDone = new AtomicBoolean(true);
        buildSuccessful = new AtomicBoolean(true);
        if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
            return false;
        }
        buildDoneListener = new IBuildDoneListener[]{(IBuildDoneListener)LambdaMetafactory.metafactory(null, null, null, (Lro/amiq/dvt/model/IBuildDoneListener$BuildFinishReason;Ljava/lang/String;)V, lambda$2(ro.amiq.dvt.model.IBuildDoneListener[] org.eclipse.core.resources.IProject java.util.concurrent.atomic.AtomicBoolean java.util.concurrent.atomic.AtomicBoolean ro.amiq.dvt.model.IBuildDoneListener$BuildFinishReason java.lang.String ), (Lro/amiq/dvt/model/IBuildDoneListener$BuildFinishReason;Ljava/lang/String;)V)((OVMComplianceReport)this, (IBuildDoneListener[])buildDoneListener, (IProject)project, (AtomicBoolean)buildSuccessful, (AtomicBoolean)waitForBuildDone)};
        DVTMixedLangModelManager.getInstance().addBuildDoneListener(buildDoneListener[0]);
        if (DVTBuildUtils.buildWithProgressDialog((IProject)project)) ** GOTO lbl18
        DVTMixedLangModelManager.getInstance().removeBuildDoneListener(buildDoneListener[0]);
        return buildSuccessful.get();
lbl-1000:
        // 1 sources

        {
            if (Display.getDefault().readAndDispatch()) continue;
            Display.getDefault().sleep();
lbl18:
            // 3 sources

            ** while (waitForBuildDone.get() && buildSuccessful.get())
        }
lbl19:
        // 1 sources

        return buildSuccessful.get();
    }

    private void createTabs() {
        this.createMainTab(this.fTabFolder);
        this.createArchitectureTab(this.fTabFolder);
        this.createChecksTab(this.fTabFolder);
        this.createWaiversTab(this.fTabFolder);
    }

    private void createMainTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor, true);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(tabComposite, 512);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        DVTColorUtil.INSTANCE.setBackground((Control)scrolledComposite, this.fBackgroundColor, true);
        final Composite centerComposite = new Composite((Composite)scrolledComposite, 0);
        DVTColorUtil.INSTANCE.setBackground((Control)centerComposite, this.fBackgroundColor, true);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 30;
        gl.marginHeight = 40;
        gl.marginWidth = 40;
        centerComposite.setLayout((Layout)gl);
        Button button1 = new Button(centerComposite, 8);
        button1.setToolTipText(Messages.OVMComplianceReport_Main_Page_Architecture_Big_Button_TT);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        Image image = DVTImages.imageCache.getImage(DVTImages.OVM_ARCHITECTURE_BUTTON);
        gd.widthHint = image.getBounds().width;
        gd.heightHint = image.getBounds().height;
        button1.setLayoutData((Object)gd);
        button1.setImage(image);
        DVTColorUtil.INSTANCE.setBackground((Control)button1, this.fBackgroundColor, true);
        button1.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(1);
            }
        });
        Composite textContainer1 = new Composite(centerComposite, 0);
        textContainer1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer1.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer1, this.fBackgroundColor, true);
        Label title1 = new Label(textContainer1, 64);
        title1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title1.setFont(this.fFontFactory.createFont("default", 16, 1));
        title1.setText(Messages.OVMComplianceReport_Main_Page_Architecture_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title1, this.fBackgroundColor, true);
        Label description1 = new Label(textContainer1, 64);
        description1.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description1.setText(Messages.OVMComplianceReport_Main_Page_Architecture_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description1, this.fBackgroundColor, true);
        Button button2 = new Button(centerComposite, 8);
        button2.setToolTipText(Messages.OVMComplianceReport_Main_Page_Checks_Big_Button_TT);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        image = DVTImages.imageCache.getImage(DVTImages.OVM_CHECKS_BUTTON);
        gd.widthHint = image.getBounds().width;
        gd.heightHint = image.getBounds().height;
        button2.setLayoutData((Object)gd);
        button2.setImage(image);
        DVTColorUtil.INSTANCE.setBackground((Control)button2, this.fBackgroundColor, true);
        button2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(2);
            }
        });
        Composite textContainer2 = new Composite(centerComposite, 0);
        textContainer2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer2.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer2, this.fBackgroundColor, true);
        Label title2 = new Label(textContainer2, 64);
        title2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title2.setFont(this.fFontFactory.createFont("default", 16, 1));
        title2.setText(Messages.OVMComplianceReport_Main_Page_Checks_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title2, this.fBackgroundColor, true);
        Label description2 = new Label(textContainer2, 64);
        description2.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description2.setText(Messages.OVMComplianceReport_Main_Page_Checks_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description2, this.fBackgroundColor, true);
        Button button5 = new Button(centerComposite, 8);
        button5.setToolTipText(Messages.OVMComplianceReport_Main_Page_Waivers_Big_Button_TT);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        image = DVTImages.imageCache.getImage(DVTImages.OVM_WAIVERS_BUTTON);
        gd.widthHint = image.getBounds().width;
        gd.heightHint = image.getBounds().height;
        button5.setLayoutData((Object)gd);
        button5.setImage(image);
        DVTColorUtil.INSTANCE.setBackground((Control)button5, this.fBackgroundColor, true);
        button5.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                OVMComplianceReport.this.fTabFolder.setSelection(3);
            }
        });
        Composite textContainer5 = new Composite(centerComposite, 0);
        textContainer5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer5.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer5, this.fBackgroundColor, true);
        Label title5 = new Label(textContainer5, 64);
        title5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title5.setFont(this.fFontFactory.createFont("default", 16, 1));
        title5.setText(Messages.OVMComplianceReport_Main_Page_Waivers_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title5, this.fBackgroundColor, true);
        Label description5 = new Label(textContainer5, 64);
        description5.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description5.setText(Messages.OVMComplianceReport_Main_Page_Waivers_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description5, this.fBackgroundColor, true);
        Button button4 = new Button(centerComposite, 8);
        button4.setToolTipText(Messages.OVMComplianceReport_Main_Page_Export_Big_Button_TT);
        gd = new GridData(0x1000000, 0x1000000, false, false);
        image = DVTImages.imageCache.getImage(DVTImages.OVM_EXPORT_HTML_BUTTON);
        gd.widthHint = image.getBounds().width;
        gd.heightHint = image.getBounds().height;
        button4.setLayoutData((Object)gd);
        button4.setImage(image);
        DVTColorUtil.INSTANCE.setBackground((Control)button4, this.fBackgroundColor, true);
        button4.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public String getImportHTMLLocation(OVMProject ovmProject) {
                String importLocation = ovmProject.getConfiguration().getHTMLImportLocation();
                if (importLocation == null || importLocation.isEmpty()) {
                    return null;
                }
                int index = importLocation.indexOf("verissimo_html_report");
                if (index == -1) {
                    return importLocation;
                }
                importLocation = importLocation.substring(0, index);
                return importLocation;
            }

            public void widgetSelected(SelectionEvent e) {
                String importLocation;
                final OVMProject ovmProject = OVMComplianceReport.this.fOVMInfoProvider.getOVMProject();
                String htmlReportLocation = ovmProject.getConfiguration().getHTMLReportLocation();
                if (htmlReportLocation == null || htmlReportLocation.equals("")) {
                    htmlReportLocation = OVMComplianceReport.this.fOVMInfoProvider.getOutputPath();
                }
                if ((importLocation = this.getImportHTMLLocation(ovmProject)) != null && !importLocation.isEmpty()) {
                    htmlReportLocation = importLocation;
                }
                Shell currentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                String exportButtonLabel = "Export" + (OVMComplianceReport.this.isCompareReport() ? " Current" : "");
                final AbstractGenerateHandler.SavingDialog dialog = new AbstractGenerateHandler.SavingDialog(currentShell, "Export HTML", "HTML Report Location:", "Choose exporting location", exportButtonLabel, false, OVMComplianceReport.this.isCompareReport(), ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode());
                dialog.setLocation(htmlReportLocation);
                final int selection = dialog.open();
                if (selection == 1) {
                    return;
                }
                if (OVMComplianceReport.this.getEditorInput() instanceof OVMComplianceReportInput) {
                    Job job = new Job("Generating Verissimo HTML Report"){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                String location = dialog.getLocation();
                                Boolean includeSources = dialog.getIncludeSources();
                                if (includeSources != (ovmProject.getRulesetConfiguration().getIncludeHTMLCode() || ovmProject.getIncludeHTMLCode())) {
                                    ovmProject.setIncludeHTMLCode(includeSources);
                                    if (ovmProject.getReportManager().getCurrentReport() != null) {
                                        ovmProject.getReportManager().getCurrentReport().getInfoWrapper().setCommonSegmentsInfo(includeSources != false ? Arrays.asList("0") : Arrays.asList("undefined"));
                                    }
                                    if (ovmProject.getReportManager().getChangesReport() != null) {
                                        ovmProject.getReportManager().getChangesReport().getInfoWrapper().setCommonSegmentsInfo(includeSources != false ? Arrays.asList("0") : Arrays.asList("undefined"));
                                    }
                                }
                                monitor.beginTask("Generating Verissimo HTML Report", 100);
                                if (!DVTSplashMLT.INSTANCE.cc(true, new String[]{"F73765F6C696E74"})) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                boolean hasCompilationErrors = DVTProblemManager.getInstance().getAllProblems(ovmProject.getProject(), DVTProblemMatcher.all(), null).stream().anyMatch(problem -> !problem.isWaived() && problem.getSeverity() == Severity.ERROR);
                                ovmProject.setCompilationErrors(hasCompilationErrors);
                                if (selection == 0) {
                                    OVMComplianceReport.this.exportCurrent(ovmProject, monitor, location);
                                } else if (selection == 1025) {
                                    OVMComplianceReport.this.exportCompare(ovmProject, monitor, location);
                                } else {
                                    OVMComplianceReport.this.exportChanges(ovmProject, monitor, location);
                                }
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                IStatus iStatus = Status.OK_STATUS;
                                return iStatus;
                            }
                            finally {
                                monitor.done();
                                DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
                            }
                        }
                    };
                    job.setUser(true);
                    job.setPriority(30);
                    job.schedule();
                }
            }
        });
        Composite textContainer4 = new Composite(centerComposite, 0);
        textContainer4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gl = new GridLayout(1, false);
        gl.horizontalSpacing = 20;
        gl.verticalSpacing = 20;
        textContainer4.setLayout((Layout)gl);
        DVTColorUtil.INSTANCE.setBackground((Control)textContainer4, this.fBackgroundColor, true);
        Label title4 = new Label(textContainer4, 64);
        title4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        title4.setFont(this.fFontFactory.createFont("default", 16, 1));
        title4.setText(Messages.OVMComplianceReport_Main_Page_Export_Title);
        DVTColorUtil.INSTANCE.setBackground((Control)title4, this.fBackgroundColor, true);
        Label description4 = new Label(textContainer4, 64);
        description4.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        description4.setText(Messages.OVMComplianceReport_Main_Page_Export_Description);
        DVTColorUtil.INSTANCE.setBackground((Control)description4, this.fBackgroundColor, true);
        if (this.fOVMInfoProvider.getOVMProject().isImportHTML()) {
            Button button6 = new Button(centerComposite, 8);
            button6.setToolTipText(Messages.OVMComplianceReport_Main_Page_Open_Big_Button_TT);
            gd = new GridData(0x1000000, 0x1000000, false, false);
            image = DVTImages.imageCache.getImage(DVTImages.OVM_OPEN_HTML_BUTTON);
            gd.widthHint = image.getBounds().width;
            gd.heightHint = image.getBounds().height;
            button6.setLayoutData((Object)gd);
            button6.setImage(image);
            DVTColorUtil.INSTANCE.setBackground((Control)button6, this.fBackgroundColor, true);
            button6.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String importLocation = OVMComplianceReport.this.fOVMInfoProvider.getOVMProject().getConfiguration().getHTMLImportLocation();
                    if (importLocation == null || importLocation.isEmpty()) {
                        return;
                    }
                    LinterHTMLReportHandler.openHTMLReport((String)importLocation, (int)OVMComplianceReport.this.fOVMInfoProvider.getOVMProject().getNumberOfHits());
                }
            });
            Composite textContainer6 = new Composite(centerComposite, 0);
            textContainer6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            gl = new GridLayout(1, false);
            gl.horizontalSpacing = 20;
            gl.verticalSpacing = 20;
            textContainer6.setLayout((Layout)gl);
            DVTColorUtil.INSTANCE.setBackground((Control)textContainer6, this.fBackgroundColor, true);
            Label title6 = new Label(textContainer6, 64);
            title6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            title6.setFont(this.fFontFactory.createFont("default", 16, 1));
            title6.setText(Messages.OVMComplianceReport_Main_Page_Open_Title);
            DVTColorUtil.INSTANCE.setBackground((Control)title6, this.fBackgroundColor, true);
            Label description6 = new Label(textContainer6, 64);
            description6.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            description6.setText(Messages.OVMComplianceReport_Main_Page_Open_Description);
            DVTColorUtil.INSTANCE.setBackground((Control)description6, this.fBackgroundColor, true);
        }
        scrolledComposite.setContent((Control)centerComposite);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                scrolledComposite.setMinSize(centerComposite.computeSize(r.width, -1));
            }
        });
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Main_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_LINTER));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    public void exportChanges(OVMProject ovmProject, IProgressMonitor monitor, String location) {
        RReport changesReport = ovmProject.getReportManager().getChangesReport();
        if (changesReport == null || ReportManager.isDirtyReports()) {
            changesReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, true);
            if (ovmProject.getReportManager().getBaselineReport() != null) {
                changesReport.setBaselineReportLocation(ovmProject.getReportManager().getBaselineReport().getLocation());
            }
        }
        HTML5ReportGenerator.generate(changesReport, location, ovmProject, monitor, ReportManager.ReportType.CHANGES);
    }

    public void exportCompare(OVMProject ovmProject, IProgressMonitor monitor, String location) {
        File file;
        RReport compareReport = ovmProject.getReportManager().getCompareReport();
        RReport currentReport = ovmProject.getReportManager().getCurrentReport();
        if (currentReport == null || ReportManager.isDirtyReports()) {
            currentReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, false, true);
        }
        if (compareReport == null || ReportManager.isDirtyReports()) {
            RReport currentReportWithCodeFlag = new RReport(currentReport);
            ArrayList<String> commonSegmentsInfo = new ArrayList<String>(Arrays.asList("0"));
            currentReportWithCodeFlag.getInfoWrapper().setCommonSegmentsInfo(commonSegmentsInfo);
            compareReport = HTML5ReportMerger.compareReportsWithMapping(currentReportWithCodeFlag, new RReport(ovmProject.getReportManager().getBaselineReport()), null);
        }
        if ((file = ReportManager.generateCompareReport(location, compareReport, monitor, true)) != null) {
            HTML5ReportGenerator.refreshAndOpenReport(file, compareReport.getHits().size(), monitor);
        }
    }

    public void exportCurrent(OVMProject ovmProject, IProgressMonitor monitor, String location) {
        if (ovmProject.getReportManager().getCurrentReport() != null && !ReportManager.isDirtyReports() && !ovmProject.isForceSimpleGUIReport()) {
            HTML5ReportGenerator.generate(ovmProject.getReportManager().getCurrentReport(), location, ovmProject, monitor, ReportManager.ReportType.CURRENT);
        } else if (ovmProject.isCompare() && !ovmProject.isForceSimpleGUIReport()) {
            RReport currentReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier);
            currentReport.setBaselineReportLocation("");
            currentReport.getHits().forEach(x -> x.setCompareAnnotations(new LinkedHashSet<String>()));
            HTML5ReportGenerator.generate(currentReport, location, ovmProject, monitor, ReportManager.ReportType.CURRENT);
        } else if (ovmProject.getConfiguration().getBaselineReportLocation() == null || ovmProject.getConfiguration().getBaselineReportLocation().isEmpty()) {
            HTML5ReportGenerator.generate(location, ovmProject, monitor);
        } else {
            RReport changesReport = VerissimoReportConverterCommon.convertToRReport(ovmProject, HTML5ReportGenerator.collectInfo(ovmProject), null, monitor, HTML5ReportGenerator::subprogressMonitorSuplier, true);
            HTML5ReportGenerator.generate(changesReport, location, ovmProject, monitor, ReportManager.ReportType.CHANGES);
        }
    }

    private void createArchitectureTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor, true);
        this.fArchitecturePanel = new ArchitectureDoublePanel(tabComposite, 0);
        this.fArchitecturePanel.setInput(this.fArchitectureModel);
        this.fArchitecturePanel.addArchitectureChangedListener(this);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fArchitecturePanel, this.fBackgroundColor, true);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Architecture_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_OVM_ARCH));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void createChecksTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor, true);
        this.fChecksTreeBrowser = new ChecksTreeBrowser(tabComposite, null, this.fProject, this);
        this.fChecksTreeBrowser.setInput(this.fOVMInfoProvider.getCategories(), true);
        this.addUpdateListener(this.fChecksTreeBrowser);
        this.fChecksTreeBrowser.addWaiversChangeListener(this);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Checks_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.IMG_TAB_OVM_CHECKS));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void createWaiversTab(TabFolder tabFolder) {
        Composite tabComposite = new Composite((Composite)tabFolder, 0);
        tabComposite.setLayout((Layout)new FillLayout());
        DVTColorUtil.INSTANCE.setBackground((Control)tabComposite, this.fBackgroundColor, true);
        this.fWaiversEditor = new WaiversEditor(tabComposite, 0, this.fProject, this);
        this.fWaiversEditor.setInput(this.fOVMInfoProvider.getOVMProject().getProjectWaivers());
        DVTColorUtil.INSTANCE.setBackground((Control)this.fWaiversEditor, this.fBackgroundColor, true);
        this.fWaiversEditor.addChangeListener(this);
        this.addUpdateListener(this.fWaiversEditor);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.OVMComplianceReport_Waivers_Tab);
        tabItem.setImage(DVTImages.imageCache.getImage(DVTImages.WAIVERS));
        tabItem.setControl((Control)tabComposite);
        DVTColorUtil.INSTANCE.setBackground(tabItem.getControl(), this.fBackgroundColor, true);
    }

    private void updateTopBar(boolean reportBuilt) {
        if (reportBuilt) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(Messages.OVMComplianceReport_Top_Bar_Date_Format);
            this.fDate.setText(dateFormat.format(new Date()));
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Status_Updated);
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fBackgroundColor);
            this.fTopBar.layout(true, true);
        } else {
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_1);
            DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
        }
    }

    public void updateArchitecturePostBuild() {
        this.fArchitectureModel.updateOVMProject(true, this.fArchitectureChanged);
    }

    @Override
    public void architectureChanged() {
        this.updateTopBar(false);
        this.fArchitectureChanged = true;
    }

    @Override
    public void waiversChanged(boolean isPostWaiver) {
        if (isPostWaiver) {
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_6);
        } else {
            this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_5);
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
        this.fWaiversEditor.setWaivedFailuresOutOfSync(true);
        this.updateListeners();
    }

    @Override
    public void preferencesChanged() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_3);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void lintingCanceled() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_4);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void lintingErrors() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Errors);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void timedOutProcess() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Timedout_Process);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void timedOutSession() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Timedout_Session);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void timedOutChecks() {
        this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_Timedout_Checks);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    private void memoryChecks(String message) {
        this.fStatusBar.setText(message);
        DVTColorUtil.INSTANCE.setBackground((Control)this.fStatusBar, this.fInfoBackgroundColor);
    }

    public void addUpdateListener(IReportUpdateListener listener) {
        this.fReportUpdateListeners.add(listener);
    }

    protected void updateListeners() {
        for (IReportUpdateListener listener : this.fReportUpdateListeners) {
            listener.reportUpdate();
        }
    }

    public void addBeforeUpdateListener(IBeforeReportUpdateListener listener) {
        this.fBeforeReportUpdateListeners.add(listener);
    }

    protected void updateBeforeReportListeners() {
        for (IBeforeReportUpdateListener listener : this.fBeforeReportUpdateListeners) {
            listener.beforeReportUpdate();
        }
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        OVMProject ovmProject;
        OVMReportInfoProvider ovmInfoProvider;
        RfProject rfProject;
        DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener((IResourceChangeListener)this);
        }
        if (this.fReportUpdateListeners != null) {
            this.fReportUpdateListeners.clear();
        }
        if (this.fFontFactory != null) {
            this.fFontFactory.dispose();
        }
        if ((rfProject = RfManager.getInstance().getRfProject(this.fProject)) != null) {
            rfProject.stopLintTracking();
        }
        if ((ovmInfoProvider = this.getOVMInfoProvider()) != null && (ovmProject = ovmInfoProvider.getOVMProject()) != null) {
            ovmProject.clean(true, true);
        }
        VlogModelManager.getInstance().removeReparseListener(this);
        LintingProblemsManager.getInstance().clearMarkers(this.fProject);
        if (this.fChecksTreeBrowser != null) {
            this.fChecksTreeBrowser.dispose();
        }
        if (this.fWaiversEditor != null) {
            this.fWaiversEditor.dispose();
        }
        if (this.fArchitecturePanel != null) {
            this.fArchitecturePanel.dispose();
        }
        VerissimoAutofixManager.getInstance().cleanCanonicalPathsCache();
        OVMComplianceBuilder.getInstance().removeOVMProject(this.fProject);
        super.dispose();
    }

    protected OVMReportInfoProvider getOVMInfoProvider() {
        return this.fOVMInfoProvider;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void reparsed(int buildKind, int type, IResource resource, List errors, List warnings, List tasks) {
        if (resource != null && this.fProject != null && !this.fProject.equals((Object)resource.getProject())) {
            return;
        }
        this.setStatusBarDirty();
    }

    private void setStatusBarDirty() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (OVMComplianceReport.this.fStatusBar != null && !OVMComplianceReport.this.fStatusBar.isDisposed()) {
                    OVMComplianceReport.this.fStatusBar.setText(Messages.OVMComplianceReport_Top_Bar_status_Dirty_2);
                    DVTColorUtil.INSTANCE.setBackground((Control)OVMComplianceReport.this.fStatusBar, OVMComplianceReport.this.fInfoBackgroundColor, true);
                }
            }
        });
    }

    public void showCheck(String checkName, OVMComplianceCheckHit checkHit) {
        this.fTabFolder.setSelection(2);
        this.getEditorSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)this);
        this.fChecksTreeBrowser.showCheck(checkName);
        this.fChecksTreeBrowser.showHit(checkHit);
    }

    public Object getAdapter(Class adapter) {
        IProject project = this.getProject();
        if (project != null) {
            if (IResource.class.equals((Object)adapter)) {
                return project;
            }
            if (IFile.class.equals((Object)adapter)) {
                IFile file = project.getFile(".project");
                if (file.isAccessible()) {
                    return file;
                }
                return project;
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void setFocus() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.fProject == null) {
            return;
        }
        int type = event.getType();
        if (this.fProject.equals((Object)event.getResource()) && (type == 4 || type == 2)) {
            this.doClose();
        }
    }

    public void doClose() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                OVMComplianceReport.this.getSite().getPage().closeEditor((IEditorPart)OVMComplianceReport.this, true);
            }
        });
    }

    public DocumentManager getDocumentManager() {
        return this.fDocumentManager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return new StructuredSelection((Object)this.getProject());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.fSelectionListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
    }

    public boolean checkIfSourceCodeChanged() {
        if (this.fStatusBar == null) {
            return false;
        }
        return Messages.OVMComplianceReport_Top_Bar_status_Dirty_2.equals(this.fStatusBar.getText());
    }

    public void notifyWaiversChangedListeners(boolean isPostWaiver) {
        this.fChecksTreeBrowser.notifyChangeListeners(isPostWaiver);
    }

    private boolean isCompareReport() {
        return this.isCompareReport(OVMComplianceBuilder.getInstance().getOVMProject(this.fProject));
    }

    private boolean isCompareReport(OVMProject ovmProject) {
        return ovmProject.isCompare();
    }

    private /* synthetic */ void lambda$1(int[] nArray) {
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Full build required", null, "A full build of the project is required before reapplying the rules.\nDo you want to start it now?", 2, new String[]{"Yes", "No"}, 0){};
        nArray[0] = dialog.open();
    }

    private /* synthetic */ void lambda$2(IBuildDoneListener[] iBuildDoneListenerArray, IProject iProject, AtomicBoolean atomicBoolean, AtomicBoolean atomicBoolean2, IBuildDoneListener.BuildFinishReason buildFinishReason, String projectName) {
        DVTMixedLangModelManager.getInstance().removeBuildDoneListener(iBuildDoneListenerArray[0]);
        if (IBuildDoneListener.BuildFinishReason.isCanceled((IBuildDoneListener.BuildFinishReason)buildFinishReason) || OVMComplianceBuilder.getInstance().getOVMProject(iProject).hasTimedOutDuringBuild()) {
            DVTSplashMLT.INSTANCE.i(true, "F73765F6C696E74");
            atomicBoolean.set(false);
            return;
        }
        DVTMixedLangModelManager.getInstance().removeBuildDoneListener(iBuildDoneListenerArray[0]);
        this.fRequiresFullBuild = false;
        atomicBoolean2.set(false);
    }
}

